addNewDepartment
function showShiftTeam() {
  var teamID = $(".deptshift").val();
  var shift = $(".deptshift option:selected").text();


  $("#shift_selection").val(shift);
  $("#team_id").val(teamID);
  $("#shift_selection").val(shift);
  get_added_employees_table_markup();

  $("#shift_team_shift").html('<option value="">--Select--</option><option value="' + shift + '">' + shift + '</option>')

}


function showDepartmentShift(obj) {
  var deptId = $(obj).val();
  if (deptId) {
    $.ajax({
      type: 'POST',
      async: false,
      data: {deptId: deptId},
      url: baseURL + "/getDepartmentShift",
      dataType: 'json',
      success: function (response) {
        var html = '<option value="">Select</option>';
        if (response != '') {

          $.each(response, function (index, value) {
            html += '<option value="' + value['id'] + '">' + value['shift'] + '</option>';

          });
        }
        $(".deptshift").html(html);
      }
    });
  }

}

function showRequestEmployee() {
  $("#requestEmployee").DataTable().destroy();
  $("#requestEmployee").DataTable({
    "columnDefs": [
      {"className": "dt-center", "targets": "_all"}
    ],
    "ordering": false,
    "processing": true,
    "serverSide": true,
    "searching": false,
    "ajax": {
      "url": baseURL + "/getrequestemployeelist",
      "type": "POST",
      "data": {shift: $("#selectshift").val()}
    }
  });
}
function showUserAttendancenew() {

  $('#attendancelist').DataTable().destroy();
  $('#attendancelist').DataTable({
    "columnDefs": [
      {"className": "dt-center", "targets": "_all"}
    ],
    "ordering": false,
    "processing": true,
    "serverSide": true,
    "searching": false,
    "ajax": {
      "url": baseURL + "/getuserattendancelist",
      "type": "POST",
      "data": {start_date: $("#attandance_start_date").val(), end_date: $("#attandance_end_date").val()}

    }
  });
}


function updateToTime(time, obj) {

  var empcode = $(obj).data('value');

  $(".to_time_" + empcode).val('');
  $(".hours_" + empcode).val('');
  $(".to_time_" + empcode).timepicker({'timeFormat': 'H:i', 'minTime': time});



}



function showDepartmentEmployee(deptId) {
  if (deptId == '') {

  } else {
    $.ajax({
      type: 'POST',
      url: baseURL + "getdeptemployee",
      data: {deptId: deptId},
      async: false,
      dataType: 'JSON',
      success: function (response) {
        var assignHtml = '';
        if (response.length > 0) {
          $.each(response, function (index, value) {
            assignHtml += '<option value="' + value['userId'] + '">' + value['name'] + ' ' + value['emp_code'] + '</option>';

          });
          $("#ticketassigntonew").html(assignHtml);
        } else {

          $("#ticketassigntonew").html('');
        }
      }
    });
  }
}


function updateHours(time, obj) {
  var empcode = $(obj).data('value');
  var fromTime = $(".from_time_" + empcode).val();
  $.ajax({
    type: 'POST',
    url: baseURL + "gethoursbetweentime",
    data: {fromTime: fromTime, toTime: time},
    async: false,
    dataType: 'JSON',
    success: function (response) {

      $(".hours_" + empcode).val(response);
    }
  });

}



function checkPreviousSuperVisor(shift, userId) {
  if (shift != '') {
    var department = $("#department").val();
    if (department == '') {
      alert("Please select department first.");
      $("#shift").val('');
    } else {
      $.ajax({
        type: 'POST',
        url: baseURL + "getprevioussupervisor",
        data: {shift: shift, department: department, userId: userId},
        async: false,
        dataType: 'JSON',
        success: function (e) {
          if (e['supervisor'] > 0) {
            $(".change-role-section").html(e['html']);
            $("#changeRoleModel").modal("show");
            $("#shift").val('');
          }

        }
      });
    }
  }


}


/*function take_snapshot() {


 Webcam.snap( function(data_uri) {

 document.getElementById('capturephoto').innerHTML =
 '<img src="'+data_uri+'"/>';
 } );
 }*/


function changeTicketStatus(ticketId, obj) {
  var status = $(obj).val();


  $.ajax({
    type: 'POST',
    url: baseURL + "/updateticketstatus",
    data: {ticketId: ticketId, status: status},
    async: false,
    beforeSend: function () {
      $("body").LoadingOverlay("show", {
        background: "rgba(165, 190, 100, 0.5)"
      });
    },
    success: function (e) {
      $("body").LoadingOverlay("hide", true);
      swal("Ticket Status Updated", "", "success");
    }
  });
}

function showRackSection(obj) {
  var racksection = $(obj).val();
  if (racksection == 'HD Racks') {
    $(".hdracksection").show();
    $(".mezzsection").hide();
    $(".shelvingsection").hide();
  } else if (racksection == 'Mezz') {
    $(".mezzsection").show();
    $(".hdracksection").hide();
    $(".shelvingsection").hide();
  } else if (racksection == 'Shelving') {
    $(".shelvingsection").show();
    $(".hdracksection").hide();
    $(".mezzsection").hide();
  }
}

function showMezzClearHeight() {
  var warehouseHeight = $("#rackmezzwarehouseheight").val();
  var clearHeight = parseInt(warehouseHeight / 10);
  $("#rackmezzclearheight").val(clearHeight);
  var clearHeightText = clearHeight - 1;
  $("#rackmezzclearheighttext").text('G + ' + clearHeightText);
}


function calculateRackMezzTotalArea() {

  var rack_mezz_stored_pallets = parseInt($("#rack_mezz_stored_pallets").val());
  var rack_mezz_pallets_type = $("#rack_mezz_pallets_type").val();
  var rackmezzwarehouseheight = $("#rackmezzwarehouseheight").val();
  var rack_mezz_movement = $("#rack_mezz_movement").val();
  var mezzProcessing = $("#rackmezzprocessingarea").val();
  var areaofonepallet = '';
  var nooflevel = parseInt($("#rackmezzclearheight").val());
  var totalArea = '';
  if (rack_mezz_pallets_type == '') {
    alert("Please select the type of pallets");
    $("#rack_mezz_movement").val('');
  } else if (rack_mezz_stored_pallets == '') {
    alert("Please enter the No. of Pallets");
    $("#rack_mezz_movement").val('');
  } else if (rackmezzwarehouseheight == '') {
    alert('Please enter the ware house height');
    $("#rack_mezz_movement").val('');
  } else {

    if (rack_mezz_pallets_type == 'american') {
      if (rack_mezz_movement == 'single') {

        //areaofonepallet = parseInt(4*6.5);
        areaofonepallet = 26;

      } else if (rack_mezz_movement == 'double') {

        //areaofonepallet = parseInt(4*8.5);
        areaofonepallet = 34;
      }
    } else {
      if (rack_mezz_movement == 'single') {

        //areaofonepallet = parseInt(4*6.5);
        areaofonepallet = 22;

      } else if (rack_mezz_movement == 'double') {

        //areaofonepallet = parseInt(4*8.5);
        areaofonepallet = 30;
      }
    }



    $("#rackmezzonepallettext").text(areaofonepallet);
    $("#rackmezzonepalletvalue").val(areaofonepallet);

    totalArea = (1 / nooflevel) * rack_mezz_stored_pallets * areaofonepallet;
    totalArea = parseInt(totalArea);

    var percentageTotalArea = percentage(totalArea, mezzProcessing);
    var totalAreawithprocessing = totalArea + percentageTotalArea;

    $(".rackmezztotalareanew").text(totalArea + ' Sq Ft.');
    $(".rackmezztotalarea").text(totalAreawithprocessing + ' sq ft.')
  }

}

$(function () {


  $("#addticketform").on('submit', function (e) {
    e.preventDefault();
    var ticketId = $("#ticket_id").val();
    $.ajax({
      url: baseURL + "/addticketcomment",
      type: 'POST',
      data: new FormData(this),
      processData: false,
      contentType: false,
      cache: false,
      async: false,
      dataType: 'JSON',
      beforeSend: function () {
        $("body").LoadingOverlay("show", {
          background: "rgba(165, 190, 100, 0.5)"
        });
        $('.submitBtn').attr("disabled", "disabled");
        $('#addticketform').css("opacity", ".5");

      },
      success: function (result) {
        //$("#response").text(result);
        if (result['status'] == 'SUCCESS') {

          var htmlText = '';
          htmlText += '<div class="row mb10">';
          htmlText += '<div class="col-md-3 text-right"><b>' + result['name'] + '</b><br>' + result['datetime'] + '</div>';
          htmlText += '<div class="col-md-9"><div class="support-ticket-bg-incoming">' + result['comment'] + '</div>';
          if (result['file'] != '') {

            $.each(JSON.parse(result['file']), function (index, file) {

              htmlText += '<a download href="' + baseURL + '/assets/images/tickets/' + file + '"><i class="fa fa-paperclip" aria-hidden="true"></i>' + file + '</a>,';
            });

          }

          htmlText += '</div>';
          htmlText += '</div>';
          $(".ticketcomment-section").prepend(htmlText);
          //document.getElementById("addticketform").reset();
          $('#addticketform')[0].reset();
          $('#addticketform').css("opacity", "");
          $(".submitBtn").removeAttr("disabled");
          $("body").LoadingOverlay("hide", true);
        } else {
          alert('Something went wrong');
          $('#addticketform')[0].reset();
          $('#addticketform').css("opacity", "");
          $(".submitBtn").removeAttr("disabled");
          $("body").LoadingOverlay("hide", true);
        }
      }
    });
  });

  $("#visitorcheckinform").submit(function (event) {
    event.preventDefault();

    $.ajax({
      url: baseURL + "/checkinvisitor",
      type: 'POST',
      dataType: 'JSON',
      data: $(this).serialize(),
      success: function (result) {
        //$("#response").text(result);

        if (result == 'SUCCESS') {
          //document.getElementById("entrymodel").reset();
          $('#entrymodel').modal('hide');
          showPreappointmentfilter();
        }
      }

    });
  });




  /* $("#visitoreportForm").submit(function(event){
   alert('test');

   });*/




  /*$("#usersearchform").submit(function(e){
   //e.preventDefault();



   });*/


  $("#employeeTicketForm").submit(function (e) {
    $('.searchList').attr("disabled", "disabled");
    e.preventDefault();
    $.ajax({
      url: baseURL + "/addnewticket",
      type: 'POST',
      data: new FormData(this),
      processData: false,
      contentType: false,
      cache: false,
      async: false,
      beforeSend: function () {
        $('.searchList').attr("disabled", "disabled");
        $('#employeeTicketForm').css("opacity", ".5");

      },
      success: function (result) {
        document.getElementById("employeeTicketForm").reset();
        $('#addnew').modal('toggle');
        //$("#employeeTicketForm").LoadingOverlay("hide",true);
        $('#employeeTicketForm').css("opacity", "");
        $(".searchList").removeAttr("disabled");
        swal("Ticket added", "", "success");
        showTicketFilter();
      }

    });
  });

  $("#editemployeeticketform").submit(function (e) {

    e.preventDefault();
    $.ajax({
      url: baseURL + "/updateticket",
      type: 'POST',
      data: new FormData(this),
      processData: false,
      contentType: false,
      cache: false,
      async: false,
      beforeSend: function () {
        $("#editticketform").LoadingOverlay("show", {
          background: "rgba(165, 190, 100, 0.5)"
        });
      },
      success: function (result) {
        document.getElementById("editemployeeticketform").reset();
        $('#editticketform').modal('toggle');
        $("#editticketform").LoadingOverlay("hide", true);
        swal("Ticket updated", "", "success");
        showTicketFilter();
      }

    });
  });


  $("#stored_pallets").keypress(function (e) {
    //if the letter is not digit then display error and don't type anything
    if (e.which != 8 && e.which != 0 && (e.which < 48 || e.which > 57)) {

      return false;
    }
  });

});


function searchEmployee() {
  var emp_id = $("#emp_id").val();
  var emp_email = $("#emp_email").val();
  var organization_id = $("#organization_id").val();
  var department_id = $("#department_id").val();
  $("#userlistintbl").DataTable().destroy();
  $("#userlistintbl").DataTable({
    "columnDefs": [
      {"className": "dt-center", "targets": "_all"}
    ],
    "ordering": false,
    "processing": true,
    "serverSide": true,
    "searching": false,
    "ajax": {
      "url": baseURL + "/getuserajaxlisting",
      "type": "POST",
      "data": {emp_id: emp_id, emp_email: emp_email, organization_id: organization_id, department_id: department_id},

    }
  });
}

function showVisitorReport() {

  $("#visitiorreporttbl").DataTable().destroy();
  var startDate = $("#visitor_report_start_date").val();
  var enddate = $("#visitor_report_end_date").val();
  var visitorType = $("#visitor_report_type").val();
  var visitStatus = $("#visitor_report_status").val();
  $("#visitiorreporttbl").DataTable({
    "columnDefs": [
      {"className": "dt-center", "targets": "_all"}
    ],
    "ordering": false,
    "processing": true,
    "serverSide": true,
    "searching": false,
    "ajax": {
      "url": baseURL + "/getvisitorreport",
      "type": "POST",
      "data": {startDate: startDate, enddate: enddate, visitorType: visitorType, visitStatus: visitStatus},

    }
  });
}


function removeOldFileRow(obj) {
  $(obj).parent('.oldfilerow').remove();
}

function openEdirTicketForm(ticketId) {
  if (ticketId) {
    $.ajax({
      type: 'POST',
      url: baseURL + "ticketDetailforedit",
      async: false,
      data: {ticketId: ticketId},
      dataType: 'JSON',
      success: function (response) {
        if (response) {
          $("#editticketsubject").val(response['subject']);
          var assignHtml = [];
          $.each(response['assignuser'], function (index, value) {
            assignHtml += '<option value="' + value['user_id'] + '" selected>' + value['name'] + ' ' + value['emp_code'] + '</option>';
          });
          $("#ticketassigntonew").html(assignHtml);
          $("#editticketstartdate").val(response['start_date']);
          $("#editticketduedate").val(response['due_date']);
          $("#editticketpriority").val(response['priority']);
          $("#editticketdescription").val(response['description']);
          //tinyMCE.activeEditor.setContent(response['description']);
          tinymce.get("editticketdescription").setContent(response['description']);

          var attachmentfile = '';
          if (response['ticket_file']) {
            $.each(response['ticket_file'], function (ind, val) {
              attachmentfile += '<div class="oldfilerow"><a target="_blank" downlaod href="' + baseURL + 'assets/images/tickets/' + val + '">' + val + '</a><input type="hidden" name="oldfile[]" value="' + val + '"><a style="margin-left:5px" href="javascript:void(0)" onclick="removeOldFileRow(this)"><i class="fa fa-trash" aria-hidden="true"></i></a></div></br>';
            });
            /*$.each(response['ticket_file'],function(index,val)){
             //attachmentfile += '<a style="margin-left:2px" downlaod href="'+baseURL+'assets/uploads/'+val+'">'+val+'</a><input type="hidden" name="oldfile[]" value="'+val+'">';
             }*/
          }
          $(".oldfiles").html(attachmentfile);


          $("#editticketId").val(response['id']);
          $('#editticketform').modal('toggle');
        }
      }
    });
  }
}



function showmonthlyBenchMark(view) {


  var warehouseId = $("#warehouseId").val();
  var department_id = $("#department_id").val();
  var subdepartment = $("#subdepartment").val();
  var benchmonth = $("#benchmonth").val();

  if (warehouseId != '' && department_id != '' && benchmonth != '' && subdepartment != '') {
    $.ajax({
      type: 'POST',
      url: baseURL + 'getdepartment_benchmark',
      data: {
        warehouseId: warehouseId,
        department_id: department_id,
        sub_department_id: subdepartment,
        benchmonth: benchmonth,
        view: view
      },
      async: false,
      dataType: 'JSON',
      success: function (response) {

        $("#banchmark_script").html(response);
      }
    });
  }



}

function isNumber(evt) {
  evt = (evt) ? evt : window.event;
  var charCode = (evt.which) ? evt.which : evt.keyCode;
  if (charCode > 31 && (charCode < 48 || charCode > 57)) {
    return false;
  }
  return true;
}

function calculateShelvingTotalArea() {
  showShelvinStorageArea();
}

function calculateRackTotalArea() {
  var rackprocessingarea = $("#rackprocessingarea").val();
  var rackaisle = $("#rackaisle").val();

  var rackclearheight = $("#rackclearheight").val();
  var rackpalletoneshelf = $("#rackpalletoneshelf").val();
  var rackrequired = $("#rackrequired").val();

  if (rackaisle == '') {
    alert("Select Aisle");
    return true;
  } else if (rackstackingheight == '') {
    alert("Please enter Stacking Height");
    return true;
  } else if (rackwarehouseheight == '') {
    alert("Please enter the Ware House Height");
    return true;
  } else if (rackprocessingarea == '') {
    alert("Select Processing Area");
    return true;
  }

  var numberofpalletinonerack = rackpalletoneshelf * rackclearheight;

  //var numberofrack = rackrequired / numberofpalletinonerack;
  var numberofrack = $("#rackrequired").val();

  var area = '';

  if (rackaisle == 5) {

    area = 58.5;

  } else if (rackaisle == 9) {

    area = 76.5;
  }

  area = 9 * (4 + (0.5 * rackaisle));
  //alert(area);

  var totalArea = area * numberofrack;
  //alert(totalArea);

  var percentageTotalArea = percentage(totalArea, rackprocessingarea);
  var totalAreawithprocessing = totalArea + percentageTotalArea;
  //var totalAreawithprocessing = totalArea;

  $(".racktotalareanew").text(totalArea + ' Sq Ft.');
  $(".racktotalarea").text(totalAreawithprocessing + ' Sq Ft.');
}


function showshelfinobetier(shelfheight) {

  if (shelfheight != '') {
    var noshelfinonetier = 8 / shelfheight;
    if (shelfheight == 0) {
      noshelfinonetier = 0;
    }

    $("#shelvin_no_of_shelf_in_one_tier").val(noshelfinonetier);
    $("#shelvin_no_of_shelf_in_one_tier_text").text(noshelfinonetier);
  } else {
    $("#shelvin_no_of_shelf_in_one_tier_text").text('');
  }

}


function showshelfinoneTier(warehouseheight) {
  var noshelfinonerack = 0;
  var heightofshelf = $("#rack_shelving_height_of_shelf").val();
  if (warehouseheight != '' && heightofshelf != '') {
    noshelfinonerack = (warehouseheight - 2) / heightofshelf;
    $("#shelvin_no_of_shelf_in_one_rack_text").text(noshelfinonerack);
    $("#shelvin_no_of_shelf_in_one_rack").val(noshelfinonerack);

  } else {
    $("#shelvin_no_of_shelf_in_one_rack_text").text(0);
    $("#shelvin_no_of_shelf_in_one_rack").val(0);
  }
  showNoofracks();
}

function showRequiredShelf(oneshelflocation) {
  var nolocationtolocate = $("#rack_shelving_no_of_location_to_locate").val();
  var requirednoshelf = 0;
  if (oneshelflocation != '' && oneshelflocation != 0 && nolocationtolocate != '') {
    requirednoshelf = nolocationtolocate / oneshelflocation;
    requirednoshelf = requirednoshelf.toFixed(2);
    $("#shelvin_required_no_shelf").val(requirednoshelf);
    $("#shelvin_required_no_shelf_text").text(requirednoshelf);
  } else {
    $("#shelvin_required_no_shelf").val(0);
    $("#shelvin_required_no_shelf_text").text(0);
  }
  showNoofracks();
}


function showShelvinStorageArea() {
  var A = $("#rack_shelving_height_of_shelf").val();
  var B = $("#shelvin_length_of_shelf").val();
  var C = parseFloat($("#rack_shelving_width_of_shelf").val());
  var D = $("#shelvin_height_of_tier").val();
  var E = parseFloat($("#rack_shelving_aisle").val());
  var F = $("#rack_shelving_height_of_warehouse").val();
  var G = $("#rack_shelving_no_of_location_to_locate").val();
  var H = $("#rack_shelving_no_of_location_one_shelf").val();
  var I = $("#shelvin_no_of_shelf_in_one_tier").val();
  var J = $("#shelvin_no_of_shelf_in_one_rack").val();
  var K = $("#shelvin_required_no_shelf").val();
  var L = parseFloat($("#shelvin_no_of_racks").val());
  var processingpercentage = $("#shelvingprocessingarea").val();

  if (A == '') {
    alert('Please select Height of the shelf');
  } else if (C == '') {
    alert("Please select width of the shelf");
  } else if (E == '') {
    alert("Please select Aisle");
  } else if (F == '') {
    alert("Please enter height of warehouse");
  } else if (G == '') {
    alert("Please enter no. of location to be locate");
  } else if (H == '') {
    alert("Please enter no. of location in one shelf");
  } else {
    M = L * 9 * (C + 0.5 * E);




    $("#shelvin_storage_area").val(M);
    $("#shelvin_storage_area_text").text(M + ' Sq Ft.');
    if (processingpercentage != '') {
      var percentageTotalArea = percentage(M, processingpercentage);
      var totalAreawithprocessing = M + percentageTotalArea;
      totalAreawithprocessing = totalAreawithprocessing.toFixed(2);
      $(".rackshelvingtotalarea").text(totalAreawithprocessing + ' Sq Ft.');
    } else {
      $(".rackshelvingtotalarea").text('');
    }
  }


}

function showNoofracks() {
  var K = $("#shelvin_required_no_shelf").val();
  var J = $("#shelvin_no_of_shelf_in_one_rack").val();
  var L = 0;
  if (K != '' && J != '') {
    L = K / J
  }
  L = L.toFixed(2);
  $("#shelvin_no_of_racks").val(L);
  $("#shelvin_no_of_racks_text").text(L);
}



function resetRackFields() {
  $("#rackstackingheight").val('');
  $("#rackwarehouseheight").val('');
  $("#rackclearheighttext").text('');
  $("#rackclearheight").val('');
  $("#racktotalstoredpallets").val('');
  $("#rackpalletoneshelf").val('');
  $(".rackrequiredtext").text('');
  $("#rackrequired").val('');
  $("#rackprocessingarea").val('');
  $(".racktotalareanew").text('');
  $(".racktotalarea").text('');
}


function resetMezzField() {
  $("#rack_mezz_stored_pallets").val('');
  $("#rackmezzwarehouseheight").val('');
  $(".rackmezzclearheighttext").text('');
  $("#rackmezzclearheight").val('');
  $("#rack_mezz_movement").val('');
  $(".rackmezztotalarea").text('');
  $(".rackmezztotalareanew").text('');
}

function showrackrequiredrack() {
  var racktotalstoredpallets = $("#racktotalstoredpallets").val();
  var rackpalletoneshelf = $("#rackpalletoneshelf").val();
  var rackclearheight = $("#rackclearheight").val();
  var requiredRack = 0;

  if (racktotalstoredpallets != '' && rackpalletoneshelf != '' && rackclearheight != '') {

    racktotalstoredpallets = parseInt(racktotalstoredpallets);
    rackpalletoneshelf = parseInt(rackpalletoneshelf);
    rackclearheight = parseInt(rackclearheight);

    var palletinoneRack = rackpalletoneshelf * rackclearheight;

    requiredRack = parseInt(racktotalstoredpallets / palletinoneRack);

    $(".rackrequiredtext").text(requiredRack);
    $("#rackrequired").val(requiredRack);


  }
}

function percentage(num, per)
{
  return (num / 100) * per;
}



function setClearHeight() {

  var rackstackingheight = parseInt($("#rackstackingheight").val());
  var rackwarehouseheight = parseInt($("#rackwarehouseheight").val());

  if (rackstackingheight != '' && rackwarehouseheight != '') {

    var newstackheight = rackstackingheight + 1;

    var clearHeight = (rackwarehouseheight - 2) / newstackheight;

    if (!Number.isInteger(clearHeight)) {
      clearHeight = parseInt(clearHeight);
    }
    if (!isNaN(clearHeight)) {
      $("#rackclearheighttext").text('G + ' + (clearHeight - 1));
      $("#rackclearheight").val(clearHeight);
    }

  }
  showrackrequiredrack();
}

function calculateFloorSalesResult() {
  var processingArea = $("#floorprocessingarea").val();
  var floor_pallets = $("#floor_pallets").val();
  var floor_stored_pallets = $("#floor_stored_pallets").val();
  var floor_aisle = $("#floor_aisle").val();
  if (floor_pallets == '') {
    alert('Please select type of pallets');
    $("#floorprocessingarea").val('');
    return;
  } else if (floor_stored_pallets == '') {
    alert('Please enter the pallets');
    $("#floorprocessingarea").val('');
    return;
  } else if (floor_aisle == '') {
    alert('Please select the aisle');
    $("#floorprocessingarea").val('');
    return;
  } else {
    $.ajax({
      type: 'POST',
      beforeSend: function () {
        $(".floorsection").LoadingOverlay("show", {
          background: "rgba(165, 190, 100, 0.5)"
        });
      },
      url: baseURL + "/getfloorsalescalculation",
      async: false,
      dataType: 'JSON',
      data: {floor_pallets: floor_pallets, floor_stored_pallets: floor_stored_pallets, floor_aisle: floor_aisle, processingArea: processingArea},
      success: function (e) {
        $(".floorresult").text(e['areapercentage']);
        $(".floorresulttext").text(e['area']);
        $(".floorsection").LoadingOverlay("hide", true);
      }
    });
  }
}

function showFloorSalesCalulation(processingArea) {
  calculateFloorSalesResult();
}

function updateEndTime(obj) {
  var starttime = $(obj).val();
  var timeList = ["00:00", "00:15", "00:30", "00:45", "01:00", "01:15", "01:30", "01:45", "02:00", "02:15", "02:30", "02:45", "03:00", "03:15",
    "03:30", "03:45", "04:00", "04:15", "04:30", "04:45", "05:00", "05:15", "05:30", "05:45", "06:00", "06:15", "06:30", "06:45",
    "07:00", "07:15", "07:30", "07:45", "08:00", "08:15", "08:30", "08:45", "09:00", "09:15", "09:30", "09:45", "10:00", "10:15", "10:30", "10:45", "11:00",
    "11:15", "11:30", "11:45", "12:00", "12:15", "12:30", "12:45", "13:00", "13:15", "13:30", "13:45", "14:00", "14:15", "14:30", "14:45", "15:00",
    "15:15", "15:30", "15:45", "16:00", "16:15", "16:30", "16:45", "17:00", "17:15", "17:30", "17:45", "18:00", "18:15", "18:30", "18:45", "19:00", "19:15",
    "19:30", "19:45", "20:00", "20:15", "20:30", "20:45", "21:00", "21:15", "21:30", "21:45", "22:00", "22:15", "22:30", "22:45", "23:00",
    "23:15", "23:30", "23:45"];
  var html = '<option value="">-- Select --</option>';

  var temp = 0;
  $.map(timeList, function (val, i) {
    if (val == starttime) {
      temp = 1;
    }
    if (temp == 1) {
      html += '<option value="' + val + '">' + val + '</option>';
    }
  });
  $("#appointmenttohr").html(html);
  if (starttime == '') {
    $('#appointmenttohr').prop("disabled", true);
  } else {
    $('#appointmenttohr').prop("disabled", false);
  }


}

function checkInVisitor() {
  $("#visitorcheckinform").LoadingOverlay("show", {
    background: "rgba(165, 190, 100, 0.5)"
  });

  $("#visitorcheckinform").ajaxForm({
    url: baseURL + "/checkinvisitor",
    type: 'POST',
    async: false,
    success: function (response) {

      $("#visitorcheckinform").LoadingOverlay("hide", true);
    }

  });

  /*	var empContactnumber = $("#passcontactnumber").val();

   var empExt = $("#passempext").val();

   var visitorIntimation = $("input[name='visitorintimation']:checked").val();

   var imageType = $("input[name='visitorcam']:checked").val();

   var passcheckingate = $("#passcheckingate").val();

   var passaccesscardnumber = $("#passaccesscardnumber").val();

   var passmeetinglocation = $("#passmeetinglocation").val();

   var appointmentid = $("#passappointmentid").val();

   var passItems = $("input[name='passitems[]'").val();

   alert(passItems);

   var passitemdescription = $("input[name='passitemdescription[]']").val();

   var visitorId = $("#visitorId").val();

   var visitorurl = $("#visitorurl").val();

   var visitoridurl = $("#visitoridurl").val();

   var emp_id = $("#emp_id").val();

   $.ajax({
   type:'POST',
   url: baseURL+"/checkinvisitor",
   dataType:'JSON',
   async:false,
   data:{empContactnumber:empContactnumber,empExt:empExt,visitorIntimation:visitorIntimation,imageType:imageType,checkinGate:passcheckingate,
   empAccessCardNumber:passaccesscardnumber,meetingLocation:passmeetinglocation,appointmentid:appointmentid,Items:passItems,
   itemDescription:passitemdescription,visitorId:visitorId,visitorurl:visitorurl,emp_id:emp_id,visitoridurl:visitoridurl},
   success:function(response){

   }
   });*/

  return false;
}


function removePassPicImgUrl(idimg) {
  $("#" + idimg).val('');
  if (idimg == 'visitorurl') {
    $(".picimglebel").hide();
  } else if (idimg == 'visitoridurl') {
    $(".idimglabel").hide();
  }
  $("#capturephoto").html('');
}

function take_snapshot() {

  var radioValue = $("input[name='visitorcam']:checked").val();

  if (radioValue == undefined || radioValue == '') {
    alert('Please select radio option');
  } else {
    $("#entrymodel").LoadingOverlay("show", {
      background: "rgba(165, 190, 100, 0.5)"
    });
    Webcam.snap(function (data_uri) {

      Webcam.upload(data_uri, baseURL + 'uploadwebcamimage', function (code, text) {
        $("#capturephoto").html('');
        if (radioValue == 'vpic') {

          document.getElementById('capturephoto').innerHTML =
                  '<img src="' + text + '"/>';
          $("#captureappointmentid").html('');
          $("#visitorurl").val(text);
          $(".picimglebel").show();
          $(".idimglabel").hide();
        } else {


          document.getElementById('capturephoto').innerHTML =
                  '<img src="' + text + '"/>';

          $("#visitoridurl").val(text);
          $(".idimglabel").show();
          $(".picimglebel").hide();

        }

      });
      $("#entrymodel").LoadingOverlay("hide", true);
    });
  }

}


function getDepartment(obj) {
  var orgaizationId = $(obj).val();
  if (orgaizationId) {
    var htmltext = '<option value="">Select Department</option>';
    $.ajax({
      type: 'POST',
      url: baseURL + "/getdepartmentajax/1",
      async: false,
      data: {orgaizationId: orgaizationId},
      dataType: 'JSON',
      success: function (response) {

        $(response).each(function (index, value) {

          htmltext += '<option value="' + value['dept_id'] + '">' + value['dept_name'] + ' (' + value['manpower'] + ')</option>';
        });

        $("#department_id").html(htmltext);

      }
    });
  }
}
function getMainDepartment(obj) {
  var orgaizationId = $(obj).val();
  if (orgaizationId) {
    var htmltext = '<option value="">Select Department</option>';
    $.ajax({
      type: 'POST',
      url: baseURL + "/getmaindepartmentajax/1",
      async: false,
      data: {orgaizationId: orgaizationId},
      dataType: 'JSON',
      success: function (response) {

        $(response).each(function (index, value) {

          htmltext += '<option value="' + value['dept_id'] + '">' + value['dept_name'] + '</option>';
        });

        $("#department_id").html(htmltext);

      }
    });
  }
}

function getlocation(obj) {
  var clientId = $(obj).val();
  if (clientId) {
    var htmltext = '<option value="">Select Location</option>';
    $.ajax({
      type: 'POST',
      url: baseURL + "/getlocationajax",
      async: false,
      data: {clientId: clientId},
      dataType: 'JSON',
      success: function (response) {

        $(response).each(function (index, value) {

          htmltext += '<option value="' + value['loc_id'] + '">' + value['loc_name'] + '</option>';
        });

        $("#location_id").html(htmltext);

      }
    });
  }
}
function getClient(obj) {
  var orgId = $(obj).val();
  if (orgId) {
    var htmltext = '<option value="">Select Client</option>';
    $.ajax({
      type: 'POST',
      //url: baseURL + "/getlocationajax",
      url: baseURL + "/get-client-ajax",
      async: false,
      data: {orgId: orgId},
      dataType: 'JSON',
      success: function (response) {

//        $(response).each(function (index, value) {
//
//          htmltext += '<option value="' + value['id'] + '">' + value['client'] + '</option>';
//        });

        //$("#client_id").html(htmltext);
        $("#client").html(response);

      }
    });
  }
}

function removePasstr(obj) {

  $(obj).parents('tr').remove();
  //$(".belongingsection")
  var count = 1;
  $('.belongingsection tr td:first-child').each(function () {
    $(this).text(count);
    count++;
  });
}

function addNewBelongItem(obj) {
  //$(obj).replaceWith( '' );
  var belonitemlength = $(".belongingsection tr").length;
  var newtr = parseInt(belonitemlength) + 1;
  var html = '';
  html += '<tr class="odd">';
  html += '<td>' + newtr + '</td>';
  html += '<td><select id="" name="passitems[]" required>';
  html += '<option value="">-- Select --</option><option value="None">None</option><option value="Laptop">Laptop</option><option value="Phone">Phone</option><option value="Other">Other</option>';
  html += '</select></td>';
  html += '<td><input type="text" name="passitemdescription[]" class="form-control"></td>';
  html += '<td align="right">';
  html += '<a href="javascript:void(0)" onclick="removePasstr(this)" class="btn btn-danger">Remove</a>';
  html += '</td>';
  html += '</tr>';
  $(".belongingsection").append(html);

}

function showEntryPopUpModel(visitorId, obj) {
  Webcam.set({
    width: 500,
    height: 250,
    image_format: 'jpeg',
    jpeg_quality: 90
  });
  Webcam.attach('#webcam');
  $(".picimglebel").hide();
  $(".idimglabel").hide();
  $("#visitorurl").val('');
  $("#visitoridurl").val('');
  $("#capturephoto").html('');
  var appointmentid = $(obj).data('appointmentid');
  var visitorname = $(obj).data('visitorname');
  var organizationName = $(obj).data('organizationname');

  var visitortype = $(obj).data('visitortype');

  var orgaddress = $(obj).data('orgaddress');
  var contactnumber = $(obj).data('contactnumber');
  var employeename = $(obj).data('employeename');
  var visitingpurpose = $(obj).data('visitingpurpose');
  var meetinglocation = $(obj).data('meetinglocation');
  var orgaizationId = $(obj).data('organizationid');
  var emp_id = $(obj).data('emp_id');
  var htmltext = '';
  $.ajax({
    type: 'POST',
    url: baseURL + "/getdepartmentajax",
    async: false,
    data: {orgaizationId: orgaizationId},
    dataType: 'JSON',
    success: function (response) {

      $(response).each(function (index, value) {

        htmltext += '<option value="' + value['dept_name'] + '">' + value['dept_name'] + '</option>';
      });
      htmltext += '<option value="Other">Other</option>';


    }
  });

  //$("#passmeetinglocation").html(htmltext);
  $("#passappointmentid").val(appointmentid);
  $("#passvisitorname").val(visitorname);
  $("#passorganization").val(organizationName);
  $("#passvisitortype").val(visitortype);
  $("#passorganizationaddress").val(orgaddress);
  $("#passcontactnumber").val(contactnumber);
  $("#passemployeename").val(employeename);
  $("#passvisitingpurpose").val(visitingpurpose);
  $("#passmeetinglocation").val(meetinglocation);
  $("#visitorId").val(visitorId);
  $("#emp_id").val(emp_id);
  $('#entrymodel').modal('show');
}

function showPreappointmentfilternew() {
  setTimeout(function () {
    showPreappointmentfilter();
  }, 500);
}

function showPreappointmentfilter() {
  var visit_date = $("#visit_date_filter").val();
  var visitor_organization_id = $("#visitor_organization").val();
  var searchtype = $("input[name='searchtype']:checked").val();
  var visitor_type = $("#visitor_type").val();
  var search_term = $("#search_term").val();

  $('#visitor_pre_register_tbl').DataTable().destroy();
  $('#visitor_pre_register_tbl').DataTable({
    "columnDefs": [
      {"className": "dt-center", "targets": "_all"}
    ],
    "ordering": false,
    "processing": true,
    "serverSide": true,
    "searching": false,
    "ajax": {
      "url": baseURL + "/getpreregistervisit",
      "type": "POST",
      //"async":false,
      "data": {visit_date: visit_date, visitor_organization_id: visitor_organization_id, searchtype: searchtype, visitor_type: visitor_type, search_term: search_term},

    }
  });
}

function showalluserlisting() {

  $('#userattenlist').DataTable().destroy();

  $('#foradminattendancelist').DataTable().destroy();
  $('#foradminattendancelist-section').hide();

  $('#userattenlist').DataTable({
    "columnDefs": [
      {"className": "dt-center", "targets": "_all"}
    ],
    "ordering": false,
    "processing": true,
    "serverSide": true,
    "searching": false,
    "ajax": {
      "url": baseURL + "/getalluserattendancelist",
      "type": "POST",
      "data": {organization_id: $("#organization_id").val(),
        emp_id: $("#emp_id").val(),
        email: $("#emp_email").val()},

    }
  });
}

function addnewvisitor(obj) {
  var visitorlength = $(".new-visitor-section").length;

  if (visitorlength == 1) {
    //$(obj).replaceWith('');
  } else {
    //$(obj).replaceWith('');
    //$(obj).replaceWith('<button type="button" onclick="removenewvisitor(this)" class="btn btn-danger mt25">Remove</button>');
  }

  //$(obj).remove();
  var htmltxt = '';
  htmltxt += '<div class="row new-visitor-section">';
  htmltxt += '<div class="col-md-5">';
  htmltxt += '<div class="form-group">';
  htmltxt += '<label for="pwd">First Name</label>';
  htmltxt += '<input type="text" class="form-control" name="vfname[]" required>';
  htmltxt += '</div>';
  htmltxt += '</div>';
  htmltxt += '<div class="col-md-5">';
  htmltxt += '<div class="form-group">';
  htmltxt += '<label for="usr">Last Name</label>';
  htmltxt += '<input type="text" class="form-control" name="vlname[]">';
  htmltxt += '</div>';
  htmltxt += '</div>';
  htmltxt += '<div class="col-md-2">';
  htmltxt += '<div class="form-group">';
  htmltxt += '<button type="button" onclick="removenewvisitor(this)" class="btn btn-danger mt25">Remove</button>';
  htmltxt += '</div>';
  htmltxt += '</div>';
  htmltxt += '</div>';
  $(".visitorcontainer").append(htmltxt);

}

function printDiv()
{

  var divToPrint = document.getElementById('visitingcardTbl');

  var newWin = window.open('', 'Print-Window');

  newWin.document.open();

  newWin.document.write('<html><body onload="window.print()">' + divToPrint.innerHTML + '</body></html>');

  newWin.document.close();

  setTimeout(function () {
    newWin.close();
  }, 10);

}

function resetattandancefilter() {
  $("#attandance_start_date").val('');
  $("#attandance_end_date").val('');
  showattendanceFilter();
}

function removenewvisitor(obj) {
  var sectionLength = $(".new-visitor-section").length;

  $(obj).parents('.new-visitor-section').remove();
}


function settovisitinghr(obj) {
  var fromhr = $(obj).val();
  var fromhrstart = 00;
  if (fromhr) {
    var fromhrstart = fromhr;
  } else {
    var fromhrstart = 00;
  }
}




function addVisitorOrganization() {
  $(".visitor-submit-button").LoadingOverlay("show", {
    background: "rgba(165, 190, 100, 0.5)"
  });
  $(".visitor-submit-button").prop('disabled', true);
  var vorganization_name = $("#vorganization_name").val();
  var vcontact_name = $("#vcontact_name").val();
  var vaddress = $("#vaddress").val();
  var vcity = $("#vcity").val();
  var vstate = $("#vstate").val();
  var vcountry = $("#vcountry").val();
  var vlandline = $("#vlandline").val();
  var vmobilenumber = $("vmobilenumber").val();
  $.ajax({
    type: 'POST',
    url: baseURL + "addvisitororganization",
    dataType: 'JSON',
    async: false,
    data: {vorganization_name: vorganization_name, vcontact_name: vcontact_name, vaddress: vaddress, vcity: vcity, vstate: vstate,
      vcountry: vcountry, vlandline: vlandline, vmobilenumber: vmobilenumber},
    success: function (response) {

      if (response == 'EXIST') {
        $(".error_vorganization_name").text('Organization name already exist.');
        $(".visitor-submit-button").prop('disabled', false);
      } else if (response == 'SUCCESS') {

        document.getElementById("visitorOrganizationForm").reset();
        $(".visitor-submit-button").prop('disabled', false);
        $('#addorganizationModal').modal("hide");
        $("#visitor_organization").val(vorganization_name);
      }
      $(".visitor-submit-button").LoadingOverlay("hide", true);
    }
  });
  return false;
}




$(document).ready(function () {



  showmonthlyBenchMark('week');

  $("#benchmonth").datepicker({
    changeMonth: true,
    changeYear: true,
    showButtonPanel: true,
    dateFormat: 'yy-mm',
    maxDate: "+1D"
  });

  $("#manpower_teams_listing_tbl").DataTable();

  /*$('#selected_employees').select2();*/

  $("#skills").select2({
    tags: true,
    tokenSeparators: [',']
  });



  $("#client_selection").select2({
    placeholder: "Please select client",
    tags: true,
    tokenSeparators: [',']
  });


  $("#filter_ticket_assign").select2({

    minimumInputLength: 2,
    width: 'resolve',
    placeholder: "Search Employee",
    allowClear: true,
    ajax: {
      url: baseURL + "getsearchemployee",
      dataType: 'json',
      type: "POST",
      async: false,
      data: function (term) {
        return {
          term: term,
          rolePriority: $('#role option:selected').data('role-priority'),
          //rolePriority: $('#role').data('role-priority')
        };
      },
      //data: {term: term, rolePriority: $(this).data('role-priority')},
      processResults: function (data) {
        return {
          results: data
        };
      },
    }
  });

  $("#ticketassigntonew").select2({
    minimumInputLength: 2,
    width: 'resolve',
    placeholder: "Search Employee",
    allowClear: true,
  });

  $("#ticketassignto").select2({
    minimumInputLength: 2,
    width: 'resolve',
    placeholder: "Search Employee",
    allowClear: true,
    ajax: {
      url: baseURL + "getsearchemployee",
      dataType: 'json',
      type: "POST",
      async: false,
      data: function (term) {
        return {
          term: term
        };
      },
      processResults: function (data) {
        return {
          results: data
        };
      },
    }
  });

  $("#editticketassignto").select2({
    minimumInputLength: 2,
    width: 'resolve',
    placeholder: "Search Employee",
    allowClear: true,
    /*ajax:{
     url:baseURL+"getsearchemployee",
     dataType: 'json',
     type: "POST",
     async:false,
     data: function (term) {
     return {
     term: term
     };
     },
     processResults: function (data) {
     return {
     results: data
     };
     },
     }*/
  });

  $("#visitor_organization").select2({
    minimumInputLength: 2,
    placeholder: "Select a organization",
    allowClear: true,
    ajax: {
      url: baseURL + "getvisitorganization",
      dataType: 'json',
      type: "POST",
      async: false,
      data: function (term) {
        return {
          term: term
        };
      },
      processResults: function (data) {
        return {
          results: data
        };
      },

    }
  });

  $("#empname").select2({
    minimumInputLength: 2,
    width: 'resolve',
    placeholder: "Search Employee",
    allowClear: true,
    ajax: {
      url: baseURL + "getappointmentemployee",
      dataType: 'json',
      type: "POST",
      async: false,
      data: function (term) {
        return {
          term: term
        };
      },
      processResults: function (data) {
        return {
          results: data
        };
      },
      select: function (data) {
        alert(data);
      }
    }
  });

  $('#empname').on('change', function () {
    var label = $("#empname option:selected").text();
    var value = $("#empname option:selected").val();
    $('#emp_id').val(value);
  })

  /*$( "#empname" ).autocomplete({
   source: function( request, response ) {
   // Fetch data
   $.ajax({
   url: baseURL+"fetchemployeelist",
   type: 'post',
   dataType: "json",
   data: {
   search: request.term,org_id:$("#organization_id").val()
   },
   success: function( data ) {
   response( data );
   }
   });
   },
   select: function (event, ui) {
   // Set selection
   $('#empname').val(ui.item.label); // display the selected text
   $('#emp_id').val(ui.item.value); // save selected id to input
   return false;
   }
   });*/

  $("#attandance_start_date").datepicker({
    dateFormat: 'dd-mm-yy',
    changeMonth: true,
    changeYear: true,
    yearRange: "-50:+0", maxDate: new Date(),
    onSelect: function (date) {
      var min = $(this).datepicker('getDate') || new Date();
      var max = new Date(min.getTime());
      $('#attandance_end_date').datepicker('option', {minDate: min});
      //$("#attandance_end_date").datepicker( "option", "minDate", endDate );
    }
  });


  $("#attandance_end_date").datepicker({
    dateFormat: 'dd-mm-yy',
    changeMonth: true,
    changeYear: true,
    yearRange: "-50:+0",
    maxDate: new Date(),
  });

  $("#doj").datepicker({
    dateFormat: 'dd-mm-yy',
    changeMonth: true,
    changeYear: true,
    yearRange: "-50:+0",
    maxDate: new Date(),
  });

  //ticketstartdate
  //ticketduedate

  $("#ticketstartdate").datepicker({
    dateFormat: 'dd-mm-yy',
    changeMonth: true,
    changeYear: true,
    yearRange: "-50:+0",
    //maxDate:new Date(),
    minDate: new Date(),
    onSelect: function (date) {
      var min = $(this).datepicker('getDate') || new Date();
      var max = new Date(min.getTime());
      $('#ticketduedate').datepicker('option', {minDate: min});
      //$("#attandance_end_date").datepicker( "option", "minDate", endDate );
    }
  });

  $("#ticketduedate").datepicker({
    dateFormat: 'dd-mm-yy',
    changeMonth: true,
    changeYear: true,
    yearRange: "-50:+0",
    minDate: new Date(),
    //maxDate:new Date(),
  });




  $("#editticketstartdate").datepicker({
    dateFormat: 'dd-mm-yy',
    changeMonth: true,
    changeYear: true,
    yearRange: "-50:+0",
    //maxDate:new Date(),
    minDate: new Date(),
    onSelect: function (date) {
      var min = $(this).datepicker('getDate') || new Date();
      var max = new Date(min.getTime());
      $('#ticketduedate').datepicker('option', {minDate: min});
      //$("#attandance_end_date").datepicker( "option", "minDate", endDate );
    }
  });

  $("#editticketduedate").datepicker({
    dateFormat: 'dd-mm-yy',
    changeMonth: true,
    changeYear: true,
    yearRange: "-50:+0",
    minDate: new Date(),
    //maxDate:new Date(),
  });



  $("#filter_ticket_start_date").datepicker({
    dateFormat: 'dd-mm-yy',
    changeMonth: true,
    changeYear: true,
    yearRange: "-50:+0",
    onSelect: function (date) {
      var min = $(this).datepicker('getDate') || new Date();
      var max = new Date(min.getTime());
      $('#filter_ticket_due_date').datepicker('option', {minDate: min});
      //$("#attandance_end_date").datepicker( "option", "minDate", endDate );
    }
  });

  $("#filter_ticket_due_date").datepicker({
    dateFormat: 'dd-mm-yy',
    changeMonth: true,
    changeYear: true,
    yearRange: "-50:+0",
    //maxDate:new Date(),
  });



  $("#visitor_report_start_date").datepicker({
    dateFormat: 'dd-mm-yy',
    changeMonth: true,
    changeYear: true,
    yearRange: "-50:+0",
    maxDate: new Date(),
    onSelect: function (date) {
      var min = $(this).datepicker('getDate') || new Date();
      var max = new Date(min.getTime());
      $('#visitor_report_end_date').datepicker('option', {minDate: min});
    }
  });

  $("#visitor_report_end_date").datepicker({
    dateFormat: 'dd-mm-yy',
    changeMonth: true,
    changeYear: true,
    yearRange: "-50:+0",
    //maxDate:new Date(),
  });



  $("#visit_date_filter").datepicker({
    dateFormat: 'dd-mm-yy',
    changeMonth: true,
    changeYear: true,
    yearRange: "-50:+0",
    //maxDate:new Date(),
  });

  $("#appointmentfromdate").datepicker({
    dateFormat: 'dd-mm-yy',
    minDate: new Date(),
    changeMonth: true,
    changeYear: true,
    yearRange: "-50:+2",
    //maxDate:new Date(),
    onSelect: function (date) {
      var min = $(this).datepicker('getDate') || new Date();
      var max = new Date(min.getTime());
      $('#appointmenttodate').datepicker('option', {minDate: min});
      //$("#attandance_end_date").datepicker( "option", "minDate", endDate );
    }
  });

  $("#appointmenttodate").datepicker({
    dateFormat: 'dd-mm-yy',
    changeMonth: true,
    changeYear: true,
    yearRange: "-50:+0",
    //maxDate:new Date(),
  });

  showUserAttendancenew();

  $('#userattenlist').DataTable({
    "columnDefs": [
      {"className": "dt-center", "targets": "_all"}
    ],
    "ordering": false,
    "processing": true,
    "serverSide": true,
    "searching": false,
    "ajax": {
      "url": baseURL + "/getalluserattendancelist",
      "type": "POST",
      "data": {organization_id: $("#organization_id").val()},

    }
  });


  $("#requestEmployee").DataTable({
    "columnDefs": [
      {"className": "dt-center", "targets": "_all"}
    ],
    "ordering": false,
    "processing": true,
    "serverSide": true,
    "searching": false,
    "ajax": {
      "url": baseURL + "/getrequestemployeelist",
      "type": "POST",
    }
  });


  $("#userlistintbl").DataTable({
    "columnDefs": [
      {"className": "dt-center", "targets": "_all"}
    ],
    "ordering": false,
    "processing": true,
    "serverSide": true,
    "searching": false,
    "ajax": {
      "url": baseURL + "/getuserajaxlisting",
      "type": "POST",
      //"data": {roleId: '3'}

    }
  });


  $('#departmentlisttbl').DataTable({
    "columnDefs": [
      {"className": "dt-center", "targets": "_all"}
    ],
    "ordering": false,
    "processing": true,
    "serverSide": true,
    "searching": true,
    "ajax": {
      "url": baseURL + "getdepartmentlist",
      "type": "POST",

    }
  });

  $('#subdepartmentlisttbl').DataTable({
    "columnDefs": [
      {"className": "dt-center", "targets": "_all"}
    ],
    "ordering": false,
    "processing": true,
    "serverSide": true,
    "searching": true,
    "ajax": {
      "url": baseURL + "getsubdepartmentlist",
      "type": "POST",

    }
  });
  $('#shiftlisttbl').DataTable({
    "columnDefs": [
      {"className": "dt-center", "targets": "_all"}
    ],
    "ordering": false,
    "processing": true,
    "serverSide": true,
    "searching": true,
    "ajax": {
      "url": baseURL + "getshiftlist",
      "type": "POST",

    }
  });


  $('#clientlisttbl').DataTable({
    "columnDefs": [
      {"className": "dt-center", "targets": "_all"}
    ],
    "ordering": false,
    "processing": true,
    "serverSide": true,
    "searching": true,
    "ajax": {
      "url": baseURL + "getclientajax",
      "type": "POST",

    }
  });

  $('#subdeptmngttbl').DataTable({
    "columnDefs": [
      {"className": "dt-center", "targets": "_all"}
    ],
    "ordering": false,
    "processing": true,
    "serverSide": true,
    "searching": true,
    "ajax": {
      "url": baseURL + "get-sub-dept-mngt-list",
      "type": "POST",

    }
  });
  $('#supervisormngttbl').DataTable({
    "columnDefs": [
      {"className": "dt-center", "targets": "_all"}
    ],
    "ordering": false,
    "processing": true,
    "serverSide": true,
    "searching": true,
    "ajax": {
      "url": baseURL + "get-supervisor-mngt-list",
      "type": "POST",

    }
  });


  $('#locationlisttbl').DataTable({
    "columnDefs": [
      {"className": "dt-center", "targets": "_all"}
    ],
    "ordering": false,
    "processing": true,
    "serverSide": true,
    "searching": false,
    "ajax": {
      "url": baseURL + "/getlocationlist",
      "type": "POST",

    }
  });

  $('#visitor_pre_register_tbl').DataTable({
    "columnDefs": [
      {"className": "dt-center", "targets": "_all"}
    ],
    "ordering": false,
    "processing": true,
    "serverSide": true,
    "searching": false,
    "ajax": {
      "url": baseURL + "/getpreregistervisit",
      "type": "POST",

    }
  });


  $("#visitiorreporttbl").DataTable({
    "columnDefs": [
      {"className": "dt-center", "targets": "_all"}
    ],
    "ordering": false,
    "processing": true,
    "serverSide": true,
    "searching": false,
    "ajax": {
      "url": baseURL + "/getvisitorreport",
      "type": "POST",

    }
  });

  $("#checkoutlistbl").DataTable({
    "columnDefs": [
      {"className": "dt-center", "targets": "_all"}
    ],
    "ordering": false,
    "processing": true,
    "serverSide": true,
    "searching": false,
    "ajax": {
      "url": baseURL + "/getcheckoutlist",
      "type": "POST",

    }
  });

  $("#allticketlisting").DataTable({
    "columnDefs": [
      {"className": "dt-center", "targets": "_all"}
    ],
    "ordering": false,
    "processing": true,
    "serverSide": true,
    //"searching":false,
    "ajax": {
      "url": baseURL + "getticketslisting",
      "type": "POST",
      "data": {type: 'all'}

    }
  });

  $("#openticketlisting").DataTable({
    "columnDefs": [
      {"className": "dt-center", "targets": "_all"}
    ],
    "ordering": false,
    "processing": true,
    "serverSide": true,
    //"searching":false,
    "ajax": {
      "url": baseURL + "getticketslisting",
      "type": "POST",
      "data": {type: '0'}

    }
  });

  $("#closeticketlisting").DataTable({
    "columnDefs": [
      {"className": "dt-center", "targets": "_all"}
    ],
    "ordering": false,
    "processing": true,
    "serverSide": true,
    //"searching":false,
    "ajax": {
      "url": baseURL + "getticketslisting",
      "type": "POST",
      "data": {type: '1'}

    }
  });



  tinymce.init({selector: '#ticketcommenttext'});
  tinymce.init({selector: '#ticketdescription'});
  tinymce.init({selector: '#editticketdescription'});
});


function addcommentattachmentfiles() {
  var html = '<input type="file" accept=".csv,.xls,.txt,.pdf,.docx,.xlsx,image/*" id="ticketcommentfile" name="ticketcommentfile[]" class="mb10" />';
  $(".file-section").append(html);
}

function addattachmentfiles() {
  var html = '<div class="addfiles"><input accept=".csv,.xls,.txt,.pdf,.docx,.xlsx,image/*" type="file" name="ticketfile[]" id="ticketpriority" /> <a href="javascript:void(0)" onclick="removeTicketFile(this)"><i class="fa fa-close" style="color:red"></i></a></div>';
  $(".ticketfilesection").append(html);
}

function editattachmentfiles() {
  var html = '<div class="addfiles"><input accept=".csv,.xls,.txt,.pdf,.docx,.xlsx,image/*" type="file" name="editticketfile[]" id="ticketpriority" /> <a href="javascript:void(0)" onclick="removeTicketFile(this)"><i class="fa fa-close" style="color:red"></i></a></div>';
  $(".editticketfilesection").append(html);
}

function removeTicketFile(obj) {
  $(obj).parent('.addfiles').remove();
}

function showTicketFilter() {
  var ticketId = $("#filter_ticket_id").val();
  var subject = $("#filter_ticket_subject").val();
  var assignUser = $("#filter_ticket_assign").val();
  var email = $("#filter_ticket_email").val();
  var start_date = $("#filter_ticket_start_date").val();
  var due_date = $("#filter_ticket_due_date").val();
  var ticket_priority = $("#filter_ticket_priority").val();

  $("#allticketlisting").DataTable().destroy();
  $("#openticketlisting").DataTable().destroy();
  $("#closeticketlisting").DataTable().destroy();

  $("#allticketlisting").DataTable({
    "columnDefs": [
      {"className": "dt-center", "targets": "_all"}
    ],
    "ordering": false,
    "processing": true,
    "serverSide": true,
    //"searching":false,
    "ajax": {
      "url": baseURL + "getticketslisting",
      "type": "POST",
      "data": {type: 'all', ticketId: ticketId, subject: subject, assignUser: assignUser, start_date: start_date, due_date: due_date, ticket_priority: ticket_priority}

    }
  });

  $("#openticketlisting").DataTable({
    "columnDefs": [
      {"className": "dt-center", "targets": "_all"}
    ],
    "ordering": false,
    "processing": true,
    "serverSide": true,
    //"searching":false,
    "ajax": {
      "url": baseURL + "getticketslisting",
      "type": "POST",
      "data": {type: '0', ticketId: ticketId, subject: subject, assignUser: assignUser, start_date: start_date, due_date: due_date, ticket_priority: ticket_priority}

    }
  });

  $("#closeticketlisting").DataTable({
    "columnDefs": [
      {"className": "dt-center", "targets": "_all"}
    ],
    "ordering": false,
    "processing": true,
    "serverSide": true,
    //"searching":false,
    "ajax": {
      "url": baseURL + "getticketslisting",
      "type": "POST",
      "data": {type: '1', ticketId: ticketId, subject: subject, assignUser: assignUser, start_date: start_date, due_date: due_date, ticket_priority: ticket_priority}

    }
  });



  return false;
}

function showcheckoutlist() {
  $("#checkoutlistbl").DataTable().destroy();
  $("#checkoutlistbl").DataTable({
    "columnDefs": [
      {"className": "dt-center", "targets": "_all"}
    ],
    "ordering": false,
    "processing": true,
    "serverSide": true,
    "searching": false,
    "ajax": {
      "url": baseURL + "/getcheckoutlist",
      "type": "POST",

    }
  });
}

function checkoutvisitor(visitorId, obj) {
  $("#checkoutappointmentid").val(visitorId);
  $('#checkoutpopup').modal('show');
}


function resetcheckoutform() {
  $("#checkoutgatefilter").val('');
  $("#appointmentfilter").val('');
  showcheckoutlist();
}

function checkoutfilter() {
  var checkoutgate = $("#checkoutgatefilter").val();
  var appointment = $("#appointmentfilter").val();
  $("#checkoutlistbl").DataTable().destroy();
  $("#checkoutlistbl").DataTable({
    "columnDefs": [
      {"className": "dt-center", "targets": "_all"}
    ],
    "ordering": false,
    "processing": true,
    "serverSide": true,
    "searching": false,
    "ajax": {
      "url": baseURL + "/getcheckoutlist",
      "type": "POST",
      "data": {checkoutgate: checkoutgate, appointment: appointment}

    }
  });
  return false;
}

function addcheckstatus() {
  var visitoID = $("#checkoutappointmentid").val();
  var checkoutgate = $("#checkoutgate").val();
  if (visitoID) {
    $.ajax({
      type: 'POST',
      url: baseURL + "/checkoutrequest",
      data: {visitoID: visitoID, checkoutgate: checkoutgate},
      async: false,
      dataType: 'JSON',
      success: function (response) {
        if (response == 'updated') {
          showcheckoutlist();


          document.getElementById("checkoutform").reset();
          $('#checkoutpopup').modal('hide');
        }
      }
    });
  }

}

function showattendanceFilter() {


  var start_date = $("#attandance_start_date").val();
  var end_date = $("#attandance_end_date").val();

  var userId = $("#selectempid").val();

  if (userId == undefined || userId == '') {

    showUserAttendancenew();

  } else {

    showuserattendance(userId);
  }
}

function addNewDepartment(client, department, subDepartment, shift) {
  $(".alert-msg").text('');
  var remark = $("#remark").val();
  if (client && department && subDepartment && shift) {
//    alert(baseURL + "/addnewdepartment");
    $.ajax({
      type: 'POST',
      url: baseURL + "/addnewdepartment",
      dataType: 'JSON',
      data: {remark: remark, client: client, department: department, subDepartment: subDepartment, shift: shift},
      success: function (response) {
//        console.log(response);
        if (response == 'exist') {
          $(".alert-msg").css("color", "red");
          $(".alert-msg").text('Remark already exist.');
          $(".alert-msg").delay(1000).fadeOut('slow');
        } else {
          $(".alert-msg").css("color", "green");
          $(".alert-msg").text('Remark updated successfully.');
          $(".alert-msg").delay(1000).fadeOut('slow');

          $("#organizationm").val('');
          $("#deptnamem").val('');

        }
      }
    });
  }
  return false;
}


function getdepartmentlist(organizationId, type) {
  if (organizationId) {
    $.ajax({
      type: 'POST',
      url: baseURL + 'getdepartmentlistnew',
      dataType: 'JSON',
      data: {organizationId: organizationId, type: type},
      success: function (response) {
        $("#department").html(response);
      }
    });
  } else {
    $("#department").html('<option value="">Select Department</option>');
  }
  //validate_w_d_sd();
}
function getClientlist(organizationId, locId, type) {
  if (organizationId) {
    $.ajax({
      type: 'POST',
      url: baseURL + 'getclientlist',
      dataType: 'JSON',
      data: {organizationId: organizationId, type: type, locId: locId},
      success: function (response) {
        $("#client").html(response);
      }
    });
  } else {
    $("#client").html('<option value="">Select Client</option>');
  }
  //validate_w_d_sd();
}

function getLocationlist(clientId) {
  $("#location").attr('disabled', '');
  if (clientId && clientId != 'all') {

    $.ajax({
      type: 'POST',
      url: baseURL + 'getLocationByClient',
      dataType: 'JSON',
      data: {clientId: clientId},
      success: function (response) {
        $("#location").html(response);
        $("#location").removeAttr('disabled');

      }
    });
  } else {
    $("#location").html('<option value="">Select Location</option>');
  }
  //validate_w_d_sd();

}

function getClientlistBy(clientId) {
  $("#location").attr('disabled', '');
  if (clientId && clientId != 'all') {

    $.ajax({
      type: 'POST',
      url: baseURL + 'getLocationByClient',
      dataType: 'JSON',
      data: {clientId: clientId},
      success: function (response) {
        $("#location").html(response);
        $("#location").removeAttr('disabled');

      }
    });
  } else {
    $("#location").html('<option value="">Select Location</option>');
  }
  //validate_w_d_sd();

}

function getWarehouselist(locId, type) {
  if (locId) {
    $.ajax({
      type: 'POST',
      url: baseURL + 'getWarehouseByLocation',
      //url: baseURL + 'getWarehouseByClient',
      dataType: 'JSON',
      data: {locationId: locId, type: type},
      success: function (response) {
        $("#organization").html(response);
      }
    });
  } else {
    $("#organization").html('<option value="">Select Organization</option>');
  }
  //validate_w_d_sd();
}

function  getsubdepartmentlist(department, organizationId, type) {
  //console.log(department);
  if (department) {
    $.ajax({
      type: 'POST',
      url: baseURL + 'getsubdepartmentlistajax',
      dataType: 'JSON',
      data: {organizationId: organizationId, departmentId: department, type: type},
      success: function (response) {
//        console.log(response);
        $("#subdepartment").html(response);
      }
    });
  } else {
    $("#subdepartment").html('<option value="">Select Sub Department</option>');
  }
  //validate_w_d_sd();
}
function  getshiftlist(subDepartment) {
  //console.log(department);
  if (subDepartment) {
    $.ajax({
      type: 'POST',
      url: baseURL + 'getshiftlistajax',
      dataType: 'JSON',
      data: {subdepartmentId: subDepartment},
      success: function (response) {
        $("#shift").html(response);
      }
    });
  } else {
    $("#shift").html('<option value="">Select Sub Department</option><option value="all">All</option>');
  }
  //validate_w_d_sd();
}


function  getSupervisorListBySubDept(subDept) {
  if (subDept) {
    $.ajax({
      type: 'POST',
      url: baseURL + 'get-supervisorlist-by-sub-dept',
      dataType: 'JSON',
      data: {subDeptId: subDept},
      success: function (response) {
        console.log(response);
        $("#supervisor").html(response);
      }
    });
  } else {
    $("#supervisor").html('<option value="">Select Supervisor</option>');
  }
  //validate_w_d_sd();
}
function  getShiftMngtListBySubDept(subDept) {
  var dept = $('#department').val()
  if (subDept) {
    $.ajax({
      type: 'POST',
      url: baseURL + 'shiftmngtajax',
      dataType: 'JSON',
      data: {deptId: dept, subDeptId: subDept},
      success: function (response) {
        //console.log(response);
        $("#siftmngtid").html(response);
      }
    });
  } else {
    $("#siftmngtid").html('<option value="">Select Supervisor</option>');
  }
  //validate_w_d_sd();
}

function getPerformaceEmployeeBySubDepartment(subDepartment) {
  if (subDepartment) {
    $.ajax({
      type: 'POST',
      url: baseURL + 'getPerformaceEmployeeBySubDepartmentAjax',
      dataType: 'JSON',
      data: {subDepartment: subDepartment},
      success: function (response) {
        console.log(response);
        $("#emp_name").html(response);
      }
    });
  } else {
    $("#emp_name").html('<option value="">Select Employee Name</option>');
  }
  //validate_w_d_sd();
}
function showHideEmpDiv(empDivVal) {

  if ($(empDivVal).is(":checked")) {
    $('#emp_div').show();
  } else {
    $('#emp_div').hide();
  }

}

function validateme() {
  alert("hhhhh");
  if ($("#location").val() == '') {
    $("#location").css("border", "1px solid red");
    $("#location").focus();
    return false;
  } else if ($("#organization").val() == '') {
    $("#organization").css("border", "1px solid red");
    $("#organization").focus();
    return false;
  } else if ($("#client").val() == '') {
    $("#client").css("border", "1px solid red");
    $("#client").focus();
    return false;
  } else if ($("#department").val() == '') {
    $("#department").css("border", "1px solid red");
    $("#department").focus();
    return false;
  } else if ($("#subdepartment").val() == '') {
    $("#subdepartment").css("border", "1px solid red");
    $("#subdepartment").focus();
    return false;
  } else if ($("#emp_name").val() == '') {
    $("#emp_name").css("border", "1px solid red");
    $("#emp_name").focus();
    return false;
  } else {
    // $(".dwn-button").show();
    return true;
  }
}

$("#client").change(function () {


  $(this).css("border", "1px solid #d2d6de");

});
$("#location").change(function () {


  $(this).css("border", "1px solid #d2d6de");

});
$("#organization").change(function () {


  $(this).css("border", "1px solid #d2d6de");

});
$("#department").change(function () {


  $(this).css("border", "1px solid #d2d6de");

});
$("#subdepartment").change(function () {


  $(this).css("border", "1px solid #d2d6de");

});

function showuserattendance(userId) {

  $("#selectempid").val(userId);
  $('#foradminattendancelist').DataTable().destroy();

  var start_date = $("#attandance_start_date").val();
  var end_date = $("#attandance_end_date").val();

  $('#foradminattendancelist').DataTable({
    "columnDefs": [
      {"className": "dt-center", "targets": "_all"}
    ],
    "ordering": false,
    "processing": true,
    "serverSide": true,
    "searching": false,
    "ajax": {
      "url": baseURL + "/getuserattendancelist",
      "type": "POST",
      "data": {userId: userId, start_date: $("#attandance_start_date").val(), end_date: $("#attandance_end_date").val()},

    }
  });
  $("#foradminattendancelist-section").show();
}


function showloading() {
  $.LoadingOverlay("show");
}

function hideloading() {
  $.LoadingOverlay("hide");
}

function updateAttendance(userId, status, obj) {
  showloading();
  $.ajax({
    type: 'POST',
    url: baseURL + 'updateattendancestatus',
    async: false,
    dataType: 'JSON',
    data: {userId: userId, status: status},
    success: function (e) {
      if (e) {
        var html = '';
        if (status == 'in') {
          html += '<div class="col-md-12"><b>Check In:</b></div>';

        } else {
          html += '<div class="col-md-12"><b>Check Out:</b></div>';
        }
        html += '<div class="col-md-12">Date:' + e['date'] + '</div>';
        html += '<div class="col-md-12">Time:' + e['time'] + '</div>';

        if (status == 'in') {
          $(".today-signin-attandance").html(html);
        } else {
          $(".today-signout-attandance").html(html);
        }

        $(obj).parent('td').text(e);
        hideloading();
        swal("Thank you!", "", "success");
        showuserattendance(userId);
      }
    }
  });
}