<div class="content-wrapper">
  <!-- Content Header (Page header) -->
  <section class="content-header">
    <h1>
      <i class="fa fa-users"></i> Employee Management
      <small>Add / Edit Employee</small>
    </h1>
  </section>

  <section class="content">

    <div class="row">
      <!-- left column -->
      <div class="col-md-8">
        <!-- general form elements -->



        <div class="box box-primary">
          <div class="box-header">
            <h3 class="box-title">Enter User Details</h3>
          </div><!-- /.box-header -->
          <!-- form start -->
          <?php $this->load->helper("form"); ?>
          <form id="addUser1"  action="<?php echo base_url() ?>addNewUser" onsubmit="return addNewUserForm()" method="post" role="form" enctype="multipart/form-data">
            <div class="box-body">
              <div class="row">
                <div class="col-md-6">
                  <div class="form-group">
                    <label for="fname">Full Name</label>
                    <input type="text" class="form-control required" required value="<?php echo set_value('fname'); ?>" id="fname" name="fname" maxlength="128">
                  </div>

                </div>
                <div class="col-md-6">
                  <div class="form-group">
                    <label for="email">Email Address</label>
                    <input type="email" class="form-control required email" onblur="checkUniqueMail()" required id="email" value="<?php echo set_value('email'); ?>" name="email" maxlength="128">
                  </div>
                </div>
              </div>
              <div class="row">
                <div class="col-md-6">
                  <div class="form-group">
                    <label for="password">Password</label>
                    <input type="password" class="form-control required"  required id="password" name="password" maxlength="20">
                  </div>
                </div>
                <div class="col-md-6">
                  <div class="form-group">
                    <label for="cpassword">Confirm Password</label>
                    <input type="password" class="form-control required equalTo"  required id="cpassword" name="cpassword" maxlength="20">
                  </div>
                </div>
              </div>
              <div class="row">
                <div class="col-md-6">
                  <div class="form-group">
                    <label for="mobile">Mobile No.</label>
                    <input type="text" class="form-control required digits" required pattern="^\d{10}$" title="Please enter 10 digit valid mobile number" id="mobile" value="<?php echo set_value('mobile'); ?>" name="mobile" maxlength="10">
                  </div>
                </div>
                <div class="col-md-6">
                  <div class="form-group">
                    <label for="role">Date of joining</label>

                    <input type="text" required autocomplete="off" required onkeypress="return false" class="form-control required" name="doj" id="doj" > </input>
                  </div>
                </div>

              </div>

              <div class="row">
                <div class="col-md-6">
                  <div class="form-group">
                    <label for="organization">Organization</label>
                    <select class="form-control required" id="organization" required="" name="organization" onchange="getdepartmentlist(this.value)">
                      <option value="">Select Organization</option>
                      <?php if (isset($organizationList)) { ?>
                        <?php foreach ($organizationList as $key => $org) { ?>
                          <option value="<?php echo $org['id'] ?>"><?php echo $org['org_name']; ?></option>
                        <?php } ?>
                      <?php } ?>
                    </select>
                  </div>
                </div>
                <div class="col-md-6">
                  <div class="form-group">
                    <label for="department">Department</label><a data-toggle="modal" data-target="#adddepartmentmodel" href="javascript:void(0)" class="pull-right">Add New</a>
                    <select class="form-control required" required=""  id="department" name="department" onchange="$('#shift').val('')">
                      <option value="">Select Department</option>>

                    </select>
                  </div>
                </div>
              </div>
              <div class="row">
                <div class="col-md-6">
                  <div class="form-group">
                    <label for="role">Role</label>
                    <select class="form-control required" required="" id="role" name="role">
                      <option value="">Select Role</option>
                      <?php
                      if (!empty($roles)) {
                        foreach ($roles as $rl) {
                          if ($rl->roleId == 8 && $role != 1)
                            continue;
                          ?>
                          <option value="<?php echo $rl->roleId ?>" <?php if ($rl->roleId == set_value('role')) {
                        echo "selected=selected";
                      } ?>><?php echo $rl->role ?></option>
                          <?php
                        }
                      }
                      ?>
                    </select>
                  </div>
                </div>
                <div class="col-md-6">
                  <div class="form-group">
                    <label for="reporting_manager">Reporting Manager</label>
                    <!-- <input type="text" class="form-control required" name="skills" id="skills" > </input> -->
                    <select class="form-control" name="reporting_manager" id="filter_ticket_assign"></select>
                  </div>
                </div>

              </div>
              <div class="row" id="shift_div">
                <div class="col-md-6">
                  <div class="form-group">
                    <label for="shift">Shift</label>
                    <!-- //onchange="checkPreviousSuperVisor(this.value,'')" -->
                    <select class="form-control" id="shift" name="shift" >
                      <option value="">--Select--</option>
                      <option value="A">A</option>
                      <option value="B">B</option>
                      <option value="C">C</option>
                      <option value="D">D</option>
                      <option value="E">E</option>
                      <option value="F">F</option>
                      <option value="G">G</option>
                      <option value="H">H</option>
                    </select>
                  </div>
                </div>
                <div class="col-md-6"></div>
              </div>
              <div class="row">
                <div class="col-md-6">
                  <div class="form-group">
                    <label for="designation">Designation</label>
                    <input type="text" class="form-control required" required name="designation" id="designation" required=""> </input>
                  </div>
                </div>
                <div class="col-md-6">
                  <div class="form-group">
                    <label for="emp_code">Employee code</label>
                    <!-- <input type="text" class="form-control required" required name="skills" id="skills" > </input> -->
                    <input type="text" class="form-control" required onblur="checkEmployeeCode(this)" name="emp_code" id="emp_code" > </input>
                  </div>
                </div>
              </div>
              <div class="row">

                <div class="col-md-6">
                  <div class="form-group">
                    <label for="role">Skills</label>
                    <!-- <input type="text" class="form-control required" required name="skills" id="skills" > </input> -->
                    <select class="form-control" multiple="multiple" name="skills[]" id="skills"></select>
                  </div>
                </div>
                <div class="col-md-6">
                  <div class="form-group">
                    <label for="role">Profile Photo</label>
                    <input type="file" accept="image/*" class="form-control" name="avatar" id="avatar"> </input>
                  </div>
                </div>

              </div>
            </div><!-- /.box-body -->

            <div class="box-footer">
              <input type="submit" id="submitBth" class="btn btn-primary" value="Submit" />
              <input type="reset" class="btn btn-default" value="Reset" />
            </div>
          </form>
        </div>
      </div>
      <div class="col-md-4">
        <?php
        $this->load->helper('form');
        $error = $this->session->flashdata('error');
        if ($error) {
          ?>
          <div class="alert alert-danger alert-dismissable">
            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
            <?php echo $this->session->flashdata('error'); ?>
          </div>
        <?php } ?>
        <?php
        $success = $this->session->flashdata('success');
        if ($success) {
          ?>
          <div class="alert alert-success alert-dismissable">
            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
            <?php echo $this->session->flashdata('success'); ?>
          </div>
        <?php } ?>

        <div class="row">
          <div class="col-md-12">
            <?php echo validation_errors('<div class="alert alert-danger alert-dismissable">', ' <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button></div>'); ?>
          </div>
        </div>
      </div>
    </div>
  </section>

</div>
<script src="<?php echo base_url(); ?>assets/js/addUser.js" type="text/javascript"></script>
<div class="modal" id="adddepartmentmodel">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header listingtable-head">
        <button type="button" class="close" data-dismiss="modal">&times;</button>
        <h4 class="modal-title">Add New Department</h4>
      </div>
      <!-- Modal body -->
      <form action="" type="post" onsubmit="return addNewDepartment()">
        <div class="modal-body">

          <div class="row">
            <div class="col-md-6">
              <div class="form-group">
                <label for="fname">Organization Name</label>
                <select class="form-control required" id="organizationm" name="organizationm" required="">
                  <option value="">Select Organization</option>
                  <?php if (isset($organizationList)) { ?>
                    <?php foreach ($organizationList as $key => $org) { ?>
                      <option value="<?php echo $org['id'] ?>"><?php echo $org['org_name']; ?></option>
                    <?php } ?>
                  <?php } ?>
                </select>
              </div>
            </div>
            <div class="col-md-6">
              <div class="form-group">
                <label for="email">Department Name</label>
                <input type="text" class="form-control" id="deptnamem" value="" name="deptnamem" maxlength="128" required="">
              </div>
            </div>
          </div>

        </div>
        <div class="row">
          <div class="col-md-6">
            <div class="form-group">
              <p class="alert-msg"></p>
            </div>
          </div>
        </div>
        <!-- Modal footer -->
        <div class="modal-footer">
          <button type="submit" class="btn btn-primary">Add</button>
          <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
        </div>
      </form>
    </div>
  </div>
</div>


<div class="modal" id="changeRoleModel">
  <div class="modal-dialog">
    <div class="modal-content">

      <!-- Modal Header -->
      <div class="modal-header">
        <h4 class="modal-title">Change Role</h4>
        <button type="button" class="close" data-dismiss="modal">&times;</button>
      </div>
      <div><p>First Change the supervisor role of below employee</p></div>
      <!-- Modal body -->
      <div class="modal-body change-role-section">

      </div>

      <!-- Modal footer -->
      <div class="modal-footer">
        <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
      </div>

    </div>
  </div>
</div>
