<?php

if (!function_exists('get_instance')) {

  function get_instance() {
    $CI = &get_instance();
  }

}

if (!defined('BASEPATH'))
  exit('No direct script access allowed');





if (!function_exists('clientsListArray')) {

  function clientsListArray($supervisorId, $type = 'table') {
    if (isset($supervisorId) && !empty($supervisorId)) {
      $clientName = "<td>";

      $CI = get_instance();
      $CI->db->select('tbl_sub_dept_mngt.client_id,tbl_clients.client,tbl_clients.client as client_name');
      $CI->db->join('tbl_sub_dept_mngt', 'tbl_sub_dept_mngt.shift_mngt_id = shift_mgmt.id', 'left');
      $CI->db->join('tbl_clients', 'tbl_clients.id = tbl_sub_dept_mngt.client_id', 'left');
      $CI->db->where('shift_mgmt.superviser_id', $supervisorId);
      $CI->db->where('tbl_sub_dept_mngt.isDeleted', '0');
      $CI->db->group_by('client_id');
      $dataArray = $CI->db->get('shift_mgmt')->result_array();
      if ($type === 'array') {
        return $dataArray;
      }
      foreach ($dataArray as $data) {
        $clientName .= clientName($data['client_id']) . " <br>";
      }
      return $clientName .= "</td>";
    } else {
      return $clientName = "<td> NA </td>";
    }
  }

}
if (!function_exists('departmentList')) {

  function departmentList($supervisorId, $type = 'table') {
    if (isset($supervisorId) && !empty($supervisorId)) {
      $deptName = "<td>";
      $CI = get_instance();
      $CI->db->select('tbl_departments.dept_id,tbl_departments.dept_name');
      $CI->db->join('tbl_departments', 'tbl_departments.dept_id = shift_mgmt.dept_id', 'left');
      $CI->db->where('superviser_id', $supervisorId);
      $CI->db->group_by('dept_id');
      $dataArray = $CI->db->get('shift_mgmt')->result_array();
      if ($type === 'array') {
        return $dataArray;
      }
      foreach ($dataArray as $data) {
        $deptName .= deptName($data['dept_id']) . " <br>";
      }
      return $deptName .= "</td>";
    } else {
      return $deptName = "<td> NA </td>";
    }
  }

}

if (!function_exists('subDepartmentList')) {

  function subDepartmentList($supervisorId, $type = 'table') {
    if (isset($supervisorId) && !empty($supervisorId)) {
      $deptName = "<td>";
      $CI = get_instance();
      $CI->db->select('shift_mgmt.sub_dept_id,tbl_sub_departments.sub_dept_name,LOWER(uom.name)as name');
      $CI->db->join('tbl_sub_departments', 'tbl_sub_departments.id = shift_mgmt.sub_dept_id', 'left');
      $CI->db->join('tbl_sub_dept_mngt', 'tbl_sub_dept_mngt.shift_mngt_id = shift_mgmt.id', 'left');
      $CI->db->join('uom', 'uom.id = tbl_sub_dept_mngt.uom_id', 'left');
// . ' left join uom on uom.id = tbl_sub_dept_mngt.uom_id'
      $CI->db->where('shift_mgmt.superviser_id', $supervisorId);
      $CI->db->group_by('sub_dept_id');
      $dataArray = $CI->db->get('shift_mgmt')->result_array();
      if ($type === 'array') {
        return $dataArray;
      }
      foreach ($dataArray as $data) {
        $deptName .= subDeptName($data['sub_dept_id']) . " <br>";
      }
      return $deptName .= "</td>";
    } else {
      return $deptName = "<td> NA </td>";
    }
  }

}


if (!function_exists('shiftList')) {

  function shiftList($supervisorId, $type = 'table') {
    if (isset($supervisorId) && !empty($supervisorId)) {
//      tbl_shift
      $deptName = "<td>";
      $CI = get_instance();
      $CI->db->select('shift,shift_name,shift_mgmt.in_time,shift_mgmt.out_time');
      $CI->db->where('superviser_id', $supervisorId);
      $CI->db->join('tbl_shift', 'tbl_shift.id = shift_mgmt.shift', 'left');

      $CI->db->group_by('shift');
      $dataArray = $CI->db->get('shift_mgmt')->result_array();
      if ($type === 'array') {
        return $dataArray;
      }
      foreach ($dataArray as $data) {
        $deptName .= shiftName($data['shift']) . " (" . $data['in_time'] . "-" . $data['out_time'] . ") <br>";
      }
      return $deptName .= "</td>";
    } else {
      return $deptName = "<td> NA </td>";
    }
  }

}

if (!function_exists('supervisorPresentTeam')) {

  function supervisorPresentTeam($departmentId, $subDepartmentId, $userId, $orgId) {
    $CI = &get_instance();
    $currentStatus = "'1'";
    $selectQuery = 'SELECT '
            . '  '
            . ' U.roleId AS user_role,'
            . ' U.designation, '
            . ' U.userId AS user_id, '
            . ' U.name AS employee_name, '
            . ' U.email AS employee_email, '
            . ' U.userId AS employee_id, '
            . ' U.emp_code AS employee_code,'
            . ' U.department_id, U.current_status, '
            . ' (SELECT dept_name from `tbl_departments` where `dept_id`= department_id) as department_name, '
            . ' (SELECT sub_dept_name from `tbl_sub_departments` where `id`= sub_department_id) as sub_department_name FROM tbl_users AS U '
            . ' WHERE U.current_status = ' . $currentStatus . ' AND U.sub_department_id = ' . $subDepartmentId . ' AND U.department_id = ' . $departmentId . ' AND U.userId != ' . $userId . ' and organization_id = ' . $orgId . ' and U.roleId = 3 ';
    // die;
    $query = $CI->db->query($selectQuery);
    //pre($query);
    //return $result = $query->result_array();
    return $employees = $query->result_array();
    //pre($employees);
  }

}

if (!function_exists('shiftNameBySupervisorId')) {

  function shiftNameBySupervisorId($supervisorId) {
    $CI = &get_instance();
    $selectQuery = 'SELECT * '
            . ' from shift_mgmt'
            . ' WHERE superviser_id = ' . $supervisorId . ' AND isDeleted = 0 ';
    $query = $CI->db->query($selectQuery);
    $employees = $query->row_array('shift');
    return $employees['shift'];
  }

}
if (!function_exists('shiftIdByName')) {

  function shiftIdByName($shift) {
    $CI = &get_instance();
    $selectQuery = "SELECT id "
            . " from tbl_shift"
            . " WHERE shift_name = '" . $shift . "' AND isDeleted = '0' ";
    // die;
    $query = $CI->db->query($selectQuery);
    $employees = $query->row_array('id');
    //pre($employees);
    return $employees['id'];
  }

}

if (!function_exists('supervisorIdByOrgDeptSubDept')) {

  function supervisorIdByOrgDeptSubDept(
  $orgId, $deptId, $subDeptId) {
    $CI = &get_instance();
    $selectQuery = 'SELECT * '
            . ' from shift_mgmt'
            . ' WHERE org_id = ' . $orgId
            . ' AND dept_id = ' . $deptId
            . ' AND sub_dept_id = ' . $subDeptId
            . ' AND isDeleted = 0 '
            . '';
    $query = $CI->db->query($selectQuery);
    $employees = $query->row_array('superviser_id');
    return $employees['superviser_id'];
  }

}
?>
