<?php

if (!defined('BASEPATH'))
  exit('No direct script access allowed');

require APPPATH . '/libraries/BaseController.php';

/**
 * Class : User (UserController)
 * User Class to control all user related operations.
 * @author : Vijayraj Chaudhary
 * @version : 2.1
 * @since : 15 November 2019
 */
class SubDeptMngtController extends BaseController {

  /**
   * This is default constructor of the class
   */
  public function __construct() {
    parent::__construct();
    $this->load->model('user_model');
    $this->load->model('SubDeptMngt_model', 'subdeptmngt_model');
    $this->isLoggedIn();
    date_default_timezone_set('Asia/Kolkata');
  }

  function delSubDeptMngt($shiftId) {
    $this->db->where('id', $shiftId);
    $this->db->delete('tbl_sub_dept_mngt');
    //last_query();
    $this->session->set_flashdata('success', 'Sub Department Mngt Deleted Successfully');
    redirect(site_url('sub-dept-mngt'));
  }

  function getShiftMgmtListBySubDeptId() {
    if (!$this->input->is_ajax_request()) {
      exit('No direct script access allowed');
    }
    if (!in_array($this->role, ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12'])) {
      $this->loadThis();
    } else {
      $subDeptId = $this->input->post('subDeptId');
      $shiftList = $this->subdeptmngt_model->getShiftListBySubDeptId($subDeptId);
      //pre($shiftList);
      $html = "<option value=''>Select Shift</option>";
      if (!empty($shiftList)) {
        foreach ($shiftList as $key => $shift) {
          $html .= "<option value='" . $shift['id'] . "'>" . $shift['shift_name'] . "</option>";
        }
      }
      echo json_encode($html);
    }
  }

  function SubDeptMngt($subDeptMngt = '') {
//    pre($this->input->post());
    if (!in_array($this->role, ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12'])) {
      $this->loadThis();
    } else {

      if ($this->input->post()) {
        $this->form_validation->set_rules('dept_name', 'Department Name', 'required');
        $this->form_validation->set_rules('sub_dept_name', 'Sub Department Name', 'required');
        $this->form_validation->set_rules('siftmngtid', 'Shift Name', 'required');
        $this->form_validation->set_rules('client', 'Client Name', 'required');
        $this->form_validation->set_rules('banchmark', 'Banchmark', 'required');
        $this->form_validation->set_rules('uom', 'UOM', 'required');
        if ($this->form_validation->run() === TRUE) {
          $orgId = $this->organization_id;
          $deptId = $this->input->post('dept_name');
          $subDeptId = $this->input->post('sub_dept_name');
          $siftmngtid = $this->input->post('siftmngtid');
          $clientId = $this->input->post('client');
          $banchmark = $this->input->post('banchmark');
          $uom = $this->input->post('uom');
          $this->db->insert('tbl_sub_dept_mngt', ['dept_id' => $deptId, 'sub_dept_id' => $subDeptId, 'org_id' => $orgId, 'shift_mngt_id' => $siftmngtid, 'client_id' => $clientId, 'banchmark' => $banchmark, 'uom_id' => $uom]);
          $this->session->set_flashdata('success', 'New Shift Created Successfully');
          redirect(site_url('sub-dept-mngt'));
        }
      }
//      echo $subDeptMngt;
//      die;
      if ($subDeptMngt) {
        $data['subDeptMngtInfo'] = $this->subdeptmngt_model->getSubDeptMngtInfo($subDeptMngt);
      }
//      pre($data['subDeptMngtInfo']);
      $orgId = '';
      if (in_array($this->role, ['2', '4', '5', '6', '8', '9', '14', '11', '12'])) {
        $orgId = $this->organization_id;
      }

      $this->global['pageTitle'] = 'Searbird : Sub Department Management';
      $data['departmentList'] = $departmentList = $this->user_model->getDepartmentList($orgId);
      $deptId = isset($departmentList[0]['dept_id']) ? $departmentList[0]['dept_id'] : '';
      if ($subDeptMngt) {
        $data['subDepartmentList'] = $subDepartmentList = $this->user_model->getSubDepartmentList($data['subDeptMngtInfo']['dept_id'], $subDepartmentId = '', $withManPowerCount = '0');
      } else {
        $data['subDepartmentList'] = $subDepartmentList = $this->user_model->getSubDepartmentList($deptId, $subDepartmentId = '', $withManPowerCount = '0');
      }

      $subDeptId = isset($subDepartmentList[0]['id']) ? $subDepartmentList[0]['id'] : '';
      if ($subDeptMngt) {
        $data['shiftMngtList'] = shiftMngtByDeptIdSubDeptId($data['subDeptMngtInfo']['dept_id'], $data['subDeptMngtInfo']['sub_dept_id']);
      } else {
//        $data['subDepartmentList'] = $subDepartmentList = $this->user_model->getSubDepartmentList($deptId, $subDepartmentId = '', $withManPowerCount = '0');

        $data['shiftMngtList'] = shiftMngtByDeptIdSubDeptId($deptId, $subDeptId);
      }

      $data['uomList'] = getUOMList();
      //pre($data['uomList']);

      $data['organizedClientsList'] = getOrganizedClient();
//      pre($data['subDeptMngtInfo']);
      $this->loadViews("sub-dept-mngt-view", $this->global, $data, NULL);
    }
  }

  function shiftMngtAjax() {
    if (!in_array($this->role, ['1', '2', '5', '8', '9', '10', '11', '12', '13', '14'])) {
      $this->loadThis();
    } else {
      //pre($this->input->post());
      $deptId = $this->input->post('deptId');
      $subDeptId = $this->input->post('subDeptId');
      $shiftMngtList = shiftMngtByDeptIdSubDeptId($deptId, $subDeptId);
//      pre($shiftMngtList);
      $html = "<option value=''>Select Shift Mangt</option>";
      if (!empty($shiftMngtList)) {
        foreach ($shiftMngtList as $key => $shiftMngt) {
          $html .= "<option value='" . $shiftMngt['id'] . "'>" . $shiftMngt['shift_name'] . ' (' . empNameById($shiftMngt['superviser_id']) . ')' . "</option>";
        }
      }
      echo json_encode($html);
    }
  }

  function updateSubDeptMngt() {
    //pre($this->input->post());
    if (!in_array($this->role, ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12'])) {
      $this->loadThis();
    } else {
      $subDeptMngtId = $this->input->post('sub_dept_mngt_id');
      if ($this->input->post()) {
        $this->form_validation->set_rules('dept_name', 'Department Name', 'required');
        $this->form_validation->set_rules('sub_dept_name', 'Sub Department Name', 'required');
        $this->form_validation->set_rules('siftmngtid', 'Shiftt Mngt Id', 'required');
        $this->form_validation->set_rules('client', 'Client', 'required');
        $this->form_validation->set_rules('banchmark', 'Banchmark', 'required');
        $this->form_validation->set_rules('uom', 'UOM', 'required');
        if ($this->form_validation->run() === TRUE) {
          //$orgId = $this->organization_id;
          $deptId = $this->input->post('dept_name');
          $subDeptId = $this->input->post('sub_dept_name');
          $siftmngtid = $this->input->post('siftmngtid');
          $client = $this->input->post('client');
          $banchmark = $this->input->post('banchmark');
          $uom = $this->input->post('uom');
          $this->db->where('id', $subDeptMngtId);
          $this->db->update('tbl_sub_dept_mngt', ['dept_id' => $deptId, 'sub_dept_id' => $subDeptId, 'shift_mngt_id' => $siftmngtid, 'client_id' => $client, 'banchmark' => $banchmark, 'uom_id' => $uom]);
          $this->session->set_flashdata('success', 'Sub Department Mngt updated successfully');
          redirect(site_url('sub-dept-mngt'));
          exit;
        }
      }
      redirect(site_url('sub-dept-mngt'));
    }
  }

  function getSubDeptMngtlist() {
    if (!$this->input->is_ajax_request()) {
      exit('No direct script access allowed');
    }
    $userId = $this->session->userdata('userId');
    $draw = intval($this->input->post("draw"));
    $start = intval($this->input->post("start"));
    $length = intval($this->input->post("length"));
    $search = $this->input->post('search[value]');

    $this->db->select('tbl_users.name as super_name,shift_mgmt.in_time,shift_mgmt.out_time,tbl_clients.client,tbl_sub_dept_mngt.id,tbl_sub_departments.sub_dept_name,tbl_shift.shift_name,shift_mgmt.shift,tbl_departments.dept_name,tbl_sub_dept_mngt.banchmark,uom.name uom_name');
    $this->db->from('tbl_sub_dept_mngt');
    $this->db->where('tbl_sub_departments.isDeleted', '0');
    $this->db->where('tbl_sub_dept_mngt.isDeleted', '0');
    $this->db->where('tbl_sub_dept_mngt.org_id', $this->organization_id);
    $this->db->where('tbl_users.createdBy', $this->session->userdata('userId'));
    $this->db->not_like('tbl_sub_departments.sub_dept_name', 'FTU');
    $this->db->join('tbl_departments', 'tbl_departments.dept_id = tbl_sub_dept_mngt.dept_id', 'left');
    $this->db->join('tbl_sub_departments', 'tbl_sub_departments.id = tbl_sub_dept_mngt.sub_dept_id', 'left');
    $this->db->join('shift_mgmt', 'shift_mgmt.id = tbl_sub_dept_mngt.shift_mngt_id', 'left');
    $this->db->join('tbl_shift', 'tbl_shift.id = shift_mgmt.shift', 'left');
    $this->db->join('tbl_clients', 'tbl_clients.id = tbl_sub_dept_mngt.client_id', 'left');
    $this->db->join('tbl_users', 'tbl_users.userId = shift_mgmt.superviser_id', 'left');
    $this->db->join('uom', 'uom.id = tbl_sub_dept_mngt.uom_id', 'left');
    if ($search != '') {
      $likeCriteria = "(shift_mgmt.shift  LIKE '%" . $search . "%' "
          . " OR tbl_sub_departments.sub_dept_name  LIKE '%" . $search . "%' "
          . " OR  tbl_departments.dept_name  LIKE '%" . $search . "%')";
      $this->db->where($likeCriteria);
    }
//    $this->db->limit($length, $start);
//    $query = $this->db->get();
    $totalrows = $this->db->get()->num_rows();
    $this->db->select('tbl_users.name as super_name,shift_mgmt.in_time,shift_mgmt.out_time,tbl_clients.client,tbl_sub_dept_mngt.id,tbl_sub_departments.sub_dept_name,tbl_shift.shift_name,shift_mgmt.shift,tbl_departments.dept_name,tbl_sub_dept_mngt.banchmark,uom.name uom_name');
    $this->db->from('tbl_sub_dept_mngt');
    $this->db->where('tbl_sub_departments.isDeleted', '0');
    $this->db->where('tbl_sub_dept_mngt.isDeleted', '0');
    $this->db->where('tbl_sub_dept_mngt.org_id', $this->organization_id);
    $this->db->where('tbl_users.createdBy', $this->session->userdata('userId'));
    $this->db->not_like('tbl_sub_departments.sub_dept_name', 'FTU');
    $this->db->join('tbl_departments', 'tbl_departments.dept_id = tbl_sub_dept_mngt.dept_id', 'left');
    $this->db->join('tbl_sub_departments', 'tbl_sub_departments.id = tbl_sub_dept_mngt.sub_dept_id', 'left');
    $this->db->join('shift_mgmt', 'shift_mgmt.id = tbl_sub_dept_mngt.shift_mngt_id', 'left');
    $this->db->join('tbl_shift', 'tbl_shift.id = shift_mgmt.shift', 'left');
    $this->db->join('tbl_clients', 'tbl_clients.id = tbl_sub_dept_mngt.client_id', 'left');
    $this->db->join('tbl_users', 'tbl_users.userId = shift_mgmt.superviser_id', 'left');
    $this->db->join('uom', 'uom.id = tbl_sub_dept_mngt.uom_id', 'left');
    if ($search != '') {
      $likeCriteria = "(shift_mgmt.shift  LIKE '%" . $search . "%' "
          . " OR tbl_sub_departments.sub_dept_name  LIKE '%" . $search . "%' "
          . " OR  tbl_departments.dept_name  LIKE '%" . $search . "%')";
      $this->db->where($likeCriteria);
    }
    $this->db->limit($length, $start);
    $query = $this->db->get();
    $results = $query->result_array();
    $data = array();
//    pre($results);
    if (!empty($results)) {
      foreach ($results as $key => $shift) {
//        pre($shift);
        $attr = array();
        $attr[] = $shift['id'];
        $attr[] = $shift['super_name'];
        $attr[] = $shift['client'];
        $attr[] = $shift['dept_name'];
        $attr[] = $shift['sub_dept_name'];
        $attr[] = $shift['banchmark'];
        $attr[] = $shift['shift_name'] . ' (' . $shift['in_time'] . '-' . $shift['out_time'] . ')';
        $attr[] = $shift['uom_name'];
        $attr[] = '<a href="' . site_url('sub-dept-mngt/' . $shift['id']) . '" class="btn btn-sm btn-primary"><i class="fa fa-pencil-square-o" aria-hidden="true"></i></a><a onclick="return confirm(\'Are you sure\')" href="' . site_url('delshiftmngt/' . $shift['id']) . '" style="margin-left:5px" class="btn btn-sm btn-danger"><i class="fa fa-trash" aria-hidden="true"></i></a>';
        $data[] = $attr;
      }
    }
    $output = array(
      "draw" => $draw,
      "recordsTotal" => $totalrows,
      "recordsFiltered" => $totalrows,
      "data" => $data
    );
    echo json_encode($output);
    exit();
  }

}
