<?php

if (!defined('BASEPATH'))
  exit('No direct script access allowed');

require APPPATH . '/libraries/BaseController.php';

/**
 * Class : Report (ReportController)
 * Visitor Class to control all user related operations.
 * @author : Vijayraj Chaudhary
 * @version : 2.1
 * @since : 30 August 2019
 */
class ReportDetailController extends BaseController {

  /**
   * This is default constructor of the class
   */
  public function __construct() {
    parent::__construct();
    $this->load->model('user_model');
    $this->isLoggedIn();
    date_default_timezone_set('Asia/Kolkata');
  }

  function view_report_new_detailed_c_l_w_d() {

    $orgId = '';
    if ($this->role == 2 || $this->role == 8) {
      $orgId = $this->organization_id;
    }
    if ($this->role == '11') {
      $locationList = $this->db->get('tbl_location')->result_array();
    } elseif ($this->role == '12') {
      $locationList = $this->db->select('*')->where_in('loc_id', $this->session->userdata('location_id'))->get('tbl_location')->result_array();
    } else {
      $locationList = $this->db->select('*')
              //->where('client_id', $clientId)
              ->get('tbl_location')->result_array();
    }
    $locationId = isset($locationList[0]['loc_id']) ? $locationList[0]['loc_id'] : '';

    if ($this->role == 10) {
      // $lientIdsArray = clientIdByLocationId(explode(',', $this->session->userdata('location_id')));
      $this->db->where_in('location_id', explode(',', $this->session->userdata('location_id')));
      $clientList = $this->db->get('tbl_clients')->result_array();
    } else {
      $clientList = $this->db->where('location_id', $locationId)->get('tbl_clients')->result_array();
    }
    $clientId = isset($clientList[0]['id']) ? $clientList[0]['id'] : '';

    if ($this->role == '11') {
      $warehouseList = $this->db->get('tbl_organization')->result_array();
    } elseif (in_array($this->role, ['2', '8', '9', '5'])) {
      $warehouseList = $this->db->where('id', $this->session->userdata('organization_id'))->get('tbl_organization')->result_array();
    } else {
      $warehouseList = $this->db->where('client_id', $clientId)->get('tbl_organization')->result_array();
    }
    $warehouseId = isset($warehouseList[0]['id']) ? $warehouseList[0]['id'] : '';
    $departmentList = $this->user_model->getDepartmentListAll($warehouseId, '', '', '0');
    $data['clientList'] = $clientList;
    $data['locationList'] = $locationList;
    $data['warehouseList'] = $warehouseList;
    $data['departmentList'] = $departmentList;
    $data['role'] = $this->role;
    $data['department_id'] = $this->department_id;
    $this->global['pageTitle'] = 'Searbird : View Report';
    $this->loadViews("manpower_view_report_new_detailed_c_l_w_d", $this->global, $data, NULL);
  }

  function view_report_new_detailed_c_l_w_d_sd() {


    $orgId = '';
    if ($this->role == 2 || $this->role == 8) {
      $orgId = $this->organization_id;
    }
    if ($this->role == '11') {
      $locationList = $this->db->get('tbl_location')
          ->join('tbl_manpower_team_performance', 'tbl_manpower_team_performance.location = tbl_location.loc_id', 'right')
          ->where('tbl_location.isDeleted', '0')
          ->group_by('tbl_location.loc_id')
          ->result_array();
    } elseif ($this->role == '12') {
      $locationList = $this->db->select('*')
              ->join('tbl_manpower_team_performance', 'tbl_manpower_team_performance.location = tbl_location.loc_id', 'right')
              ->where('tbl_location.isDeleted', '0')
              ->group_by('tbl_location.loc_id')
              ->where_in('loc_id', $this->session->userdata('location_id'))
              ->get('tbl_location')->result_array();
    } else {
      $locationList = $this->db->select('*')
              ->join('tbl_manpower_team_performance', 'tbl_manpower_team_performance.location = tbl_location.loc_id', 'right')
              ->where('tbl_location.isDeleted', '0')
              ->group_by('tbl_location.loc_id')
              ->get('tbl_location')->result_array();
    }
    $locationId = isset($locationList[0]['loc_id']) ? $locationList[0]['loc_id'] : '';
    if ($this->role == '11') {
      $warehouseList = $this->db->where('isDeleted', '0')->get('tbl_organization')->result_array();
    } elseif (in_array($this->role, ['2', '8', '9', '5'])) {
      $warehouseList = $this->db->where('id', $this->session->userdata('organization_id'))->where('isDeleted', '0')->get('tbl_organization')->result_array();
    } else {
      $warehouseList = $this->db->where('loc_id', $locationId)->where('isDeleted', '0')->get('tbl_organization')->result_array();
    }
    //last_query();
    //pre($warehouseList);
    $warehouseId = isset($warehouseList[0]['id']) ? $warehouseList[0]['id'] : '';
//    if ($this->role == 10) {
//      // $lientIdsArray = clientIdByLocationId(explode(',', $this->session->userdata('location_id')));
//      $this->db->where_in('location_id', explode(',', $this->session->userdata('location_id')));
    if (isset($warehouseList[0]['client_id'])) {
      $this->db->where_in('id', explode(',', $warehouseList[0]['client_id']));
    }
    $clientList = $this->db->get('tbl_clients')->result_array();
    //pre($clientList);
    //last_query();
//    } else {
//      $clientList = $this->db->where('location_id', $locationId)->get('tbl_clients')->result_array();
//    }
    $clientId = isset($clientList[0]['id']) ? $clientList[0]['id'] : '';
    //die;




    $departmentList = $this->user_model->getDepartmentListAll($warehouseId, '', '', '0');
    $data['clientList'] = $clientList;
    $data['locationList'] = $locationList;
    $data['warehouseList'] = $warehouseList;
    $data['departmentList'] = $departmentList;
    $data['role'] = $this->role;
    $data['department_id'] = $this->department_id;
    $this->global['pageTitle'] = 'Searbird : View Report';
    $this->loadViews("manpower_view_report_new_detailed_c_l_w_d_sd", $this->global, $data, NULL);
  }

  function get_date_ranged_report_excel_new_detailed() {
    $this->load->library('excel');
    $this->load->helper('report');
//    pre($this->input->post());
    if ($this->session->userdata('role') == '4') {
      $department_id = $this->session->userdata('department_id');
      $sub_department_id = $this->session->userdata('sub_department_id');
      $this->get_date_ranged_report_excel_new_detailed_c_l_w_d_sd_shift();
    } else {
      $shift = $this->input->post('shift');
      $subdepartment = $this->input->post('subdepartment');
      $departmentId = $this->input->post('departmentId');
      $clientId = $this->input->post('clientId');
      $organizationid = $this->input->post('warehouseId');
      $locationId = $this->input->post('locationId');
//      if ($shift != '') {
//        $this->get_date_ranged_report_excel_new_detailed_c_l_w_d_sd_shift();
//        die;
//      } elseif ($subdepartment != '') {
//        $this->get_date_ranged_report_excel_new_detailed_c_l_w_d_sd_all();
//        die;
//      } elseif ($departmentId != '') {
//        $this->get_date_ranged_report_excel_new_detailed_c_l_w_d();
//        die;
//      } elseif ($clientId != '') {
//        $this->get_date_ranged_report_excel_new_detailed_l_w_c();
//        die;
//      } elseif ($organizationid != '') {
//        $this->get_date_ranged_report_excel_new_detailed_l_w();
//        die;
//      } elseif ($locationId != '') {
//        $this->get_date_ranged_report_excel_new_detailed_l();
//        die;
//      }
//      pre($this->input->post());
      $this->get_date_ranged_report_excel_new_detailed_c_l_w_d_sd_shift();
//      $this->get_date_ranged_report_excel_new_detailed_c_l_w_d();
      die;
    }
  }

  function get_date_ranged_report_excel_new_detailed_l() {

    //pre($this->input->post());
    $total = 0;
    $this->load->library('excel');
    $this->load->helper('report');
    if ($this->session->userdata('role') == '4') {
      $department_id = $this->session->userdata('department_id');
      $sub_department_id = $this->session->userdata('sub_department_id');
    } else {
      $location_id = $this->input->post('locationId');
      $organization_id = $this->input->post('warehouseId');
      $client_id = $this->input->post('clientId');
      $department_id = $this->input->post('departmentId');
      $sub_department_id = $this->input->post('subdepartment');
      $shift_id = $this->input->post('shift');
    }
    $fromDate = $this->input->post('from_date');
    $toDate = $this->input->post('to_date');
    $date = $this->input->post('date');
    $filename = 'detailed_productivity_report.xls';
    $this->db->select('tbl_manpower_team_performance.*');
    $this->db->group_by('tbl_manpower_team_performance.sub_dept_id');
    $all_team_ids = $this->db->get('tbl_manpower_team_performance')->result();
    $totalcount = count($all_team_ids);
    $this->excel->setActiveSheetIndex(0);
    $this->excel->getActiveSheet()->setTitle('Report');
    $this->excel->getActiveSheet()->setCellValue('A1', 'Location')->getStyle('A1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B1:O1')->setCellValue('B1', ($location_id && $location_id != 'all') ? locationName($location_id) : $location_id )->getStyle('B1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A2', 'Report Type')->getStyle('A2')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B2:O2')->setCellValue('B2', ($location_id && $location_id != 'all') ? locationName($location_id) . "Location Manpower Report" : $location_id . " Locations Manpower Report")->getStyle('B2')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A3', 'Date Range')->getStyle('A3')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B3:O3')->setCellValue('B3', $date)->getStyle('B3')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A4', 'Report Generated Date & Time')->getStyle('A4')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B4:O4')->setCellValue('B4', date("Y-m-d H:i:s"))->getStyle('B4')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A5', 'Employee Name')->getStyle('A5')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('B5', 'Emp Code')->getStyle('B5')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('C5', 'Total Benchmark')->getStyle('C5')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('D5', 'Benchmark Unit (UOM)')->getStyle('D5')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('E5', 'Challan')->getStyle('E5')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('F5', 'Boxes')->getStyle('F5')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('G5', 'Qty')->getStyle('G5')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('H5', 'SKU')->getStyle('H5')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('I5', 'KG')->getStyle('I5')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('J5', 'CFC')->getStyle('J5')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('K5', 'Bins')->getStyle('K5')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('L5', 'Pallet')->getStyle('L5')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('M5', 'Time')->getStyle('M5')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('N5', 'Productivity')->getStyle('N5')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('O5', '%age Achievement')->getStyle('O5')->getFont()->setBold(true);
    $fChallan = 0;
    $fBoxes = 0;
    $fQty = 0;
    $fSku = 0;
    $fEmp = 0;
    //pre($all_team_ids);
    if (!empty($all_team_ids)) {
      $excelrow = 6;
      $where = ' ';
      $select = ' ';
      $groupBY = '  GROUP BY location';
      if ($location_id != '' && $location_id != 'all') {
        $where .= ' AND tbl_manpower_team_performance.location = ' . $location_id;
        $groupBY = ' GROUP BY location';
      } elseif ($location_id == 'all') {
        $groupBY = ' GROUP BY location';
      }
      if ($client_id != '' && $client_id != 'all') {
        $where .= ' AND tbl_manpower_team_performance.client = ' . $client_id;
        $groupBY = ' GROUP BY client';
      } elseif ($client_id == 'all') {
        $groupBY = ' GROUP BY client';
      }

      if ($organization_id != '' && $organization_id != 'all') {
        $where .= ' AND tbl_manpower_team_performance.org = ' . $organization_id;
        $groupBY = ' GROUP BY org';
      } elseif ($organization_id == 'all') {
        $groupBY = ' GROUP BY org';
      }
      if ($department_id != '' && $department_id != 'all') {
        $where .= ' AND tbl_manpower_team_performance.dept_id = ' . $department_id;
        $groupBY = ' GROUP BY dept_id';
      } elseif ($department_id == 'all') {
        $groupBY = ' GROUP BY dept_id';
      }
      if ($sub_department_id != '' && $sub_department_id != 'all') {
        $where .= ' AND tbl_manpower_team_performance.sub_dept_id = ' . $sub_department_id;
        $groupBY = ' GROUP BY sub_dept_id';
      } elseif ($sub_department_id == 'all') {
        $groupBY = ' GROUP BY sub_dept_id';
      }
      $groupBY = ' GROUP BY employee_id';

      $total_challans = $this->db->query('SELECT *, IFNULL(SUM(challans), 0) AS total_challans,date ' . $select . ' FROM tbl_manpower_team_performance WHERE date =\'' . $this->input->post('date') . '\' ' . $where . $groupBY)->result_array();
//      last_query();
      $totalcount = count($total_challans);
      if ($totalcount == '0') {
        $this->session->set_flashdata('success', 'Data Not Found with your Search.');
        redirect('view-report-new-detailed-c-l-w-d-sd');
      }
      $total_boxes = $this->db->query('SELECT IFNULL(SUM(A), 0) AS total_boxes,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date =\'' . $this->input->post('date') . '\' ' . $where . $groupBY)->result_array();
      $total_qty = $this->db->query('SELECT IFNULL(SUM(B), 0) AS total_qty,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date =\'' . $this->input->post('date') . '\' ' . $where . $groupBY)->result_array();
      $total_sku = $this->db->query('SELECT IFNULL(SUM(C), 0) AS total_sku,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date =\'' . $this->input->post('date') . '\' ' . $where . $groupBY)->result_array();
      $total_manpower = $this->db->query('SELECT IFNULL(COUNT(absent),0) AS manpower,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date =\'' . $this->input->post('date') . '\' ' . $where . $groupBY)->result_array();
      $client_list = $this->db->query('SELECT GROUP_CONCAT(DISTINCT CONCAT(\'"\', `client`, \'"\')) AS `clientlist`, date ' . $select . '  FROM tbl_manpower_team_performance WHERE date =\'' . $this->input->post('date') . '\' ' . $where . $groupBY)->result_array();
      $total_time = $this->db->query('SELECT IFNULL(SEC_TO_TIME(SUM(TIME_TO_SEC(time))),0) AS total_time,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date =\'' . $this->input->post('date') . '\' ' . $where . $groupBY)->result_array();
      if (!empty($total_challans)) {
        foreach ($total_challans as $key1 => $challan) {
//          pre($challan);
          $uomKey = $challan['uom'];
          $fChallan += $TCHALLAN = $challan['total_challans'];
          $fBoxes += $TOTALBOXES = isset($total_boxes[$key1]['total_boxes']) ? $total_boxes[$key1]['total_boxes'] : 0;
          $fQty += $TOTALQTY = isset($total_qty[$key1]['total_qty']) ? $total_qty[$key1]['total_qty'] : 0;
          $fSku += $TOTALSKU = isset($total_sku[$key1]['total_sku']) ? $total_sku[$key1]['total_sku'] : 0;
          $fEmp += $TOTALMANPOWER = isset($total_manpower[$key1]['manpower']) ? $total_manpower[$key1]['manpower'] : 0;
          $TOTALTIME = isset($challan['time']) ? strtotime($challan['time']) : strtotime('00:00:00');
          $fTime += $TOTALTIME;
          $this->excel->getActiveSheet()->setCellValue('A' . $excelrow, ucfirst(empNameById($challan['employee_id'])));
          $this->excel->getActiveSheet()->setCellValue('B' . $excelrow, ucfirst(empCodeByEmpId($challan['employee_id'])));
          $this->excel->getActiveSheet()->setCellValue('C' . $excelrow, $challan['banchmark']);
          $this->excel->getActiveSheet()->setCellValue('D' . $excelrow, $challan['uom']);
          $this->excel->getActiveSheet()->setCellValue('E' . $excelrow, $challan['challans']);
          $this->excel->getActiveSheet()->setCellValue('F' . $excelrow, $challan['A']);
          $this->excel->getActiveSheet()->setCellValue('G' . $excelrow, $challan['B']);
          $this->excel->getActiveSheet()->setCellValue('H' . $excelrow, $challan['C']);
          $this->excel->getActiveSheet()->setCellValue('I' . $excelrow, $challan['kg']);
          $this->excel->getActiveSheet()->setCellValue('J' . $excelrow, $challan['cfc']);
          $this->excel->getActiveSheet()->setCellValue('K' . $excelrow, $challan['bins']);
          $this->excel->getActiveSheet()->setCellValue('L' . $excelrow, $challan['pallet']);
          $this->excel->getActiveSheet()->setCellValue('M' . $excelrow, $challan['time']);
          $this->excel->getActiveSheet()->setCellValue('N' . $excelrow, ($challan[$uomKey] / 1));
          $this->excel->getActiveSheet()->setCellValue('O' . $excelrow, ((($challan[$uomKey] / 1) * 100) / $challan['banchmark']) . ' %');
          fputcsv($output, [$team_details->shift, '', $team_details->department_name, $challan['date'], $team_details->created_by, $challan['total_challans'], $total_boxes[$key]['total_boxes'], $total_qty[$key]['total_qty'], $total_sku[$key]['total_sku'], $total_manpower[$key]['manpower']]);

          $element = $challan['time'];
          // Explode by seperator :
          $temp = explode(":", $element);

          // Convert the hours into seconds
          // and add to total
          $total += (int) $temp[0] * 3600;

          // Convert the minutes to seconds
          // and add to total
          $total += (int) $temp[1] * 60;

          // Add the seconds to total
          $total += (int) $temp[2];

          $excelrow++;
        }
      }

      $this->excel->getActiveSheet()->setCellValue('A' . $excelrow, 'Total : ')->getStyle('B' . $excelrow)->getFont()->setBold(true);
      $this->excel->getActiveSheet()->setCellValue('E' . $excelrow, $fChallan);
      $this->excel->getActiveSheet()->setCellValue('F' . $excelrow, $fBoxes);
      $this->excel->getActiveSheet()->setCellValue('G' . $excelrow, $fQty);
      $this->excel->getActiveSheet()->setCellValue('H' . $excelrow, $fSku);
      $this->excel->getActiveSheet()->setCellValue('M' . $excelrow, secToTime($total));
    }
    header('Content-Type: application/vnd.ms-excel'); //mime type
    header('Content-Disposition: attachment;filename="' . $filename . '"'); //tell browser what's the file name
    header('Cache-Control: max-age=0'); //no cache
    $objWriter = PHPExcel_IOFactory::createWriter($this->excel, 'Excel5');
    $objWriter->save('php://output');
    exit;
  }

  function get_date_ranged_report_excel_new_detailed_l_w() {

    pre($this->input->post());
    $total = 0;
    $this->load->library('excel');
    $this->load->helper('report');
    if ($this->session->userdata('role') == '4') {
      $department_id = $this->session->userdata('department_id');
      $sub_department_id = $this->session->userdata('sub_department_id');
    } else {
      $location_id = $this->input->post('locationId');
      $organization_id = $this->input->post('warehouseId');
      $client_id = $this->input->post('clientId');
      $department_id = $this->input->post('departmentId');
      $sub_department_id = $this->input->post('subdepartment');
      $shift_id = $this->input->post('shift');
    }
    $fromDate = $this->input->post('from_date');
    $toDate = $this->input->post('to_date');
    $date = $this->input->post('date');
    $filename = 'detailed_productivity_report.xls';
    $this->db->select('tbl_manpower_team_performance.*');
    $this->db->group_by('tbl_manpower_team_performance.sub_dept_id');
    $all_team_ids = $this->db->get('tbl_manpower_team_performance')->result();
    $totalcount = count($all_team_ids);
    $this->excel->setActiveSheetIndex(0);
    $this->excel->getActiveSheet()->setTitle('Report');
    if ($organization_id != 'all') {
      $this->excel->getActiveSheet()->setCellValue('A1', 'Location')->getStyle('A1')->getFont()->setBold(true);
      $this->excel->getActiveSheet()->mergeCells('B1:O1')->setCellValue('B1', locationName(locationIdByOrgId($organization_id)))->getStyle('B1')->getFont()->setBold(true);
    } else if ($organization_id) {
      $this->excel->getActiveSheet()->setCellValue('A1', 'Location')->getStyle('A1')->getFont()->setBold(true);
      $this->excel->getActiveSheet()->mergeCells('B1:O1')->setCellValue('B1', locationName($location_id))->getStyle('B1')->getFont()->setBold(true);
    }
    $this->excel->getActiveSheet()->setCellValue('A2', 'Warehouse')->getStyle('A2')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B2:O2')->setCellValue('B2', ($organization_id && $organization_id != 'all') ? orgName($organization_id) : $organization_id)->getStyle('B2')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A3', 'Report Type')->getStyle('A3')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B3:O3')->setCellValue('B3', ($organization_id && $organization_id != 'all') ? orgName($organization_id) . " of " . locationName(locationIdByOrgId($organization_id)) . " Manpower Report" : $organization_id . " Warehouses of " . locationName($location_id) . " Manpower Report")->getStyle('B3')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A4', 'Date Range')->getStyle('A4')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B4:O4')->setCellValue('B4', $date)->getStyle('B4')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A5', 'Report Generated Date & Time')->getStyle('A5')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B5:O5')->setCellValue('B5', date("Y-m-d H:i:s"))->getStyle('B5')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A6', 'Employee Name')->getStyle('A6')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('B6', 'Emp Code')->getStyle('B6')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('C6', 'Total Benchmark')->getStyle('C6')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('D6', 'Benchmark Unit (UOM)')->getStyle('D6')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('E6', 'Challan')->getStyle('E6')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('F6', 'Boxes')->getStyle('F6')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('G6', 'Qty')->getStyle('G6')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('H6', 'SKU')->getStyle('H6')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('I6', 'KG')->getStyle('I6')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('J6', 'CFC')->getStyle('J6')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('K6', 'Bins')->getStyle('K6')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('L6', 'Pallet')->getStyle('L6')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('M6', 'Time')->getStyle('M6')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('N6', 'Productivity')->getStyle('N6')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('O6', '%age Achievement')->getStyle('O6')->getFont()->setBold(true);
    $fChallan = 0;
    $fBoxes = 0;
    $fQty = 0;
    $fSku = 0;
    $fEmp = 0;
    //pre($all_team_ids);
    if (!empty($all_team_ids)) {
      $excelrow = 7;
      $where = ' ';
      $select = ' ';
      $groupBY = '  GROUP BY location';
      if ($location_id != '' && $location_id != 'all') {
        $where .= ' AND tbl_manpower_team_performance.location = ' . $location_id;
        $groupBY = ' GROUP BY location';
      } elseif ($location_id == 'all') {
        $groupBY = ' GROUP BY location';
      }
      if ($client_id != '' && $client_id != 'all') {
        $where .= ' AND tbl_manpower_team_performance.client = ' . $client_id;
        $groupBY = ' GROUP BY client';
      } elseif ($client_id == 'all') {
        $groupBY = ' GROUP BY client';
      }

      if ($organization_id != '' && $organization_id != 'all') {
        $where .= ' AND tbl_manpower_team_performance.org = ' . $organization_id;
        $groupBY = ' GROUP BY org';
      } elseif ($organization_id == 'all') {
        $groupBY = ' GROUP BY org';
      }
      if ($department_id != '' && $department_id != 'all') {
        $where .= ' AND tbl_manpower_team_performance.dept_id = ' . $department_id;
        $groupBY = ' GROUP BY dept_id';
      } elseif ($department_id == 'all') {
        $groupBY = ' GROUP BY dept_id';
      }
      if ($sub_department_id != '' && $sub_department_id != 'all') {
        $where .= ' AND tbl_manpower_team_performance.sub_dept_id = ' . $sub_department_id;
        $groupBY = ' GROUP BY sub_dept_id';
      } elseif ($sub_department_id == 'all') {
        $groupBY = ' GROUP BY sub_dept_id';
      }
      $groupBY = ' GROUP BY employee_id';

      $total_challans = $this->db->query('SELECT *, IFNULL(SUM(challans), 0) AS total_challans,date ' . $select . ' FROM tbl_manpower_team_performance WHERE date =\'' . $this->input->post('date') . '\' ' . $where . $groupBY)->result_array();
//      last_query();
      $totalcount = count($total_challans);
      if ($totalcount == '0') {
        $this->session->set_flashdata('success', 'Data Not Found with your Search.');
        redirect('view-report-new-detailed-c-l-w-d-sd');
      }
      $total_boxes = $this->db->query('SELECT IFNULL(SUM(A), 0) AS total_boxes,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date =\'' . $this->input->post('date') . '\' ' . $where . $groupBY)->result_array();
      $total_qty = $this->db->query('SELECT IFNULL(SUM(B), 0) AS total_qty,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date =\'' . $this->input->post('date') . '\' ' . $where . $groupBY)->result_array();
      $total_sku = $this->db->query('SELECT IFNULL(SUM(C), 0) AS total_sku,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date =\'' . $this->input->post('date') . '\' ' . $where . $groupBY)->result_array();
      $total_manpower = $this->db->query('SELECT IFNULL(COUNT(absent),0) AS manpower,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date =\'' . $this->input->post('date') . '\' ' . $where . $groupBY)->result_array();
      $client_list = $this->db->query('SELECT GROUP_CONCAT(DISTINCT CONCAT(\'"\', `client`, \'"\')) AS `clientlist`, date ' . $select . '  FROM tbl_manpower_team_performance WHERE date =\'' . $this->input->post('date') . '\' ' . $where . $groupBY)->result_array();
      $total_time = $this->db->query('SELECT IFNULL(SEC_TO_TIME(SUM(TIME_TO_SEC(time))),0) AS total_time,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date =\'' . $this->input->post('date') . '\' ' . $where . $groupBY)->result_array();
      if (!empty($total_challans)) {
        foreach ($total_challans as $key1 => $challan) {
          $uomKey = $challan['uom'];
          $fChallan += $TCHALLAN = $challan['total_challans'];
          $fBoxes += $TOTALBOXES = isset($total_boxes[$key1]['total_boxes']) ? $total_boxes[$key1]['total_boxes'] : 0;
          $fQty += $TOTALQTY = isset($total_qty[$key1]['total_qty']) ? $total_qty[$key1]['total_qty'] : 0;
          $fSku += $TOTALSKU = isset($total_sku[$key1]['total_sku']) ? $total_sku[$key1]['total_sku'] : 0;
          $fEmp += $TOTALMANPOWER = isset($total_manpower[$key1]['manpower']) ? $total_manpower[$key1]['manpower'] : 0;
          $TOTALTIME = isset($challan['time']) ? strtotime($challan['time']) : strtotime('00:00:00');
          $fTime += $TOTALTIME;
          $this->excel->getActiveSheet()->setCellValue('A' . $excelrow, ucfirst(empNameById($challan['employee_id'])));
          $this->excel->getActiveSheet()->setCellValue('B' . $excelrow, ucfirst(empCodeByEmpId($challan['employee_id'])));
          $this->excel->getActiveSheet()->setCellValue('C' . $excelrow, $challan['banchmark']);
          $this->excel->getActiveSheet()->setCellValue('D' . $excelrow, $challan['uom']);
          $this->excel->getActiveSheet()->setCellValue('E' . $excelrow, $challan['challans']);
          $this->excel->getActiveSheet()->setCellValue('F' . $excelrow, $challan['A']);
          $this->excel->getActiveSheet()->setCellValue('G' . $excelrow, $challan['B']);
          $this->excel->getActiveSheet()->setCellValue('H' . $excelrow, $challan['C']);
          $this->excel->getActiveSheet()->setCellValue('I' . $excelrow, $challan['kg']);
          $this->excel->getActiveSheet()->setCellValue('J' . $excelrow, $challan['cfc']);
          $this->excel->getActiveSheet()->setCellValue('K' . $excelrow, $challan['bins']);
          $this->excel->getActiveSheet()->setCellValue('L' . $excelrow, $challan['pallet']);
          $this->excel->getActiveSheet()->setCellValue('M' . $excelrow, $challan['time']);
          $this->excel->getActiveSheet()->setCellValue('N' . $excelrow, ($challan[$uomKey] / 1));
          $this->excel->getActiveSheet()->setCellValue('O' . $excelrow, ((($challan[$uomKey] / 1) * 100) / $challan['banchmark']) . ' %');
          fputcsv($output, [$team_details->shift, '', $team_details->department_name, $challan['date'], $team_details->created_by, $challan['total_challans'], $total_boxes[$key]['total_boxes'], $total_qty[$key]['total_qty'], $total_sku[$key]['total_sku'], $total_manpower[$key]['manpower']]);

          $element = $challan['time'];
          // Explode by seperator :
          $temp = explode(":", $element);

          // Convert the hours into seconds
          // and add to total
          $total += (int) $temp[0] * 3600;

          // Convert the minutes to seconds
          // and add to total
          $total += (int) $temp[1] * 60;

          // Add the seconds to total
          $total += (int) $temp[2];

          $excelrow++;
        }
      }

      $this->excel->getActiveSheet()->setCellValue('A' . $excelrow, 'Total : ')->getStyle('B' . $excelrow)->getFont()->setBold(true);
      $this->excel->getActiveSheet()->setCellValue('E' . $excelrow, $fChallan);
      $this->excel->getActiveSheet()->setCellValue('F' . $excelrow, $fBoxes);
      $this->excel->getActiveSheet()->setCellValue('G' . $excelrow, $fQty);
      $this->excel->getActiveSheet()->setCellValue('H' . $excelrow, $fSku);
      $this->excel->getActiveSheet()->setCellValue('M' . $excelrow, secToTime($total));
    }
    header('Content-Type: application/vnd.ms-excel'); //mime type
    header('Content-Disposition: attachment;filename="' . $filename . '"'); //tell browser what's the file name
    header('Cache-Control: max-age=0'); //no cache
    $objWriter = PHPExcel_IOFactory::createWriter($this->excel, 'Excel5');
    $objWriter->save('php://output');
    exit;
  }

  function get_date_ranged_report_excel_new_detailed_l_w_c() {

    //pre($this->input->post());
    $total = 0;
    $this->load->library('excel');
    $this->load->helper('report');
    if ($this->session->userdata('role') == '4') {
      $department_id = $this->session->userdata('department_id');
      $sub_department_id = $this->session->userdata('sub_department_id');
    } else {
      $location_id = $this->input->post('locationId');
      $organization_id = $this->input->post('warehouseId');
      $client_id = $this->input->post('clientId');
      $department_id = $this->input->post('departmentId');
      $sub_department_id = $this->input->post('subdepartment');
      $shift_id = $this->input->post('shift');
    }
    $fromDate = $this->input->post('from_date');
    $toDate = $this->input->post('to_date');
    $date = $this->input->post('date');
    $filename = 'detailed_productivity_report.xls';
    $this->db->select('tbl_manpower_team_performance.*');
    $this->db->group_by('tbl_manpower_team_performance.sub_dept_id');
    $all_team_ids = $this->db->get('tbl_manpower_team_performance')->result();
    $totalcount = count($all_team_ids);
    $this->excel->setActiveSheetIndex(0);
    $this->excel->getActiveSheet()->setTitle('Report');
    $this->excel->getActiveSheet()->setCellValue('A1', 'Location')->getStyle('A1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B1:O1')->setCellValue('B1', locationName(locationIdByOrgId($organization_id)))->getStyle('B1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A2', 'Warehouse')->getStyle('A2')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B2:O2')->setCellValue('B2', orgName($organization_id))->getStyle('B2')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A3', 'Client Name')->getStyle('A3')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B3:O3')->setCellValue('B3', ($client_id && $client_id != 'all') ? clientName($client_id) : $client_id)->getStyle('B3')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A4', 'Report Type')->getStyle('A4')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B4:O4')->setCellValue('B4', ($client_id && $client_id != 'all') ? clientName($client_id) . " of " . orgName($organization_id) . " Manpower Report" : $client_id . " Clients of " . orgName($organization_id) . " Manpower Report")->getStyle('B4')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A5', 'Date Range')->getStyle('A5')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B5:O5')->setCellValue('B5', $date)->getStyle('B5')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A6', 'Report Generated Date & Time')->getStyle('A6')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B6:O6')->setCellValue('B6', date("Y-m-d H:i:s"))->getStyle('B6')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A7', 'Employee Name')->getStyle('A7')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('B7', 'Emp Code')->getStyle('B7')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('C7', 'Total Benchmark')->getStyle('C7')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('D7', 'Benchmark Unit (UOM)')->getStyle('D7')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('E7', 'Challan')->getStyle('E7')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('F7', 'Boxes')->getStyle('F7')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('G7', 'Qty')->getStyle('G7')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('H7', 'SKU')->getStyle('H7')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('I7', 'KG')->getStyle('I7')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('J7', 'CFC')->getStyle('J7')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('K7', 'Bins')->getStyle('K7')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('L7', 'Pallet')->getStyle('L7')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('M7', 'Time')->getStyle('M7')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('N7', 'Productivity')->getStyle('N7')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('O7', '%age Achievement')->getStyle('O7')->getFont()->setBold(true);
    $fChallan = 0;
    $fBoxes = 0;
    $fQty = 0;
    $fSku = 0;
    $fEmp = 0;
    //pre($all_team_ids);
    if (!empty($all_team_ids)) {
      $excelrow = 8;
      $where = ' ';
      $select = ' ';
      $groupBY = '  GROUP BY location';
      if ($location_id != '' && $location_id != 'all') {
        $where .= ' AND tbl_manpower_team_performance.location = ' . $location_id;
        $groupBY = ' GROUP BY location';
      } elseif ($location_id == 'all') {
        $groupBY = ' GROUP BY location';
      }
      if ($client_id != '' && $client_id != 'all') {
        $where .= ' AND tbl_manpower_team_performance.client = ' . $client_id;
        $groupBY = ' GROUP BY client';
      } elseif ($client_id == 'all') {
        $groupBY = ' GROUP BY client';
      }

      if ($organization_id != '' && $organization_id != 'all') {
        $where .= ' AND tbl_manpower_team_performance.org = ' . $organization_id;
        $groupBY = ' GROUP BY org';
      } elseif ($organization_id == 'all') {
        $groupBY = ' GROUP BY org';
      }
      if ($department_id != '' && $department_id != 'all') {
        $where .= ' AND tbl_manpower_team_performance.dept_id = ' . $department_id;
        $groupBY = ' GROUP BY dept_id';
      } elseif ($department_id == 'all') {
        $groupBY = ' GROUP BY dept_id';
      }
      if ($sub_department_id != '' && $sub_department_id != 'all') {
        $where .= ' AND tbl_manpower_team_performance.sub_dept_id = ' . $sub_department_id;
        $groupBY = ' GROUP BY sub_dept_id';
      } elseif ($sub_department_id == 'all') {
        $groupBY = ' GROUP BY sub_dept_id';
      }
      $groupBY = ' GROUP BY employee_id';

      $total_challans = $this->db->query('SELECT *, IFNULL(SUM(challans), 0) AS total_challans,date ' . $select . ' FROM tbl_manpower_team_performance WHERE date =\'' . $this->input->post('date') . '\' ' . $where . $groupBY)->result_array();
//      last_query();
      $totalcount = count($total_challans);
      if ($totalcount == '0') {
        $this->session->set_flashdata('success', 'Data Not Found with your Search.');
        redirect('view-report-new-detailed-c-l-w-d-sd');
      }
      $total_boxes = $this->db->query('SELECT IFNULL(SUM(A), 0) AS total_boxes,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date =\'' . $this->input->post('date') . '\' ' . $where . $groupBY)->result_array();
      $total_qty = $this->db->query('SELECT IFNULL(SUM(B), 0) AS total_qty,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date =\'' . $this->input->post('date') . '\' ' . $where . $groupBY)->result_array();
      $total_sku = $this->db->query('SELECT IFNULL(SUM(C), 0) AS total_sku,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date =\'' . $this->input->post('date') . '\' ' . $where . $groupBY)->result_array();
      $total_manpower = $this->db->query('SELECT IFNULL(COUNT(absent),0) AS manpower,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date =\'' . $this->input->post('date') . '\' ' . $where . $groupBY)->result_array();
      $client_list = $this->db->query('SELECT GROUP_CONCAT(DISTINCT CONCAT(\'"\', `client`, \'"\')) AS `clientlist`, date ' . $select . '  FROM tbl_manpower_team_performance WHERE date =\'' . $this->input->post('date') . '\' ' . $where . $groupBY)->result_array();
      $total_time = $this->db->query('SELECT IFNULL(SEC_TO_TIME(SUM(TIME_TO_SEC(time))),0) AS total_time,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date =\'' . $this->input->post('date') . '\' ' . $where . $groupBY)->result_array();
      if (!empty($total_challans)) {
        foreach ($total_challans as $key1 => $challan) {
          $uomKey = $challan['uom'];
          $fChallan += $TCHALLAN = $challan['total_challans'];
          $fBoxes += $TOTALBOXES = isset($total_boxes[$key1]['total_boxes']) ? $total_boxes[$key1]['total_boxes'] : 0;
          $fQty += $TOTALQTY = isset($total_qty[$key1]['total_qty']) ? $total_qty[$key1]['total_qty'] : 0;
          $fSku += $TOTALSKU = isset($total_sku[$key1]['total_sku']) ? $total_sku[$key1]['total_sku'] : 0;
          $fEmp += $TOTALMANPOWER = isset($total_manpower[$key1]['manpower']) ? $total_manpower[$key1]['manpower'] : 0;
          $TOTALTIME = isset($challan['time']) ? strtotime($challan['time']) : strtotime('00:00:00');
          $fTime += $TOTALTIME;
          $this->excel->getActiveSheet()->setCellValue('A' . $excelrow, ucfirst(empNameById($challan['employee_id'])));
          $this->excel->getActiveSheet()->setCellValue('B' . $excelrow, ucfirst(empCodeByEmpId($challan['employee_id'])));
          $this->excel->getActiveSheet()->setCellValue('C' . $excelrow, $challan['banchmark']);
          $this->excel->getActiveSheet()->setCellValue('D' . $excelrow, $challan['uom']);
          $this->excel->getActiveSheet()->setCellValue('E' . $excelrow, $challan['challans']);
          $this->excel->getActiveSheet()->setCellValue('F' . $excelrow, $challan['A']);
          $this->excel->getActiveSheet()->setCellValue('G' . $excelrow, $challan['B']);
          $this->excel->getActiveSheet()->setCellValue('H' . $excelrow, $challan['C']);
          $this->excel->getActiveSheet()->setCellValue('I' . $excelrow, $challan['kg']);
          $this->excel->getActiveSheet()->setCellValue('J' . $excelrow, $challan['cfc']);
          $this->excel->getActiveSheet()->setCellValue('K' . $excelrow, $challan['bins']);
          $this->excel->getActiveSheet()->setCellValue('L' . $excelrow, $challan['pallet']);
          $this->excel->getActiveSheet()->setCellValue('M' . $excelrow, $challan['time']);
          $this->excel->getActiveSheet()->setCellValue('N' . $excelrow, ($challan[$uomKey] / 1));
          $this->excel->getActiveSheet()->setCellValue('O' . $excelrow, ((($challan[$uomKey] / 1) * 100) / $challan['banchmark']) . ' %');
          fputcsv($output, [$team_details->shift, '', $team_details->department_name, $challan['date'], $team_details->created_by, $challan['total_challans'], $total_boxes[$key]['total_boxes'], $total_qty[$key]['total_qty'], $total_sku[$key]['total_sku'], $total_manpower[$key]['manpower']]);

          $element = $challan['time'];
          // Explode by seperator :
          $temp = explode(":", $element);

          // Convert the hours into seconds
          // and add to total
          $total += (int) $temp[0] * 3600;

          // Convert the minutes to seconds
          // and add to total
          $total += (int) $temp[1] * 60;

          // Add the seconds to total
          $total += (int) $temp[2];

          $excelrow++;
        }
      }

      $this->excel->getActiveSheet()->setCellValue('A' . $excelrow, 'Total : ')->getStyle('B' . $excelrow)->getFont()->setBold(true);
      $this->excel->getActiveSheet()->setCellValue('E' . $excelrow, $fChallan);
      $this->excel->getActiveSheet()->setCellValue('F' . $excelrow, $fBoxes);
      $this->excel->getActiveSheet()->setCellValue('G' . $excelrow, $fQty);
      $this->excel->getActiveSheet()->setCellValue('H' . $excelrow, $fSku);
      $this->excel->getActiveSheet()->setCellValue('M' . $excelrow, secToTime($total));
    }
    header('Content-Type: application/vnd.ms-excel'); //mime type
    header('Content-Disposition: attachment;filename="' . $filename . '"'); //tell browser what's the file name
    header('Cache-Control: max-age=0'); //no cache
    $objWriter = PHPExcel_IOFactory::createWriter($this->excel, 'Excel5');
    $objWriter->save('php://output');
    exit;
  }

  function get_date_ranged_report_excel_new_detailed_c_l_w_d() {

    //pre($this->input->post());
    $total = 0;
    $this->load->library('excel');
    $this->load->helper('report');
    if ($this->session->userdata('role') == '4') {
      $department_id = $this->session->userdata('department_id');
      $sub_department_id = $this->session->userdata('sub_department_id');
    } else {
      $location_id = $this->input->post('locationId');
      $organization_id = $this->input->post('warehouseId');
      $client_id = $this->input->post('clientId');
      $department_id = $this->input->post('departmentId');
      $sub_department_id = $this->input->post('subdepartment');
      $shift_id = $this->input->post('shift');
    }
    $fromDate = $this->input->post('from_date');
    $toDate = $this->input->post('to_date');
    $date = $this->input->post('date');
    $filename = 'detailed_productivity_report.xls';
    $this->db->select('tbl_manpower_team_performance.*');
    $this->db->group_by('tbl_manpower_team_performance.sub_dept_id');
    $all_team_ids = $this->db->get('tbl_manpower_team_performance')->result();
    $totalcount = count($all_team_ids);
    $this->excel->setActiveSheetIndex(0);
    $this->excel->getActiveSheet()->setTitle('Report');
    $this->excel->getActiveSheet()->setCellValue('A1', 'Location')->getStyle('A1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B1:O1')->setCellValue('B1', locationName(locationIdByOrgId($organization_id)))->getStyle('B1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A2', 'Warehouse')->getStyle('A2')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B2:O2')->setCellValue('B2', orgName($organization_id))->getStyle('B2')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A3', 'Client Name')->getStyle('A3')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B3:O3')->setCellValue('B3', clientName($client_id))->getStyle('B3')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A4', 'Department')->getStyle('A4')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B4:O4')->setCellValue('B4', ($department_id && $department_id != 'all') ? deptName($department_id) : $department_id)->getStyle('B4')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A5', 'Report Type')->getStyle('A5')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B5:O5')->setCellValue('B5', ($department_id && $department_id != 'all') ? deptName($department_id) . " of " . clientName($client_id) . " Manpower Report" : $department_id . " Department of " . clientName($client_id) . " Manpower Report")->getStyle('B5')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A6', 'Date Range')->getStyle('A6')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B6:O6')->setCellValue('B6', $date)->getStyle('B6')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A7', 'Report Generated Date & Time')->getStyle('A7')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B7:O7')->setCellValue('B7', date("Y-m-d H:i:s"))->getStyle('B7')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A8', 'Employee Name')->getStyle('A8')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('B8', 'Emp Code')->getStyle('B8')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('C8', 'Total Benchmark')->getStyle('C8')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('D8', 'Benchmark Unit (UOM)')->getStyle('D8')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('E8', 'Challan')->getStyle('E8')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('F8', 'Boxes')->getStyle('F8')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('G8', 'Qty')->getStyle('G8')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('H8', 'SKU')->getStyle('H8')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('I8', 'KG')->getStyle('I8')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('J8', 'CFC')->getStyle('J8')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('K8', 'Bins')->getStyle('K8')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('L8', 'Pallet')->getStyle('L8')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('M8', 'Time')->getStyle('M8')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('N8', 'Productivity')->getStyle('N8')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('O8', '%age Achievement')->getStyle('O8')->getFont()->setBold(true);
    $fChallan = 0;
    $fBoxes = 0;
    $fQty = 0;
    $fSku = 0;
    $fEmp = 0;
    //pre($all_team_ids);
    if (!empty($all_team_ids)) {
      $excelrow = 9;
      $where = ' ';
      $select = ' ';
      $groupBY = '  GROUP BY location';
      if ($location_id != '' && $location_id != 'all') {
        $where .= ' AND tbl_manpower_team_performance.location = ' . $location_id;
        $groupBY = ' GROUP BY location';
      } elseif ($location_id == 'all') {
        $groupBY = ' GROUP BY location';
      }
      if ($client_id != '' && $client_id != 'all') {
        $where .= ' AND tbl_manpower_team_performance.client = ' . $client_id;
        $groupBY = ' GROUP BY client';
      } elseif ($client_id == 'all') {
        $groupBY = ' GROUP BY client';
      }

      if ($organization_id != '' && $organization_id != 'all') {
        $where .= ' AND tbl_manpower_team_performance.org = ' . $organization_id;
        $groupBY = ' GROUP BY org';
      } elseif ($organization_id == 'all') {
        $groupBY = ' GROUP BY org';
      }
      if ($department_id != '' && $department_id != 'all') {
        $where .= ' AND tbl_manpower_team_performance.dept_id = ' . $department_id;
        $groupBY = ' GROUP BY dept_id';
      } elseif ($department_id == 'all') {
        $groupBY = ' GROUP BY dept_id';
      }
      if ($sub_department_id != '' && $sub_department_id != 'all') {
        $where .= ' AND tbl_manpower_team_performance.sub_dept_id = ' . $sub_department_id;
        $groupBY = ' GROUP BY sub_dept_id';
      } elseif ($sub_department_id == 'all') {
        $groupBY = ' GROUP BY sub_dept_id';
      }
      $groupBY = ' GROUP BY employee_id';

      $total_challans = $this->db->query('SELECT *, IFNULL(SUM(challans), 0) AS total_challans,date ' . $select . ' FROM tbl_manpower_team_performance WHERE date =\'' . $this->input->post('date') . '\' ' . $where . $groupBY)->result_array();
//      last_query();
      $totalcount = count($total_challans);
      if ($totalcount == '0') {
        $this->session->set_flashdata('success', 'Data Not Found with your Search.');
        redirect('view-report-new-detailed-c-l-w-d-sd');
      }
      $total_boxes = $this->db->query('SELECT IFNULL(SUM(A), 0) AS total_boxes,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date =\'' . $this->input->post('date') . '\' ' . $where . $groupBY)->result_array();
      $total_qty = $this->db->query('SELECT IFNULL(SUM(B), 0) AS total_qty,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date =\'' . $this->input->post('date') . '\' ' . $where . $groupBY)->result_array();
      $total_sku = $this->db->query('SELECT IFNULL(SUM(C), 0) AS total_sku,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date =\'' . $this->input->post('date') . '\' ' . $where . $groupBY)->result_array();
      $total_manpower = $this->db->query('SELECT IFNULL(COUNT(absent),0) AS manpower,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date =\'' . $this->input->post('date') . '\' ' . $where . $groupBY)->result_array();
      $client_list = $this->db->query('SELECT GROUP_CONCAT(DISTINCT CONCAT(\'"\', `client`, \'"\')) AS `clientlist`, date ' . $select . '  FROM tbl_manpower_team_performance WHERE date =\'' . $this->input->post('date') . '\' ' . $where . $groupBY)->result_array();
      $total_time = $this->db->query('SELECT IFNULL(SEC_TO_TIME(SUM(TIME_TO_SEC(time))),0) AS total_time,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date =\'' . $this->input->post('date') . '\' ' . $where . $groupBY)->result_array();
      if (!empty($total_challans)) {
        foreach ($total_challans as $key1 => $challan) {
          $uomKey = $challan['uom'];
          $fChallan += $TCHALLAN = $challan['total_challans'];
          $fBoxes += $TOTALBOXES = isset($total_boxes[$key1]['total_boxes']) ? $total_boxes[$key1]['total_boxes'] : 0;
          $fQty += $TOTALQTY = isset($total_qty[$key1]['total_qty']) ? $total_qty[$key1]['total_qty'] : 0;
          $fSku += $TOTALSKU = isset($total_sku[$key1]['total_sku']) ? $total_sku[$key1]['total_sku'] : 0;
          $fEmp += $TOTALMANPOWER = isset($total_manpower[$key1]['manpower']) ? $total_manpower[$key1]['manpower'] : 0;
          $TOTALTIME = isset($challan['time']) ? strtotime($challan['time']) : strtotime('00:00:00');
          $fTime += $TOTALTIME;
          $this->excel->getActiveSheet()->setCellValue('A' . $excelrow, ucfirst(empNameById($challan['employee_id'])));
          $this->excel->getActiveSheet()->setCellValue('B' . $excelrow, ucfirst(empCodeByEmpId($challan['employee_id'])));
          $this->excel->getActiveSheet()->setCellValue('C' . $excelrow, $challan['banchmark']);
          $this->excel->getActiveSheet()->setCellValue('D' . $excelrow, $challan['uom']);
          $this->excel->getActiveSheet()->setCellValue('E' . $excelrow, $challan['challans']);
          $this->excel->getActiveSheet()->setCellValue('F' . $excelrow, $challan['A']);
          $this->excel->getActiveSheet()->setCellValue('G' . $excelrow, $challan['B']);
          $this->excel->getActiveSheet()->setCellValue('H' . $excelrow, $challan['C']);
          $this->excel->getActiveSheet()->setCellValue('I' . $excelrow, $challan['kg']);
          $this->excel->getActiveSheet()->setCellValue('J' . $excelrow, $challan['cfc']);
          $this->excel->getActiveSheet()->setCellValue('K' . $excelrow, $challan['bins']);
          $this->excel->getActiveSheet()->setCellValue('L' . $excelrow, $challan['pallet']);
          $this->excel->getActiveSheet()->setCellValue('M' . $excelrow, $challan['time']);
          $this->excel->getActiveSheet()->setCellValue('N' . $excelrow, ($challan[$uomKey] / 1));
          $this->excel->getActiveSheet()->setCellValue('O' . $excelrow, ((($challan[$uomKey] / 1) * 100) / $challan['banchmark']) . ' %');
          fputcsv($output, [$team_details->shift, '', $team_details->department_name, $challan['date'], $team_details->created_by, $challan['total_challans'], $total_boxes[$key]['total_boxes'], $total_qty[$key]['total_qty'], $total_sku[$key]['total_sku'], $total_manpower[$key]['manpower']]);

          $element = $challan['time'];
          // Explode by seperator :
          $temp = explode(":", $element);

          // Convert the hours into seconds
          // and add to total
          $total += (int) $temp[0] * 3600;

          // Convert the minutes to seconds
          // and add to total
          $total += (int) $temp[1] * 60;

          // Add the seconds to total
          $total += (int) $temp[2];

          $excelrow++;
        }
      }

      $this->excel->getActiveSheet()->setCellValue('A' . $excelrow, 'Total : ')->getStyle('B' . $excelrow)->getFont()->setBold(true);
      $this->excel->getActiveSheet()->setCellValue('E' . $excelrow, $fChallan);
      $this->excel->getActiveSheet()->setCellValue('F' . $excelrow, $fBoxes);
      $this->excel->getActiveSheet()->setCellValue('G' . $excelrow, $fQty);
      $this->excel->getActiveSheet()->setCellValue('H' . $excelrow, $fSku);
      $this->excel->getActiveSheet()->setCellValue('M' . $excelrow, secToTime($total));
    }
    header('Content-Type: application/vnd.ms-excel'); //mime type
    header('Content-Disposition: attachment;filename="' . $filename . '"'); //tell browser what's the file name
    header('Cache-Control: max-age=0'); //no cache
    $objWriter = PHPExcel_IOFactory::createWriter($this->excel, 'Excel5');
    $objWriter->save('php://output');
    exit;
  }

  function get_date_ranged_report_excel_new_detailed_c_l_w_d_sd() {
    $this->load->library('excel');
    $this->load->helper('report');
    if ($this->session->userdata('role') == '4') {
      $department_id = $this->session->userdata('department_id');
      $sub_department_id = $this->session->userdata('sub_department_id');
    } else {
      $department_id = $this->input->post('departmentId');
      $sub_department_id = $this->input->post('subdepartment');
      $client_id = $this->input->post('clientId');
      $location_id = $this->input->post('locationId');
      $organization_id = $this->input->post('warehouseId');
    }
    $fromDate = $this->input->post('from_date');
    $toDate = $this->input->post('to_date');
    //$filename = 'detailed_productivity_report_' . clientName(clientIdByLocationId(locationIdByOrgId($organization_id))) . '_' . locationName(locationIdByOrgId($organization_id)) . '_' . orgName($organization_id) . '_' . deptName($department_id) . '_' . subDeptName($sub_department_id) . '_' . $fromDate . '_to_' . $toDate . '.xls';
    $filename = 'detailed_productivity_report_' . locationName(locationIdByClientId(clientIdByOrgId($organization_id))) . '_' . clientName(clientIdByOrgId($organization_id)) . '_' . orgName($organization_id) . '_' . deptName($department_id) . '_' . subDeptName($sub_department_id) . '_' . $fromDate . '_to_' . $toDate . '.xls';
    $this->db->select('tbl_manpower_team_performance.*');
    $this->db->group_by('tbl_manpower_team_performance.sub_dept_id');
    $all_team_ids = $this->db->get('tbl_manpower_team_performance')->result();
    $totalcount = count($all_team_ids);
    $this->excel->setActiveSheetIndex(0);
    $this->excel->getActiveSheet()->setTitle('Report');
    $this->excel->getActiveSheet()->setCellValue('A1', 'Client Name')->getStyle('A1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B1:G1')->setCellValue('B1', clientName(clientIdByLocationId(locationIdByOrgId($organization_id))))->getStyle('B1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A2', 'Location')->getStyle('A2')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B2:G2')->setCellValue('B2', locationName(locationIdByOrgId($organization_id)))->getStyle('B2')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A3', 'Warehouse')->getStyle('A3')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B3:G3')->setCellValue('B3', orgName($organization_id))->getStyle('B3')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A4', 'Department')->getStyle('A4')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B4:G4')->setCellValue('B4', deptName($department_id))->getStyle('B4')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A5', 'Sub Department')->getStyle('A5')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B5:G5')->setCellValue('B5', subDeptName($sub_department_id))->getStyle('B5')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A6', 'Date Range')->getStyle('A6')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B6:G6')->setCellValue('B6', $fromDate . '_to_' . $toDate)->getStyle('B6')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A7', 'Date')->getStyle('A5')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('B7', 'Superviser')->getStyle('B5')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('C7', 'Total Challan')->getStyle('C5')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('D7', 'Total Boxes')->getStyle('D5')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('E7', 'Toatal Qty')->getStyle('E5')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('F7', 'Total SKU')->getStyle('F5')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('G7', 'Total Manpower')->getStyle('G5')->getFont()->setBold(true);
    $fChallan = 0;
    $fBoxes = 0;
    $fQty = 0;
    $fSku = 0;
    $fEmp = 0;
    if (!empty($all_team_ids)) {
      $excelrow = 8;
      $where = ' ';
      $select = ' ';
      $groupBY = '  GROUP BY location';
      if ($location_id != '' && $location_id != 'all') {
        $where .= ' AND tbl_manpower_team_performance.location = ' . $location_id;
        $groupBY = ' GROUP BY location';
      } elseif ($location_id == 'all') {
        $groupBY = ' GROUP BY location';
      }
      if ($client_id != '' && $client_id != 'all') {
        $where .= ' AND tbl_manpower_team_performance.client = ' . $client_id;
        $groupBY = ' GROUP BY client';
      } elseif ($client_id == 'all') {
        $groupBY = ' GROUP BY client';
      }

      if ($organization_id != '' && $organization_id != 'all') {
        $where .= ' AND tbl_manpower_team_performance.org = ' . $organization_id;
        $groupBY = ' GROUP BY org';
      } elseif ($organization_id == 'all') {
        $groupBY = ' GROUP BY org';
      }
      if ($department_id != '' && $department_id != 'all') {
        $where .= ' AND tbl_manpower_team_performance.dept_id = ' . $department_id;
        $groupBY = ' GROUP BY dept_id';
      } elseif ($department_id == 'all') {
        $groupBY = ' GROUP BY dept_id';
      }
      if ($sub_department_id != '' && $sub_department_id != 'all') {
        $where .= ' AND tbl_manpower_team_performance.sub_dept_id = ' . $sub_department_id;
        $groupBY = ' GROUP BY sub_dept_id';
      } elseif ($sub_department_id == 'all') {
        $groupBY = ' GROUP BY sub_dept_id';
      }
      $groupBY = ' GROUP BY date';

      $total_challans = $this->db->query('SELECT *, IFNULL(SUM(challans), 0) AS total_challans,date ' . $select . ' FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
      $totalcount = count($total_challans);
      if ($totalcount == '0') {
        $this->session->set_flashdata('success', 'Data Not Found with your Search.');
        redirect('view-report-new-detailed-c-l-w-d-sd');
      }
      $total_boxes = $this->db->query('SELECT IFNULL(SUM(A), 0) AS total_boxes,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
      $total_qty = $this->db->query('SELECT IFNULL(SUM(B), 0) AS total_qty,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
      $total_sku = $this->db->query('SELECT IFNULL(SUM(C), 0) AS total_sku,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
      $total_manpower = $this->db->query('SELECT IFNULL(COUNT(absent),0) AS manpower,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
      $client_list = $this->db->query('SELECT GROUP_CONCAT(DISTINCT CONCAT(\'"\', `client`, \'"\')) AS `clientlist`, date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' AND client != \'\' ' . $where . $groupBY)->result_array();
      $total_time = $this->db->query('SELECT IFNULL(SEC_TO_TIME(SUM(TIME_TO_SEC(time))),0) AS total_time,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\'  ' . $where . $groupBY)->result_array();
      if (!empty($total_challans)) {
        foreach ($total_challans as $key1 => $challan) {
          $fChallan += $TCHALLAN = $challan['total_challans'];
          $fBoxes += $TOTALBOXES = isset($total_boxes[$key1]['total_boxes']) ? $total_boxes[$key1]['total_boxes'] : 0;
          $fQty += $TOTALQTY = isset($total_qty[$key1]['total_qty']) ? $total_qty[$key1]['total_qty'] : 0;
          $fSku += $TOTALSKU = isset($total_sku[$key1]['total_sku']) ? $total_sku[$key1]['total_sku'] : 0;
          $fEmp += $TOTALMANPOWER = isset($total_manpower[$key1]['manpower']) ? $total_manpower[$key1]['manpower'] : 0;
          $this->excel->getActiveSheet()->setCellValue('A' . $excelrow, date('d-m-Y', strtotime($challan['date'])));
          $this->excel->getActiveSheet()->setCellValue('B' . $excelrow, ucfirst(superviserBySubDeptId($challan['sub_dept_id'])));
          $this->excel->getActiveSheet()->setCellValue('C' . $excelrow, $TCHALLAN);
          $this->excel->getActiveSheet()->setCellValue('D' . $excelrow, $TOTALBOXES);
          $this->excel->getActiveSheet()->setCellValue('E' . $excelrow, $TOTALQTY);
          $this->excel->getActiveSheet()->setCellValue('F' . $excelrow, $TOTALSKU);
          $this->excel->getActiveSheet()->setCellValue('G' . $excelrow, $TOTALMANPOWER);
          fputcsv($output, [$team_details->shift, '', $team_details->department_name, $challan['date'], $team_details->created_by, $challan['total_challans'], $total_boxes[$key]['total_boxes'], $total_qty[$key]['total_qty'], $total_sku[$key]['total_sku'], $total_manpower[$key]['manpower']]);
          $excelrow++;
        }
      }
      $this->excel->getActiveSheet()->setCellValue('B' . $excelrow, 'Total : ')->getStyle('B' . $excelrow)->getFont()->setBold(true);
      $this->excel->getActiveSheet()->setCellValue('C' . $excelrow, $fChallan);
      $this->excel->getActiveSheet()->setCellValue('D' . $excelrow, $fBoxes);
      $this->excel->getActiveSheet()->setCellValue('E' . $excelrow, $fQty);
      $this->excel->getActiveSheet()->setCellValue('F' . $excelrow, $fSku);
      $this->excel->getActiveSheet()->setCellValue('G' . $excelrow, $fEmp);
    }
    header('Content-Type: application/vnd.ms-excel'); //mime type
    header('Content-Disposition: attachment;filename="' . $filename . '"'); //tell browser what's the file name
    header('Cache-Control: max-age=0'); //no cache
    $objWriter = PHPExcel_IOFactory::createWriter($this->excel, 'Excel5');
    $objWriter->save('php://output');
    exit;
  }

  function get_date_ranged_report_excel_new_detailed_c_l_w_d_sd_all() {

    //pre($this->input->post());
    $total = 0;
    $this->load->library('excel');
    $this->load->helper('report');
    if ($this->session->userdata('role') == '4') {
      $department_id = $this->session->userdata('department_id');
      $sub_department_id = $this->session->userdata('sub_department_id');
    } else {
      $location_id = $this->input->post('locationId');
      $organization_id = $this->input->post('warehouseId');
      $client_id = $this->input->post('clientId');
      $department_id = $this->input->post('departmentId');
      $sub_department_id = $this->input->post('subdepartment');
      $shift_id = $this->input->post('shift');
    }
    $fromDate = $this->input->post('from_date');
    $toDate = $this->input->post('to_date');
    $date = $this->input->post('date');
    $filename = 'detailed_productivity_report.xls';
    $this->db->select('tbl_manpower_team_performance.*');
    $this->db->group_by('tbl_manpower_team_performance.sub_dept_id');
    $all_team_ids = $this->db->get('tbl_manpower_team_performance')->result();
    $totalcount = count($all_team_ids);
    $this->excel->setActiveSheetIndex(0);
    $this->excel->getActiveSheet()->setTitle('Report');
    $this->excel->getActiveSheet()->setCellValue('A1', 'Location')->getStyle('A1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B1:O1')->setCellValue('B1', locationName(locationIdByOrgId($organization_id)))->getStyle('B1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A2', 'Warehouse')->getStyle('A2')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B2:O2')->setCellValue('B2', orgName($organization_id))->getStyle('B2')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A3', 'Client Name')->getStyle('A3')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B3:O3')->setCellValue('B3', clientName($client_id))->getStyle('B3')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A4', 'Department')->getStyle('A4')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B4:O4')->setCellValue('B4', deptName($department_id))->getStyle('B4')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A5', 'Sub Department')->getStyle('A5')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B5:O5')->setCellValue('B5', ($sub_department_id && $sub_department_id != 'all') ? subDeptName($sub_department_id) : $sub_department_id . " Sub Department" )->getStyle('B5')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A6', 'Report Type')->getStyle('A6')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B6:O6')->setCellValue('B6', ($sub_department_id && $sub_department_id != 'all') ? subDeptName($sub_department_id) . " of " . deptName($department_id) . " Manpower Report" : $sub_department_id . " Sub Department of " . deptName($department_id) . " Manpower Report")->getStyle('B6')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A7', 'Date Range')->getStyle('A7')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B7:O7')->setCellValue('B7', $date)->getStyle('B7')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A8', 'Report Generated Date & Time')->getStyle('A8')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B8:O8')->setCellValue('B8', date("Y-m-d H:i:s"))->getStyle('B8')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A9', 'Employee Name')->getStyle('A9')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('B9', 'Emp Code')->getStyle('B9')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('C9', 'Total Benchmark')->getStyle('C9')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('D9', 'Benchmark Unit (UOM)')->getStyle('D9')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('E9', 'Challan')->getStyle('E9')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('F9', 'Boxes')->getStyle('F9')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('G9', 'Qty')->getStyle('G9')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('H9', 'SKU')->getStyle('H9')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('I9', 'KG')->getStyle('I9')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('J9', 'CFC')->getStyle('J9')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('K9', 'Bins')->getStyle('K9')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('L9', 'Pallet')->getStyle('L9')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('M9', 'Time')->getStyle('M9')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('N9', 'Productivity')->getStyle('N9')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('O9', '%age Achievement')->getStyle('O9')->getFont()->setBold(true);
    $fChallan = 0;
    $fBoxes = 0;
    $fQty = 0;
    $fSku = 0;
    $fEmp = 0;
    //pre($all_team_ids);
    if (!empty($all_team_ids)) {
      $excelrow = 10;
      $where = ' ';
      $select = ' ';
      $groupBY = '  GROUP BY location';
      if ($location_id != '' && $location_id != 'all') {
        $where .= ' AND tbl_manpower_team_performance.location = ' . $location_id;
        $groupBY = ' GROUP BY location';
      } elseif ($location_id == 'all') {
        $groupBY = ' GROUP BY location';
      }
      if ($client_id != '' && $client_id != 'all') {
        $where .= ' AND tbl_manpower_team_performance.client = ' . $client_id;
        $groupBY = ' GROUP BY client';
      } elseif ($client_id == 'all') {
        $groupBY = ' GROUP BY client';
      }

      if ($organization_id != '' && $organization_id != 'all') {
        $where .= ' AND tbl_manpower_team_performance.org = ' . $organization_id;
        $groupBY = ' GROUP BY org';
      } elseif ($organization_id == 'all') {
        $groupBY = ' GROUP BY org';
      }
      if ($department_id != '' && $department_id != 'all') {
        $where .= ' AND tbl_manpower_team_performance.dept_id = ' . $department_id;
        $groupBY = ' GROUP BY dept_id';
      } elseif ($department_id == 'all') {
        $groupBY = ' GROUP BY dept_id';
      }
      if ($sub_department_id != '' && $sub_department_id != 'all') {
        $where .= ' AND tbl_manpower_team_performance.sub_dept_id = ' . $sub_department_id;
        $groupBY = ' GROUP BY sub_dept_id';
      } elseif ($sub_department_id == 'all') {
        $groupBY = ' GROUP BY sub_dept_id';
      }
      $groupBY = ' GROUP BY employee_id';

      $total_challans = $this->db->query('SELECT *, IFNULL(SUM(challans), 0) AS total_challans,date ' . $select . ' FROM tbl_manpower_team_performance WHERE date =\'' . $this->input->post('date') . '\' ' . $where . $groupBY)->result_array();
      $totalcount = count($total_challans);
      if ($totalcount == '0') {
        $this->session->set_flashdata('success', 'Data Not Found with your Search.');
        redirect('view-report-new-detailed-c-l-w-d-sd');
      }
      $total_boxes = $this->db->query('SELECT IFNULL(SUM(A), 0) AS total_boxes,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date =\'' . $this->input->post('date') . '\' ' . $where . $groupBY)->result_array();
      $total_qty = $this->db->query('SELECT IFNULL(SUM(B), 0) AS total_qty,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date =\'' . $this->input->post('date') . '\' ' . $where . $groupBY)->result_array();
      $total_sku = $this->db->query('SELECT IFNULL(SUM(C), 0) AS total_sku,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date =\'' . $this->input->post('date') . '\' ' . $where . $groupBY)->result_array();
      $total_manpower = $this->db->query('SELECT IFNULL(COUNT(absent),0) AS manpower,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date =\'' . $this->input->post('date') . '\' ' . $where . $groupBY)->result_array();
      $client_list = $this->db->query('SELECT GROUP_CONCAT(DISTINCT CONCAT(\'"\', `client`, \'"\')) AS `clientlist`, date ' . $select . '  FROM tbl_manpower_team_performance WHERE date =\'' . $this->input->post('date') . '\' ' . $where . $groupBY)->result_array();
      $total_time = $this->db->query('SELECT IFNULL(SEC_TO_TIME(SUM(TIME_TO_SEC(time))),0) AS total_time,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date =\'' . $this->input->post('date') . '\' ' . $where . $groupBY)->result_array();
      if (!empty($total_challans)) {
        foreach ($total_challans as $key1 => $challan) {
          //pre($challan);
          $uomKey = $challan['uom'];
          $fChallan += $TCHALLAN = $challan['total_challans'];
          $fBoxes += $TOTALBOXES = isset($total_boxes[$key1]['total_boxes']) ? $total_boxes[$key1]['total_boxes'] : 0;
          $fQty += $TOTALQTY = isset($total_qty[$key1]['total_qty']) ? $total_qty[$key1]['total_qty'] : 0;
          $fSku += $TOTALSKU = isset($total_sku[$key1]['total_sku']) ? $total_sku[$key1]['total_sku'] : 0;
          $fEmp += $TOTALMANPOWER = isset($total_manpower[$key1]['manpower']) ? $total_manpower[$key1]['manpower'] : 0;
          $TOTALTIME = isset($challan['time']) ? strtotime($challan['time']) : strtotime('00:00:00');
          $fTime += $TOTALTIME;
          $this->excel->getActiveSheet()->setCellValue('A' . $excelrow, ucfirst(empNameById($challan['employee_id'])));
          $this->excel->getActiveSheet()->setCellValue('B' . $excelrow, ucfirst(empCodeByEmpId($challan['employee_id'])));
          $this->excel->getActiveSheet()->setCellValue('C' . $excelrow, $challan['banchmark']);
          $this->excel->getActiveSheet()->setCellValue('D' . $excelrow, $challan['uom']);
          $this->excel->getActiveSheet()->setCellValue('E' . $excelrow, $challan['challans']);
          $this->excel->getActiveSheet()->setCellValue('F' . $excelrow, $challan['A']);
          $this->excel->getActiveSheet()->setCellValue('G' . $excelrow, $challan['B']);
          $this->excel->getActiveSheet()->setCellValue('H' . $excelrow, $challan['C']);
          $this->excel->getActiveSheet()->setCellValue('I' . $excelrow, $challan['kg']);
          $this->excel->getActiveSheet()->setCellValue('J' . $excelrow, $challan['cfc']);
          $this->excel->getActiveSheet()->setCellValue('K' . $excelrow, $challan['bins']);
          $this->excel->getActiveSheet()->setCellValue('L' . $excelrow, $challan['pallet']);
          $this->excel->getActiveSheet()->setCellValue('M' . $excelrow, $challan['time']);
          $this->excel->getActiveSheet()->setCellValue('N' . $excelrow, ($challan[$uomKey] / 1));
          $this->excel->getActiveSheet()->setCellValue('O' . $excelrow, ((($challan[$uomKey] / 1) * 100) / $challan['banchmark']) . ' %');
          fputcsv($output, [$team_details->shift, '', $team_details->department_name, $challan['date'], $team_details->created_by, $challan['total_challans'], $total_boxes[$key]['total_boxes'], $total_qty[$key]['total_qty'], $total_sku[$key]['total_sku'], $total_manpower[$key]['manpower']]);

          $element = $challan['time'];
          // Explode by seperator :
          $temp = explode(":", $element);

          // Convert the hours into seconds
          // and add to total
          $total += (int) $temp[0] * 3600;

          // Convert the minutes to seconds
          // and add to total
          $total += (int) $temp[1] * 60;

          // Add the seconds to total
          $total += (int) $temp[2];

          $excelrow++;
        }
      }

      $this->excel->getActiveSheet()->setCellValue('A' . $excelrow, 'Total : ')->getStyle('B' . $excelrow)->getFont()->setBold(true);
      $this->excel->getActiveSheet()->setCellValue('E' . $excelrow, $fChallan);
      $this->excel->getActiveSheet()->setCellValue('F' . $excelrow, $fBoxes);
      $this->excel->getActiveSheet()->setCellValue('G' . $excelrow, $fQty);
      $this->excel->getActiveSheet()->setCellValue('H' . $excelrow, $fSku);
      $this->excel->getActiveSheet()->setCellValue('M' . $excelrow, secToTime($total));
    }
    header('Content-Type: application/vnd.ms-excel'); //mime type
    header('Content-Disposition: attachment;filename="' . $filename . '"'); //tell browser what's the file name
    header('Cache-Control: max-age=0'); //no cache
    $objWriter = PHPExcel_IOFactory::createWriter($this->excel, 'Excel5');
    $objWriter->save('php://output');
    exit;
  }
  
  
  
  function get_date_ranged_report_excel_new_detailed_c_l_w_d_sd_shift() {
    $total = 0;
    $this->load->library('excel');
    $this->load->helper('report');
    if ($this->session->userdata('role') == '4') {
      $location_id = $this->input->post('locationId');
      $organization_id = $this->input->post('warehouseId');
      $client_id = $this->input->post('clientId');
      $department_id = $this->input->post('departmentId');
      $sub_department_id = $this->input->post('subdepartment');
    } else {
      $location_id = $this->input->post('locationId');
      $organization_id = $this->input->post('warehouseId');
      $client_id = $this->input->post('clientId');
      $department_id = $this->input->post('departmentId');
      $sub_department_id = $this->input->post('subdepartment');
    }
    $fromDate = $this->input->post('from_date');
    $toDate = $this->input->post('to_date');
    $date = $this->input->post('date');
    $filename = 'detailed_productivity_report_' . locationName(locationIdByOrgId($organization_id)) . '_' . orgName($organization_id) . '_' . clientName($client_id) . '_' . deptName($department_id) . '_' . subDeptName($sub_department_id) . '_' . $date . '.xls';
    $this->excel->setActiveSheetIndex(0);
    $this->excel->getActiveSheet()->setTitle('Report');
    $this->excel->getActiveSheet()->setCellValue('A1', 'Date')->getStyle('A1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('B1', 'Location Name')->getStyle('B1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('C1', 'Client Name')->getStyle('C1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('D1', 'Warehouse')->getStyle('D1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('E1', 'Department')->getStyle('E1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('F1', 'Sub Department')->getStyle('F1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('G1', 'Shift')->getStyle('G1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('H1', 'Employee Name')->getStyle('H1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('I1', 'Emp Code')->getStyle('I1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('J1', 'Total Benchmark')->getStyle('J1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('K1', 'Benchmark Unit (UOM)')->getStyle('K1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('L1', 'Challan')->getStyle('L1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('M1', 'Boxes')->getStyle('M1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('N1', 'Qty')->getStyle('N1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('O1', 'SKU')->getStyle('O1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('P1', 'KG')->getStyle('P1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('Q1', 'CFC')->getStyle('Q1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('R1', 'Bins')->getStyle('R1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('S1', 'Pallet')->getStyle('S1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('T1', 'Line')->getStyle('T1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('U1', 'Time')->getStyle('U1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('V1', 'Productivity')->getStyle('V1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('W1', '%age Achievement')->getStyle('W1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('X1', 'Remark')->getStyle('X1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('Y1', 'Employee Type')->getStyle('Y1')->getFont()->setBold(true);
    $fChallan = 0;
    $fBoxes = 0;
    $fQty = 0;
    $fSku = 0;
    $fEmp = 0;
    $excelrow = 2;
    $where = ' ';
    $select = ' ';
    $groupBY = '  GROUP BY client';
    if ($location_id != '' && $location_id != 'all') {
      $where .= ' AND tbl_manpower_team_performance.location = ' . $location_id;
      $groupBY = ' GROUP BY location';
    } elseif ($location_id == 'all') {
      $groupBY = ' GROUP BY location';
    }
    if ($organization_id != '' && $organization_id != 'all') {
      $where .= ' AND tbl_manpower_team_performance.org = ' . $organization_id;
      $groupBY = ' GROUP BY org';
    } elseif ($organization_id == 'all') {
      $groupBY = ' GROUP BY org';
    }
    if ($client_id != '' && $client_id != 'all') {
      $where .= ' AND tbl_manpower_team_performance.client = ' . $client_id;
      $groupBY = ' GROUP BY client';
    } elseif ($client_id == 'all') {
      $groupBY = ' GROUP BY client';
    }

    if ($department_id != '' && $department_id != 'all') {
      $where .= ' AND tbl_manpower_team_performance.dept_id = ' . $department_id;
      $groupBY = ' GROUP BY dept_id';
    } elseif ($department_id == 'all') {
      $groupBY = ' GROUP BY dept_id';
    }
    if ($sub_department_id != '' && $sub_department_id != 'all') {
      $where .= ' AND tbl_manpower_team_performance.sub_dept_id = ' . $sub_department_id;
      $groupBY = ' GROUP BY sub_dept_id';
    } elseif ($sub_department_id == 'all') {
      $groupBY = ' GROUP BY sub_dept_id';
    }
    if ($this->session->userdata('role') == '4') {
      $where .= ' AND tbl_manpower_team_performance.superviser_id = ' . $this->session->userdata('userId');
    }
    $groupBY = ' GROUP BY date,client,dept_id,sub_dept_id,tbl_manpower_team_performance.shift,employee_code,employee_id,id';
    $queryChallan = 'SELECT tbl_manpower_team_performance.*,TIME_TO_SEC(time) as total_sec_worked,A as boxes,B as qty,C as sku, '
        . 'IFNULL(SUM(challans), 0) AS total_challans,'
        . 'IFNULL(SUM(A), 0) AS total_boxes,'
        . 'IFNULL(SUM(B), 0) AS total_qty,'
        . 'IFNULL(SUM(C), 0) AS total_sku,'
        . 'IFNULL(SUM(kg), 0) AS total_kg,'
        . 'IFNULL(SUM(cfc), 0) AS total_cfc,'
        . 'IFNULL(SUM(bins), 0) AS total_bins,'
        . 'IFNULL(SUM(pallet), 0) AS total_pallet,'
        . 'IFNULL(SUM(line), 0) AS total_line,'
        . 'IFNULL(COUNT(absent),0) AS manpower,'
        . 'IFNULL(SEC_TO_TIME(SUM(TIME_TO_SEC(time))),0) AS total_time,'
        . 'date ' . $select . ' FROM tbl_manpower_team_performance left join tbl_users on tbl_users.userId = tbl_manpower_team_performance.employee_id WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY;
    $total_challans = $this->db->query($queryChallan)->result_array();
    $totalcount = count($total_challans);

    if ($totalcount == '0') {
      $this->session->set_flashdata('success', 'Data Not Found with your Search.');
      redirect('view-report-new-detailed-c-l-w-d-sd');
    }
    if (!empty($total_challans)) {
      foreach ($total_challans as $key1 => $challan) {
        $shiftMngt = getShiftMngtBySupervisor($challan['superviser_id'], $challan['dept_id'], $challan['sub_dept_id']);
        $totalSec = (int) round($shiftMngt['total_sec_to_work'], '2');
        $uomKey = $challan['uom'];
        $AchivementPer = ((($challan[$uomKey] / 1) * 100 * $totalSec) / (($challan['banchmark']) * (($challan['total_sec_worked'])) . ' %'));
        $AchivementPer = (integer) (round($AchivementPer)) ? round($AchivementPer) : '0';
        $fChallan += $TCHALLAN = $challan['total_challans'];
        $fBoxes += $TOTALBOXES = $challan['total_boxes'];
        $fQty += $TOTALQTY = $challan['total_qty'];
        $fSku += $TOTALSKU = $challan['total_sku'];
        $fKG += $TOTALKG = $challan['total_kg'];
        $fCFC += $TOTALCFC = $challan['total_cfc'];
        $fBINS += $TOTALBINS = $challan['total_bins'];
        $fPALLET += $TOTALPALLET = $challan['total_pallet'];
        $fLINE += $TOTALLINE = $challan['total_line'];
        $fEmp += $TOTALMANPOWER = $challan['manpower'];
        $fTime += $TOTALTIME = $challan['total_time'];
        $this->excel->getActiveSheet()->setCellValue('A' . $excelrow, date('d-m-Y', strtotime($challan['date'])));
        $this->excel->getActiveSheet()->setCellValue('B' . $excelrow, locationName($challan['location']));
        $this->excel->getActiveSheet()->setCellValue('C' . $excelrow, clientName($challan['client']));
        $this->excel->getActiveSheet()->setCellValue('D' . $excelrow, orgName($challan['org']));
        $this->excel->getActiveSheet()->setCellValue('E' . $excelrow, deptName($challan['dept_id']));
        $this->excel->getActiveSheet()->setCellValue('F' . $excelrow, subDeptName($challan['sub_dept_id']));
        $this->excel->getActiveSheet()->setCellValue('G' . $excelrow, $challan['shift']);
//          $this->excel->getActiveSheet()->setCellValue('H' . $excelrow, empCodeById($challan['employee_id']));
        if ($challan['emp_type'] == 'Contractual') {
          $this->excel->getActiveSheet()->setCellValue('H' . $excelrow, $challan['co_emp_name']);
        } else {
          $this->excel->getActiveSheet()->setCellValue('H' . $excelrow, empNameById($challan['employee_id']) ? empNameById($challan['employee_id']) : $challan['co_emp_name']);
        }
//          $this->excel->getActiveSheet()->setCellValue('H' . $excelrow, empNameById($challan['employee_id']));
        $this->excel->getActiveSheet()->setCellValue('I' . $excelrow, empCodeByEmpId($challan['employee_id']) ? empCodeByEmpId($challan['employee_id']) : ucfirst($challan['employee_code']));
        $this->excel->getActiveSheet()->setCellValue('J' . $excelrow, $challan['banchmark']);
        $this->excel->getActiveSheet()->setCellValue('K' . $excelrow, $challan['uom']);
        $this->excel->getActiveSheet()->setCellValue('L' . $excelrow, $TCHALLAN);
        $this->excel->getActiveSheet()->setCellValue('M' . $excelrow, $TOTALBOXES);
        $this->excel->getActiveSheet()->setCellValue('N' . $excelrow, $TOTALQTY);
        $this->excel->getActiveSheet()->setCellValue('O' . $excelrow, $TOTALSKU);
        $this->excel->getActiveSheet()->setCellValue('P' . $excelrow, $TOTALKG);
        $this->excel->getActiveSheet()->setCellValue('Q' . $excelrow, $TOTALCFC);
        $this->excel->getActiveSheet()->setCellValue('R' . $excelrow, $TOTALBINS);
        $this->excel->getActiveSheet()->setCellValue('S' . $excelrow, $TOTALPALLET);
        $this->excel->getActiveSheet()->setCellValue('T' . $excelrow, $TOTALLINE);
        $this->excel->getActiveSheet()->setCellValue('U' . $excelrow, $TOTALTIME);
        $this->excel->getActiveSheet()->setCellValue('V' . $excelrow, ($challan[$uomKey] / 1));
        $this->excel->getActiveSheet()->setCellValue('W' . $excelrow, abs($AchivementPer));
        $this->excel->getActiveSheet()->setCellValue('X' . $excelrow, $challan['remark']);
        $this->excel->getActiveSheet()->setCellValue('Y' . $excelrow, $challan['emp_type']);
        fputcsv($output, [$team_details->shift, '', $team_details->department_name, $challan['date'], $team_details->created_by, $challan['total_challans'], $total_boxes[$key]['total_boxes'], $total_qty[$key]['total_qty'], $total_sku[$key]['total_sku'], $total_manpower[$key]['manpower']]);

        $element = $challan['total_time'];
        // Explode by seperator :
        $temp = explode(":", $element);

        // Convert the hours into seconds
        // and add to total
        $total += (int) $temp[0] * 3600;

        // Convert the minutes to seconds
        // and add to total
        $total += (int) $temp[1] * 60;

        // Add the seconds to total
        $total += (int) $temp[2];

        $excelrow++;
      }
    }

    $this->excel->getActiveSheet()->setCellValue('K' . $excelrow, 'Total : ')->getStyle('K' . $excelrow)->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('L' . $excelrow, $fChallan)->getStyle('L' . $excelrow)->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('M' . $excelrow, $fBoxes)->getStyle('M' . $excelrow)->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('N' . $excelrow, $fQty)->getStyle('N' . $excelrow)->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('O' . $excelrow, $fSku)->getStyle('o' . $excelrow)->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('P' . $excelrow, $fKG)->getStyle('P' . $excelrow)->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('Q' . $excelrow, $fCFC)->getStyle('Q' . $excelrow)->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('R' . $excelrow, $fBINS)->getStyle('R' . $excelrow)->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('S' . $excelrow, $fPALLET)->getStyle('S' . $excelrow)->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('T' . $excelrow, $fLINE)->getStyle('S' . $excelrow)->getFont()->setBold(true);
    // $this->excel->getActiveSheet()->setCellValue('M' . $excelrow, date('H:i', strtotime($total)));
    $this->excel->getActiveSheet()->setCellValue('U' . $excelrow, secToTime($total));
//    }
//    die;
    header('Content-Type: application/vnd.ms-excel'); //mime type
    header('Content-Disposition: attachment;filename="' . $filename . '"'); //tell browser what's the file name
    header('Cache-Control: max-age=0'); //no cache
    $objWriter = PHPExcel_IOFactory::createWriter($this->excel, 'Excel5');
    $objWriter->save('php://output');
    exit;
  }
  
  

//   function get_date_ranged_report_excel_new_detailed_c_l_w_d_sd_shift() {
// //    pre($this->input->post());

//     $total = 0;
//     $this->load->library('excel');
//     $this->load->helper('report');
//     if ($this->session->userdata('role') == '4') {
// //      pre($this->input->post());
//       $location_id = $this->input->post('locationId');
//       $organization_id = $this->input->post('warehouseId');
//       $client_id = $this->input->post('clientId');
//       $department_id = $this->input->post('departmentId');
//       $sub_department_id = $this->input->post('subdepartment');
//     } else {
//       $location_id = $this->input->post('locationId');
//       $organization_id = $this->input->post('warehouseId');
//       $client_id = $this->input->post('clientId');
//       $department_id = $this->input->post('departmentId');
//       $sub_department_id = $this->input->post('subdepartment');
// //      $shift_id = $this->input->post('shift');
//     }
//     //locationName(locationIdByOrgId($organization_id));
//     //pre($this->input->post());
//     $fromDate = $this->input->post('from_date');
//     $toDate = $this->input->post('to_date');
//     $date = $this->input->post('date');
//     $filename = 'detailed_productivity_report_' . locationName(locationIdByOrgId($organization_id)) . '_' . orgName($organization_id) . '_' . clientName($client_id) . '_' . deptName($department_id) . '_' . subDeptName($sub_department_id) . '_' . $date . '.xls';
//     //$filename = 'detailed_productivity_report_' . locationName(locationIdByClientId(clientIdByOrgId($organization_id))) . '_' . clientName(clientIdByOrgId($organization_id)) . '_' . orgName($organization_id) . '_' . deptName($department_id) . '_' . subDeptName($sub_department_id) . '_' . $date . '.xls';
//     //$filename = 'detailed_productivity_report.xls';
//     $this->db->select('tbl_manpower_team_performance.*');
//     $this->db->group_by('tbl_manpower_team_performance.sub_dept_id');
//     $all_team_ids = $this->db->get('tbl_manpower_team_performance')->result();
//     $totalcount = count($all_team_ids);
// //    pre($all_team_ids);
// //    echo superviserBySubDeptId($sub_department_id);
// //    echo "<br>" . locationName(locationIdByOrgId($organization_id));
// //    echo "<br>" . orgName($organization_id);
// //    echo "<br>" . clientName($client_id);
// //    echo "<br>" . deptName($department_id);
// //    echo "<br>" . subDeptName($sub_department_id);
// //    echo "<br>" . superviserBySubDeptId($sub_department_id);
// //    echo "<br>" . shiftName($shift_id);
// //    die;
//     $this->excel->setActiveSheetIndex(0);
//     $this->excel->getActiveSheet()->setTitle('Report');
//     $this->excel->getActiveSheet()->setCellValue('A1', 'Date')->getStyle('A1')->getFont()->setBold(true);
//     $this->excel->getActiveSheet()->setCellValue('B1', 'Location Name')->getStyle('B1')->getFont()->setBold(true);
//     $this->excel->getActiveSheet()->setCellValue('C1', 'Client Name')->getStyle('C1')->getFont()->setBold(true);
//     $this->excel->getActiveSheet()->setCellValue('D1', 'Warehouse')->getStyle('D1')->getFont()->setBold(true);
//     $this->excel->getActiveSheet()->setCellValue('E1', 'Department')->getStyle('E1')->getFont()->setBold(true);
//     $this->excel->getActiveSheet()->setCellValue('F1', 'Sub Department')->getStyle('F1')->getFont()->setBold(true);
//     $this->excel->getActiveSheet()->setCellValue('G1', 'Shift')->getStyle('G1')->getFont()->setBold(true);
//     $this->excel->getActiveSheet()->setCellValue('H1', 'Employee Name')->getStyle('H1')->getFont()->setBold(true);
//     $this->excel->getActiveSheet()->setCellValue('I1', 'Emp Code')->getStyle('I1')->getFont()->setBold(true);
//     $this->excel->getActiveSheet()->setCellValue('J1', 'Total Benchmark')->getStyle('J1')->getFont()->setBold(true);
//     $this->excel->getActiveSheet()->setCellValue('K1', 'Benchmark Unit (UOM)')->getStyle('K1')->getFont()->setBold(true);
//     $this->excel->getActiveSheet()->setCellValue('L1', 'Challan')->getStyle('L1')->getFont()->setBold(true);
//     $this->excel->getActiveSheet()->setCellValue('M1', 'Boxes')->getStyle('M1')->getFont()->setBold(true);
//     $this->excel->getActiveSheet()->setCellValue('N1', 'Qty')->getStyle('N1')->getFont()->setBold(true);
//     $this->excel->getActiveSheet()->setCellValue('O1', 'SKU')->getStyle('O1')->getFont()->setBold(true);
//     $this->excel->getActiveSheet()->setCellValue('P1', 'KG')->getStyle('P1')->getFont()->setBold(true);
//     $this->excel->getActiveSheet()->setCellValue('Q1', 'CFC')->getStyle('Q1')->getFont()->setBold(true);
//     $this->excel->getActiveSheet()->setCellValue('R1', 'Bins')->getStyle('R1')->getFont()->setBold(true);
//     $this->excel->getActiveSheet()->setCellValue('S1', 'Pallet')->getStyle('S1')->getFont()->setBold(true);
//     $this->excel->getActiveSheet()->setCellValue('T1', 'Line')->getStyle('T1')->getFont()->setBold(true);
//     $this->excel->getActiveSheet()->setCellValue('U1', 'Time')->getStyle('U1')->getFont()->setBold(true);
//     $this->excel->getActiveSheet()->setCellValue('V1', 'Productivity')->getStyle('V1')->getFont()->setBold(true);
//     $this->excel->getActiveSheet()->setCellValue('W1', '%age Achievement')->getStyle('W1')->getFont()->setBold(true);
//     $this->excel->getActiveSheet()->setCellValue('X1', 'Remark')->getStyle('X1')->getFont()->setBold(true);
//     $this->excel->getActiveSheet()->setCellValue('Y1', 'Employee Type')->getStyle('Y1')->getFont()->setBold(true);
//     $fChallan = 0;
//     $fBoxes = 0;
//     $fQty = 0;
//     $fSku = 0;
//     $fEmp = 0;
//     //pre($all_team_ids);
//     if (!empty($all_team_ids)) {
//       $excelrow = 2;
//       $where = ' ';
//       $select = ' ';
//       $groupBY = '  GROUP BY client';
//       if ($location_id != '' && $location_id != 'all') {
//         $where .= ' AND tbl_manpower_team_performance.location = ' . $location_id;
//         $groupBY = ' GROUP BY location';
//       } elseif ($location_id == 'all') {
//         $groupBY = ' GROUP BY location';
//       }
//       if ($organization_id != '' && $organization_id != 'all') {
//         $where .= ' AND tbl_manpower_team_performance.org = ' . $organization_id;
//         $groupBY = ' GROUP BY org';
//       } elseif ($organization_id == 'all') {
//         $groupBY = ' GROUP BY org';
//       }
//       if ($client_id != '' && $client_id != 'all') {
//         $where .= ' AND tbl_manpower_team_performance.client = ' . $client_id;
//         $groupBY = ' GROUP BY client';
//       } elseif ($client_id == 'all') {
//         $groupBY = ' GROUP BY client';
//       }

//       if ($department_id != '' && $department_id != 'all') {
//         $where .= ' AND tbl_manpower_team_performance.dept_id = ' . $department_id;
//         $groupBY = ' GROUP BY dept_id';
//       } elseif ($department_id == 'all') {
//         $groupBY = ' GROUP BY dept_id';
//       }
//       if ($sub_department_id != '' && $sub_department_id != 'all') {
//         $where .= ' AND tbl_manpower_team_performance.sub_dept_id = ' . $sub_department_id;
//         $groupBY = ' GROUP BY sub_dept_id';
//       } elseif ($sub_department_id == 'all') {
//         $groupBY = ' GROUP BY sub_dept_id';
//       }
// //      pre($this->session->userdata('role'));
//       if ($this->session->userdata('role') == '4') {
//         $where .= ' AND tbl_manpower_team_performance.superviser_id = ' . $this->session->userdata('userId');
//       }
// //      echo $where;
// //      die;
//       $groupBY = ' GROUP BY date,client,dept_id,sub_dept_id,shift,employee_code,employee_id,id';
//       $total_challans = $this->db->query('SELECT *,TIME_TO_SEC(time) as total_sec_worked,A as boxes,B as qty,C as sku, IFNULL(SUM(challans), 0) AS total_challans,date ' . $select . ' FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
// //      pre($total_challans);
// //      last_query();
//       $totalcount = count($total_challans);
//       if ($totalcount == '0') {
//         $this->session->set_flashdata('success', 'Data Not Found with your Search.');
//         redirect('view-report-new-detailed-c-l-w-d-sd');
//       }
//       $total_boxes = $this->db->query('SELECT IFNULL(SUM(A), 0) AS total_boxes,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
//       $total_qty = $this->db->query('SELECT IFNULL(SUM(B), 0) AS total_qty,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
//       $total_sku = $this->db->query('SELECT IFNULL(SUM(C), 0) AS total_sku,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
//       $total_kg = $this->db->query('SELECT IFNULL(SUM(kg), 0) AS total_kg,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
//       $total_cfc = $this->db->query('SELECT IFNULL(SUM(cfc), 0) AS total_cfc,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
//       $total_bins = $this->db->query('SELECT IFNULL(SUM(bins), 0) AS total_bins,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
//       $total_pallet = $this->db->query('SELECT IFNULL(SUM(pallet), 0) AS total_pallet,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
//       $total_line = $this->db->query('SELECT IFNULL(SUM(line), 0) AS total_line,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
//       $total_manpower = $this->db->query('SELECT IFNULL(COUNT(absent),0) AS manpower,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
//       $client_list = $this->db->query('SELECT GROUP_CONCAT(DISTINCT CONCAT(\'"\', `client`, \'"\')) AS `clientlist`, date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
//       $total_time = $this->db->query('SELECT IFNULL(SEC_TO_TIME(SUM(TIME_TO_SEC(time))),0) AS total_time,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
//       if (!empty($total_challans)) {
//         foreach ($total_challans as $key1 => $challan) {
// //          pre($challan);
//           $shiftMngt = getShiftMngtBySupervisor($challan['superviser_id'], $challan['dept_id'], $challan['sub_dept_id']);
//           $totalSec = (int) round($shiftMngt['total_sec_to_work'], '2');
//           $uomKey = $challan['uom'];
//           $AchivementPer = ((($challan[$uomKey] / 1) * 100 * $totalSec) / (($challan['banchmark']) * (($challan['total_sec_worked'])) . ' %'));
//           $AchivementPer = (integer) (round($AchivementPer)) ? round($AchivementPer) : '0';
//           $fChallan += $TCHALLAN = $challan['total_challans'];
//           $fBoxes += $TOTALBOXES = isset($total_boxes[$key1]['total_boxes']) ? $total_boxes[$key1]['total_boxes'] : 0;
//           $fQty += $TOTALQTY = isset($total_qty[$key1]['total_qty']) ? $total_qty[$key1]['total_qty'] : 0;
//           $fSku += $TOTALSKU = isset($total_sku[$key1]['total_sku']) ? $total_sku[$key1]['total_sku'] : 0;
//           $fKG += $TOTALKG = isset($total_kg[$key1]['total_kg']) ? $total_kg[$key1]['total_kg'] : 0;
//           $fCFC += $TOTALCFC = isset($total_cfc[$key1]['total_cfc']) ? $total_cfc[$key1]['total_cfc'] : 0;
//           $fBINS += $TOTALBINS = isset($total_bins[$key1]['total_bins']) ? $total_bins[$key1]['total_bins'] : 0;
//           $fPALLET += $TOTALPALLET = isset($total_pallet[$key1]['total_pallet']) ? $total_pallet[$key1]['total_pallet'] : 0;
//           $fLINE += $TOTALLINE = isset($total_line[$key1]['total_line']) ? $total_line[$key1]['total_line'] : 0;
//           $fEmp += $TOTALMANPOWER = isset($total_manpower[$key1]['manpower']) ? $total_manpower[$key1]['manpower'] : 0;
//           $TOTALTIME = isset($total_time[$key1]['total_time']) ? strtotime($total_time[$key1]['total_time']) : strtotime('00:00:00');
//           $fTime += $TOTALTIME;
// //$this->excel->getActiveSheet()->setCellValue('A' . $excelrow, date('d-m-Y', strtotime($challan['date'])));
//           $this->excel->getActiveSheet()->setCellValue('A' . $excelrow, date('d-m-Y', strtotime($challan['date'])));
//           $this->excel->getActiveSheet()->setCellValue('B' . $excelrow, locationName($challan['location']));
//           $this->excel->getActiveSheet()->setCellValue('C' . $excelrow, clientName($challan['client']));
//           $this->excel->getActiveSheet()->setCellValue('D' . $excelrow, orgName($challan['org']));
//           $this->excel->getActiveSheet()->setCellValue('E' . $excelrow, deptName($challan['dept_id']));
//           $this->excel->getActiveSheet()->setCellValue('F' . $excelrow, subDeptName($challan['sub_dept_id']));
//           $this->excel->getActiveSheet()->setCellValue('G' . $excelrow, $challan['shift']);
// //          $this->excel->getActiveSheet()->setCellValue('H' . $excelrow, empCodeById($challan['employee_id']));
//           if ($challan['emp_type'] == 'Contractual') {
//             $this->excel->getActiveSheet()->setCellValue('H' . $excelrow, $challan['co_emp_name']);
//           } else {
//             $this->excel->getActiveSheet()->setCellValue('H' . $excelrow, empNameById($challan['employee_id']) ? empNameById($challan['employee_id']) : $challan['co_emp_name']);
//           }
// //          $this->excel->getActiveSheet()->setCellValue('H' . $excelrow, empNameById($challan['employee_id']));
//           $this->excel->getActiveSheet()->setCellValue('I' . $excelrow, empCodeByEmpId($challan['employee_id']) ? empCodeByEmpId($challan['employee_id']) : ucfirst($challan['employee_code']));
//           $this->excel->getActiveSheet()->setCellValue('J' . $excelrow, $challan['banchmark']);
//           $this->excel->getActiveSheet()->setCellValue('K' . $excelrow, $challan['uom']);
//           $this->excel->getActiveSheet()->setCellValue('L' . $excelrow, $TCHALLAN);
//           $this->excel->getActiveSheet()->setCellValue('M' . $excelrow, $TOTALBOXES);
//           $this->excel->getActiveSheet()->setCellValue('N' . $excelrow, $TOTALQTY);
//           $this->excel->getActiveSheet()->setCellValue('O' . $excelrow, $TOTALSKU);
//           $this->excel->getActiveSheet()->setCellValue('P' . $excelrow, $TOTALKG);
//           $this->excel->getActiveSheet()->setCellValue('Q' . $excelrow, $TOTALCFC);
//           $this->excel->getActiveSheet()->setCellValue('R' . $excelrow, $TOTALBINS);
//           $this->excel->getActiveSheet()->setCellValue('S' . $excelrow, $TOTALPALLET);
//           $this->excel->getActiveSheet()->setCellValue('T' . $excelrow, $TOTALLINE);
//           $this->excel->getActiveSheet()->setCellValue('U' . $excelrow, $total_time[$key1]['total_time']);
//           $this->excel->getActiveSheet()->setCellValue('V' . $excelrow, ($challan[$uomKey] / 1));
//           $this->excel->getActiveSheet()->setCellValue('W' . $excelrow, abs($AchivementPer));
//           $this->excel->getActiveSheet()->setCellValue('X' . $excelrow, $challan['remark']);
//           $this->excel->getActiveSheet()->setCellValue('Y' . $excelrow, $challan['emp_type']);
//           fputcsv($output, [$team_details->shift, '', $team_details->department_name, $challan['date'], $team_details->created_by, $challan['total_challans'], $total_boxes[$key]['total_boxes'], $total_qty[$key]['total_qty'], $total_sku[$key]['total_sku'], $total_manpower[$key]['manpower']]);

//           $element = $total_time[$key1]['total_time'];
//           // Explode by seperator :
//           $temp = explode(":", $element);

//           // Convert the hours into seconds
//           // and add to total
//           $total += (int) $temp[0] * 3600;

//           // Convert the minutes to seconds
//           // and add to total
//           $total += (int) $temp[1] * 60;

//           // Add the seconds to total
//           $total += (int) $temp[2];

//           $excelrow++;
//         }
//       }

//       $this->excel->getActiveSheet()->setCellValue('K' . $excelrow, 'Total : ')->getStyle('K' . $excelrow)->getFont()->setBold(true);
//       $this->excel->getActiveSheet()->setCellValue('L' . $excelrow, $fChallan)->getStyle('L' . $excelrow)->getFont()->setBold(true);
//       $this->excel->getActiveSheet()->setCellValue('M' . $excelrow, $fBoxes)->getStyle('M' . $excelrow)->getFont()->setBold(true);
//       $this->excel->getActiveSheet()->setCellValue('N' . $excelrow, $fQty)->getStyle('N' . $excelrow)->getFont()->setBold(true);
//       $this->excel->getActiveSheet()->setCellValue('O' . $excelrow, $fSku)->getStyle('o' . $excelrow)->getFont()->setBold(true);
//       $this->excel->getActiveSheet()->setCellValue('P' . $excelrow, $fKG)->getStyle('P' . $excelrow)->getFont()->setBold(true);
//       $this->excel->getActiveSheet()->setCellValue('Q' . $excelrow, $fCFC)->getStyle('Q' . $excelrow)->getFont()->setBold(true);
//       $this->excel->getActiveSheet()->setCellValue('R' . $excelrow, $fBINS)->getStyle('R' . $excelrow)->getFont()->setBold(true);
//       $this->excel->getActiveSheet()->setCellValue('S' . $excelrow, $fPALLET)->getStyle('S' . $excelrow)->getFont()->setBold(true);
//       $this->excel->getActiveSheet()->setCellValue('T' . $excelrow, $fLINE)->getStyle('S' . $excelrow)->getFont()->setBold(true);
//       // $this->excel->getActiveSheet()->setCellValue('M' . $excelrow, date('H:i', strtotime($total)));
//       $this->excel->getActiveSheet()->setCellValue('U' . $excelrow, secToTime($total));
//     }
// //    die;
//     header('Content-Type: application/vnd.ms-excel'); //mime type
//     header('Content-Disposition: attachment;filename="' . $filename . '"'); //tell browser what's the file name
//     header('Cache-Control: max-age=0'); //no cache
//     $objWriter = PHPExcel_IOFactory::createWriter($this->excel, 'Excel5');
//     $objWriter->save('php://output');
//     exit;
//   }

}
