<?php

if (!defined('BASEPATH'))
  exit('No direct script access allowed');

require APPPATH . '/libraries/BaseController.php';

/**
 * Class : Matrix (MatrixController)
 * Matrix Class to control all user related operations.
 * @author : Vijayraj Chaudhary
 * @version : 1.1
 * @since : 30 August 2019
 */
class MatrixController extends BaseController {

  /**
   * This is default constructor of the class
   */
  public function __construct() {
    parent::__construct();
    $this->load->model('user_model');
    $this->isLoggedIn();
    date_default_timezone_set('Asia/Kolkata');
  }

  function matrix() {
    $data['organizationList'] = $this->user_model->getOrganizationList();
    $data['visitor_purpose_list'] = $this->user_model->getvisitorpurpose();
    $data['visitor_type_list'] = $this->user_model->getvisitortypelist();
    $data['meetingLocation'] = $this->user_model->getLocationList($this->organization_id, '');
    $this->global['pageTitle'] = 'Searbird : Employee Development Matrix';
    $this->loadViews("matrix_view", $this->global, $data, NULL);
  }

  function matrixListing() {
    $this->global['pageTitle'] = 'Searbird : Employee Development Matrix';
    $this->loadViews("matrixlisting_view", $this->global, $data = array(), NULL);
  }

  function visitingCard($visitorId) {

    $this->global['pageTitle'] = 'Searbird : Employee Development Matrix';


    $visitingInfo = $this->user_model->getvisitorinfo($visitorId);

    $data['visitor_type_list'] = $this->user_model->getvisitortypelist();
    $data['visitorId'] = $visitorId;
    $data['visitingInfo'] = $visitingInfo;
    $this->loadViews("matrix_card_view", $this->global, $data, NULL);
  }

  function visitorReport() {

    if ($this->input->post()) {
      $checkIndate = $this->input->post('visitor_report_start_date');
      if ($checkIndate != '') {
        $checkIndate = date('Y-m-d', strtotime($checkIndate));
      }
      $checkOutdate = $this->input->post('visitor_report_start_date');
      if ($checkOutdate != '') {
        $checkOutdate = date('Y-m-d', strtotime($checkOutdate));
      }
      $visitorType = $this->input->post('visitor_report_type');
      $visitStatus = $this->input->post('visitor_report_status');


      $this->db->select('tbl_appointment_details.*,tbl_users.name as employeename,tbl_users.userId as emp_id,tbl_visitor_organization.org_name as visitor_organization,tbl_visitor_organization.address as orgaddress,tbl_visitor_organization.city as orgcity,tbl_visitor_list.first_name as visitor_firstname,tbl_visitor_list.last_name as visitor_lastname,tbl_visitor_list.contact_no,tbl_visitor_list.id as visitor_id,CONCAT_WS(" ", tbl_visitor_list.first_name, tbl_visitor_list.last_name) AS visitorname,tbl_visitor_list.id as visitor_id,tbl_visitor_list.checkin,tbl_visitor_list.checkout,tbl_visitor_list.checkin,tbl_visitor_list.checkin_datetime,tbl_visitor_list.checkin_gate,tbl_visitor_list.checkout_gate,tbl_visitor_list.checkout_datetime,tbl_visitor_list.checkout,tbl_visitor_list.item_description,tbl_visitor_list.item_list');
      if ($this->role != 1) {
        $this->db->where('tbl_users.organization_id', $this->organization_id);
      }
      if ($checkIndate != '') {
        $this->db->where("tbl_visitor_list.checkin_datetime >= '" . $checkIndate . "'");
      }
      if ($checkOutdate != '') {
        $this->db->where("tbl_visitor_list.checkout_datetime <= '" . $checkOutdate . "'");
      }
      if ($visitorType != '') {
        $this->db->like('tbl_appointment_details.visitor_type', $visitorType);
      }

      if ($visitStatus != '') {
        if ($visitStatus == 'checkin') {
          $this->db->where('tbl_visitor_list.checkin', '1');
        } elseif ($visitStatus == 'checkout') {
          $this->db->where('tbl_visitor_list.checkout', '1');
        } elseif ($visitStatus == 'notcheckin') {
          $this->db->where('tbl_visitor_list.checkin', '0');
        } elseif ($visitStatus == 'notcheckout') {
          $this->db->where('tbl_visitor_list.checkout', '0');
        }
      }
      $this->db->from('tbl_visitor_list');
      $this->db->join('tbl_appointment_details', 'tbl_appointment_details.id=tbl_visitor_list.appointment_id');
      $this->db->join('tbl_users', 'tbl_users.userId=tbl_appointment_details.user_id');
      $this->db->join('tbl_visitor_organization', 'tbl_visitor_organization.id=tbl_appointment_details.visitor_organization');
      $this->db->where('tbl_users.isDeleted', '0');
      $this->db->order_by('tbl_appointment_details.start_date', 'DESC');
      $query = $this->db->get();
      $visitorReport = $query->result_array();
      $fileName = 'visitorreport_' . time() . '' . rand();
      header('Content-Type: text/csv; charset=utf-8');
      header('Content-Disposition: attachment; filename=' . $fileName . '.csv');
      $output = fopen('php://output', 'w');
      fputcsv($output, array('Visitor Id', 'Visitor Name', 'Organization', 'Visitor contact no', 'Checkin Datetime', 'Checkout datetime', 'Meeting with', 'Meeting location', 'Purpose', 'Belongings'));

      if (!empty($visitorReport)) {
        foreach ($visitorReport as $visitorinfo) {
          $attr = array();
          $attr[] = $visitorinfo['appointment_id'];
          $attr[] = ucfirst($visitorinfo['visitorname']);
          $attr[] = $visitorinfo['visitor_organization'];
          $attr[] = $visitorinfo['contact_no'];

          if ($visitorinfo['checkin'] == '1') {
            $attr[] = date('d-m-Y H:i:s', strtotime($visitorinfo['checkin_datetime']));
          } else {
            $attr[] = '-';
          }

          if ($visitorinfo['checkout'] == '1') {
            $attr[] = date('d-m-Y H:i:s', strtotime($visitorinfo['checkout_datetime']));
          } else {
            $attr[] = '-';
          }


          $attr[] = ucfirst($visitorinfo['employeename']);
          $attr[] = $visitorinfo['meeting_location'];
          $attr[] = $visitorinfo['purpose'];

          $belogging = json_decode($visitorinfo['item_list']);
          $belogging = implode(', ', $belogging);
          $attr[] = $belogging;
          fputcsv($output, $attr);
        }
      }
      fclose($output);
      die;
    }

    $this->global['pageTitle'] = 'Searbird : Visitor Report';
    $data['visitor_type_list'] = $this->user_model->getvisitortypelist();

    $this->loadViews("visitorreport_view", $this->global, $data, NULL);
  }

  function createAppointment() {
    // ini_set('display_errors', 1);
    $loginUserId = $this->session->userdata('userId');
    if ($this->role != 1 && $this->role != 2 && $this->role != 4 && $this->role != 5 && $this->role != 6 && $this->role != 7 && $this->role != 8) {
      $this->loadThis();
    } else {
      if ($this->input->post()) {
        $emp_id_code = $this->input->post('emp_id');
        $emp_id_code_array = explode('_', $emp_id_code);
        $empId = '';
        if (!empty($emp_id_code_array)) {
          $empId = isset($emp_id_code_array[0]) ? $emp_id_code_array[0] : '';
        }
        $visitor_type = $this->security->xss_clean($this->input->post('visitor_type'));
        $vfnamearray = $this->security->xss_clean($this->input->post('vfname'));
        $vlnamearray = $this->input->post('vlname');
        $start_date = date('Y-m-d', strtotime($this->input->post('appointmentfromdate')));
        $end_date = date('Y-m-d', strtotime($this->input->post('appointmenttodate')));
        $start_time = date('H:i:s', strtotime($this->input->post('appointmentfromhr')));
        $end_time = date('H:i:s', strtotime($this->input->post('appointmenttohr')));
        $warehouseId = $this->input->post('organization_id');
        $visit_purpose = $this->security->xss_clean($this->input->post('visit_purpose'));
        $visitor_organization = $this->security->xss_clean($this->input->post('visitor_organization'));
        $visitor_detail = $this->security->xss_clean($this->input->post('visitor_detail'));
        $visitor_category = $this->security->xss_clean($this->input->post('visitor_category'));
        $visiting_place = $this->security->xss_clean($this->input->post('visiting_place'));
        $meeting_location = $this->security->xss_clean($this->input->post('meeting_location'));
        $visitor_contact_no = $this->security->xss_clean($this->input->post('visitor_contact_no'));
        $remark = $this->security->xss_clean($this->input->post('remark'));

        $appointmentAttribute = array(
            'appointment_id' => '',
            'user_id' => $empId,
            'created_by' => $loginUserId,
            'start_date' => $start_date,
            'end_date' => $end_date,
            'start_time' => $start_time,
            'end_time' => $end_time,
            'warehouse_id' => $warehouseId,
            'purpose' => $visit_purpose,
            'visitor_organization' => $visitor_organization,
            'visit_detail' => $visitor_detail,
            'visitor_type' => $visitor_type,
            'visitor_category' => $visitor_category,
            'visiting_place' => $visiting_place,
            'meeting_location' => $meeting_location,
            'visitor_contact_no' => $visitor_contact_no,
            'remark' => $remark,
            'created_at' => date('Y-m-d H:i:s')
        );
        $appointmentId = $this->user_model->insertRecord('tbl_appointment_details', $appointmentAttribute);
        $visitorList = array();
        $visitorId = '';
        if ($appointmentId) {
          $visitorId = '' . sprintf("%'.07d\n", $appointmentId);
          $this->db->where('id', $appointmentId);
          $this->db->update('tbl_appointment_details', ['appointment_id' => $visitorId]);
          if ($empId) {
            $notificationAttribute = array('title' => 'Appoinment ' . $visitorId . ' created for you', 'type' => 'newappointment', 'user_id' => $empId, 'message' => '', 'object_id' => $appointmentId);
            $this->db->insert('tbl_notification', $notificationAttribute);
          }
          if (!empty($vfnamearray)) {
            foreach ($vfnamearray as $key => $vfirstName) {

              $lastName = isset($vlnamearray[$key]) ? $vlnamearray[$key] : '';
              $this->user_model->insertRecord('tbl_visitor_list', ['appointment_id' => $appointmentId, 'first_name' => $vfirstName, 'last_name' => $lastName, 'created_at' => date('Y-m-d H:i:s')]);
              $visitorList[] = $vfirstName . ' ' . $lastName;
            }
          }
        }


        /* ===========Send mail to create appointement ============ */
        $EmployeeInfo = $this->user_model->getUserInfoById($empId);

        $mailAttribute = array();
        $mailAttribute['email'] = isset($EmployeeInfo->email) ? strtolower($EmployeeInfo->email) : '';
        $mailAttribute['name'] = isset($EmployeeInfo->name) ? $EmployeeInfo->name : '';
        $mailAttribute['appointmentno'] = $visitorId;
        $mailAttribute['date'] = date('d-m-Y', strtotime($start_date));
        $mailAttribute['time'] = $start_time;
        $mailAttribute['visitorList'] = $visitorList;
        $sendStatus = createAppointmentEmail($mailAttribute);

        $loginUserInfo = $this->user_model->getUserInfoById($loginUserId);
        if (!empty($loginUserInfo)) {
          $mailAttribute = array();
          $mailAttribute['email'] = isset($loginUserInfo->email) ? strtolower($loginUserInfo->email) : '';
          $mailAttribute['name'] = isset($loginUserInfo->name) ? $loginUserInfo->name : '';
          $mailAttribute['appointmentno'] = $visitorId;
          $mailAttribute['date'] = date('d-m-Y', strtotime($start_date));
          $mailAttribute['time'] = $start_time;
          $mailAttribute['visitorList'] = $visitorList;
          $sendStatus = createAppointmentConfirmEmail($mailAttribute);
        }


        $notificationattributr = array();
        $notificationattributr['title'] = "Appoinment(" . $visitorId . ") has been created";
        $notificationattributr['type'] = "newappointment";
        $notificationattributr['user_id'] = $empId;
        $notificationattributr['message'] = '';
        $this->db->insert('tbl_notification', $notificationattributr);

        $this->session->set_flashdata('success', 'The appointment id has been created successfully. The appointment id is ' . $visitorId . '.');
        redirect(site_url('create-appointment'));
      }

      $data['visitor_purpose_list'] = $this->user_model->getvisitorpurpose();
      $data['visitor_type_list'] = $this->user_model->getvisitortypelist();
      $orgId = '';
      if ($this->role == '8' || $this->role == '4' || $this->role == '5' || $this->role == '6' || $this->role == '7' || $this->role == '2') {
        $orgId = $this->organization_id;
      }

      $data['organizationList'] = $this->user_model->getOrganizationList($orgId);


      $data['meetingLocation'] = $this->user_model->getLocationList($this->organization_id, '');

      $this->global['pageTitle'] = 'Searbird : Create appointment';
      $this->loadViews("createappointment_view", $this->global, $data, NULL);
    }
  }

  function getvisitorreport() {
    if (!$this->input->is_ajax_request()) {
      exit('No direct script access allowed');
    }
    $draw = intval($this->input->post("draw"));
    $start = intval($this->input->post("start"));
    $length = intval($this->input->post("length"));
    $search = $this->input->post('search[value]');
    $startDate = $this->input->post('startDate');
    $visitStatus = $this->input->post('visitStatus');

    if ($startDate != '') {
      $startDate = date('Y-m-d', strtotime($startDate));
    }
    $enddate = $this->input->post('enddate');
    if ($enddate != '') {
      $enddate = date('Y-m-d', strtotime($enddate));
    }
    $visitorType = $this->input->post('visitorType');


    $this->db->select('tbl_appointment_details.*,tbl_users.name as employeename,tbl_visitor_organization.org_name as visitor_organization,tbl_visitor_list.first_name as visitor_firstname,tbl_visitor_list.last_name as visitor_lastname,CONCAT_WS(" ", tbl_visitor_list.first_name, tbl_visitor_list.last_name) AS visitorname,tbl_visitor_list.id as visitor_id');
    if ($this->role != 1) {
      $this->db->where('tbl_users.organization_id', $this->organization_id);
    }
    if ($startDate != '') {
      $this->db->where("tbl_visitor_list.checkin_datetime >= '" . $startDate . "'");
    }
    if ($enddate != '') {
      $this->db->where("tbl_visitor_list.checkout_datetime <= '" . $enddate . "'");
    }
    if ($visitorType != '') {
      $this->db->like('tbl_appointment_details.visitor_type', $visitorType);
    }

    if ($visitStatus != '') {
      if ($visitStatus == 'checkin') {
        $this->db->where('tbl_visitor_list.checkin', '1');
      } elseif ($visitStatus == 'checkout') {
        $this->db->where('tbl_visitor_list.checkout', '1');
      } elseif ($visitStatus == 'notcheckin') {
        $this->db->where('tbl_visitor_list.checkin', '0');
      } elseif ($visitStatus == 'notcheckout') {
        $this->db->where('tbl_visitor_list.checkout', '0');
      }
    }

    $this->db->from('tbl_visitor_list');
    $this->db->join('tbl_appointment_details', 'tbl_appointment_details.id=tbl_visitor_list.appointment_id');
    $this->db->join('tbl_users', 'tbl_users.userId=tbl_appointment_details.user_id');
    $this->db->join('tbl_visitor_organization', 'tbl_visitor_organization.id=tbl_appointment_details.visitor_organization');
    $this->db->order_by('tbl_appointment_details.start_date', 'DESC');
    $this->db->where('tbl_users.isDeleted', '0');
    $totalrows = $this->db->get()->num_rows();



    $this->db->select('tbl_appointment_details.*,tbl_users.name as employeename,tbl_users.userId as emp_id,tbl_visitor_organization.org_name as visitor_organization,tbl_visitor_organization.address as orgaddress,tbl_visitor_organization.city as orgcity,tbl_visitor_list.first_name as visitor_firstname,tbl_visitor_list.last_name as visitor_lastname,tbl_visitor_list.contact_no,tbl_visitor_list.id as visitor_id,CONCAT_WS(" ", tbl_visitor_list.first_name, tbl_visitor_list.last_name) AS visitorname,tbl_visitor_list.id as visitor_id,tbl_visitor_list.checkin,tbl_visitor_list.checkout,tbl_visitor_list.checkin,tbl_visitor_list.checkin_datetime,tbl_visitor_list.checkin_gate,tbl_visitor_list.checkout_gate,tbl_visitor_list.checkout_datetime,tbl_visitor_list.checkout,tbl_visitor_list.item_description,tbl_visitor_list.item_list');

    if ($this->role != 1) {
      $this->db->where('tbl_users.organization_id', $this->organization_id);
    }
    if ($startDate != '') {
      $this->db->where("tbl_visitor_list.checkin_datetime >= '" . $startDate . "'");
    }
    if ($enddate != '') {
      $this->db->where("tbl_visitor_list.checkout_datetime <= '" . $enddate . "'");
    }
    if ($visitorType != '') {
      $this->db->like('tbl_appointment_details.visitor_type', $visitorType);
    }

    if ($visitStatus != '') {
      if ($visitStatus == 'checkin') {
        $this->db->where('tbl_visitor_list.checkin', '1');
      } elseif ($visitStatus == 'checkout') {
        $this->db->where('tbl_visitor_list.checkout', '1');
      } elseif ($visitStatus == 'notcheckin') {
        $this->db->where('tbl_visitor_list.checkin', '0');
      } elseif ($visitStatus == 'notcheckout') {
        $this->db->where('tbl_visitor_list.checkout', '0');
      }
    }

    $this->db->from('tbl_visitor_list');
    $this->db->join('tbl_appointment_details', 'tbl_appointment_details.id=tbl_visitor_list.appointment_id');
    $this->db->join('tbl_users', 'tbl_users.userId=tbl_appointment_details.user_id');
    $this->db->join('tbl_visitor_organization', 'tbl_visitor_organization.id=tbl_appointment_details.visitor_organization');
    $this->db->where('tbl_users.isDeleted', '0');
    $this->db->order_by('tbl_appointment_details.start_date', 'DESC');
    $this->db->limit($length, $start);
    $query = $this->db->get();

    $filterrecord = $query->num_rows();

    $results = $query->result_array();

    $data = array();
    if (!empty($results)) {
      foreach ($results as $key => $visitorinfo) {
        $attr = array();
        $attr[] = $visitorinfo['appointment_id'];
        $attr[] = ucfirst($visitorinfo['visitorname']);
        $attr[] = $visitorinfo['visitor_organization'];
        $attr[] = $visitorinfo['contact_no'];

        if ($visitorinfo['checkin'] == '1') {
          $attr[] = date('d-m-Y H:i:s', strtotime($visitorinfo['checkin_datetime']));
        } else {
          $attr[] = '-';
        }

        if ($visitorinfo['checkout'] == '1') {
          $attr[] = date('d-m-Y H:i:s', strtotime($visitorinfo['checkout_datetime']));
        } else {
          $attr[] = '-';
        }


        $attr[] = ucfirst($visitorinfo['employeename']);
        $attr[] = $visitorinfo['meeting_location'];
        $attr[] = $visitorinfo['purpose'];

        $belogging = json_decode($visitorinfo['item_list']);
        $belogging = implode(', ', $belogging);
        $attr[] = $belogging;
        $data[] = $attr;
      }
    }
    $output = array(
        "draw" => $draw,
        "recordsTotal" => $totalrows,
        "recordsFiltered" => $totalrows,
        "data" => $data
    );
    echo json_encode($output);
    exit();
  }

  function getCheckoutList() {
    if (!$this->input->is_ajax_request()) {
      exit('No direct script access allowed');
    }
    $draw = intval($this->input->post("draw"));
    $start = intval($this->input->post("start"));
    $length = intval($this->input->post("length"));
    $search = $this->input->post('search[value]');
    $checkoutgate = $this->input->post('checkoutgate');
    $appointment = $this->input->post('appointment');

    $this->db->select('tbl_appointment_details.*,tbl_users.name as employeename,tbl_visitor_organization.org_name as visitor_organization,tbl_visitor_list.contact_no,tbl_visitor_list.first_name as visitor_firstname,tbl_visitor_list.last_name as visitor_lastname,CONCAT_WS(" ", tbl_visitor_list.first_name, tbl_visitor_list.last_name) AS visitorname,tbl_visitor_list.id as visitor_id');
    if ($this->role != 1) {
      $this->db->where('tbl_users.organization_id', $this->organization_id);
    }
    if ($checkoutgate != '') {
      $this->db->where('tbl_visitor_list.checkout_gate', $checkoutgate);
    }
    if ($appointment != '') {
      $this->db->like('tbl_appointment_details.appointment_id', $appointment);
    }
    $this->db->from('tbl_visitor_list');
    $this->db->join('tbl_appointment_details', 'tbl_appointment_details.id=tbl_visitor_list.appointment_id');
    $this->db->join('tbl_users', 'tbl_users.userId=tbl_appointment_details.user_id');
    $this->db->join('tbl_visitor_organization', 'tbl_visitor_organization.id=tbl_appointment_details.visitor_organization');
    $this->db->order_by('tbl_appointment_details.start_date', 'DESC');
    $this->db->where('tbl_users.isDeleted', '0');
    $this->db->where('tbl_visitor_list.checkin', '1');
    $totalrows = $this->db->get()->num_rows();

    $this->db->select('tbl_appointment_details.*,tbl_users.name as employeename,tbl_users.userId as emp_id,tbl_visitor_organization.org_name as visitor_organization,tbl_visitor_organization.address as orgaddress,tbl_visitor_organization.city as orgcity,tbl_visitor_list.first_name as visitor_firstname,tbl_visitor_list.last_name as visitor_lastname,tbl_visitor_list.id as visitor_id,CONCAT_WS(" ", tbl_visitor_list.first_name, tbl_visitor_list.last_name) AS visitorname,tbl_visitor_list.id as visitor_id,tbl_visitor_list.checkin,tbl_visitor_list.checkout,tbl_visitor_list.checkin_datetime,tbl_visitor_list.checkin_gate,tbl_visitor_list.checkout_gate,tbl_visitor_list.checkout_datetime,tbl_visitor_list.item_description,tbl_visitor_list.item_list');
    if ($this->role != 1) {
      $this->db->where('tbl_users.organization_id', $this->organization_id);
    }
    if ($checkoutgate != '') {
      $this->db->where('tbl_visitor_list.checkout_gate', $checkoutgate);
    }
    if ($appointment != '') {
      $this->db->like('tbl_appointment_details.appointment_id', $appointment);
    }
    $this->db->from('tbl_visitor_list');
    $this->db->join('tbl_appointment_details', 'tbl_appointment_details.id=tbl_visitor_list.appointment_id');
    //$this->db->from('tbl_appointment_details');
    $this->db->join('tbl_users', 'tbl_users.userId=tbl_appointment_details.user_id');
    $this->db->join('tbl_visitor_organization', 'tbl_visitor_organization.id=tbl_appointment_details.visitor_organization');
    $this->db->where('tbl_users.isDeleted', '0');
    $this->db->where('tbl_visitor_list.checkin', '1');
    $this->db->order_by('tbl_appointment_details.start_date', 'DESC');
    $this->db->limit($length, $start);
    $query = $this->db->get();

    $filterrecord = $query->num_rows();

    $results = $query->result_array();

    $data = array();
    if (!empty($results)) {
      foreach ($results as $key => $visitorinfo) {
        $attr = array();


        if ($visitorinfo['checkout'] == '0') {
          $attr[] = '<a href="javascript:void(0)" class="btn btn-primary pull-right" data-appointmentid="' . $visitorinfo['appointment_id'] . '" data-visitorname="' . ucfirst($visitorinfo['visitorname']) . '" data-organizationName="' . ucfirst($visitorinfo['visitor_organization']) . '" data-visitortype="' . $visitorinfo['visitor_category'] . '" data-orgaddress="' . $visitorinfo['orgaddress'] . '" data-contactnumber="' . $visitorinfo['visitor_contact_no'] . '" data-employeename="' . ucfirst($visitorinfo['employeename']) . '" data-emp_id="' . $visitorinfo['emp_id'] . '" data-visitingpurpose="' . $visitorinfo['purpose'] . '" data-meetinglocation="' . $visitorinfo['meeting_location'] . '" type="button" onclick="checkoutvisitor(\'' . $visitorinfo['visitor_id'] . '\',this)">Checkout</a>';
        } else {
          $attr[] = '<i class="fa fa-check" aria-hidden="true"></i>';
        }


        $attr[] = $visitorinfo['appointment_id'];
        $attr[] = ucfirst($visitorinfo['visitorname']);
        $attr[] = $visitorinfo['visitor_organization'];
        $attr[] = $visitorinfo['contact_no'];
        $attr[] = date('d-m-Y H:i:s', strtotime($visitorinfo['checkin_datetime']));
        $attr[] = ucfirst($visitorinfo['employeename']);
        $attr[] = $visitorinfo['meeting_location'];
        $attr[] = $visitorinfo['purpose'];

        $belogging = json_decode($visitorinfo['item_list']);
        $belogging = implode(', ', $belogging);
        $attr[] = $belogging;
        $data[] = $attr;
      }
    }
    $output = array(
        "draw" => $draw,
        "recordsTotal" => $totalrows,
        //"recordsFiltered" => $filterrecord,
        "recordsFiltered" => $totalrows,
        "data" => $data
    );
    echo json_encode($output);
    exit();
  }

  function checkoutrequest() {
    $visitoID = $this->input->post('visitoID');
    $checkoutgate = $this->input->post('checkoutgate');

    $this->db->where('id', $visitoID);
    $this->db->update('tbl_visitor_list', ['checkout' => '1', 'checkout_gate' => $checkoutgate, 'checkout_datetime' => date('Y-m-d H:i:s')]);
    echo json_encode('updated');
  }

  function getPreRegisterVisit() {

    if (!$this->input->is_ajax_request()) {
      exit('No direct script access allowed');
    }

    $draw = intval($this->input->post("draw"));
    $start = intval($this->input->post("start"));
    $length = intval($this->input->post("length"));
    $search = $this->input->post('search[value]');

    $visit_date = $this->input->post('visit_date');
    if ($visit_date != '') {
      $visit_date = date('Y-m-d', strtotime($visit_date));
    }

    $visitor_organization_id = $this->input->post('visitor_organization_id');

    $searchtype = $this->input->post('searchtype');
    $visitor_type = $this->input->post('visitor_type');
    $search_term = $this->input->post('search_term');



    /* ============Get total count=================== */
    $this->db->select('tbl_appointment_details.*,tbl_users.name as employeename,tbl_visitor_organization.org_name as visitor_organization,tbl_visitor_list.first_name as visitor_firstname,tbl_visitor_list.last_name as visitor_lastname,CONCAT_WS(" ", tbl_visitor_list.first_name, tbl_visitor_list.last_name) AS visitorname,tbl_visitor_list.id as visitor_id,tbl_visitor_list.contact_no');

    if ($visit_date != '') {
      $this->db->where('tbl_appointment_details.start_date', $visit_date);
    }

    if ($visitor_organization_id != '') {
      $this->db->where('tbl_appointment_details.visitor_organization', $visitor_organization_id);
    }
    if ($visitor_type != '') {

      $this->db->where("tbl_appointment_details.visitor_category LIKE '" . $visitor_type . "'");
    }

    if ($searchtype != '' && $search_term != '') {
      if ($searchtype == 'visitonname') {
        $this->db->where("`tbl_visitor_list`.`first_name` LIKE '%" . $search_term . "%'");
      } elseif ($searchtype == 'appointmentid') {
        $this->db->like("tbl_appointment_details`.`appointment_id`", $search_term);
      } elseif ($searchtype == 'employeename') {
        $this->db->like("`tbl_users`.`name`", $search_term);
      }
    }


    if ($this->role != '1') {

      $this->db->where('tbl_users.organization_id', $this->organization_id);
    }
    $this->db->from('tbl_visitor_list');
    $this->db->join('tbl_appointment_details', 'tbl_appointment_details.id=tbl_visitor_list.appointment_id');
    $this->db->join('tbl_users', 'tbl_users.userId=tbl_appointment_details.user_id');
    $this->db->join('tbl_visitor_organization', 'tbl_visitor_organization.id=tbl_appointment_details.visitor_organization');
    $this->db->order_by('tbl_appointment_details.start_date', 'DESC');
    $this->db->where('tbl_users.isDeleted', '0');
    $this->db->where('tbl_visitor_list.checkout', '0');
    $totalrows = $this->db->get()->num_rows();




    /* ==============Get record =================== */

    $this->db->select('tbl_appointment_details.*,tbl_users.name as employeename,tbl_users.userId as emp_id,tbl_users.organization_id as organization_id,tbl_visitor_organization.org_name as visitor_organization,tbl_visitor_organization.address as orgaddress,tbl_visitor_organization.city as orgcity,tbl_visitor_list.first_name as visitor_firstname,tbl_visitor_list.contact_no,tbl_visitor_list.last_name as visitor_lastname,tbl_visitor_list.id as visitor_id,CONCAT_WS(" ", tbl_visitor_list.first_name, tbl_visitor_list.last_name) AS visitorname,tbl_visitor_list.id as visitor_id,tbl_visitor_list.checkin,tbl_visitor_list.checkout');

    if ($visit_date != '') {
      $this->db->where('tbl_appointment_details.start_date', $visit_date);
    }
    if ($visitor_organization_id != '') {
      $this->db->where('tbl_appointment_details.visitor_organization', $visitor_organization_id);
    }
    if ($visitor_type != '') {
      $this->db->where("tbl_appointment_details.visitor_category LIKE '" . $visitor_type . "'");
    }
    if ($searchtype != '' && $search_term != '') {
      if ($searchtype == 'visitonname') {
        $this->db->where("`tbl_visitor_list`.`first_name` LIKE '%" . $search_term . "%'");
      } elseif ($searchtype == 'appointmentid') {
        $this->db->like("tbl_appointment_details`.`appointment_id`", $search_term);
      } elseif ($searchtype == 'employeename') {
        $this->db->like("`tbl_users`.`name`", $search_term);
      }
    }
    if ($this->role != '1') {
      $this->db->where('tbl_users.organization_id', $this->organization_id);
    }
    $this->db->from('tbl_visitor_list');
    $this->db->join('tbl_appointment_details', 'tbl_appointment_details.id=tbl_visitor_list.appointment_id');
    //$this->db->from('tbl_appointment_details');
    $this->db->join('tbl_users', 'tbl_users.userId=tbl_appointment_details.user_id');
    $this->db->join('tbl_visitor_organization', 'tbl_visitor_organization.id=tbl_appointment_details.visitor_organization');
    $this->db->where('tbl_users.isDeleted', '0');
    $this->db->where('tbl_visitor_list.checkout', '0');
    $this->db->order_by('tbl_appointment_details.start_date', 'DESC');
    $this->db->limit($length, $start);
    $query = $this->db->get();

    $filterrecord = $query->num_rows();

    $results = $query->result_array();

    $data = array();
    if (!empty($results)) {
      foreach ($results as $key => $visitorinfo) {
        $attr = array();


        if ($visitorinfo['checkin'] == '0') {
          if (date('Y-m-d') == $visitorinfo['start_date']) {
            $attr[] = '<a href="javascript:void(0)" data-appointmentid="' . $visitorinfo['appointment_id'] . '" data-visitorname="' . ucfirst($visitorinfo['visitorname']) . '" data-organizationName="' . ucfirst($visitorinfo['visitor_organization']) . '" data-visitortype="' . $visitorinfo['visitor_category'] . '" data-orgaddress="' . $visitorinfo['orgaddress'] . '" data-contactnumber="' . $visitorinfo['visitor_contact_no'] . '" data-employeename="' . ucfirst($visitorinfo['employeename']) . '" data-emp_id="' . $visitorinfo['emp_id'] . '" data-visitingpurpose="' . $visitorinfo['purpose'] . '" data-meetinglocation="' . $visitorinfo['meeting_location'] . '" data-organizationid="' . $visitorinfo['organization_id'] . '" type="button" onclick="showEntryPopUpModel(\'' . $visitorinfo['visitor_id'] . '\',this)">Pass</a>';
          } else {
            $attr[] = '<a href="javascript:void(0)" data-appointmentid="' . $visitorinfo['appointment_id'] . '" data-visitorname="' . ucfirst($visitorinfo['visitorname']) . '" data-organizationName="' . ucfirst($visitorinfo['visitor_organization']) . '" data-visitortype="' . $visitorinfo['visitor_category'] . '" data-orgaddress="' . $visitorinfo['orgaddress'] . '" data-contactnumber="' . $visitorinfo['visitor_contact_no'] . '" data-employeename="' . ucfirst($visitorinfo['employeename']) . '" data-emp_id="' . $visitorinfo['emp_id'] . '" data-visitingpurpose="' . $visitorinfo['purpose'] . '" data-meetinglocation="' . $visitorinfo['meeting_location'] . '" data-organizationid="' . $visitorinfo['organization_id'] . '" type="button" onclick="confirm(\'Invalid request\')">Pass</a>';
          }
        } else {
          $attr[] = '<i class="fa fa-check" aria-hidden="true"></i>';
        }
        $attr[] = $visitorinfo['appointment_id'];
        $attr[] = ucfirst($visitorinfo['visitorname']);
        $attr[] = $visitorinfo['visitor_organization'];
        $attr[] = $visitorinfo['contact_no'];
        $attr[] = ucfirst($visitorinfo['employeename']);
        $attr[] = $visitorinfo['meeting_location'];
        $attr[] = date('d-m-Y', strtotime($visitorinfo['start_date']));
        $attr[] = date('d-m-Y', strtotime($visitorinfo['end_date']));
        if ($visitorinfo['checkin'] == '1') {
          $attr[] = '<a target="_blank" href="' . site_url('visitingcard/' . $visitorinfo['visitor_id']) . '" class="btn btn-primary pull-right">Gate Pass</a>';
        } else {
          $attr[] = '';
        }
        $data[] = $attr;
      }
    }
    $output = array(
        "draw" => $draw,
        "recordsTotal" => $totalrows,
        "recordsFiltered" => $totalrows,
        "data" => $data
    );
    echo json_encode($output);
    exit();
  }

  function checkinvisitor() {
    if (!$this->input->is_ajax_request()) {
      exit('No direct script access allowed');
    }
    $employeeId = $this->input->post('emp_id');
    $visitorId = $this->input->post('visitorId');
    $appointmentid = $this->input->post('passappointmentid');
    $visitorNumber = $this->input->post('passcontactnumber');
    $empAccessCardNumber = $this->input->post('passaccesscardnumber');
    $imageType = $this->input->post('imageType');
    $visitorUrl = $this->input->post('visitorurl');
    $visitoridurl = $this->input->post('visitoridurl');
    $empContactnumber = $this->input->post('empContactnumber');
    $employeeExt = $this->input->post('passempext');
    $visitorIntimation = $this->input->post('visitorintimation');
    $checkinGate = $this->input->post('passcheckingate');
    $passmeetinglocation = $this->input->post('passmeetinglocation');
    $Items = $this->input->post('passitems');
    $itemDescription = $this->input->post('passitemdescription');
    if ($employeeId) {
      $this->db->where('userId', $employeeId);
      $this->db->update('tbl_users', ['ext_no' => $employeeExt]);
    }
    if ($visitorId) {
      $this->db->where('id', $visitorId);
      $this->db->update('tbl_visitor_list', ['visitor_image' => $visitorUrl, 'visitorid_image' => $visitoridurl, 'contact_no' => $visitorNumber, 'access_no' => $empAccessCardNumber,
          'checkin_gate' => $checkinGate, 'checkin' => '1', 'checkin_datetime' => date('Y-m-d H:i:s'), 'item_list' => json_encode($Items), 'item_description' => json_encode($itemDescription)
      ]);
    }
    if ($appointmentid) {
      $this->db->where('appointment_id', $appointmentid);
      $this->db->update('tbl_appointment_details', ['meeting_location' => $passmeetinglocation]);
    }

    /*     * *******Send email to employee************* */


    $this->db->select('first_name,last_name,contact_no,appointment_id');
    $this->db->where('id', $visitorId);
    $visitorInfo = $this->db->get('tbl_visitor_list')->row_array();
    $appointmentId = isset($visitorInfo['appointment_id']) ? $visitorInfo['appointment_id'] : '';
    $visitorNumber = '' . sprintf("%'.07d\n", $appointmentId);
    $visitorName = ucfirst($visitorInfo['first_name']) . ' ' . $visitorInfo['last_name'];

    $EmployeeInfo = $this->user_model->getUserInfoById($employeeId);
    if (!empty($EmployeeInfo)) {
      $mailAttribute = array();
      $mailAttribute['email'] = isset($EmployeeInfo->email) ? strtolower($EmployeeInfo->email) : '';
      $mailAttribute['name'] = isset($EmployeeInfo->name) ? $EmployeeInfo->name : '';
      $mailAttribute['visitorName'] = $visitorName;
      $mailAttribute['visitorId'] = $visitorNumber;
      $sendStatus = sendcheckInEmail($mailAttribute);
    }

    echo json_encode('SUCCESS');
    exit;
  }

  function getvisitorinformation() {
    if (!$this->input->is_ajax_request()) {
      exit('No direct script access allowed');
    }
    $result = array();
    $startdate = $this->input->post('visitor_report_start_date');
    if ($startdate != '') {
      $startdate = date('Y-m-d', strtotime($startdate));
    }
    /*     * ****==========Start get total visitor list==============********* */
    $this->db->from('tbl_visitor_list');
    if ($this->role != 1) {
      $this->db->where('tbl_users.organization_id', $this->organization_id);
    }
    $this->db->join('tbl_appointment_details', 'tbl_appointment_details.id=tbl_visitor_list.appointment_id');
    $this->db->join('tbl_users', 'tbl_users.userId=tbl_appointment_details.user_id');
    $this->db->where('tbl_appointment_details.start_date >=', $startdate);
    $this->db->where('tbl_appointment_details.start_date <=', $startdate);
    $totalVisitor = $this->db->get()->num_rows();
    /*     * **============End get total visitor list==============**** */


    /*     * ****==========Start get total checkin visitor list==============********* */
    $this->db->from('tbl_visitor_list');
    if ($this->role != 1) {
      $this->db->where('tbl_users.organization_id', $this->organization_id);
    }
    $this->db->join('tbl_appointment_details', 'tbl_appointment_details.id=tbl_visitor_list.appointment_id');
    $this->db->join('tbl_users', 'tbl_users.userId=tbl_appointment_details.user_id');
    $this->db->where('tbl_visitor_list.checkin', '1');
    $this->db->like('tbl_visitor_list.checkin_datetime', $startdate);
    $checkinVisitor = $this->db->get()->num_rows();
    /*     * **============End get total checkin visitor list==============**** */

    /*     * ****==========Start get total checkout visitor list==============********* */
    $this->db->from('tbl_visitor_list');
    if ($this->role != 1) {
      $this->db->where('tbl_users.organization_id', $this->organization_id);
    }
    $this->db->join('tbl_appointment_details', 'tbl_appointment_details.id=tbl_visitor_list.appointment_id');
    $this->db->join('tbl_users', 'tbl_users.userId=tbl_appointment_details.user_id');
    $this->db->where('tbl_visitor_list.checkout', '1');
    $this->db->like('tbl_visitor_list.checkout_datetime', $startdate);
    $checkoutVisitor = $this->db->get()->num_rows();
    /*     * **============End get total checkout visitor list==============**** */


    $result['totalVisitor'] = $totalVisitor;
    $result['checkinvisitor'] = $checkinVisitor;
    $result['checkoutvisitor'] = $checkoutVisitor;

    echo json_encode($result);
  }

  function uploadwebcamimage() {

    /* $img = $_POST['image'];

      $folderPath = BASE_PATH.'/assets/images/avatar/';

      $image_parts = explode(";base64,", $img);

      $image_type_aux = explode("image/", $image_parts[0]);

      $image_type = $image_type_aux[1];

      $image_base64 = base64_decode($image_parts[1]);

      $fileName = uniqid() . '.png';

      $file = $folderPath . $fileName;

      file_put_contents($file, $image_base64);

      print_r($fileName); */



    if ($_FILES["webcam"]["size"] > 0) {

      $config['upload_path'] = BASE_PATH . '/assets/images/visitors/';
      $config['allowed_types'] = 'gif|jpg|png';
      //$config['max_width']            = 1024;
      //$config['max_height']           = 768;
      $config['encrypt_name'] = TRUE;
      $this->load->library('upload', $config);
      if ($this->upload->do_upload('webcam')) {
        $webcamInfo = $this->upload->data();
        $webcamImg = $webcamInfo['file_name'];
        echo site_url('assets/images/visitors/' . $webcamImg);
      } else {
        echo $config['upload_path'];
        echo $this->upload->display_errors();
        die;
      }
    }
  }

  function visitorCheckout() {
    $this->global['pageTitle'] = 'Searbird : Visitor Checkout';
    $this->loadViews("visitorcheckout_view", $this->global, $data = array(), NULL);
  }

  function getappointmentemployee() {

    if (!$this->input->is_ajax_request()) {
      exit('No direct script access allowed');
    }


    $search = $this->input->post('search');
    $terms = $this->input->post('term[term]');
    $orgId = $this->session->userdata('organization_id');
    $userId = $this->session->userdata('userId');

    if ($this->role != '1') {
      $this->db->where('organization_id', $orgId);
    }

    //$this->db->where_not_in('userId',['1',$userId]);
    $this->db->where('isDeleted', '0');
    $this->db->where("(name like '%" . $terms . "%' OR emp_id like '%" . $terms . "%')");
    /* $this->db->like('name',$search);
      $this->db->or_like('emp_id',$search); */


    $result = $this->db->get('tbl_users')->result_array();

    //echo $this->db->last_query(); die;
    $response = array();
    if (!empty($result)) {
      foreach ($result as $row) {
        $response[] = array("id" => $row['userId'] . '_' . $row['emp_id'] . '_' . $row['name'], "text" => $row['name'] . ' (#' . $row['emp_id'] . ')');
      }
    }
    echo json_encode($response);
    exit;
  }

  function getvisitorganization() {

    if (!$this->input->is_ajax_request()) {
      exit('No direct script access allowed');
    }
    $term = $this->input->post('term')['term'];

    //$this->db->where("org_name LIKE '".$vorganization_name."'");
    $this->db->select('id,org_name as text,org_name as slug');
    $this->db->like('org_name', $term);
    $oranizationlist = $this->db->get('tbl_visitor_organization')->result_array();
    //echo $this->db->last_query();die;
    echo json_encode($oranizationlist);
  }

  function addvisitororganization() {
    if (!$this->input->is_ajax_request()) {
      exit('No direct script access allowed');
    }
    $vorganization_name = $this->security->xss_clean($this->input->post('vorganization_name'));
    $vcontact_name = $this->security->xss_clean($this->input->post('vcontact_name'));
    $vaddress = $this->security->xss_clean($this->input->post('vaddress'));
    $vcity = $this->security->xss_clean($this->input->post('vcity'));
    $vstate = $this->security->xss_clean($this->input->post('vstate'));
    $vcountry = $this->security->xss_clean($this->input->post('vcountry'));
    $vlandline = $this->security->xss_clean($this->input->post('vlandline'));
    $vmobilenumber = $this->security->xss_clean($this->input->post('vmobilenumber'));

    $this->db->where("org_name LIKE '" . $vorganization_name . "'");
    $chkoranization = $this->db->get('tbl_visitor_organization')->num_rows();

    if ($chkoranization) {
      echo json_encode('EXIST');
    } else {
      $this->db->insert('tbl_visitor_organization', ['org_name' => $vorganization_name, 'contact_person' => $vcontact_name, 'address' => $vaddress,
          'city' => $vcity, 'state' => state, 'country' => $vcountry, 'landline' => $vlandline, 'mobile' => $vmobilenumber
      ]);
      echo json_encode('SUCCESS');
    }
  }

}
