<?php

if (!defined('BASEPATH'))
  exit('No direct script access allowed');

require APPPATH . '/libraries/BaseController.php';

/**
 * Class : Visitor (VisitorController)
 * Visitor Class to control all user related operations.
 * @author : Vijayraj Chaudhary
 * @version : 2.1
 * @since : 30 August 2019
 */
class ManpowerController extends BaseController {

  /**
   * This is default constructor of the class
   */
  public function __construct() {
    parent::__construct();
    $this->load->model('user_model');
    $this->isLoggedIn();
    date_default_timezone_set('Asia/Kolkata');
  }

  public function index() {
    $this->global['pageTitle'] = 'Searbird : Manpower';
    $this->loadViews("manpower_view", $this->global, $data, NULL);
  }

  function manpowerReport() {
    $this->global['pageTitle'] = 'Searbird : Manpower Report';
    $this->loadViews("manpower_report_view", $this->global, $data, NULL);
  }

  function list_teams() {

    $data['all_teams'] = $this->db->query('SELECT MT.id AS id, (SELECT COUNT(id) FROM tbl_manpower_team_performance WHERE team_id=MT.id) AS performance_already_exists, MT.date AS date, (SELECT dept_name FROM tbl_departments WHERE dept_id=MT.department_id) AS department_name, MT.shift FROM tbl_manpower_team AS MT')->result();

    $this->global['pageTitle'] = 'Searbird : Manpower Teams List';
    $this->loadViews("manpower_teams_list", $this->global, $data, NULL);
  }

  function fetch_employees_from_team_id_post() {

    $all_employees = $this->db->query('SELECT name FROM tbl_users WHERE userId IN (SELECT employee_id FROM tbl_manpower_team_members WHERE manpower_team_id=' . $this->input->post('team_id') . ')')->result();

    $return_html = '<ul>';

    foreach ($all_employees as $employee) {

      $return_html .= '<li>' . $employee->name . '</li>';
    }

    $return_html .= '</ul>';

    echo $return_html;
  }

  function add_performance() {
    $departmentId = $this->session->userdata('department_id');
    $subDepartmentId = $this->session->userdata('sub_department_id');
    $post_data = $this->input->post();
//pre($post_data);
    $index_counter = 0;
    foreach ($post_data['employee_id'] as $employee_id) {
      $manpower_team_performance_query = $this->db->select('id')->from('tbl_manpower_team_performance')->where('dept_id', $departmentId)->where('sub_dept_id', $subDepartmentId)->where('date', date('Y-m-d'))->where('employee_id', $employee_id)->get();
      if ($manpower_team_performance_query->num_rows()) {
// echo 'tttt';
//die;
        if ($post_data['hours'][$index_counter] == '0' || $post_data['hours'][$index_counter] == '0') {
          $post_data['hours'][$index_counter] = '00:00:00';
        }
        $update_data = array(
            'dept_id' => $departmentId,
            'sub_dept_id' => $subDepartmentId,
            'employee_id' => $employee_id,
            'challans' => is_null($post_data['challans'][$index_counter]) ? 0 : $post_data['challans'][$index_counter],
            'A' => is_null($post_data['a'][$index_counter]) ? 0 : $post_data['a'][$index_counter],
            'B' => is_null($post_data['b'][$index_counter]) ? 0 : $post_data['b'][$index_counter],
            'C' => is_null($post_data['c'][$index_counter]) ? 0 : $post_data['c'][$index_counter],
            'time' => is_null($post_data['hours'][$index_counter]) ? '00:00:00' : date('H:i:s', strtotime($post_data['hours'][$index_counter])),
            'from_time' => is_null($post_data['from_time'][$index_counter]) ? '00:00:00' : date('H:i:s', strtotime($post_data['from_time'][$index_counter])),
            'to_time' => is_null($post_data['to_time'][$index_counter]) ? '00:00:00' : date('H:i:s', strtotime($post_data['to_time'][$index_counter])),
            'client' => is_null($post_data['client'][$index_counter]) ? 0 : $post_data['client'][$index_counter],
            'date' => date('Y-m-d'),
                //'absent' => is_null($post_data['absent'][$index_counter]) ? '0' : $post_data['absent'][$index_counter],
        );

        $this->db->where(['dept_id' => $departmentId, 'employee_id' => $employee_id, 'date' => date('Y-m-d')]);
        $this->db->where(['sub_dept_id' => $subDepartmentId]);
        $this->db->update('tbl_manpower_team_performance', $update_data);
//echo $this->db->last_query();
//pre($update_data);
      } else {
//echo 'ffff';
//die;
        if ($post_data['hours'][$index_counter] == '0' || $post_data['hours'][$index_counter] == '0') {
          $post_data['hours'][$index_counter] = '00:00:00';
        }
        $insert_data = array(
            'dept_id' => $departmentId,
            'sub_dept_id' => $subDepartmentId,
            'employee_id' => $employee_id,
            'challans' => $post_data['challans'][$index_counter],
            'A' => $post_data['a'][$index_counter],
            'B' => $post_data['b'][$index_counter],
            'C' => $post_data['c'][$index_counter],
            'time' => date('H:i:s', strtotime($post_data['hours'][$index_counter])),
            'from_time' => date('H:i:s', strtotime($post_data['from_time'][$index_counter])),
            'to_time' => date('H:i:s', strtotime($post_data['to_time'][$index_counter])),
            // 'client' => $post_data['client'][$index_counter],
            'date' => date('Y-m-d'),
                //'absent' => is_null($post_data['absent'][$index_counter]) ? 0 : $post_data['absent'][$index_counter],
        );
// pre(add_performance);
        $this->db->insert('tbl_manpower_team_performance', $insert_data);
      }
      $index_counter++;
    }
    $this->session->set_flashdata('message', '<div class="alert alert-success">Performance added successfully!</div>');
    redirect('view-team');
  }

  public function fetch_performance_stats() {

    $team_performance_data = $this->db->query('SELECT * FROM tbl_manpower_team_performance WHERE team_id=' . $this->input->post('team_id') . '')->result();

    $return_html = '
        <div class="row">
          <div class="col-xs-12">
            <table class="table table-striped listingtable">
              <thead>
                <tr class="listingtable-head">
                  <th>Employee</th>
                  <th>Challans</th>
                  <th>Picking</th>
                  <th>Packing</th>
                  <th>Dispatch</th>
                  <th>InBound</th>
                  <th>Binning</th>
                </tr>
              </thead>
            <tbody>';

    foreach ($team_performance_data as $rec) {

      $employee_name = $this->db->select('name')->from('tbl_users')->where('userId', $rec->employee_id)->get()->row()->name;

      $return_html .= '
            <tr class="odd">
                <td>' . $employee_name . '</td>
                <td>' . $rec->challans . '</td>
                <td>' . $rec->picking . '</td>
                <td>' . $rec->packing . '</td>
                <td>' . $rec->dispatch . '</td>
                <td>' . $rec->inbound . '</td>
                <td>' . $rec->binning . '</td>
            </tr>
            ';
    }

    $return_html .= '</tbody>
                </table>
            </div>
        </div>
        ';

    echo $return_html;
  }

  function fetch_add_performance_form() {
    $userId = $this->session->userdata('userId');
    $departmentId = $this->session->userdata('department_id');
    $subDepartmentId = $this->session->userdata('sub_department_id');
    $orgId = $this->session->userdata('organization_id');

    $client_list = $this->db->from('tbl_clients')->get()->result_array();
//$all_employees = $this->db->query('SELECT U.userId, U.name, U.emp_id, U.emp_code, (SELECT dept_name FROM tbl_departments WHERE dept_id=U.department_id) AS department_name FROM tbl_users AS U WHERE userId IN (SELECT employee_id FROM tbl_manpower_team_members WHERE shift_over = \'0\' AND manpower_team_id=' . $this->input->post('team_id') . ')')->result();
    $currentStatus = "'1'";
    $selectQuery = 'SELECT '
            . '  '
            . 'U.roleId AS user_role,'
            . 'U.designation, '
            . 'U.userId AS user_id, '
            . 'U.name AS employee_name, '
            . 'U.email AS employee_email, '
            . 'U.userId AS employee_id, '
            . 'U.emp_code AS employee_code,'
            . 'U.department_id, U.current_status, '
            . ' (SELECT dept_name from `tbl_departments` where `dept_id`= department_id) as department_name, '
            . ' (SELECT sub_dept_name from `tbl_sub_departments` where `id`= sub_department_id) as sub_department_name FROM tbl_users AS U '
            . ' WHERE U.current_status = ' . $currentStatus . ' AND U.sub_department_id = ' . $subDepartmentId . ' AND U.department_id = ' . $departmentId . ' AND U.userId != ' . $userId . ' and organization_id = ' . $orgId;
    $all_employees = $this->db->query($selectQuery)->result();
    //pre($all_employees);
    $return_html = '<style> .error { border-color: red; } </style>';

    $return_html .= '<form action="' . base_url() . 'add_performance" method="post" onsubmit="return validate_add_performance_form();" autocomplete="off">';
    $return_html .= '<input type="hidden" name="team_id" value="' . $this->input->post('team_id') . '">';
    $return_html .= '<div class="row">';
    $return_html .= '<div class="col-xs-12">';
    $return_html .= '<table class="table table-striped listingtable">';
    $return_html .= '<thead>';
    $return_html .= '<tr class="listingtable-head">';
//$return_html .= '<th width="10">Absent</th>';
    $return_html .= '<th>Name</th>';
//$return_html .= '<th>Emp. ID</th>';
    $return_html .= '<th>Emp. Code</th>';
    $return_html .= '<th>Department</th>';
    $return_html .= '<th>Sub Department</th>';
    $return_html .= '<th width="120">Challans</th>';
    $return_html .= '<th width="120">Boxes</th>';
    $return_html .= '<th width="120">#Qty</th>';
    $return_html .= '<th width="120">SKU</th>';

    $return_html .= '<th width="120">From Time</th>';
    $return_html .= '<th width="120">To Time</th>';

//    $return_html .= '<th width="120">Hours</th>';
//    $return_html .= '<th width="120">Client</th>';
    $return_html .= '</tr>';
    $return_html .= '</thead>';
    $return_html .= '<tbody>';

    $total_challans = 0;
    $total_a = 0;
    $total_b = 0;
    $total_c = 0;

    foreach ($all_employees as $employee) {

      $employee_performance_data_query = $this->db->select(array('challans', 'A', 'B', 'C', 'client', 'absent', 'time', 'from_time', 'to_time'))->from('tbl_manpower_team_performance')->where('employee_id', $employee->employee_id)->where('date', date('Y-m-d'))->get();


      $employee_performance_data = array(
          'challans' => 0,
          'A' => 0,
          'B' => 0,
          'C' => 0,
          'from_time' => '00:00',
          'to_time' => '00:00',
          'time' => '00:00',
          'client' => '',
          'absent' => '',
      );

      if ($employee_performance_data_query->num_rows()) {

        $employee_performance_data = $employee_performance_data_query->row_array();
      }
      $readOnlyTxt = '';
      if ($employee_performance_data['absent'] == '1') {
        $readOnlyTxt = 'readonly';
      }
// print_r($employee_performance_data); die;
      $total_challans = $total_challans + $employee_performance_data['challans'];
      $total_a = $total_a + $employee_performance_data['A'];
      $total_b = $total_b + $employee_performance_data['B'];
      $total_c = $total_c + $employee_performance_data['C'];



      $return_html .= '<tr class="odd">';
//      if ($employee_performance_data['absent'] == '1') {
//        $return_html .= '<td><input  type="checkbox" onclick="disableSiblingField(this)" value="1" checked> <input class="absent" type="hidden" name="absent[]" value="1"></td>';
//      } else {
//        $return_html .= '<td><input  type="checkbox" onclick="disableSiblingField(this)" value="1"> <input class="absent" type="hidden" name="absent[]" value="0"></td>';
//      }

      $return_html .= '<td>' . $employee->employee_name . '</td>';
//$return_html .= '<td>' . $employee->employee_id . '</td>';
      $return_html .= '<td>' . $employee->employee_code . '</td>';
      $return_html .= '<td>' . $employee->department_name . '</td>';
      $return_html .= '<td>' . $employee->sub_department_name . '</td>';
      $return_html .= '<input type="hidden" name="employee_id[]" value="' . $employee->user_id . '">';
      $return_html .= '<td><input ' . $readOnlyTxt . ' class="form-control form-field" type="text" name="challans[]" maxlength="6" value="' . $employee_performance_data['challans'] . '"></td>';
      $return_html .= '<td><input ' . $readOnlyTxt . ' class="form-control form-field" type="text" name="a[]" maxlength="6" value="' . $employee_performance_data['A'] . '"></td>';
      $return_html .= '<td><input ' . $readOnlyTxt . ' class="form-control form-field" type="text" name="b[]" maxlength="6" value="' . $employee_performance_data['B'] . '"></td>';
      $return_html .= '<td><input ' . $readOnlyTxt . ' class="form-control form-field" type="text" name="c[]" maxlength="6" value="' . $employee_performance_data['C'] . '"></td>';

      $return_html .= '<td><input ' . $readOnlyTxt . ' class="form-control form-field hoursminute from_time_' . $employee->emp_id . '" onkeypress="return false" placeholder = "00:00" type="text" name="from_time[]" data-value="' . $employee->emp_id . '" onchange="updateToTime(this.value,this)" value="' . date('H:i', strtotime($employee_performance_data['from_time'])) . '"></td>';

      $return_html .= '<td><input ' . $readOnlyTxt . ' class="form-control form-field hoursminute to_time_' . $employee->emp_id . '" onkeypress="return false" placeholder = "00:00" type="text" name="to_time[]"  data-value="' . $employee->emp_id . '" onchange="updateHours(this.value,this)" value="' . date('H:i', strtotime($employee_performance_data['to_time'])) . '"></td>';

// $return_html .= '<td><input ' . $readOnlyTxt . ' class="form-control form-field hourstest hours_' . $employee->emp_id . '" onkeypress="return false" placeholder = "00:00" type="text" name="hours[]" value="' . date('H:i', strtotime($employee_performance_data['time'])) . '"></td>';
// $return_html .= '<td><select ' . $readOnlyTxt . ' class="form-control"  name="client[]">';
//      $return_html .= '<option value="">Select</option>';
//      if (!empty($client_list)) {
//        foreach ($client_list as $client) {
//          $selectTxt = '';
//          if ($employee_performance_data['client'] == $client['client']) {
//            $selectTxt = 'selected';
//          }
//          $return_html .= '<option ' . $selectTxt . '  value="' . $client['client'] . '">' . $client['client'] . '</option>';
//        }
//      }
//      $return_html .= '</select></td>';

      $return_html .= '</tr>';
    }
    $return_html .= '<tr>';
    $return_html .= '<td></td>';
    $return_html .= '<td></td>';
    $return_html .= '<td></td>';
    $return_html .= '<td></td>';
    $return_html .= '<td><h4><b>Total</b></h4></td>';
    $return_html .= '<td><h4>' . $total_challans . '</h4></td>';
    $return_html .= '<td><h4>' . $total_a . '</h4></td>';
    $return_html .= '<td><h4>' . $total_b . '</h4></td>';
    $return_html .= '<td><h4>' . $total_c . '</h4></td>';
    $return_html .= '<td></td>';
    $return_html .= '</tr>';

    $return_html .= '</tbody>';
    $return_html .= '</table>';

    $return_html .= '</div>';
    $return_html .= '<div class="col-xs-12" style="margin-top: 20px;"><button type="submit" class="btn btn-success">Submit</button></div>';
    $return_html .= '<div>';
    $return_html .= '</form> <script>$(".hoursminute").timepicker({\'timeFormat\': \'H:i\' });</script>';

//if ($(this).val() === \'\' || isNaN($(this).val())) {
    $return_html .= '
        <script>
            function validate_add_performance_form () {

                var form_is_error_free = true;

                $(".form-field").each(function(i, obj){

                    if ($(this).val() === \'\')) {

                        $(this).css(\'border-color\', \'red\');
                        form_is_error_free = false;

                    } else {

                        $(this).css(\'border-color\', \'\');
                    }
                });

                if (form_is_error_free) {

                    return true;
                } else {

                    return false;
                }
            }
        </script>
        ';

    echo $return_html;
  }

  function fetch_team_report_markup() {

    $all_employees = $this->db->query('SELECT U.userId, U.name, U.emp_id, U.emp_code, (SELECT dept_name FROM tbl_departments WHERE dept_id=U.department_id) AS department_name FROM tbl_users AS U WHERE userId IN (SELECT employee_id FROM tbl_manpower_team_members WHERE manpower_team_id=' . $this->input->post('team_id') . ')')->result();

    $return_html = '<style> .error { border-color: red; } </style>';

    $return_html .= '<form action="' . base_url() . 'add_performance" method="post" onsubmit="return validate_add_performance_form();" autocomplete="off">';
    $return_html .= '<input type="hidden" name="dept_id" value="' . $departmentId . '">';
    $return_html .= '<input type="hidden" name="sub_dept_id" value="' . $subDepartmentId . '">';
    $return_html .= '<div class="row">';
    $return_html .= '<div class="col-xs-12">';
    $return_html .= '<table class="table table-striped listingtable">';
    $return_html .= '<thead>';
    $return_html .= '<tr class="listingtable-head">';
    $return_html .= '<th>Name</th>';
    $return_html .= '<th>Emp. ID</th>';
    $return_html .= '<th>Emp. Code</th>';
    $return_html .= '<th>Department</th>';
    $return_html .= '<th width="120">Challans</th>';
    $return_html .= '<th width="120">Boxes</th>';
    $return_html .= '<th width="120">#Qty</th>';
    $return_html .= '<th width="120">SKU</th>';
    $return_html .= '</tr>';
    $return_html .= '</thead>';
    $return_html .= '<tbody>';

    $total_challans = 0;
    $total_a = 0;
    $total_b = 0;
    $total_c = 0;

    foreach ($all_employees as $employee) {

      $employee_performance_data_query = $this->db->select(array('challans', 'A', 'B', 'C'))->from('tbl_manpower_team_performance')->where('team_id', $this->input->post('team_id'))->where('employee_id', $employee->userId)->get();

      $employee_performance_data = array(
          'challans' => 0,
          'A' => 0,
          'B' => 0,
          'C' => 0
      );

      if ($employee_performance_data_query->num_rows()) {

        $employee_performance_data = $employee_performance_data_query->row_array();
      }

      $total_challans = $total_challans + $employee_performance_data['challans'];
      $total_a = $total_a + $employee_performance_data['A'];
      $total_b = $total_b + $employee_performance_data['B'];
      $total_c = $total_c + $employee_performance_data['C'];


      $return_html .= '<tr class="odd">';
      $return_html .= '<td>' . $employee->name . '</td>';
      $return_html .= '<td>' . $employee->emp_id . '</td>';
      $return_html .= '<td>' . $employee->emp_code . '</td>';
      $return_html .= '<td>' . $employee->department_name . '</td>';
      $return_html .= '<input type="hidden" name="employee_id[]" value="' . $employee->userId . '">';
      $return_html .= '<td>' . $employee_performance_data['challans'] . '</td>';
      $return_html .= '<td>' . $employee_performance_data['A'] . '</td>';
      $return_html .= '<td>' . $employee_performance_data['B'] . '</td>';
      $return_html .= '<td>' . $employee_performance_data['C'] . '</td>';
      $return_html .= '</tr>';
    }
    $return_html .= '<tr>';
    $return_html .= '<td></td>';
    $return_html .= '<td></td>';
    $return_html .= '<td></td>';
    $return_html .= '<td><h4><b>Total</b></h4></td>';
    $return_html .= '<td><h4>' . $total_challans . '</h4></td>';
    $return_html .= '<td><h4>' . $total_a . '</h4></td>';
    $return_html .= '<td><h4>' . $total_b . '</h4></td>';
    $return_html .= '<td><h4>' . $total_c . '</h4></td>';
    $return_html .= '</tr>';

    $return_html .= '</tbody>';
    $return_html .= '</table>';

    $return_html .= '</div>';
    $return_html .= '<div>';
    $return_html .= '</form>';

    echo $return_html;
  }

  public function download_today_report($todays_team_id) {
    $userId = $this->session->userdata('userId');
    $departmentId = $this->session->userdata('department_id');
    $subDepartmentId = $this->session->userdata('sub_department_id');
    $orgId = $this->session->userdata('organization_id');

    $client_list = $this->db->from('tbl_clients')->get()->result_array();
//$all_employees = $this->db->query('SELECT U.userId, U.name, U.emp_id, U.emp_code, (SELECT dept_name FROM tbl_departments WHERE dept_id=U.department_id) AS department_name FROM tbl_users AS U WHERE userId IN (SELECT employee_id FROM tbl_manpower_team_members WHERE shift_over = \'0\' AND manpower_team_id=' . $this->input->post('team_id') . ')')->result();
    $currentStatus = "'1'";
    $selectQuery = 'SELECT '
            . '  '
            . 'U.roleId AS user_role,'
            . 'U.designation, '
            . 'U.userId AS employee_id, '
            . 'U.name AS employee_name, '
            . 'U.email AS employee_email, '
            . 'U.userId AS employee_id, '
            . 'U.emp_code AS employee_code,'
            . 'U.department_id, '
            . 'U.sub_department_id, '
            . 'U.current_status, '
            . ' (SELECT dept_name from `tbl_departments` where `dept_id`= department_id) as department_name, '
            . ' (SELECT sub_dept_name from `tbl_sub_departments` where `id`= sub_department_id) as sub_department_name, '
            . ' (SELECT org_name from `tbl_organization` where `id`= organization_id) as org_name FROM tbl_users AS U '
            . ' WHERE U.current_status = ' . $currentStatus . ' AND U.sub_department_id = ' . $subDepartmentId . ' AND U.department_id = ' . $departmentId . ' AND U.userId != ' . $userId . ' and organization_id = ' . $orgId;
    $all_team_employees_list = $this->db->query($selectQuery)->result();
//pre($all_team_employees_list);
//$all_team_employees_list = $this->db->get()->result();
//$teamcreatedate = isset($teamInfo->date) ? $teamInfo->date : '';
//$teamshift = isset($teamInfo->shift) ? $teamInfo->shift : '';
//$teamclient = isset($teamInfo->client) ? $teamInfo->client : '';
    $filename = 'dailyreport_.xls';

    $data['total_challans'] = 0;
    $data['total_boxes'] = 0;
    $data['total_qty'] = 0;
    $data['total_sku'] = 0;
    $data['all_employees_data'] = array();
    $index_counter = 0;
    $empIdList = array();
//pre($all_team_employees_list);
    foreach ($all_team_employees_list as $employee) {

      if (!empty($empIdList) && in_array($employee->employee_id, $empIdList)) {
        continue;
      }
      $empIdList[] = $employee->employee_id;

      $data['all_employees_data'][$index_counter]['employee_name'] = $this->db->select('name')->from('tbl_users')->where('userId', $employee->employee_id)->get()->row()->name;
      $data['all_employees_data'][$index_counter]['supervisor'] = $this->db->select('name')->from('tbl_users')->where('department_id', $employee->department_id)->where('sub_department_id', $employee->sub_department_id)->where('roleId', '4')->get()->row()->name;

      $data['all_employees_data'][$index_counter]['dept_name'] = deptName($employee->department_id);
      $data['all_employees_data'][$index_counter]['org_name'] = $employee->org_name;
      $data['all_employees_data'][$index_counter]['sub_dept'] = $employee->sub_department_id;

      $total_time_query = $this->db->select('time')->from('tbl_manpower_team_performance')->where('employee_id', $employee->employee_id)->where('date', date('Y-m-d'))->get();

      if ($total_time_query->num_rows()) {

        $data['all_employees_data'][$index_counter]['total_time'] = $total_time_query->row()->time;
      } else {

        $data['all_employees_data'][$index_counter]['total_time'] = '00:00';
      }


      $total_challans_query = $this->db->select('challans')->from('tbl_manpower_team_performance')->where('employee_id', $employee->employee_id)->where('date', date('Y-m-d'))->get();

      if ($total_challans_query->num_rows()) {

        $data['all_employees_data'][$index_counter]['total_challans'] = $total_challans_query->row()->challans;
      } else {

        $data['all_employees_data'][$index_counter]['total_challans'] = 0;
      }

      $total_boxes_query = $this->db->select('A')->from('tbl_manpower_team_performance')->where('employee_id', $employee->employee_id)->where('date', date('Y-m-d'))->get();

      if ($total_boxes_query->num_rows()) {

        $data['all_employees_data'][$index_counter]['total_boxes'] = $total_boxes_query->row()->A;
      } else {

        $data['all_employees_data'][$index_counter]['total_boxes'] = 0;
      }

      $total_qty_query = $this->db->select('B')->from('tbl_manpower_team_performance')->where('employee_id', $employee->employee_id)->where('date', date('Y-m-d'))->get();

      if ($total_qty_query->num_rows()) {

        $data['all_employees_data'][$index_counter]['total_qty'] = $total_qty_query->row()->B;
      } else {

        $data['all_employees_data'][$index_counter]['total_qty'] = 0;
      }

      $total_sku_query = $this->db->select('C')->from('tbl_manpower_team_performance')->where('employee_id', $employee->employee_id)->where('date', date('Y-m-d'))->get();

      if ($total_sku_query->num_rows()) {

        $data['all_employees_data'][$index_counter]['total_sku'] = $total_sku_query->row()->C;
      } else {

        $data['all_employees_data'][$index_counter]['total_sku'] = 0;
      }

      $chck_absent_query = $this->db->select('absent')->from('tbl_manpower_team_performance')->where('employee_id', $employee->employee_id)->where('date', date('Y-m-d'))->get();

      if ($chck_absent_query->num_rows()) {

        $data['all_employees_data'][$index_counter]['absent'] = $chck_absent_query->row()->absent;
      } else {

        $data['all_employees_data'][$index_counter]['absent'] = 0;
      }
      $time = array();

      $time[] = $this->db->select('time')->from('tbl_manpower_team_performance')->where('employee_id', $employee->employee_id)->where('date', date('Y-m-d'))->get()->row()->time;

      $time[] = $data['total_time'];

      $data['total_time'] = $this->AddPlayTime($time);


      $data['total_challans'] = $data['total_challans'] + $this->db->select('challans')->from('tbl_manpower_team_performance')->where('employee_id', $employee->employee_id)->where('date', date('Y-m-d'))->get()->row()->challans;

      $data['total_boxes'] = $data['total_boxes'] + $this->db->select('A')->from('tbl_manpower_team_performance')->where('employee_id', $employee->employee_id)->where('date', date('Y-m-d'))->get()->row()->A;

      $data['total_qty'] = $data['total_qty'] + $this->db->select('B')->from('tbl_manpower_team_performance')->where('employee_id', $employee->employee_id)->where('date', date('Y-m-d'))->get()->row()->B;

      $data['total_sku'] = $data['total_sku'] + $this->db->select('C')->from('tbl_manpower_team_performance')->where('employee_id', $employee->employee_id)->where('date', date('Y-m-d'))->get()->row()->C;
      $index_counter++;
    }

//pre($data['all_employees_data']);
    $this->load->library('excel');
//activate worksheet number 1
    $this->excel->setActiveSheetIndex(0);
//name the worksheet
    $this->excel->getActiveSheet()->setTitle('Today Report');

    $this->excel->getActiveSheet()->setCellValue('A1', 'Employee Name')->getStyle('A1')->getFont()->setBold(true);

    $this->excel->getActiveSheet()->setCellValue('B1', 'Warehouse')->getStyle('B1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('C1', 'Department')->getStyle('C1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('D1', 'Sub Department')->getStyle('D1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('E1', 'Supervisor')->getStyle('E1')->getFont()->setBold(true);


    $this->excel->getActiveSheet()->setCellValue('F1', 'Challan')->getStyle('F1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('G1', 'Boxes')->getStyle('G1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('H1', 'Qty')->getStyle('H1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('I1', 'SKU')->getStyle('I1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('J1', 'Time')->getStyle('J1')->getFont()->setBold(true);

    if (isset($data['all_employees_data']) && !empty($data['all_employees_data'])) {
      $excelrow = 2;
      foreach ($data['all_employees_data'] as $key => $emp) {

        if (isset($emp['absent']) && $emp['absent'] == 1) {
          $emp['total_challans'] = 'A';
          $emp['total_boxes'] = 'A';
          $emp['total_qty'] = 'A';
          $emp['total_sku'] = 'A';
          $emp['total_time'] = 'A';
        }
//pre($emp);
        $this->excel->getActiveSheet()->setCellValue('A' . $excelrow, ucfirst($emp['employee_name']));
        $this->excel->getActiveSheet()->setCellValue('B' . $excelrow, $emp['org_name']);
        $this->excel->getActiveSheet()->setCellValue('C' . $excelrow, $emp['dept_name']);
        $this->excel->getActiveSheet()->setCellValue('D' . $excelrow, subDeptName($emp['sub_dept']));
        $this->excel->getActiveSheet()->setCellValue('E' . $excelrow, $emp['supervisor']);


        $this->excel->getActiveSheet()->setCellValue('F' . $excelrow, $emp['total_challans']);
        $this->excel->getActiveSheet()->setCellValue('G' . $excelrow, $emp['total_boxes']);
        $this->excel->getActiveSheet()->setCellValue('H' . $excelrow, $emp['total_qty']);
        $this->excel->getActiveSheet()->setCellValue('I' . $excelrow, $emp['total_sku']);
        $this->excel->getActiveSheet()->setCellValue('J' . $excelrow, $emp['total_time']);


        $excelrow++;
      }

      $this->excel->getActiveSheet()->setCellValue('A' . $excelrow, 'Total : ')->getStyle('E' . $excelrow)->getFont()->setBold(true);
      $this->excel->getActiveSheet()->setCellValue('F' . $excelrow, $data['total_challans']);
      $this->excel->getActiveSheet()->setCellValue('G' . $excelrow, $data['total_boxes']);
      $this->excel->getActiveSheet()->setCellValue('H' . $excelrow, $data['total_qty']);
      $this->excel->getActiveSheet()->setCellValue('I' . $excelrow, $data['total_sku']);
      $this->excel->getActiveSheet()->setCellValue('J' . $excelrow, $data['total_time']);
    }


    header('Content-Type: application/vnd.ms-excel'); //mime type
    header('Content-Disposition: attachment;filename="' . $filename . '"'); //tell browser what's the file name
    header('Cache-Control: max-age=0'); //no cache
//save it to Excel5 format (excel 2003 .XLS file), change this to 'Excel2007' (and adjust the filename extension, also the header mime type)
//if you want to save it as .XLSX Excel 2007 format
    $objWriter = PHPExcel_IOFactory::createWriter($this->excel, 'Excel5');
//force user to download the Excel file without writing it to server's HD
    $objWriter->save('php://output');
    redirect(site_url('view-report'));
    die;
  }

  function get_date_ranged_report_excel_new() {
//pre($this->input->post());
    $this->load->library('excel');

    if ($this->session->userdata('role') == '4') {
      $department_id = $this->session->userdata('department_id');
      $sub_department_id = $this->session->userdata('sub_department_id');
      $shift = $this->session->userdata('shift');
    } else {
      $department_id = $this->input->post('departmentId');
      $sub_department_id = $this->input->post('subdepartment');

      $shift = $this->input->post('shift');
    }


    $departmentId = $this->input->post('departmentId');
    $fromDate = $this->input->post('from_date');
    $toDate = $this->input->post('to_date');
    //$shift = $this->input->post('shift');
// error_reporting(-1);
//    $this->db->select('dept_name');
//    $this->db->where('dept_id', $departmentId);
//    $departmentName = $this->db->get('tbl_departments')->row()->dept_name;

    $filename = 'manpower_productivity_' . $departmentName . '_' . $shift . '_' . $fromDate . '_to_' . $toDate . '.xls';


//    $this->db->select('id,shift,client,date,department_id');
//    $this->db->where('department_id', $departmentId);
//    if ($shift != '') {
//      $this->db->where("shift like '" . $shift . "'");
//    }
// if($fromDate != ''){
// $this->db->where("date >= '".$fromDate."'");
// }
// if($toDate != ''){
// $this->db->where("date <= '".$toDate."'");
// }
// $this->db->group_by(['date']);

    $this->db->select('tbl_manpower_team_performance.*');
//    $this->db->where([
//        'tbl_manpower_team_performance.dept_id' => $departmentId,
//        'tbl_manpower_team_performance.sub_dept_id' => $subDepartmentId,
//        'tbl_manpower_team_performance.sub_dept_id' => $subDepartmentId,
//    ]);


    $this->db->group_by('tbl_manpower_team_performance.sub_dept_id');
    //$this->db->join('tbl_users', 'tbl_users.userId = tbl_manpower_team_performance.employee_id');
    //$this->db->join('tbl_roles', 'tbl_roles.roleId = tbl_users.roleId');
    $all_team_ids = $this->db->get('tbl_manpower_team_performance')->result();

    $totalcount = count($all_team_ids);

//header('Content-Type: text/csv; charset=utf-8');
//header('Content-Disposition: attachment; filename=data.csv');
//$output = fopen('php://output', 'w');

    $this->load->library('excel');
//activate worksheet number 1
    $this->excel->setActiveSheetIndex(0);
//name the worksheet
    $this->excel->getActiveSheet()->setTitle('Report');

    $this->excel->getActiveSheet()->setCellValue('A1', 'Department')->getStyle('A1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('D1', 'Date')->getStyle('D1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('B1', 'Sub Department')->getStyle('B1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('C1', 'Client')->getStyle('C1')->getFont()->setBold(true);

    $this->excel->getActiveSheet()->setCellValue('E1', 'Supervisor')->getStyle('E1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('F1', 'Challan')->getStyle('F1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('G1', 'Boxes')->getStyle('G1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('H1', 'Qty')->getStyle('H1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('I1', 'SKU')->getStyle('I1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('J1', 'Manpower')->getStyle('J1')->getFont()->setBold(true);
//$this->excel->getActiveSheet()->setCellValue('K1', 'Time')->getStyle('K1')->getFont()->setBold(true);


    $fChallan = 0;
    $fBoxes = 0;
    $fQty = 0;
    $fSku = 0;
    $fEmp = 0;
    //pre($all_team_ids);





    if (!empty($all_team_ids)) {
      $excelrow = 2;
      foreach ($all_team_ids as $key => $team_id) {

        //$team_details = $this->db->query('SELECT MT.date AS date, (SELECT name FROM tbl_users WHERE userId=MT.created_by) AS created_by, MT.shift AS shift, MT.client AS client, (SELECT dept_name FROM tbl_departments WHERE dept_id=MT.department_id) AS department_name FROM tbl_manpower_team AS MT WHERE id=' . $team_id->id)->row();
        if ($department_id != '') {
          $this->db->where('tbl_manpower_team_performance.dept_id', $department_id);
        }
        if ($sub_department_id != '') {
          $this->db->where('tbl_manpower_team_performance.sub_dept_id', $sub_department_id);
        }
//$total_challans = $this->db->query('SELECT IFNULL(SUM(challans), 0) AS total_challans FROM tbl_manpower_team_performance WHERE team_id=\''.$team_id->id.'\'')->row()->total_challans;
        $total_challans = $this->db->query('SELECT IFNULL(SUM(challans), 0) AS total_challans,date FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' GROUP BY date')->result_array();
        $total_boxes = $this->db->query('SELECT IFNULL(SUM(A), 0) AS total_boxes,date FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' GROUP BY date')->result_array();
        $total_qty = $this->db->query('SELECT IFNULL(SUM(B), 0) AS total_qty,date FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' GROUP BY date')->result_array();
        $total_sku = $this->db->query('SELECT IFNULL(SUM(C), 0) AS total_sku,date FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' GROUP BY date')->result_array();
        $total_manpower = $this->db->query('SELECT IFNULL(COUNT(absent),0) AS manpower,date FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' AND absent = \'0\' GROUP BY date')->result_array();
        $client_list = $this->db->query('SELECT GROUP_CONCAT(DISTINCT CONCAT(\'"\', `client`, \'"\')) AS `clientlist`, date FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' AND client != \'\' GROUP BY date')->result_array();


        $total_time = $this->db->query('SELECT IFNULL(SEC_TO_TIME(SUM(TIME_TO_SEC(time))),0) AS total_time,date FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' AND absent = \'0\' GROUP BY date')->result_array();




        if (!empty($total_challans)) {
          foreach ($total_challans as $key1 => $challan) {
            $fChallan += $TCHALLAN = $challan['total_challans'];
            $fBoxes += $TOTALBOXES = isset($total_boxes[$key1]['total_boxes']) ? $total_boxes[$key1]['total_boxes'] : 0;
            $fQty += $TOTALQTY = isset($total_qty[$key1]['total_qty']) ? $total_qty[$key1]['total_qty'] : 0;
            $fSku += $TOTALSKU = isset($total_sku[$key1]['total_sku']) ? $total_sku[$key1]['total_sku'] : 0;
            $fEmp += $TOTALMANPOWER = isset($total_manpower[$key1]['manpower']) ? $total_manpower[$key1]['manpower'] : 0;

            $TOTALTIME = isset($total_time[$key1]['total_time']) ? date('H:i', strtotime($total_time[$key1]['total_time'])) : 0;


            $this->excel->getActiveSheet()->setCellValue('A' . $excelrow, ucfirst(deptName($team_id->dept_id)));
            $this->excel->getActiveSheet()->setCellValue('D' . $excelrow, date('d-m-Y', strtotime($challan['date'])));
            $this->excel->getActiveSheet()->setCellValue('B' . $excelrow, ucfirst(subDeptName($team_id->sub_dept_id)));
            $this->excel->getActiveSheet()->setCellValue('C' . $excelrow, $client_list[$key1]['clientlist']);
            $this->excel->getActiveSheet()->setCellValue('E' . $excelrow, ucfirst(superviserBySubDeptId($team_id->sub_dept_id)));
            $this->excel->getActiveSheet()->setCellValue('F' . $excelrow, $TCHALLAN);
            $this->excel->getActiveSheet()->setCellValue('G' . $excelrow, $TOTALBOXES);
            $this->excel->getActiveSheet()->setCellValue('H' . $excelrow, $TOTALQTY);
            $this->excel->getActiveSheet()->setCellValue('I' . $excelrow, $TOTALSKU);
            $this->excel->getActiveSheet()->setCellValue('J' . $excelrow, $TOTALMANPOWER);
//$this->excel->getActiveSheet()->setCellValue('K'.$excelrow, $TOTALTIME);

            fputcsv($output, [$team_details->shift, '', $team_details->department_name, $challan['date'], $team_details->created_by, $challan['total_challans'], $total_boxes[$key]['total_boxes'], $total_qty[$key]['total_qty'], $total_sku[$key]['total_sku'], $total_manpower[$key]['manpower']]);
            $excelrow++;
          }
        }
      }
      $this->excel->getActiveSheet()->setCellValue('E' . $excelrow, 'Total : ')->getStyle('E' . $excelrow)->getFont()->setBold(true);
      $this->excel->getActiveSheet()->setCellValue('F' . $excelrow, $fChallan);
      $this->excel->getActiveSheet()->setCellValue('G' . $excelrow, $fBoxes);
      $this->excel->getActiveSheet()->setCellValue('H' . $excelrow, $fQty);
      $this->excel->getActiveSheet()->setCellValue('I' . $excelrow, $fSku);
      $this->excel->getActiveSheet()->setCellValue('J' . $excelrow, $fEmp);
    }

//set cell A1 content with some text
//$this->excel->getActiveSheet()->setCellValue('A1', 'This is just some text value');
//change the font size
//$this->excel->getActiveSheet()->getStyle('A1')->getFont()->setSize(20);
//make the font become bold
//$this->excel->getActiveSheet()->getStyle('A1')->getFont()->setBold(true);
//merge cell A1 until D1
//$this->excel->getActiveSheet()->mergeCells('A1:D1');
//set aligment to center for that merged cell (A1 to D1)
//$this->excel->getActiveSheet()->getStyle('A1')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
//save our workbook as this file name
    header('Content-Type: application/vnd.ms-excel'); //mime type
    header('Content-Disposition: attachment;filename="' . $filename . '"'); //tell browser what's the file name
    header('Cache-Control: max-age=0'); //no cache
//save it to Excel5 format (excel 2003 .XLS file), change this to 'Excel2007' (and adjust the filename extension, also the header mime type)
//if you want to save it as .XLSX Excel 2007 format
    $objWriter = PHPExcel_IOFactory::createWriter($this->excel, 'Excel5');
//force user to download the Excel file without writing it to server's HD
    $objWriter->save('php://output');
    exit;
  }

  function get_date_ranged_report_excel() {

//pre($this->session->userdata);
    $department_id = $this->session->userdata('department_id');
    $subDepartmentId = $this->session->userdata('sub_department_id');
//$subDepartmentId = $this->session->userdata('sub_department_id');
//$subDepartmentId = $this->session->userdata('sub_department_id');
//$shift = $this->session->userdata('shift');
    $this->db->select('tbl_manpower_team_performance.*');
//$this->db->where(['tbl_roles.roleId' => '4']);
    $this->db->group_by('tbl_manpower_team_performance.sub_dept_id');
    $this->db->join('tbl_users', 'tbl_users.userId = tbl_manpower_team_performance.employee_id');
    $this->db->join('tbl_roles', 'tbl_roles.roleId = tbl_users.roleId');
    $created_by = $this->db->get('tbl_manpower_team_performance')->result_array();
//echo $this->db->last_query();
//pre($created_by);
//    if ($this->session->userdata('role') == '4') {
//
//      //$all_team_ids = $this->db->select('id')->from('tbl_manpower_team')->where('created_by', $this->session->userdata('userId'))->where('team_submitted', '1')->where('date >=', $this->input->post('from_date'))->where('date <=', $this->input->post('to_date'))->order_by('date', 'ASC')->get()->result();
//      $all_team_ids = $this->db->select('id')->from('tbl_manpower_team')->where('created_by', $created_by)->where('team_submitted', '1')->order_by('date', 'ASC')->get()->result();
//    } else {
//      $all_team_ids = $this->db->select('id')->from('tbl_manpower_team')->where('team_submitted', '1')->order_by('date', 'ASC')->get()->result();
//    }




    $filename = 'manpower_productivity.xls';
    $this->load->library('excel');
//activate worksheet number 1
    $this->excel->setActiveSheetIndex(0);
//name the worksheet
    $this->excel->getActiveSheet()->setTitle('Report');

    $this->excel->getActiveSheet()->setCellValue('A1', 'Department')->getStyle('A1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('D1', 'Date')->getStyle('D1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('B1', 'Sub Department')->getStyle('B1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('C1', 'Client')->getStyle('C1')->getFont()->setBold(true);

    $this->excel->getActiveSheet()->setCellValue('E1', 'Supervisor')->getStyle('E1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('F1', 'Challan')->getStyle('F1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('G1', 'Boxes')->getStyle('G1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('H1', 'Qty')->getStyle('H1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('I1', 'SKU')->getStyle('I1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('J1', 'Manpower')->getStyle('J1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('K1', 'Time')->getStyle('J1')->getFont()->setBold(true);
    $fChallan = 0;
    $fBoxes = 0;
    $fQty = 0;
    $fSku = 0;
    $fEmp = 0;

// pre($created_by);
    if (!empty($created_by)) {
      $excelrow = 2;
      foreach ($created_by as $key => $team_id) {
//pre($team_id);
//pre($team_id['id']);
//$team_details = $this->db->query('SELECT (SELECT name FROM tbl_users WHERE sub_department_id=MTP.sub_dept_id) AS created_by, (SELECT dept_name FROM tbl_departments WHERE dept_id=MTP.dept_id) AS department_name FROM tbl_manpower_team_performance AS MTP WHERE id=' . $team_id['id'])->row();
//pre($team_details);
//$total_challans = $this->db->query('SELECT IFNULL(SUM(challans), 0) AS total_challans FROM tbl_manpower_team_performance WHERE team_id=\''.$team_id->id.'\'')->row()->total_challans;
        $total_challans = $this->db->query('SELECT IFNULL(SUM(challans), 0) AS total_challans,date FROM tbl_manpower_team_performance WHERE sub_dept_id=\'' . $team_id['sub_dept_id'] . '\' AND date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' GROUP BY date')->result_array();
        $total_boxes = $this->db->query('SELECT IFNULL(SUM(A), 0) AS total_boxes,date FROM tbl_manpower_team_performance WHERE sub_dept_id=\'' . $team_id['sub_dept_id'] . '\' AND date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' GROUP BY date')->result_array();
        $total_qty = $this->db->query('SELECT IFNULL(SUM(B), 0) AS total_qty,date FROM tbl_manpower_team_performance WHERE sub_dept_id=\'' . $team_id['sub_dept_id'] . '\' AND date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' GROUP BY date')->result_array();
        $total_sku = $this->db->query('SELECT IFNULL(SUM(C), 0) AS total_sku,date FROM tbl_manpower_team_performance WHERE sub_dept_id=\'' . $team_id['sub_dept_id'] . '\' AND date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' GROUP BY date')->result_array();
        $total_manpower = $this->db->query('SELECT IFNULL(COUNT(absent),0) AS manpower,date FROM tbl_manpower_team_performance WHERE sub_dept_id=\'' . $team_id['sub_dept_id'] . '\' AND date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\'  GROUP BY date')->result_array();
        $client_list = $this->db->query('SELECT GROUP_CONCAT(DISTINCT CONCAT(\'"\', `client`, \'"\')) AS `clientlist`, date FROM tbl_manpower_team_performance WHERE sub_dept_id=\'' . $team_id['sub_dept_id'] . '\' AND date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\'  GROUP BY date')->result_array();

        $total_time = $this->db->query('SELECT IFNULL(SEC_TO_TIME(SUM(TIME_TO_SEC(time))),0) AS total_time,date FROM tbl_manpower_team_performance WHERE sub_dept_id=\'' . $team_id['sub_dept_id'] . '\' AND date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\'  GROUP BY date')->result_array();

// die;
//pre($total_challans);
        if (!empty($total_challans)) {
          foreach ($total_challans as $key1 => $challan) {
            $fChallan += $TCHALLAN = $challan['total_challans'];
            $fBoxes += $TOTALBOXES = isset($total_boxes[$key1]['total_boxes']) ? $total_boxes[$key1]['total_boxes'] : 0;
            $fQty += $TOTALQTY = isset($total_qty[$key1]['total_qty']) ? $total_qty[$key1]['total_qty'] : 0;
            $fSku += $TOTALSKU = isset($total_sku[$key1]['total_sku']) ? $total_sku[$key1]['total_sku'] : 0;
            $fEmp += $TOTALMANPOWER = isset($total_manpower[$key1]['manpower']) ? $total_manpower[$key1]['manpower'] : 0;

            $TOTALTIME = isset($total_time[$key1]['total_time']) ? $total_time[$key1]['total_time'] : 0;

            if ($TOTALTIME != '00:00:00' && $TOTALTIME != 0) {
// $TOTALTIME = date('H:i',strtotime($TOTALTIME));
            }
//pre(deptName($team_id['dept_id']));

            $this->excel->getActiveSheet()->setCellValue('A' . $excelrow, ucfirst(deptName($team_id['dept_id'])));
            $this->excel->getActiveSheet()->setCellValue('D' . $excelrow, date('d-m-Y', strtotime($challan['date'])));
            $this->excel->getActiveSheet()->setCellValue('B' . $excelrow, ucfirst(subDeptName($team_id['sub_dept_id'])));
            $this->excel->getActiveSheet()->setCellValue('C' . $excelrow, $client_list[$key1]['clientlist']);

            $this->excel->getActiveSheet()->setCellValue('E' . $excelrow, ucfirst($this->session->userdata('name')));
            $this->excel->getActiveSheet()->setCellValue('F' . $excelrow, $TCHALLAN);
            $this->excel->getActiveSheet()->setCellValue('G' . $excelrow, $TOTALBOXES);
            $this->excel->getActiveSheet()->setCellValue('H' . $excelrow, $TOTALQTY);
            $this->excel->getActiveSheet()->setCellValue('I' . $excelrow, $TOTALSKU);
            $this->excel->getActiveSheet()->setCellValue('J' . $excelrow, $TOTALMANPOWER);
            $this->excel->getActiveSheet()->setCellValue('K' . $excelrow, $TOTALTIME);

            fputcsv($output, [$team_details->shift, '', $team_details->department_name, $challan['date'], $team_details->created_by, $challan['total_challans'], $total_boxes[$key]['total_boxes'], $total_qty[$key]['total_qty'], $total_sku[$key]['total_sku'], $total_manpower[$key]['manpower']]);
            $excelrow++;
          }
        }
      }
      $this->excel->getActiveSheet()->setCellValue('E' . $excelrow, 'Total : ')->getStyle('E' . $excelrow)->getFont()->setBold(true);
      $this->excel->getActiveSheet()->setCellValue('F' . $excelrow, $fChallan);
      $this->excel->getActiveSheet()->setCellValue('G' . $excelrow, $fBoxes);
      $this->excel->getActiveSheet()->setCellValue('H' . $excelrow, $fQty);
      $this->excel->getActiveSheet()->setCellValue('I' . $excelrow, $fSku);
      $this->excel->getActiveSheet()->setCellValue('J' . $excelrow, $fEmp);
    }

//set cell A1 content with some text
//$this->excel->getActiveSheet()->setCellValue('A1', 'This is just some text value');
//change the font size
//$this->excel->getActiveSheet()->getStyle('A1')->getFont()->setSize(20);
//make the font become bold
//$this->excel->getActiveSheet()->getStyle('A1')->getFont()->setBold(true);
//merge cell A1 until D1
//$this->excel->getActiveSheet()->mergeCells('A1:D1');
//set aligment to center for that merged cell (A1 to D1)
//$this->excel->getActiveSheet()->getStyle('A1')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
//save our workbook as this file name
    header('Content-Type: application/vnd.ms-excel'); //mime type
    header('Content-Disposition: attachment;filename="' . $filename . '"'); //tell browser what's the file name
    header('Cache-Control: max-age=0'); //no cache
//save it to Excel5 format (excel 2003 .XLS file), change this to 'Excel2007' (and adjust the filename extension, also the header mime type)
//if you want to save it as .XLSX Excel 2007 format
    $objWriter = PHPExcel_IOFactory::createWriter($this->excel, 'Excel5');
//force user to download the Excel file without writing it to server's HD
    $objWriter->save('php://output');
    die;







    /* header('Content-Type: text/csv; charset=utf-8');
      header('Content-Disposition: attachment; filename=data.csv');
      $output = fopen('php://output', 'w');

      fputcsv($output, array('Shift', 'Client', 'Department','Date','Created By','Total Challans','Total Boxes','Total Qty','Total SKU','Manpower'));





      $TChallan = 0;
      $TBOXES = 0;
      $TQTY = 0;
      $TSKU = 0;
      $TMANPOWER = 0;

      foreach ($all_team_ids as $team_id) {

      $team_details = $this->db->query('SELECT MT.date AS date, (SELECT name FROM tbl_users WHERE userId=MT.created_by) AS created_by, MT.shift AS shift, MT.client AS client, (SELECT dept_name FROM tbl_departments WHERE dept_id=MT.department_id) AS department_name FROM tbl_manpower_team AS MT WHERE id='.$team_id->id)->row();

      //$total_challans = $this->db->query('SELECT IFNULL(SUM(challans), 0) AS total_challans FROM tbl_manpower_team_performance WHERE team_id=\''.$team_id->id.'\' AND date >=\''.$this->input->post('from_date').'\' AND date <= \''.$this->input->post('to_date').'\'')->row()->total_challans;
      $total_challans = $this->db->query('SELECT IFNULL(SUM(challans), 0) AS total_challans,date FROM tbl_manpower_team_performance WHERE team_id=\''.$team_id->id.'\' AND date >=\''.$this->input->post('from_date').'\' AND date <= \''.$this->input->post('to_date').'\' GROUP BY date')->result_array();


      //$total_boxes = $this->db->query('SELECT IFNULL(SUM(A), 0) AS total_boxes FROM tbl_manpower_team_performance WHERE team_id=\''.$team_id->id.'\' AND date >=\''.$this->input->post('from_date').'\' AND date <= \''.$this->input->post('to_date').'\'')->row()->total_boxes;
      $total_boxes = $this->db->query('SELECT IFNULL(SUM(A), 0) AS total_boxes, date FROM tbl_manpower_team_performance WHERE team_id=\''.$team_id->id.'\' AND date >=\''.$this->input->post('from_date').'\' AND date <= \''.$this->input->post('to_date').'\' GROUP BY date')->result_array();
      //$total_qty = $this->db->query('SELECT IFNULL(SUM(B), 0) AS total_qty FROM tbl_manpower_team_performance WHERE team_id=\''.$team_id->id.'\' AND date >=\''.$this->input->post('from_date').'\' AND date <= \''.$this->input->post('to_date').'\'')->row()->total_qty;
      $total_qty = $this->db->query('SELECT IFNULL(SUM(B), 0) AS total_qty,date FROM tbl_manpower_team_performance WHERE team_id=\''.$team_id->id.'\' AND date >=\''.$this->input->post('from_date').'\' AND date <= \''.$this->input->post('to_date').'\' GROUP BY date')->result_array();
      //$total_sku = $this->db->query('SELECT IFNULL(SUM(C), 0) AS total_sku FROM tbl_manpower_team_performance WHERE team_id=\''.$team_id->id.'\' AND date >=\''.$this->input->post('from_date').'\' AND date <= \''.$this->input->post('to_date').'\'')->row()->total_sku;
      $total_sku = $this->db->query('SELECT IFNULL(SUM(C), 0) AS total_sku, date FROM tbl_manpower_team_performance WHERE team_id=\''.$team_id->id.'\' AND date >=\''.$this->input->post('from_date').'\' AND date <= \''.$this->input->post('to_date').'\' GROUP BY date')->result_array();

      $total_manpower = $this->db->query('SELECT IFNULL(COUNT(absent),0) AS manpower,date FROM tbl_manpower_team_performance WHERE team_id=\''.$team_id->id.'\' AND date >=\''.$this->input->post('from_date').'\' AND date <= \''.$this->input->post('to_date').'\' AND absent = \'0\' GROUP BY date')->result_array();

      $all_team_member_ids = $this->db->query('SELECT employee_id FROM tbl_manpower_team_members WHERE manpower_team_id=\''.$team_id->id.'\'')->result();



      if(!empty($total_challans)){
      foreach ($total_challans as $key=> $challan){
      $TChallan += $challan['total_challans'];
      $TBOXES += $total_boxes[$key]['total_boxes'];
      $TQTY += $total_qty[$key]['total_qty'];
      $TSKU += $total_sku[$key]['total_sku'];
      $TMANPOWER += $total_manpower[$key]['manpower'];
      fputcsv($output,[$team_details->shift,'',$team_details->department_name,$challan['date'],$team_details->created_by,$challan['total_challans'],$total_boxes[$key]['total_boxes'],$total_qty[$key]['total_qty'],$total_sku[$key]['total_sku'],$total_manpower[$key]['manpower']]);
      }
      }



      fputcsv($fp, [$team_details->shift,$team_details->client,$team_details->department_name,$team_details->date,$team_details->created_by]);
      }
      fputcsv($output,['','','','','Total : ',$TChallan,$TBOXES,$TQTY,$TSKU,$TMANPOWER]);
      exit; */

    /*  foreach ($all_team_member_ids as $team_member_id) {

      $employee_name = $this->db->query('SELECT name FROM tbl_users WHERE userId=\''.$team_member_id->employee_id.'\'')->row()->name;

      $total_challans = $this->db->query('SELECT IFNULL(challans, 0) AS challans FROM tbl_manpower_team_performance WHERE team_id=\''.$team_id->id.'\' AND employee_id=\''.$team_member_id->employee_id.'\'')->row()->challans;

      $total_boxes = $this->db->query('SELECT IFNULL(A, 0) AS boxes FROM tbl_manpower_team_performance WHERE team_id=\''.$team_id->id.'\' AND employee_id=\''.$team_member_id->employee_id.'\'')->row()->boxes;

      $total_qty = $this->db->query('SELECT IFNULL(B, 0) AS qty FROM tbl_manpower_team_performance WHERE team_id=\''.$team_id->id.'\' AND employee_id=\''.$team_member_id->employee_id.'\'')->row()->qty;

      $total_sku = $this->db->query('SELECT IFNULL(C, 0) AS sku FROM tbl_manpower_team_performance WHERE team_id=\''.$team_id->id.'\' AND employee_id=\''.$team_member_id->employee_id.'\'')->row()->sku;


      }



      } */




    exit;
  }

  function get_date_range_report_new_data() {

    //pre($this->input->post());
    $return_array = array();

    //$clientId = $this->input->post('clientId');
    //$locationId = $this->input->post('locationId');
    //$organizationId = $this->input->post('organizationId');
    $departmentId = $this->input->post('departmentId');
    $subDepartmentId = $this->input->post('subdepartment');
    $fromDate = $this->input->post('from_date');
    $toDate = $this->input->post('to_date');
    $shift = $this->input->post('shift');

// $this->db->select('id,shift,client,date,department_id');
//$this->db->where('department_id', $departmentId);
//    if ($shift != '') {
//      $this->db->where("shift like '" . $shift . "'");
//    }

    /* if($fromDate != ''){
      $this->db->where("date >= '".$fromDate."'");
      }
      if($toDate != ''){
      $this->db->where("date <= '".$toDate."'");
      }

      $this->db->group_by(['date']); */

//$all_team_ids = $this->db->get('tbl_manpower_team')->result();
// $all_team_ids = $this->db->get('tbl_manpower_team')->result();

    $this->db->select('tbl_manpower_team_performance.*');
//    $this->db->where([
//        'tbl_manpower_team_performance.dept_id' => $departmentId,
//        'tbl_manpower_team_performance.sub_dept_id' => $subDepartmentId,
//        'tbl_manpower_team_performance.sub_dept_id' => $subDepartmentId,
//    ]);


    $this->db->group_by('tbl_manpower_team_performance.sub_dept_id');
    $this->db->join('tbl_users', 'tbl_users.userId = tbl_manpower_team_performance.employee_id');
    $this->db->join('tbl_roles', 'tbl_roles.roleId = tbl_users.roleId');
    $all_teams = $this->db->get('tbl_manpower_team_performance')->result_array();

//echo $this->db->last_query();
//die;


    $totalcount = count($all_teams);

    $fChallan = 0;
    $fBoxes = 0;
    $fQty = 0;
    $fSku = 0;
    $tTime = '00:00';

    if (!empty($all_teams)) {

      $excelrow = 2;

      foreach ($all_teams as $key => $team_id) {

//$team_details = $this->db->query('SELECT MT.date AS date, (SELECT name FROM tbl_users WHERE userId=MT.created_by) AS created_by, MT.shift AS shift, MT.client AS client, (SELECT dept_name FROM tbl_departments WHERE dept_id=MT.department_id) AS department_name FROM tbl_manpower_team AS MT WHERE id=' . $team_id->id)->row();

        /* $total_challans = $this->db->query('SELECT IFNULL(SUM(challans), 0) AS total_challans FROM tbl_manpower_team_performance WHERE team_id=\''.$team_id->id.'\'')->row()->total_challans;
          $total_boxes = $this->db->query('SELECT IFNULL(SUM(A), 0) AS total_boxes FROM tbl_manpower_team_performance WHERE team_id=\''.$team_id->id.'\'')->row()->total_boxes;
          $total_qty = $this->db->query('SELECT IFNULL(SUM(B), 0) AS total_qty FROM tbl_manpower_team_performance WHERE team_id=\''.$team_id->id.'\'')->row()->total_qty;
          $total_sku = $this->db->query('SELECT IFNULL(SUM(C), 0) AS total_sku FROM tbl_manpower_team_performance WHERE team_id=\''.$team_id->id.'\'')->row()->total_sku;


          $total_time = $this->db->query('SELECT IFNULL(SEC_TO_TIME(SUM(TIME_TO_SEC(time))), 0) AS total_time FROM tbl_manpower_team_performance WHERE team_id=\''.$team_id->id.'\'')->row()->total_time; */

//        if ($clientId != '') {
//          $this->db->where('tbl_manpower_team_performance.dept_id', $departmentId);
//        }
//        if ($locationId != '') {
//          $this->db->where('tbl_manpower_team_performance.sub_dept_id', $subDepartmentId);
//        }
//        if ($organizationId != '') {
//          $this->db->where('tbl_manpower_team_performance.sub_dept_id', $subDepartmentId);
//        }
        if ($subDepartmentId != '') {
          $this->db->where('tbl_manpower_team_performance.dept_id', $departmentId);
        }
        if ($subDepartmentId != '') {
          $this->db->where('tbl_manpower_team_performance.sub_dept_id', $subDepartmentId);
        }
        $total_challans = $this->db->query('SELECT IFNULL(SUM(challans), 0) AS total_challans,date FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ')->row()->total_challans;
        $total_boxes = $this->db->query('SELECT IFNULL(SUM(A), 0) AS total_boxes,date FROM tbl_manpower_team_performance WHERE  date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\'  ')->row()->total_boxes;
        $total_qty = $this->db->query('SELECT IFNULL(SUM(B), 0) AS total_qty,date FROM tbl_manpower_team_performance WHERE  date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ')->row()->total_qty;
        $total_sku = $this->db->query('SELECT IFNULL(SUM(C), 0) AS total_sku,date FROM tbl_manpower_team_performance WHERE  date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ')->row()->total_sku;
        $total_manpower = $this->db->query('SELECT IFNULL(COUNT(absent),0) AS manpower,date FROM tbl_manpower_team_performance WHERE  date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ')->row()->manpower;
//$client_list = $this->db->query('SELECT GROUP_CONCAT(DISTINCT CONCAT(\'"\', `client`, \'"\')) AS `clientlist`, date FROM tbl_manpower_team_performance WHERE team_id=\''.$team_id->id.'\' AND date >=\''.$this->input->post('from_date').'\' AND date <= \''.$this->input->post('to_date').'\' AND client != \'\' GROUP BY date')->result_array();


        $total_time = $this->db->query('SELECT IFNULL(SEC_TO_TIME(SUM(TIME_TO_SEC(time))),0) AS total_time,date FROM tbl_manpower_team_performance WHERE  date >=\'' . $this->input->post('from_date') . '\' ')->row()->total_time;





        $time = array();
        $time[] = $total_time;
        $time[] = $tTime;

        $tTime = $this->AddPlayTime($time);


        $fChallan = $fChallan + $total_challans;
        $fBoxes = $fBoxes + $total_boxes;
        $fQty = $fQty + $total_qty;
        $fSku = $fSku + $total_sku;
      }
    }

    $return_array['total_challan'] = $fChallan;
    $return_array['total_boxes'] = $fBoxes;
    $return_array['total_qty'] = $fQty;
    $return_array['total_sku'] = $fSku;
    $return_array['total_time'] = $tTime;

//pre($return_array);

    echo json_encode($return_array);
    die;
  }

  function get_date_range_report_data() {

    $return_array = array();
    //pre($this->input->post());
    if ($this->session->userdata('role') == '4') {
      $department_id = $this->session->userdata('department_id');
      $sub_department_id = $this->session->userdata('sub_department_id');
      $shift = $this->session->userdata('shift');
    } else {
      $department_id = $this->input->post('departmentId');
      $sub_department_id = $this->input->post('subdepartment');

      $shift = $this->input->post('shift');
    }
    $this->db->select('created_by');
    $this->db->where(['department_id' => $department_id, 'shift' => $shift, 'team_submitted' => '1']);
    $created_by = $this->db->get('tbl_manpower_team')->row()->created_by;

    if ($department_id != '') {
      $this->db->where('tbl_manpower_team_performance.dept_id', $department_id);
    }
    if ($sub_department_id != '') {
      $this->db->where('tbl_manpower_team_performance.sub_dept_id', $sub_department_id);
    }
    $return_array['total_challan'] = $this->db->query('SELECT IFNULL(SUM(challans), 0) AS total_challans FROM tbl_manpower_team_performance WHERE date >= \'' . $this->input->post('from_date') . '\' AND date<=\'' . $this->input->post('to_date') . '\'')->row()->total_challans;

    $return_array['total_boxes'] = $this->db->query('SELECT IFNULL(SUM(A), 0) AS total_boxes FROM tbl_manpower_team_performance WHERE date>=\'' . $this->input->post('from_date') . '\' AND date<=\'' . $this->input->post('to_date') . '\'')->row()->total_boxes;

    $return_array['total_qty'] = $this->db->query('SELECT IFNULL(SUM(B), 0) AS total_qty FROM tbl_manpower_team_performance WHERE  date>=\'' . $this->input->post('from_date') . '\' AND date<=\'' . $this->input->post('to_date') . '\' ')->row()->total_qty;

    $return_array['total_sku'] = $this->db->query('SELECT IFNULL(SUM(C), 0) AS total_sku FROM tbl_manpower_team_performance WHERE  date>=\'' . $this->input->post('from_date') . '\' AND date<=\'' . $this->input->post('to_date') . '\' ')->row()->total_sku;

    $return_array['total_time'] = $this->db->query('SELECT SEC_TO_TIME(SUM(TIME_TO_SEC(time))) AS total_time FROM tbl_manpower_team_performance WHERE date >= \'' . $this->input->post('from_date') . '\' AND date<=\'' . $this->input->post('to_date') . '\' ')->row()->total_time;


    if ($return_array['total_time'] != '00:00:00' && $return_array['total_time'] != '0') {
//$return_array['total_time'] = date('H:i',strtotime($return_array['total_time']));
    } elseif ($return_array['total_time'] == '0') {
      $return_array['total_time'] = '-';
    }



    $return_array['detailed_performance_table_markup'] = '
        <table class="table">
            <thead>
                <tr>
                    <th>Employee Name</th>
                    <th>Challans</th>
                    <th>Boxes</th>
                    <th>#QTY</th>
                    <th>SKU</th>
                    <th>Time</th>
                </tr>
            </thead>
            <tbody>
        ';
    if ($department_id != '') {
      $this->db->where('tbl_manpower_team_performance.dept_id', $department_id);
    }
    if ($sub_department_id != '') {
      $this->db->where('tbl_manpower_team_performance.sub_dept_id', $sub_department_id);
    }
    $this->db->select('tbl_manpower_team_performance.*');
    $this->db->group_by('employee_id');
//    $this->db->where([
//        'tbl_manpower_team_performance.dept_id' => $departmentId,
//        'tbl_manpower_team_performance.sub_dept_id' => $subDepartmentId,
//        'tbl_manpower_team_performance.sub_dept_id' => $subDepartmentId,
//    ]);
    //$this->db->group_by('tbl_manpower_team_performance.sub_dept_id');
    //$this->db->join('tbl_users', 'tbl_users.userId = tbl_manpower_team_performance.employee_id');
    //$this->db->join('tbl_roles', 'tbl_roles.roleId = tbl_users.roleId');
    $all_team_member_ids = $this->db->get('tbl_manpower_team_performance')->result();
    //echo $this->db->last_query();
    //pre($all_team_member_ids);
    if (empty($all_team_member_ids)) {

      $return_array['detailed_performance_table_markup'] .= '
            <tr>
                <td>N/A</td>
                <td>N/A</td>
                <td>N/A</td>
                <td>N/A</td>
                <td>N/A</td>
                <td>N/A</td>
            </tr>
            ';
    } else {

      foreach ($all_team_member_ids as $team_member_id) {
        //pre($team_member_id);
        $team_member_name = $this->db->select('name')->from('tbl_users')->where('userId', $team_member_id->employee_id)->get()->row()->name;

        $total_challans = $this->db->query('SELECT IFNULL(SUM(challans), 0) AS total_challans FROM tbl_manpower_team_performance WHERE employee_id=\'' . $team_member_id->employee_id . '\' AND date>=\'' . $this->input->post('from_date') . '\' AND date<=\'' . $this->input->post('to_date') . '\' ')->row()->total_challans;
        //echo $this->db->last_query();
        //die;
        $total_boxes = $this->db->query('SELECT IFNULL(SUM(A), 0) AS total_boxes FROM tbl_manpower_team_performance WHERE employee_id=\'' . $team_member_id->employee_id . '\' AND date>=\'' . $this->input->post('from_date') . '\' AND date<=\'' . $this->input->post('to_date') . '\' ')->row()->total_boxes;

        $total_qty = $this->db->query('SELECT IFNULL(SUM(B), 0) AS total_qty FROM tbl_manpower_team_performance WHERE employee_id=\'' . $team_member_id->employee_id . '\' AND date>=\'' . $this->input->post('from_date') . '\' AND date<=\'' . $this->input->post('to_date') . '\' ')->row()->total_qty;

        $total_sku = $this->db->query('SELECT IFNULL(SUM(C), 0) AS total_sku FROM tbl_manpower_team_performance WHERE employee_id=\'' . $team_member_id->employee_id . '\' AND date>=\'' . $this->input->post('from_date') . '\' AND date<=\'' . $this->input->post('to_date') . '\' ')->row()->total_sku;

        $total_time = $this->db->query('SELECT IFNULL(SEC_TO_TIME(SUM(TIME_TO_SEC(time))), 0) AS total_time FROM tbl_manpower_team_performance WHERE employee_id=\'' . $team_member_id->employee_id . '\' AND date>=\'' . $this->input->post('from_date') . '\' AND date<=\'' . $this->input->post('to_date') . '\' ')->row()->total_time;

        if ($total_time != '00:00:00' && $total_time != 0) {
          $total_time = date('H:i', strtotime($total_time));
        } elseif ($total_time == 0) {
          $total_time = '-';
        }

        $return_array['detailed_performance_table_markup'] .= '
                <tr>
                    <td>' . $team_member_name . '</td>
                    <td>' . $total_challans . '</td>
                    <td>' . $total_boxes . '</td>
                    <td>' . $total_qty . '</td>
                    <td>' . $total_sku . '</td>
                    <td>' . $total_time . '</td>
                </tr>
                ';
      }
    }

    $return_array['detailed_performance_table_markup'] .= '</tbody></table>';


    echo json_encode($return_array);
    die;
  }

  function view_report_new() {

    $orgId = '';
    if ($this->role == 2 || $this->role == 8) {
      $orgId = $this->organization_id;
    }

    $clientList = $this->db->get('tbl_clients')->result_array();
    $clientId = isset($clientList[0]['id']) ? $clientList[0]['id'] : '';
    $locationList = $this->db->select('*')->where('client_id', $clientId)->get('tbl_location')->result_array();
    //pre($locationList);
    $locationId = isset($locationList[0]['loc_id']) ? $locationList[0]['loc_id'] : '';
    if ($this->role == '11') {
      $warehouseList = $this->db->get('tbl_organization')->result_array();
    } else {
      $warehouseList = $this->db->where('loc_id', $locationId)->get('tbl_organization')->result_array();
    }
    //echo $this->db->last_query();
    //die;
    $warehouseId = isset($warehouseList[0]['id']) ? $warehouseList[0]['id'] : '';
    $departmentList = $this->user_model->getDepartmentList($warehouseId);
    //pre($departmentList);
    /* if($this->role == 2){
      foreach ($departmentList as $key => $dept){
      if($this->department_id != $dept['dept_id']){
      unset($departmentList[$key]);
      }
      }
      } */

    $data['clientList'] = $clientList;
    $data['locationList'] = $locationList;
    $data['warehouseList'] = $warehouseList;
    $data['departmentList'] = $departmentList;
    $data['role'] = $this->role;

    $data['department_id'] = $this->department_id;
    $this->global['pageTitle'] = 'Searbird : View Report';
    $this->loadViews("manpower_view_report_new", $this->global, $data, NULL);
  }

  function view_report() {


    $department_id = $this->session->userdata('department_id');
    $sub_department_id = $this->session->userdata('sub_department_id');
    $orgId = $this->session->userdata('organization_id');
    $userId = $this->session->userdata('userId');
    $shift = $this->session->userdata('shift');

    $this->db->select('created_by');
    $this->db->where(['department_id' => $department_id, 'shift' => $shift, 'team_submitted' => '1']);
    $created_by = $this->db->get('tbl_manpower_team')->row()->created_by;


    $todays_team_id_query = $this->db->select('id')->from('tbl_manpower_team')->where('team_submitted', 1)->where('created_by', $created_by)->get();


    $data['total_challans'] = 0;
    $data['total_boxes'] = 0;
    $data['total_qty'] = 0;
    $data['total_sku'] = 0;
    $data['total_time'] = '00:00';

    $data['all_employees_data'] = array();
    $data['today_team_id'] = '';

    $todays_team_id = $this->create_team_and_add_supervisor_if_team_does_not_exist();

    if ($todays_team_id) {

//$todays_team_id = $todays_team_id_query->row()->id;

      $data['today_team_id'] = $todays_team_id;




//$all_team_employees_list = $this->db->select(array('employee_id'))->from('tbl_manpower_team_members')->where('manpower_team_id', $todays_team_id)->get()->result();

      $selectQuery = 'SELECT '
              . '  '
              . 'U.roleId AS user_role,'
              . 'U.designation, '
              . 'U.userId AS user_id, '
              . 'U.name AS employee_name, '
              . 'U.email AS employee_email, '
              . 'U.emp_id AS employee_id, '
              . 'U.emp_code AS employee_code,'
              . 'U.department_id, U.current_status, '
              . '(SELECT dept_name from `tbl_departments` where `dept_id`= department_id) as department_name, '
              . '(SELECT sub_dept_name from `tbl_sub_departments` where `id`= sub_department_id) as sub_department_name FROM tbl_users AS U '
              . 'WHERE U.userId != ' . $userId . ' AND U.current_status != 0 AND U.sub_department_id = ' . $sub_department_id . ' AND U.department_id = ' . $department_id . ' and organization_id = ' . $orgId;
//die;
      $all_team_employees = $this->db->query($selectQuery)->result();
      $all_team_employees_list = $all_team_employees;
//pre($all_team_employees_list);

      $index_counter = 0;

      $empIdList = array();
//pre($all_team_employees_list);

      foreach ($all_team_employees_list as $employee) {

//        if (!empty($empIdList) && in_array($employee->employee_id, $empIdList)) {
//          continue;
//        }
//
//        $empIdList[] = $employee->employee_id;

        $data['all_employees_data'][$index_counter]['employee_name'] = $this->db->select('name')->from('tbl_users')->where('userId', $employee->user_id)->get()->row()->name;


        $total_challans_query = $this->db->select('challans')->from('tbl_manpower_team_performance')->where('dept_id', $department_id)->where('sub_dept_id', $sub_department_id)->where('employee_id', $employee->user_id)->where('date', date('Y-m-d'))->get();

        if ($total_challans_query->num_rows()) {

          $data['all_employees_data'][$index_counter]['total_challans'] = $total_challans_query->row()->challans;
        } else {

          $data['all_employees_data'][$index_counter]['total_challans'] = 0;
        }
        //pre($data['all_employees_data']);
        $total_boxes_query = $this->db->select('A')->from('tbl_manpower_team_performance')->where('dept_id', $department_id)->where('sub_dept_id', $sub_department_id)->where('employee_id', $employee->user_id)->where('date', date('Y-m-d'))->get();

        if ($total_boxes_query->num_rows()) {

          $data['all_employees_data'][$index_counter]['total_boxes'] = $total_boxes_query->row()->A;
        } else {

          $data['all_employees_data'][$index_counter]['total_boxes'] = 0;
        }

        $total_qty_query = $this->db->select('B')->from('tbl_manpower_team_performance')->where('dept_id', $department_id)->where('sub_dept_id', $sub_department_id)->where('employee_id', $employee->user_id)->where('date', date('Y-m-d'))->get();

        if ($total_qty_query->num_rows()) {

          $data['all_employees_data'][$index_counter]['total_qty'] = $total_qty_query->row()->B;
        } else {

          $data['all_employees_data'][$index_counter]['total_qty'] = 0;
        }

        $total_sku_query = $this->db->select('C')->from('tbl_manpower_team_performance')->where('dept_id', $department_id)->where('sub_dept_id', $sub_department_id)->where('employee_id', $employee->user_id)->where('date', date('Y-m-d'))->get();

        if ($total_sku_query->num_rows()) {

          $data['all_employees_data'][$index_counter]['total_sku'] = $total_sku_query->row()->C;
        } else {

          $data['all_employees_data'][$index_counter]['total_sku'] = 0;
        }

//        $chck_absent_query = $this->db->select('absent')->from('tbl_manpower_team_performance')->where('dept_id', $department_id)->where('sub_dept_id', $sub_department_id)->where('employee_id', $employee->employee_id)->where('date', date('Y-m-d'))->get();
//
//        if ($chck_absent_query->num_rows()) {
//
//          $data['all_employees_data'][$index_counter]['absent'] = $chck_absent_query->row()->absent;
//        } else {
//
//          $data['all_employees_data'][$index_counter]['absent'] = 0;
//        }



        $total_time = $this->db->select('time')->from('tbl_manpower_team_performance')->where('dept_id', $department_id)->where('sub_dept_id', $sub_department_id)->where('employee_id', $employee->user_id)->where('date', date('Y-m-d'))->get();

        if ($total_sku_query->num_rows()) {

          $data['all_employees_data'][$index_counter]['total_time'] = date('H:i', strtotime($total_time->row()->time));
        } else {

          $data['all_employees_data'][$index_counter]['total_time'] = '00:00';
        }



        $index_counter++;


        $data['total_challans'] = $data['total_challans'] + $this->db->select('challans')->from('tbl_manpower_team_performance')->where('dept_id', $department_id)->where('sub_dept_id', $sub_department_id)->where('employee_id', $employee->user_id)->where('date', date('Y-m-d'))->get()->row()->challans;

        if ($employee->employee_id == 42) {

        }
//pre($data['all_employees_data']);

        $data['total_boxes'] = $data['total_boxes'] + $this->db->select('A')->from('tbl_manpower_team_performance')->where('dept_id', $department_id)->where('sub_dept_id', $sub_department_id)->where('employee_id', $employee->user_id)->where('date', date('Y-m-d'))->get()->row()->A;

        $data['total_qty'] = $data['total_qty'] + $this->db->select('B')->from('tbl_manpower_team_performance')->where('dept_id', $department_id)->where('sub_dept_id', $sub_department_id)->where('employee_id', $employee->user_id)->where('date', date('Y-m-d'))->get()->row()->B;

        $data['total_sku'] = $data['total_sku'] + $this->db->select('C')->from('tbl_manpower_team_performance')->where('dept_id', $department_id)->where('sub_dept_id', $sub_department_id)->where('employee_id', $employee->user_id)->where('date', date('Y-m-d'))->get()->row()->C;

        $time = array();

        $time[] = $this->db->select('time')->from('tbl_manpower_team_performance')->where('dept_id', $department_id)->where('sub_dept_id', $sub_department_id)->where('employee_id', $employee->user_id)->where('date', date('Y-m-d'))->get()->row()->time;

        $time[] = $data['total_time'];

        $data['total_time'] = $this->AddPlayTime($time);
      }

      $highest_total = array();
      $highest_total['total'] = 0;
      $highest_total['employee_name'] = '';
//pre($data['all_employees_data']);

      foreach ($data['all_employees_data'] as $employee_data) {

        $total = $employee_data['total_challans'] + $employee_data['total_qty'] + $employee_data['total_boxes'] + $employee_data['total_sku'];

        if ($highest_total['total'] < $total) {

          $highest_total['total'] = $total;
          $highest_total['employee_name'] = $employee_data['employee_name'];
        }
      }

      $data['best_performer'] = $highest_total['employee_name'];
    }
    $this->global['pageTitle'] = 'Searbird : View Report';
    $this->loadViews("manpower_view_report", $this->global, $data, NULL);
  }

  function AddPlayTime($times) {
    $minutes = 0;

    foreach ($times as $time) {
      list($hour, $minute) = explode(':', $time);
      $minutes += $hour * 60;
      $minutes += $minute;
    }

    $hours = floor($minutes / 60);
    $minutes -= $hours * 60;

// returns the time already formatted
    return sprintf('%02d:%02d', $hours, $minutes);
  }

  function get_employees_to_be_added_table_markup() {
    $employeeDeptId = $this->session->userdata('department_id');
//U.department_id='.$employeeDeptId.' AND U.roleId = \'3\'
//$this->session->set_userdata($sessionArray);
    $query = '
        SELECT
            U.userId AS user_id,
            U.name AS employee_name,
            U.email AS employee_email,
            U.emp_id AS employee_id,
            U.emp_code AS employee_code,
            U.designation AS designation,
            (SELECT dept_name FROM tbl_departments WHERE dept_id=U.department_id) AS employee_department,
            (SELECT COUNT(id) FROM tbl_manpower_team_members WHERE employee_id=U.userId AND manpower_team_id IN (SELECT id FROM tbl_manpower_team)) As TeamMemberCount
        FROM
            tbl_users AS U
        WHERE
              U.roleId = \'3\' AND isDeleted = 0 AND U.organization_id = \'' . $this->organization_id . '\'

			AND
                (
        ';

    if ($this->input->post('employee_name_id_filter') == '' && $this->input->post('employee_name_id_filter') == '' && $this->input->post('employee_email_filter') == '' && $this->input->post('employee_code_filter') == '' && $this->input->post('employee_department_filter') == '') {

      $query .= ' 1=1 ';
    }

    $first_inner_filter = false;

    if ($this->input->post('employee_name_id_filter') != '') {

      if (!$first_inner_filter) {

        $first_inner_filter = true;

        $query .= '
                (
                    U.emp_id LIKE \'%' . $this->input->post('employee_name_id_filter') . '%\'
                OR
                    U.name LIKE \'%' . $this->input->post('employee_name_id_filter') . '%\'
                )
                ';
      } else {

        $query .= '
                AND
                (
                    U.emp_id LIKE \'%' . $this->input->post('employee_name_id_filter') . '%\'
                OR
                    U.name LIKE \'%' . $this->input->post('employee_name_id_filter') . '%\'
                )
                ';
      }
    }

    if ($this->input->post('employee_email_filter') != '') {

      if (!$first_inner_filter) {

        $first_inner_filter = true;

        $query .= '
                    U.email LIKE \'%' . $this->input->post('employee_email_filter') . '%\'
                ';
      } else {

        $query .= '
                AND
                    U.email LIKE \'%' . $this->input->post('employee_email_filter') . '%\'
                ';
      }
    }

    if ($this->input->post('employee_code_filter') != '') {

      if (!$first_inner_filter) {

        $first_inner_filter = true;

        $query .= '
                    U.emp_code LIKE \'%' . $this->input->post('employee_code_filter') . '%\'
                ';
      } else {

        $query .= '
                AND
                    U.emp_code LIKE \'%' . $this->input->post('employee_code_filter') . '%\'
                ';
      }
    }

    if ($this->input->post('employee_department_filter')) {

      if (!$first_inner_filter) {

        $first_inner_filter = true;

        $query .= '
                    U.department_id=\'' . $this->input->post('employee_department_filter') . '\'
                ';
      } else {

        $query .= '
                AND
                    U.department_id=\'' . $this->input->post('employee_department_filter') . '\'
                ';
      }
    }

    $query .= '
            )
            AND
                U.roleId!=1 ORDER BY TeamMemberCount ASC
        ';

//AND(SELECT COUNT(id) FROM tbl_manpower_team_members WHERE employee_id=U.userId AND manpower_team_id IN (SELECT id FROM tbl_manpower_team)) = 0
//(SELECT COUNT(id) FROM tbl_manpower_team_members WHERE employee_id=U.userId AND manpower_team_id IN (SELECT id FROM tbl_manpower_team WHERE date=\''.date('Y-m-d').'\'))=0


    $all_addable_employees = $this->db->query($query)->result();





    $return_html = '';

    if ($this->input->post('team_submitted') == 0) {

      $return_html .= '<div class="row"><div class="col-md-7"><h3>Add Team</h3></div> <div class="col-md-3 mt15"></div> <div class="col-md-2 mt15 text-right"><a class="btn btn-primary" href="javascript:void(0)" type="button" data-toggle="modal" data-target="#addorganizationModal" onclick="get_added_employees_table_markup();">Team Preview</a></div></div>';
    } else {

      $return_html .= '<h3>Employees To Add</h3>';
    }

    $return_html .= '<table id="employees_to_add_table" class="table table-striped listingtable">';
    $return_html .= '<thead>';
    $return_html .= '<tr class="listingtable-head">';
    $return_html .= '<th>Emp. ID</th>';
    $return_html .= '<th>Emp. Code</th>';

    $return_html .= '<th>Name</th>';
    $return_html .= '<th>Email</th>';
    $return_html .= '<th>Designation</th>';
    $return_html .= '<th>Department</th>';
    $return_html .= '<th>Actions</th>';
    $return_html .= '</tr>';
    $return_html .= '</thead>';
    $return_html .= '<tbody>';

    foreach ($all_addable_employees as $employee) {

      $return_html .= '<tr class="odd">';
      $return_html .= '<td>' . $employee->employee_id . '</td>';
      $return_html .= '<td>' . $employee->employee_code . '</td>';
      $return_html .= '<td>' . $employee->employee_name . '</td>';
      $return_html .= '<td>' . $employee->employee_email . '</td>';
      $return_html .= '<td>' . $employee->designation . '</td>';
      $return_html .= '<td>' . $employee->employee_department . '</td>';

      if ($employee->TeamMemberCount == 0) {

        $return_html .= '<td><button onclick="add_employee_to_team(\'' . $employee->user_id . '\');" type="button" class="btn btn-success">Add</button></td>';
      } else {

        $nwSQl = 'SELECT dept_name FROM tbl_departments WHERE dept_id=(SELECT department_id FROM tbl_manpower_team WHERE id = (SELECT manpower_team_id FROM tbl_manpower_team_members WHERE employee_id = \'' . $employee->employee_id . '\' ORDER BY id DESC limit 1))';

        $existindDept = $this->db->query($nwSQl)->row();

        $shiftSql = 'SELECT shift FROM tbl_manpower_team WHERE id = (SELECT manpower_team_id FROM tbl_manpower_team_members WHERE employee_id = \'' . $employee->employee_id . '\' ORDER BY id DESC limit 1)';

        $existShift = $this->db->query($shiftSql)->row();

        $deptName = ($existindDept) ? $existindDept->dept_name : '';

        $shiftName = ($existShift) ? $existShift->shift : '';

        $Supervisorquery = 'SELECT name,emp_id,emp_code FROM tbl_users WHERE userId = (SELECT created_by FROM tbl_manpower_team WHERE id = (SELECT manpower_team_id FROM tbl_manpower_team_members WHERE employee_id = \'' . $employee->employee_id . '\' ORDER BY id DESC limit 1))';
        $SupervisorInfo = $this->db->query($Supervisorquery)->row();
        $supervisorCode = ($SupervisorInfo) ? $SupervisorInfo->emp_code : '';
        $supervisorName = ($SupervisorInfo) ? $SupervisorInfo->name : '';
        $return_html .= '<td><button onclick="javascript:void(0)" type="button" class="btn btn-danger">Added in ' . $deptName . ' - ' . $shiftName . ' - Supervisor Name - ' . $supervisorName . '(' . $supervisorCode . ')</button></td>';
      }


      $return_html .= '</tr>';
    }

    $return_html .= '</tbody>';
    $return_html .= '</table>';

    $return_html .= '
        <script>
            $(\'#employees_to_add_table\').DataTable({
                columnDefs: [
                    { "targets": [4], "orderable": false, "searchable": false,"order":[[6,"DESC"]] }
                ],
                info: false,
                searching: true,
                lengthChange: false,
                aaSorting: [[6, "asc"]],
            });
        </script>
        ';

    echo $return_html;
  }

  function getEmployeesToBeAddedTableMarkup() {
    $employeeDeptId = $this->session->userdata('department_id');
    $departmentArray = utfDepartmentByOrg();
//pre($departmentArray);
    $query = '
        SELECT
            U.userId AS user_id,
            U.name AS employee_name,
            U.email AS employee_email,
            U.emp_id AS employee_id,
            U.emp_code AS employee_code,
            U.designation AS designation,
            (SELECT dept_name FROM tbl_departments WHERE dept_id=U.department_id) AS employee_department

        FROM
            tbl_users AS U
        WHERE
              U.current_status = "0" AND U.roleId = \'3\' AND isDeleted = 0 AND sub_department_id = ' . $departmentArray['id'] . '  AND U.organization_id = \'' . $this->organization_id . '\'

			AND
                (
        ';

    if ($this->input->post('employee_name_id_filter') == '' && $this->input->post('employee_name_id_filter') == '' && $this->input->post('employee_email_filter') == '' && $this->input->post('employee_code_filter') == '' && $this->input->post('employee_department_filter') == '') {

      $query .= ' 1=1 ';
    }

    $first_inner_filter = false;

    if ($this->input->post('employee_name_id_filter') != '') {

      if (!$first_inner_filter) {

        $first_inner_filter = true;

        $query .= '
                (
                    U.emp_id LIKE \'%' . $this->input->post('employee_name_id_filter') . '%\'
                OR
                    U.name LIKE \'%' . $this->input->post('employee_name_id_filter') . '%\'
                )
                ';
      } else {

        $query .= '
                AND
                (
                    U.emp_id LIKE \'%' . $this->input->post('employee_name_id_filter') . '%\'
                OR
                    U.name LIKE \'%' . $this->input->post('employee_name_id_filter') . '%\'
                )
                ';
      }
    }

    if ($this->input->post('employee_email_filter') != '') {

      if (!$first_inner_filter) {

        $first_inner_filter = true;

        $query .= '
                    U.email LIKE \'%' . $this->input->post('employee_email_filter') . '%\'
                ';
      } else {

        $query .= '
                AND
                    U.email LIKE \'%' . $this->input->post('employee_email_filter') . '%\'
                ';
      }
    }

    if ($this->input->post('employee_code_filter') != '') {

      if (!$first_inner_filter) {

        $first_inner_filter = true;

        $query .= '
                    U.emp_code LIKE \'%' . $this->input->post('employee_code_filter') . '%\'
                ';
      } else {

        $query .= '
                AND
                    U.emp_code LIKE \'%' . $this->input->post('employee_code_filter') . '%\'
                ';
      }
    }

    if ($this->input->post('employee_department_filter')) {

      if (!$first_inner_filter) {

        $first_inner_filter = true;

        $query .= '
                    U.department_id=\'' . $this->input->post('employee_department_filter') . '\'
                ';
      } else {

        $query .= '
                AND
                    U.department_id=\'' . $this->input->post('employee_department_filter') . '\'
                ';
      }
    }

    $query .= '
            )
            AND
                U.roleId!=1
        ';

//AND(SELECT COUNT(id) FROM tbl_manpower_team_members WHERE employee_id=U.userId AND manpower_team_id IN (SELECT id FROM tbl_manpower_team)) = 0
//(SELECT COUNT(id) FROM tbl_manpower_team_members WHERE employee_id=U.userId AND manpower_team_id IN (SELECT id FROM tbl_manpower_team WHERE date=\''.date('Y-m-d').'\'))=0


    $all_addable_employees = $this->db->query($query)->result();





    $return_html = '';

    if ($this->input->post('team_submitted') == 0) {

      $return_html .= '<div class="row"><div class="col-md-7"><h3>Add Team</h3></div> <div class="col-md-3 mt15"></div> <div class="col-md-2 mt15 text-right"><a class="btn btn-primary" href="javascript:void(0)" type="button" data-toggle="modal" data-target="#addorganizationModal" onclick="get_added_employees_table_markup();">Team Preview</a></div></div>';
    } else {

      $return_html .= '<h3>Employees To Add</h3>';
    }

    $return_html .= '<table id="employees_to_add_table" class="table table-striped listingtable">';
    $return_html .= '<thead>';
    $return_html .= '<tr class="listingtable-head">';
    $return_html .= '<th>Emp. ID</th>';
    $return_html .= '<th>Emp. Code</th>';

    $return_html .= '<th>Name</th>';
    $return_html .= '<th>Email</th>';
    $return_html .= '<th>Designation</th>';
    $return_html .= '<th>Department</th>';
    $return_html .= '<th>Actions</th>';
    $return_html .= '</tr>';
    $return_html .= '</thead>';
    $return_html .= '<tbody>';

    foreach ($all_addable_employees as $employee) {

      $return_html .= '<tr class="odd">';
      $return_html .= '<td>' . $employee->employee_id . '</td>';
      $return_html .= '<td>' . $employee->employee_code . '</td>';
      $return_html .= '<td>' . $employee->employee_name . '</td>';
      $return_html .= '<td>' . $employee->employee_email . '</td>';
      $return_html .= '<td>' . $employee->designation . '</td>';
      $return_html .= '<td>' . $employee->employee_department . '</td>';

      if ($employee->TeamMemberCount == 0) {

        $return_html .= '<td><button onclick="add_employee_to_team(\'' . $employee->user_id . '\');" type="button" class="btn btn-success">Add</button></td>';
      } else {

        $nwSQl = 'SELECT dept_name FROM tbl_departments WHERE dept_id=(SELECT department_id FROM tbl_manpower_team WHERE id = (SELECT manpower_team_id FROM tbl_manpower_team_members WHERE employee_id = \'' . $employee->employee_id . '\' ORDER BY id DESC limit 1))';

        $existindDept = $this->db->query($nwSQl)->row();

        $shiftSql = 'SELECT shift FROM tbl_manpower_team WHERE id = (SELECT manpower_team_id FROM tbl_manpower_team_members WHERE employee_id = \'' . $employee->employee_id . '\' ORDER BY id DESC limit 1)';

        $existShift = $this->db->query($shiftSql)->row();

        $deptName = ($existindDept) ? $existindDept->dept_name : '';

        $shiftName = ($existShift) ? $existShift->shift : '';

        $Supervisorquery = 'SELECT name,emp_id,emp_code FROM tbl_users WHERE userId = (SELECT created_by FROM tbl_manpower_team WHERE id = (SELECT manpower_team_id FROM tbl_manpower_team_members WHERE employee_id = \'' . $employee->employee_id . '\' ORDER BY id DESC limit 1))';
        $SupervisorInfo = $this->db->query($Supervisorquery)->row();
        $supervisorCode = ($SupervisorInfo) ? $SupervisorInfo->emp_code : '';
        $supervisorName = ($SupervisorInfo) ? $SupervisorInfo->name : '';
        $return_html .= '<td><button onclick="javascript:void(0)" type="button" class="btn btn-danger">Added in ' . $deptName . ' - ' . $shiftName . ' - Supervisor Name - ' . $supervisorName . '(' . $supervisorCode . ')</button></td>';
      }


      $return_html .= '</tr>';
    }

    $return_html .= '</tbody>';
    $return_html .= '</table>';

    $return_html .= '
        <script>
            $(\'#employees_to_add_table\').DataTable({
                columnDefs: [
                    { "targets": [4], "orderable": false, "searchable": false,"order":[[6,"DESC"]] }
                ],
                info: false,
                searching: true,
                lengthChange: false,
                aaSorting: [[6, "asc"]],
            });
        </script>
        ';

    echo $return_html;
  }

  function get_free_to_use_employees() {


    $employeeDeptId = $this->session->userdata('department_id');
//U.department_id='.$employeeDeptId.' AND U.roleId = \'3\'
//$this->session->set_userdata($sessionArray);
    $query = '
        SELECT
            U.userId AS user_id,
            U.name AS employee_name,
            U.email AS employee_email,
            U.emp_id AS employee_id,
            U.emp_code AS employee_code,
            U.designation AS designation,
            (SELECT dept_name FROM tbl_departments WHERE dept_id=U.department_id) AS employee_department,
            (SELECT COUNT(id) FROM tbl_manpower_team_members WHERE employee_id=U.userId AND manpower_team_id IN (SELECT id FROM tbl_manpower_team)) As TeamMemberCount
        FROM
            tbl_users AS U
        WHERE
              U.roleId = \'3\' AND isDeleted = 0 AND U.organization_id = \'' . $this->organization_id . '\'

			AND
                (
        ';

    if ($this->input->post('employee_name_id_filter') == '' && $this->input->post('employee_name_id_filter') == '' && $this->input->post('employee_email_filter') == '' && $this->input->post('employee_code_filter') == '' && $this->input->post('employee_department_filter') == '') {

      $query .= ' 1=1 ';
    }

    $first_inner_filter = false;

    if ($this->input->post('employee_name_id_filter') != '') {

      if (!$first_inner_filter) {

        $first_inner_filter = true;

        $query .= '
                (
                    U.emp_id LIKE \'%' . $this->input->post('employee_name_id_filter') . '%\'
                OR
                    U.name LIKE \'%' . $this->input->post('employee_name_id_filter') . '%\'
                )
                ';
      } else {

        $query .= '
                AND
                (
                    U.emp_id LIKE \'%' . $this->input->post('employee_name_id_filter') . '%\'
                OR
                    U.name LIKE \'%' . $this->input->post('employee_name_id_filter') . '%\'
                )
                ';
      }
    }

    if ($this->input->post('employee_email_filter') != '') {

      if (!$first_inner_filter) {

        $first_inner_filter = true;

        $query .= '
                    U.email LIKE \'%' . $this->input->post('employee_email_filter') . '%\'
                ';
      } else {

        $query .= '
                AND
                    U.email LIKE \'%' . $this->input->post('employee_email_filter') . '%\'
                ';
      }
    }

    if ($this->input->post('employee_code_filter') != '') {

      if (!$first_inner_filter) {

        $first_inner_filter = true;

        $query .= '
                    U.emp_code LIKE \'%' . $this->input->post('employee_code_filter') . '%\'
                ';
      } else {

        $query .= '
                AND
                    U.emp_code LIKE \'%' . $this->input->post('employee_code_filter') . '%\'
                ';
      }
    }

    if ($this->input->post('employee_department_filter')) {

      if (!$first_inner_filter) {

        $first_inner_filter = true;

        $query .= '
                    U.department_id=\'' . $this->input->post('employee_department_filter') . '\'
                ';
      } else {

        $query .= '
                AND
                    U.department_id=\'' . $this->input->post('employee_department_filter') . '\'
                ';
      }
    }

    $query .= '
            )
            AND
                U.roleId!=1 ORDER BY TeamMemberCount ASC
        ';

//AND(SELECT COUNT(id) FROM tbl_manpower_team_members WHERE employee_id=U.userId AND manpower_team_id IN (SELECT id FROM tbl_manpower_team)) = 0
//(SELECT COUNT(id) FROM tbl_manpower_team_members WHERE employee_id=U.userId AND manpower_team_id IN (SELECT id FROM tbl_manpower_team WHERE date=\''.date('Y-m-d').'\'))=0


    $all_addable_employees = $this->db->query($query)->result();





    $return_html = '';

    if ($this->input->post('team_submitted') == 0) {

      $return_html .= '<div class="row"><div class="col-md-7"><h3>Add Team</h3></div> <div class="col-md-3 mt15"></div> <div class="col-md-2 mt15 text-right"><a class="btn btn-primary" href="javascript:void(0)" type="button" data-toggle="modal" data-target="#addorganizationModal" onclick="get_added_employees_table_markup();">Team Preview</a></div></div>';
    } else {

      $return_html .= '<h3>Employees To Add</h3>';
    }

    $return_html .= '<table id="employees_to_add_table" class="table table-striped listingtable">';
    $return_html .= '<thead>';
    $return_html .= '<tr class="listingtable-head">';
    $return_html .= '<th>Emp. ID</th>';
    $return_html .= '<th>Emp. Code</th>';

    $return_html .= '<th>Name</th>';
    $return_html .= '<th>Email</th>';
    $return_html .= '<th>Designation</th>';
    $return_html .= '<th>Department</th>';
    $return_html .= '<th>Actions</th>';
    $return_html .= '</tr>';
    $return_html .= '</thead>';
    $return_html .= '<tbody>';

    foreach ($all_addable_employees as $employee) {

      $return_html .= '<tr class="odd">';
      $return_html .= '<td>' . $employee->employee_id . '</td>';
      $return_html .= '<td>' . $employee->employee_code . '</td>';
      $return_html .= '<td>' . $employee->employee_name . '</td>';
      $return_html .= '<td>' . $employee->employee_email . '</td>';
      $return_html .= '<td>' . $employee->designation . '</td>';
      $return_html .= '<td>' . $employee->employee_department . '</td>';

      if ($employee->TeamMemberCount == 0) {

        $return_html .= '<td><button onclick="add_employee_to_team(\'' . $employee->user_id . '\');" type="button" class="btn btn-success">Add</button></td>';
      } else {

        $nwSQl = 'SELECT dept_name FROM tbl_departments WHERE dept_id=(SELECT department_id FROM tbl_manpower_team WHERE id = (SELECT manpower_team_id FROM tbl_manpower_team_members WHERE employee_id = \'' . $employee->employee_id . '\' ORDER BY id DESC limit 1))';

        $existindDept = $this->db->query($nwSQl)->row();

        $shiftSql = 'SELECT shift FROM tbl_manpower_team WHERE id = (SELECT manpower_team_id FROM tbl_manpower_team_members WHERE employee_id = \'' . $employee->employee_id . '\' ORDER BY id DESC limit 1)';

        $existShift = $this->db->query($shiftSql)->row();

        $deptName = ($existindDept) ? $existindDept->dept_name : '';

        $shiftName = ($existShift) ? $existShift->shift : '';

        $Supervisorquery = 'SELECT name,emp_id,emp_code FROM tbl_users WHERE userId = (SELECT created_by FROM tbl_manpower_team WHERE id = (SELECT manpower_team_id FROM tbl_manpower_team_members WHERE employee_id = \'' . $employee->employee_id . '\' ORDER BY id DESC limit 1))';
        $SupervisorInfo = $this->db->query($Supervisorquery)->row();
        $supervisorCode = ($SupervisorInfo) ? $SupervisorInfo->emp_code : '';
        $supervisorName = ($SupervisorInfo) ? $SupervisorInfo->name : '';
        $return_html .= '<td><button onclick="javascript:void(0)" type="button" class="btn btn-danger">Added in ' . $deptName . ' - ' . $shiftName . ' - Supervisor Name - ' . $supervisorName . '(' . $supervisorCode . ')</button></td>';
      }


      $return_html .= '</tr>';
    }

    $return_html .= '</tbody>';
    $return_html .= '</table>';

    $return_html .= '
        <script>
            $(\'#employees_to_add_table\').DataTable({
                columnDefs: [
                    { "targets": [4], "orderable": false, "searchable": false,"order":[[6,"DESC"]] }
                ],
                info: false,
                searching: true,
                lengthChange: false,
                aaSorting: [[6, "asc"]],
            });
        </script>
        ';

    echo $return_html;
  }

  function add_employee_to_team() {
    $insert_data = array(
        'manpower_team_id' => $this->input->post('team_id'),
        'employee_id' => $this->input->post('employee_id')
    );
    $this->db->insert('tbl_manpower_team_members', $insert_data);
    echo 'success';
  }

  function addEmployeeToTeam() {
    $departmentByUserArray = departmentByUser($this->session->userdata('userId'));
//    $empId = $this->input->post('employee_id');
//    $update_data = array(
//        'department_id' => $this->session->userdata('department_id'),
//        'current_status' => 1,
//    );
//    $this->db->where('userId', $empId);
//    $this->db->update('tbl_users', $update_data);
//    echo 'success';
//pre($this->session->userdata());
    $departmentArray = utfDepartmentByOrg();
    if ($this->role == '4' && $departmentArray['id']) {
//echo 'jjj';
// die;
      $empId = $this->input->post('employee_id');
      $update_data = array(
          'sub_department_id' => $departmentByUserArray['sub_department_id'],
          'department_id' => $departmentByUserArray['department_id'],
          'current_status' => '1',
      );
      $this->db->where('userId', $empId);
      if ($this->db->update('tbl_users', $update_data)) {

        $update_data_log = array(
            'check_out' => date("Y-m-d h:i:s"),
            'status' => '0',
        );
        $this->db->where('user_id', $empId);
        $this->db->where('status', '1');
        $this->db->update('working_logs', $update_data_log);

        $insert_data = array(
            'user_id' => $empId,
            'superviser_id' => $this->session->userdata('userId'),
            'sub_dept_id ' => $departmentByUserArray['sub_department_id'],
            //'department_id' => $departmentByUserArray['department_id'],
            'check_in' => date("y-m-d h:i:s"),
            'status' => '1'
//'check_out' => date("d-m-Y h:i:s")
        );
        $this->db->insert('working_logs', $insert_data);
      }
      echo json_encode('success');
    } else {
      echo json_encode('fail');
    }
  }

  function remove_employee_from_team() {

    if ($this->role == '4') {
      $this->db->where('employee_id', $this->input->post('employee_id'))
              ->where('manpower_team_id', $this->input->post('team_id'))
              ->delete('tbl_manpower_team_members');

      echo json_encode('success');
    } else {

      echo json_encode('fail');
    }
  }

  function removeEmployeeFromTeam() {
//pre($this->session->userdata());
    $departmentArray = utfDepartmentByOrg();
    if ($this->role == '4' && $departmentArray['id']) {
      $empId = $this->input->post('employee_id');
      $update_data = array(
          'sub_department_id' => $departmentArray['id'],
          'department_id' => $departmentArray['dept_id'],
          'current_status' => '0',
      );
      $this->db->where('userId', $empId);
      if ($this->db->update('tbl_users', $update_data)) {

        $update_data_log = array(
            'check_out' => date("Y-m-d h:i:s"),
            'status' => '0',
        );
        $this->db->where('user_id', $empId);
        $this->db->where('status', '1');
        $this->db->update('working_logs', $update_data_log);
        $departmentByUserArray = departmentByUser($empId);
        $insert_data = array(
            'user_id' => $empId,
            'superviser_id' => $this->session->userdata('userId'),
            'sub_dept_id' => $departmentByUserArray['sub_department_id'],
            'check_in' => date("Y-m-d h:i:s"),
            'status' => '1'
//'check_out' => date("d-m-Y h:i:s")
        );
        $this->db->insert('working_logs', $insert_data);
      }
      echo json_encode('success');
    } else {
      echo json_encode('fail');
    }
  }

  function leaveEmployeeFromTeam() {
    $departmentArray = utfDepartmentByOrg();
    if ($this->role == '4' && $departmentArray['id']) {
      $empId = $this->input->post('employee_id');

      $update_data = array(
//'department_id' => $departmentArray['dept_id'],
          'current_status' => '2',
      );
      $this->db->where('userId', $empId);
//$this->db->update('tbl_users', $update_data);
      if ($this->db->update('tbl_users', $update_data)) {

        $this->db->where('user_id', $empId);
//$this->db->where('user_id', $empId);
        $this->db->delete('working_logs');
      }
      echo json_encode('success');
    } else {
      echo json_encode('fail');
    }
  }

  function get_added_employees_table_markup() {

    $userId = $this->session->userdata('userId');

    $all_departments = $this->db->select(array('dept_id', 'dept_name'))->from('tbl_departments')->get()->result();

    $clientClist = $this->db->from('tbl_clients')->get()->result();

    $searchString = ',';
    if (is_array($this->input->post('client'))) {
      $clientName = implode(',', $this->input->post('client'));
    } else {
      $clientName = $this->input->post('client');
    }



    $current_team_id = $this->db->select('id')
                    ->from('tbl_manpower_team')
                    ->where('department_id', $this->input->post('department_id'))
                    ->where('shift', $this->input->post('shift'))
//->where('created_by',$userId)
//->where('client', $clientName)
                    ->limit(1)
                    ->order_by('date', 'DESC')
                    ->get()->row()->id;
//echo $current_team_id; die;




    $teamshift = $this->db->select('shift')->from('tbl_manpower_team')->where('id', $current_team_id)->get()->row()->shift;

//$all_team_employees = $this->db->query('SELECT U.roleId AS user_role, U.userId AS user_id, U.name AS employee_name, U.email AS employee_email, U.emp_id AS employee_id, U.emp_code AS employee_code,U.department_id,(SELECT dept_name from `tbl_departments` where `dept_id`= department_id) as department_name FROM tbl_users AS U WHERE U.userId IN (SELECT employee_id FROM tbl_manpower_team_members WHERE manpower_team_id=(SELECT id FROM tbl_manpower_team WHERE department_id='.$this->input->post('department_id').' AND shift=\''.$this->input->post('shift').'\' AND client=\''.$clientName.'\' AND date=\''.date('Y-m-d').'\'))')->result();


    /*     * ***Old** */
    /* $all_team_employees = $this->db->query('SELECT U.roleId AS user_role,U.designation, U.userId AS user_id, U.name AS employee_name, U.email AS employee_email, U.emp_id AS employee_id, U.emp_code AS employee_code,U.department_id,(SELECT dept_name from `tbl_departments` where `dept_id`= department_id) as department_name FROM tbl_users AS U WHERE U.userId IN (SELECT employee_id FROM tbl_manpower_team_members WHERE shift_over = \'0\' AND manpower_team_id=(SELECT id FROM tbl_manpower_team WHERE created_by = '.$userId.' AND department_id='.$this->input->post('department_id').' AND shift=\''.$this->input->post('shift').'\'))')->result(); */

    $all_team_employees = $this->db->query('SELECT U.roleId AS user_role,U.designation, U.userId AS user_id, U.name AS employee_name, U.email AS employee_email, U.emp_id AS employee_id, U.emp_code AS employee_code,U.department_id,(SELECT dept_name from `tbl_departments` where `dept_id`= department_id) as department_name FROM tbl_users AS U WHERE U.userId IN (SELECT employee_id FROM tbl_manpower_team_members WHERE shift_over = \'0\' AND manpower_team_id=(SELECT id FROM tbl_manpower_team WHERE department_id=' . $this->input->post('department_id') . ' AND shift=\'' . $this->input->post('shift') . '\'))')->result();


    $return_html = '<h3>Team Members</h3>';
    $return_html .= '<table id="added_employees_table" class="table table-striped listingtable">';
    $return_html .= '<thead>';
    $return_html .= '<tr class="listingtable-head">';
    $return_html .= '<th>Name</th>';
    $return_html .= '<th>Emp. ID</th>';
    $return_html .= '<th>Emp. Code</th>';
    $return_html .= '<th>Designation</th>';
    $return_html .= '<th>Email</th>';
    $return_html .= '<th>Department</th>';
    $return_html .= '<th>Actions</th>';
    $return_html .= '</ tr>';
    $return_html .= '</head>';
    $return_html .= '<tbody>';

    foreach ($all_team_employees as $team_employee) {

      $return_html .= '<tr class="odd">';
      $return_html .= '<td>' . $team_employee->employee_name . '</td>';
      $return_html .= '<td>' . $team_employee->employee_id . '</td>';
      $return_html .= '<td>' . $team_employee->employee_code . '</td>';
      $return_html .= '<td>' . $team_employee->designation . '</td>';
      $return_html .= '<td>' . $team_employee->employee_email . '</td>';
      $return_html .= '<td>' . $team_employee->department_name . '</td>';


      $empUserId = $team_employee->user_id;
//$current_team_id

      $shiftInfo = $this->db->select('shift_date,shift_status,shift_over')->from('tbl_manpower_team_members')->where('manpower_team_id', $current_team_id)->where('employee_id', $empUserId)->get()->row();
      $shiftStatus = $shiftInfo->shift_status;

      if ($this->input->post('from_view_team_page') == 'true' || ($userId == $team_employee->user_id) || $team_employee->user_role == '4') {
        $overHtml = '';
        if ($shiftStatus == '1') {
          $overHtml = '<button class="btn btn-info btn-xs" onclick="shiftOver(\'' . $empUserId . '\',\'' . $current_team_id . '\')">Shift Over</button>';
        }

        $return_html .= '
                <td>
                    <button style="display:none" type="button" class="btn btn-success" data-toggle="modal" onclick="$(\'#shift_team_employee_id\').val(\'' . $team_employee->user_id . '\'); $(\'#shift_team_time_hour\').val(\'\'); $(\'#shift_team_time_minute\').val(\'\');" data-target="#shift_team_modal">Shift Member</button>
                ' . $overHtml . '</td>';
      } else {



        /* $chkshift = $this->db->select('id')->where('manpower_team_id',$current_team_id)->where('employee_id',$empUserId)->where("shifted_manpower_team_id","0")->where("shift_over","0")->where("return_status","0")->where('shift_date',date('Y-m-d'))->order_by('id','DESC')->limit(1)->get('tbl_manpower_team_members')->num_rows(); */

        $chkshift = $this->db->select('id')->where('employee_id', $empUserId)->where("shifted_manpower_team_id", "0")->where("shift_status", "1")->where("shift_over", "0")->where('shift_date', date('Y-m-d'))->limit(1)->get('tbl_manpower_team_members')->num_rows();



        if ($shiftStatus == '1' || $chkshift != 0) {
          $return_html .= '
                            <td>
                                <button type="button" onclick="remove_employee_from_team(\'' . $team_employee->user_id . '\');" class="btn btn-danger"><i class="fa fa-trash"></i></button>
                             </td>';
        } else {


          $return_html .= '
                    <td>
                        <button type="button" onclick="remove_employee_from_team(\'' . $team_employee->user_id . '\');" class="btn btn-danger"><i class="fa fa-trash"></i></button>
                        <button type="button" class="btn btn-success" data-toggle="modal" onclick="$(\'#shift_team_employee_id\').val(\'' . $team_employee->user_id . '\'); $(\'#shift_team_time_hour\').val(\'\'); $(\'#shift_team_department\').val(\'\'); $(\'#shift_team_shift\').val(\'\'); $(\'#shift_team_client\').val(\'\'); $(\'#response_message_div\').html(\'\');  $(\'#shift_team_time_minute\').val(\'\');" data-target="#shift_team_modal">Shift Member</button>
                    </td>';
        }
      }

      $return_html .= '</tr>';
    }

    $return_html .= '</tbody>';
    $return_html .= '</table>';

    /* $return_html .= '
      <div id="shift_team_modal123" class="modal fade" role="dialog">
      <div class="modal-dialog">

      <!-- Modal content-->
      <div class="modal-content">
      <div class="modal-header">
      <button type="button" class="close" onclick="$(\'#shift_team_modal\').modal(\'hide\');">&times;</button>
      <h4 class="modal-title">Shift Team</h4>
      </div>
      <div class="modal-body">
      <div class="row">
      <div class="col-xs-12">

      <div id="response_message_div"></div>

      <input type="hidden" id="shift_team_employee_id">

      <div class="form-group" id="shift_team_department_div">
      <label class="control-label">Select Department <sup>*<sup></label>
      <span class="help-block" id="shift_team_department_error"></span>
      <select id="shift_team_department" name="department" class="form-control">
      <option value="">--Select--</option>';

      foreach ($all_departments as $department) {

      $return_html .= '<option value="'.$department->dept_id.'">'.$department->dept_name.'</option>';
      }

      $return_html .= '</select>
      </div>
      <div class="form-group" id="shift_team_shift_div">
      <label class="control-label">Select Shift <sup>*</sup></label>
      <span class="help-block" id="shift_team_shift_error"></span>
      <select class="form-control" id="shift_team_shift" name="shift">
      <option value="">--Select--</option>';
      if($teamshift != ''){
      $return_html .= '<option value="'.$teamshift.'">'.$teamshift.'</option>';
      }
      $return_html .= '</select>
      </div>
      <div class="form-group" id="shift_team_client_div">
      <label class="control-label">Select Client <sup>*</sup></label>
      <span class="help-block" id="shift_team_client_error"></span>
      <select class="form-control" id="shift_team_client" name="client">

      <option value="">--Select--</option>
      ';
      if(!empty($clientClist)){
      foreach ($clientClist as $client){
      $return_html .= '<option value="'.$client->client.'">'.$client->client.'</option>';
      }
      }
      $return_html .= '</select>
      </div>
      <div class="form-group" id="shift_team_time_div">
      <label class="control-label">Select Time</label>
      <span class="help-block" id="shift_team_time_error"></span>
      <select class="form-control" id="shift_team_time_hour" style="float: left; width: 30%;">
      <option value="">--Select--</option>
      <option value="01">01</option>
      <option value="02">02</option>
      <option value="03">03</option>
      <option value="04">04</option>
      <option value="05">05</option>
      <option value="06">06</option>
      <option value="07">07</option>
      <option value="08">08</option>
      <option value="09">09</option>
      <option value="10">10</option>
      <option value="11">11</option>
      <option value="12">12</option>
      <option value="13">13</option>
      <option value="14">14</option>
      <option value="15">15</option>
      <option value="16">16</option>
      <option value="17">17</option>
      <option value="18">18</option>
      <option value="19">19</option>
      <option value="20">20</option>
      <option value="21">21</option>
      <option value="22">22</option>
      <option value="23">23</option>
      <option value="24">24</option>
      </select>

      <span style="float:left; text-align: center; width: 5%;"> : </span>

      <select class="form-control" id="shift_team_time_minute" style="width: 30%; float: left">
      <option value="">--Select--</option>
      <option value="00">00</option>
      <option value="05">05</option>
      <option value="10">10</option>
      <option value="15">15</option>
      <option value="20">20</option>
      <option value="25">25</option>
      <option value="30">30</option>
      <option value="35">35</option>
      <option value="40">40</option>
      <option value="45">45</option>
      <option value="50">50</option>
      <option value="55">55</option>
      </select>

      <div style="clear:both;"></div>
      </div>
      <div class="form-group">
      <button type="button" class="btn btn-success" onclick="submit_shift_team_request();">Submit Request</button>
      </div>
      </div>
      </div>
      </div>
      <div class="modal-footer">
      <button type="button" class="btn btn-default" onclick="$(\'#shift_team_modal\').modal(\'hide\');">Close</button>
      </div>
      </div>
      </div>
      </div>';
     */


    echo $return_html;
  }

  function getAddedEmployeesTableMarkup() {
    $disabled = " ";
    $disabledTest = "Leave";

//pre($this->session->userdata());

    $userId = $this->session->userdata('userId');
    $departmentId = $this->session->userdata('department_id');
    $subDepartmentId = $this->session->userdata('sub_department_id');
    $orgId = $this->session->userdata('organization_id');

    $all_departments = $this->db->select(array('dept_id', 'dept_name'))->from('tbl_departments')->get()->result();

    $clientClist = $this->db->from('tbl_clients')->get()->result();

    $searchString = ',';
    if (is_array($this->input->post('client'))) {
      $clientName = implode(',', $this->input->post('client'));
    } else {
      $clientName = $this->input->post('client');
    }



    $current_team_id = $this->db->select('id')
                    ->from('tbl_manpower_team')
                    ->where('department_id', $this->input->post('department_id'))
                    ->where('shift', $this->input->post('shift'))
//->where('created_by',$userId)
//->where('client', $clientName)
                    ->limit(1)
                    ->order_by('date', 'DESC')
                    ->get()->row()->id;
//echo $current_team_id; die;




    $teamshift = $this->db->select('shift')->from('tbl_manpower_team')->where('id', $current_team_id)->get()->row()->shift;

//$all_team_employees = $this->db->query('SELECT U.roleId AS user_role, U.userId AS user_id, U.name AS employee_name, U.email AS employee_email, U.emp_id AS employee_id, U.emp_code AS employee_code,U.department_id,(SELECT dept_name from `tbl_departments` where `dept_id`= department_id) as department_name FROM tbl_users AS U WHERE U.userId IN (SELECT employee_id FROM tbl_manpower_team_members WHERE manpower_team_id=(SELECT id FROM tbl_manpower_team WHERE department_id='.$this->input->post('department_id').' AND shift=\''.$this->input->post('shift').'\' AND client=\''.$clientName.'\' AND date=\''.date('Y-m-d').'\'))')->result();


    /*     * ***Old** */
    /* $all_team_employees = $this->db->query('SELECT U.roleId AS user_role,U.designation, U.userId AS user_id, U.name AS employee_name, U.email AS employee_email, U.emp_id AS employee_id, U.emp_code AS employee_code,U.department_id,(SELECT dept_name from `tbl_departments` where `dept_id`= department_id) as department_name FROM tbl_users AS U WHERE U.userId IN (SELECT employee_id FROM tbl_manpower_team_members WHERE shift_over = \'0\' AND manpower_team_id=(SELECT id FROM tbl_manpower_team WHERE created_by = '.$userId.' AND department_id='.$this->input->post('department_id').' AND shift=\''.$this->input->post('shift').'\'))')->result(); */
    $selectQuery = 'SELECT '
            . '  '
            . 'U.roleId AS user_role,'
            . 'U.designation, '
            . 'U.userId AS user_id, '
            . 'U.name AS employee_name, '
            . 'U.email AS employee_email, '
            . 'U.emp_id AS employee_id, '
            . 'U.emp_code AS employee_code,'
            . 'U.department_id, U.current_status, '
            . '(SELECT dept_name from `tbl_departments` where `dept_id`= department_id) as department_name, '
            . '(SELECT sub_dept_name from `tbl_sub_departments` where `id`= sub_department_id) as sub_department_name FROM tbl_users AS U '
            . 'WHERE U.userId != ' . $userId . ' AND U.current_status != 0 AND U.sub_department_id = ' . $subDepartmentId . ' AND U.department_id = ' . $departmentId . ' and organization_id = ' . $orgId;
//die;
    $all_team_employees = $this->db->query($selectQuery)->result();
//pre($all_team_employees);


    $return_html = '<h3>Team Members</h3>';
    $return_html .= '<table id="added_employees_table" class="table table-striped listingtable">';
    $return_html .= '<thead>';
    $return_html .= '<tr class="listingtable-head">';
    $return_html .= '<th>Name</th>';
    $return_html .= '<th>Emp. ID</th>';
    $return_html .= '<th>Emp. Code</th>';
//    $return_html .= '<th>Designation</th>';
    $return_html .= '<th>Email</th>';
    $return_html .= '<th>Department</th>';
    $return_html .= '<th>Actions</th>';
    $return_html .= '</ tr>';
    $return_html .= '</head>';
    $return_html .= '<tbody>';

    foreach ($all_team_employees as $team_employee) {
      $onclickRemove = 'onclick="remove_employee_from_team(\'' . $team_employee->user_id . '\');"';
      $oncliclLeave = 'onclick="leave_employee_from_team(\'' . $team_employee->user_id . '\');"';
      if ($team_employee->current_status == 2) {
        $disabled = " disabled";
        $disabledTest = "On Leave";
        $oncliclLeave = '';
        $onclickRemove = '';
      }

      $return_html .= '<tr class="odd">';
      $return_html .= '<td>' . $team_employee->employee_name . '</td>';
      $return_html .= '<td>' . '#' . sprintf("%'.07d\n", $team_employee->user_id) . '</td>';
      $return_html .= '<td>' . $team_employee->employee_code . '</td>';
//      $return_html .= '<td>' . $team_employee->designation . '</td>';
      $return_html .= '<td>' . $team_employee->employee_email . '</td>';
      $return_html .= '<td>' . $team_employee->department_name . '</td>';


      $empUserId = $team_employee->user_id;
//$current_team_id

      $shiftInfo = $this->db->select('shift_date,shift_status,shift_over')->from('tbl_manpower_team_members')->where('manpower_team_id', $current_team_id)->where('employee_id', $empUserId)->get()->row();
      $shiftStatus = $shiftInfo->shift_status;

      if ($this->input->post('from_view_team_page') == 'true' || ($userId == $team_employee->user_id) || $team_employee->user_role == '4') {
        $overHtml = '';
        if ($shiftStatus == '1') {
          $overHtml = '<button class="btn btn-info btn-xs" onclick="shiftOver(\'' . $empUserId . '\',\'' . $current_team_id . '\')">Shift Over</button>';
        }

        $return_html .= '
                <td>
                    <button style="display:none" type="button" class="btn btn-success" data-toggle="modal" onclick="$(\'#shift_team_employee_id\').val(\'' . $team_employee->user_id . '\'); $(\'#shift_team_time_hour\').val(\'\'); $(\'#shift_team_time_minute\').val(\'\');" data-target="#shift_team_modal">Shift Member</button>
                ' . $overHtml . '</td>';
      } else {



        /* $chkshift = $this->db->select('id')->where('manpower_team_id',$current_team_id)->where('employee_id',$empUserId)->where("shifted_manpower_team_id","0")->where("shift_over","0")->where("return_status","0")->where('shift_date',date('Y-m-d'))->order_by('id','DESC')->limit(1)->get('tbl_manpower_team_members')->num_rows(); */

        $chkshift = $this->db->select('id')->where('employee_id', $empUserId)->where("shifted_manpower_team_id", "0")->where("shift_status", "1")->where("shift_over", "0")->where('shift_date', date('Y-m-d'))->limit(1)->get('tbl_manpower_team_members')->num_rows();



        if ($shiftStatus == '1' || $chkshift != 0) {
          $return_html .= '
                            <td>
                                <button type="button" onclick="remove_employee_from_team(\'' . $team_employee->user_id . '\');" class="btn btn-danger"><i class="fa fa-trash"></i></button>
                             </td>';
        } else {


          $return_html .= '
                    <td>
                        <button type="button" ' . $onclickRemove . ' class="btn btn-danger' . $disabled . '">Release</button>
                        <button type="button" ' . $oncliclLeave . ' class="btn btn-danger' . $disabled . '">' . $disabledTest . '</button>

                    </td>';
        }
      }

      $return_html .= '</tr>';
      $disabledTest = "Leave";
      $disabled = " ";
    }

    $return_html .= '</tbody>';
    $return_html .= '</table>';

    /* $return_html .= '
      <div id="shift_team_modal123" class="modal fade" role="dialog">
      <div class="modal-dialog">

      <!-- Modal content-->
      <div class="modal-content">
      <div class="modal-header">
      <button type="button" class="close" onclick="$(\'#shift_team_modal\').modal(\'hide\');">&times;</button>
      <h4 class="modal-title">Shift Team</h4>
      </div>
      <div class="modal-body">
      <div class="row">
      <div class="col-xs-12">

      <div id="response_message_div"></div>

      <input type="hidden" id="shift_team_employee_id">

      <div class="form-group" id="shift_team_department_div">
      <label class="control-label">Select Department <sup>*<sup></label>
      <span class="help-block" id="shift_team_department_error"></span>
      <select id="shift_team_department" name="department" class="form-control">
      <option value="">--Select--</option>';

      foreach ($all_departments as $department) {

      $return_html .= '<option value="'.$department->dept_id.'">'.$department->dept_name.'</option>';
      }

      $return_html .= '</select>
      </div>
      <div class="form-group" id="shift_team_shift_div">
      <label class="control-label">Select Shift <sup>*</sup></label>
      <span class="help-block" id="shift_team_shift_error"></span>
      <select class="form-control" id="shift_team_shift" name="shift">
      <option value="">--Select--</option>';
      if($teamshift != ''){
      $return_html .= '<option value="'.$teamshift.'">'.$teamshift.'</option>';
      }
      $return_html .= '</select>
      </div>
      <div class="form-group" id="shift_team_client_div">
      <label class="control-label">Select Client <sup>*</sup></label>
      <span class="help-block" id="shift_team_client_error"></span>
      <select class="form-control" id="shift_team_client" name="client">

      <option value="">--Select--</option>
      ';
      if(!empty($clientClist)){
      foreach ($clientClist as $client){
      $return_html .= '<option value="'.$client->client.'">'.$client->client.'</option>';
      }
      }
      $return_html .= '</select>
      </div>
      <div class="form-group" id="shift_team_time_div">
      <label class="control-label">Select Time</label>
      <span class="help-block" id="shift_team_time_error"></span>
      <select class="form-control" id="shift_team_time_hour" style="float: left; width: 30%;">
      <option value="">--Select--</option>
      <option value="01">01</option>
      <option value="02">02</option>
      <option value="03">03</option>
      <option value="04">04</option>
      <option value="05">05</option>
      <option value="06">06</option>
      <option value="07">07</option>
      <option value="08">08</option>
      <option value="09">09</option>
      <option value="10">10</option>
      <option value="11">11</option>
      <option value="12">12</option>
      <option value="13">13</option>
      <option value="14">14</option>
      <option value="15">15</option>
      <option value="16">16</option>
      <option value="17">17</option>
      <option value="18">18</option>
      <option value="19">19</option>
      <option value="20">20</option>
      <option value="21">21</option>
      <option value="22">22</option>
      <option value="23">23</option>
      <option value="24">24</option>
      </select>

      <span style="float:left; text-align: center; width: 5%;"> : </span>

      <select class="form-control" id="shift_team_time_minute" style="width: 30%; float: left">
      <option value="">--Select--</option>
      <option value="00">00</option>
      <option value="05">05</option>
      <option value="10">10</option>
      <option value="15">15</option>
      <option value="20">20</option>
      <option value="25">25</option>
      <option value="30">30</option>
      <option value="35">35</option>
      <option value="40">40</option>
      <option value="45">45</option>
      <option value="50">50</option>
      <option value="55">55</option>
      </select>

      <div style="clear:both;"></div>
      </div>
      <div class="form-group">
      <button type="button" class="btn btn-success" onclick="submit_shift_team_request();">Submit Request</button>
      </div>
      </div>
      </div>
      </div>
      <div class="modal-footer">
      <button type="button" class="btn btn-default" onclick="$(\'#shift_team_modal\').modal(\'hide\');">Close</button>
      </div>
      </div>
      </div>
      </div>';
     */


    echo $return_html;
  }

  public function update_shift_over() {
    $empId = $this->input->post('empId');
    $teamId = $this->input->post('teamId');

    $this->db->where(['manpower_team_id' => $teamId, 'employee_id' => $empId]);
    $this->db->update('tbl_manpower_team_members', ['shift_over' => '1']);

    /*     * Update main team table */
    $this->db->where(['employee_id' => $empId, 'request_approved' => '1']);
    $this->db->where("shifted_manpower_team_id != '0'");
    $this->db->update('tbl_manpower_team_members', ['return_status' => '1']);

    echo json_encode('shiftupdated');
  }

  public function approve_team_shift($request_token) {

    $shift_request_details = $this->db->select('*')->from('tbl_manpower_team_members')->where('request_token', $request_token)->get()->row();

    $this->db->where('id', $shift_request_details->id)
            ->update('tbl_manpower_team_members', array('request_approved' => 1, 'return_status' => '1'));

    $insert_data['manpower_team_id'] = $shift_request_details->shifted_manpower_team_id;
    $insert_data['employee_id'] = $shift_request_details->employee_id;
    $insert_data['shift_date'] = date('Y-m-d');
    $insert_data['shift_status'] = '1';
    $this->db->insert('tbl_manpower_team_members', $insert_data);

    $this->session->set_flashdata('message', '<div class="alert alert-success"><b>Success!</b> Shift Change Approved Successfully.</div>');

    redirect('view-team');
  }

  public function check_and_send_shift_team_request() {



    $team_check_query = $this->db->select(array('id', 'created_by'))
            ->from('tbl_manpower_team')
            ->where('department_id', $this->input->post('department_id'))
            ->where('shift', $this->input->post('shift'))
//->where('client', $this->input->post('client'))
// ->where('date', date('Y-m-d'))
            ->where('created_by != ', $this->session->userdata('userId'))
            ->get();



    if ($team_check_query->num_rows()) {

      $new_team_id = $team_check_query->row()->id;

      $new_team_creator_id = $team_check_query->row()->created_by;

      $new_team_creator_email_name = $this->db->select(array('email', 'name'))->from('tbl_users')->where('userId', $new_team_creator_id)->get()->row();

      $current_team_creator_name = $this->db->select('name')->from('tbl_users')->where('userId', $this->session->userdata('userId'))->get()->row()->name;

      $employee_details = $this->db->select('*')->from('tbl_users')->where('userId', $this->input->post('employee_id'))->get()->row();

      $update_data['shift_request_time'] = time();

      $request_token = $update_data['request_token'] = (string) ((int) time() + (int) rand());

      $update_data['shifted_manpower_team_id'] = $new_team_id;

      $update_data['new_shift_start_date_time'] = date('Y-m-d') . ' ' . $this->input->post('shift_team_time_hour') . ':' . $this->input->post('shift_team_time_minute') . ':00';

      $update_data['shift_date'] = date('Y-m-d');

      $update_data['return_status'] = '0';

      $this->db->where('manpower_team_id', $this->input->post('current_team_id'))
              ->where('employee_id', $this->input->post('employee_id'))
              ->update('tbl_manpower_team_members', $update_data);

//echo $this->db->last_query();die;

      $to = $new_team_creator_email_name->email;
//$to = 'dileepr98@gmail.com';
      $subject = 'Employee Team Shift Request';
      $headers = "From: " . strip_tags('support@.com') . "\r\n";
      $headers .= "Reply-To: " . strip_tags('support@.com') . "\r\n";
      $headers .= "MIME-Version: 1.0\r\n";
      $headers .= "Content-Type: text/html; charset=UTF-8\r\n";

      $message = '<p>Hi ' . $new_team_creator_email_name->name . '</p>';
      $message .= '<p>Supervisor ' . $current_team_creator_name . ' has request for the following employee to be shifted to your team :-</p>';
      $message .= '
            <p>
                Employee Name : ' . $employee_details->name . '<br>
                Employee ID : ' . $employee_details->emp_id . '<br>
                Employee Code : ' . $employee_details->emp_code . '<br>
                Employee Designation : ' . $employee_details->designation . '
            </p>
            ';
      $message .= '<p>Please click on this <a href="' . base_url('approve_team_shift/' . $request_token) . '">link</a> to approve the team shift for the employee.</p>';

      $message .= '<p>Best Regards,<br>Team .</p>';

//mail($to, $subject, $message, $headers);

      $mailData['to'] = $to;
      $mailData['subject'] = $subject;
      $mailData['message'] = $message;

      /*       * *****Send Shift Mail********** */
      sendShiftMemberMail($mailData);

//echo base_url('approve_team_shift/'.$request_token); die;
      echo '<div class="alert alert-success">Request Sent Successfully</div>';
    } else {

      echo '<div class="alert alert-danger">No team created for given department and shift.</div>';
    }
  }

  protected function getAvialableShift() {
    $userId = $this->session->userdata('userId');
    $result = array();
    $this->db->select('shift');
    $this->db->where('department_id', $this->session->userdata('department_id'));
//$this->db->where('date', date('Y-m-d'));
    $this->db->where("created_by != '" . $userId . "'");
    $this->db->where("shift != ''");
    $this->db->group_by('shift');
    $shiftList = $this->db->get('tbl_manpower_team')->result_array();
    if (!empty($shiftList)) {
      foreach ($shiftList as $shift) {
        $result[] = $shift['shift'];
      }
    }
    return $result;
  }

  /** This function will be useful only for the first time when the supervisor visits the create team page. */
  protected function create_team_and_add_supervisor_if_team_does_not_exist() {

    $userId = $this->session->userdata('userId');
    $shift = $this->session->userdata('shift');
//$team_already_exists_query = $this->db->select('id')->from('tbl_manpower_team')->where('created_by',$userId)->where('department_id', $this->session->userdata('department_id'))->where('date', date('Y-m-d'))->get();

    /* $team_already_exists_query = $this->db->select('id')->from('tbl_manpower_team')->where('created_by',$userId)->where('department_id', $this->session->userdata('department_id'))->limit(1)->order_by('date','DESC')->get(); */

    $team_already_exists_query = $this->db->select('id')->from('tbl_manpower_team')->where('shift', $shift)->where('department_id', $this->session->userdata('department_id'))->limit(1)->order_by('date', 'DESC')->get();


    if (!$team_already_exists_query->num_rows()) {


      $insert_data = array(
          'department_id' => $this->session->userdata('department_id'),
          'shift' => $shift,
          'client' => '',
          'date' => date('Y-m-d'),
          'creation_time' => time(),
          'created_by' => $this->session->userdata('userId')
      );

      $this->db->insert('tbl_manpower_team', $insert_data);

      $team_id = $this->db->insert_id();

      $insert_data = array(
          'manpower_team_id' => $team_id,
          'employee_id' => $this->session->userdata('userId')
      );

      $this->db->insert('tbl_manpower_team_members', $insert_data);

      return $team_id;




      /*       * **************Check same department and shift team exist *************** */

      /* $this->db->select('id,created_by');
        $this->db->where('department_id',$this->session->userdata('department_id'));
        $this->db->where('shift',$shift);
        $this->db->order_by('id','DESC');
        $prevTeam = $this->db->get('tbl_manpower_team')->row();

        if(empty($prevTeam)){


        $insert_data = array(
        'department_id' => $this->session->userdata('department_id'),
        'shift' => $shift,
        'client' => '',
        'date' => date('Y-m-d'),
        'creation_time' => time(),
        'created_by' => $this->session->userdata('userId')
        );

        $this->db->insert('tbl_manpower_team', $insert_data);

        $team_id = $this->db->insert_id();

        $insert_data = array(
        'manpower_team_id' => $team_id,
        'employee_id' => $this->session->userdata('userId')
        );

        $this->db->insert('tbl_manpower_team_members', $insert_data);

        return $team_id;


        }else{


        $previousTeamId = $prevTeam->id;
        $previousSupervisor = $prevTeam->created_by;

        $this->db->select('employee_id');
        $this->db->where('manpower_team_id',$previousTeamId);
        $this->db->where_not_in('employee_id',[$previousSupervisor]);
        $previousTeamMember = $this->db->get('tbl_manpower_team_members')->result_array();


        $insert_data = array(
        'department_id' => $this->session->userdata('department_id'),
        'shift' => $shift,
        'client' => '',
        'team_submitted'=>'1',
        'date' => date('Y-m-d'),
        'creation_time' => time(),
        'created_by' => $this->session->userdata('userId')
        );

        $this->db->insert('tbl_manpower_team', $insert_data);
        $team_id = $this->db->insert_id();

        $insert_data = array(
        'manpower_team_id' => $team_id,
        'employee_id' => $this->session->userdata('userId')
        );

        $this->db->insert('tbl_manpower_team_members', $insert_data);

        if(!empty($previousTeamMember)){
        foreach ($previousTeamMember as $key => $emp) {
        $insert_data1 = array(
        'manpower_team_id' => $team_id,
        'employee_id' => $emp['employee_id']
        );

        $this->db->insert('tbl_manpower_team_members', $insert_data1);
        }
        }

        return $team_id;


        } */
    } else {

      $this->db->where('id', $team_already_exists_query->row()->id);
      $this->db->update('tbl_manpower_team', ['shift' => $shift]);


      return $team_already_exists_query->row()->id;
    }
  }

  function save_shift_post() {

    $update_data['shift'] = $this->input->post('shift');
    $this->db->where('id', $this->input->post('team_id'));
    $this->db->update('tbl_manpower_team', $update_data);

    $this->session->set_flashdata('message', '<div class="alert alert-success"><b>Success!</b> Shift Saved Successfully.</div>');

    redirect('create-team');
  }

  function save_client_post() {
    $clients = implode(",", $this->input->post('client'));
    $update_data['client'] = $clients;
    $this->db->where('id', $this->input->post('team_id'));
    $this->db->update('tbl_manpower_team', $update_data);

    $this->session->set_flashdata('message', '<div class="alert alert-success"><b>Success!</b> Client Saved Successfully.</div>');

    redirect('create-team');
  }

  function view_manager_team() {

    $userId = $this->session->userdata('userId');
    $departmentId = $this->session->userdata('department_id');
    $orgId = $this->session->userdata('organization_id');


    if ($this->role != 2 && $this->role != 8) {
      $this->loadThis();
    } else {

      $this->db->select('id,shift');
      $this->db->where('department_id', $departmentId);
      $this->db->where('team_submitted', '1');
      $teamList = $this->db->get('tbl_manpower_team')->result_array();
      $data['teamList'] = $teamList;


      $warehouseList = $this->user_model->getOrganizationList($orgId);

      $data['warehouseList'] = $warehouseList;
      $data['department_id'] = $departmentId;
      $data['client_list'] = $this->db->from('tbl_clients')->get()->result_array();
      $data['departmentList'] = $this->user_model->getDepartmentList($orgId);
      $data['role'] = $this->role;
      $this->loadViews("manpower_view_team_new", $this->global, $data, NULL);
    }
  }

  function getDepartmentShift() {
    if (!$this->input->is_ajax_request()) {
      exit('No direct script access allowed');
    }
    $deptId = $this->input->post('deptId');
    $this->db->select('id,shift');
    $this->db->where('team_submitted', '1');
    $this->db->where('department_id', $deptId);
    $result = $this->db->get('tbl_manpower_team')->result_array();

    echo json_encode($result);
    exit;
  }

  function getRequestEmployeeList() {
    if (!$this->input->is_ajax_request()) {
      exit('No direct script access allowed');
    }
    $userId = $this->session->userdata('userId');
    $organization_id = $this->session->userdata('organization_id');
    $department_id = $this->session->userdata('department_id');
    $shift = $this->session->userdata('shift');
    if ($this->input->post('shift')) {
      $shift = $this->input->post('shift');
    }
    $this->db->select('created_by');
    $this->db->where(['department_id' => $department_id, 'shift' => $shift, 'team_submitted' => '1']);
    $created_by = $this->db->get('tbl_manpower_team')->row()->created_by;
    $this->db->select('id');
    $this->db->where('department_id', $department_id);
    $this->db->where('shift', $shift);
    $this->db->where('team_submitted', '1');
    $this->db->where('created_by', $created_by);
    $teamId = $this->db->get('tbl_manpower_team')->row()->id;
    $draw = intval($this->input->post("draw"));
    $start = intval($this->input->post("start"));
    $length = intval($this->input->post("length"));
    $search = $this->input->post('search[value]');
    $this->db->where('shifted_manpower_team_id', $teamId);
    $this->db->where('shift_date', date('Y-m-d'));
    $this->db->from('tbl_manpower_team_members');
    $this->db->join('tbl_users', 'tbl_users.userId=tbl_manpower_team_members.employee_id');
    $this->db->join('tbl_manpower_team', 'tbl_manpower_team.id=tbl_manpower_team_members.manpower_team_id');
    $this->db->join('tbl_departments', 'tbl_departments.dept_id=tbl_users.department_id');
    $totalrows = $this->db->get()->num_rows();
    $this->db->select('tbl_users.name,tbl_users.emp_code,tbl_users.designation,tbl_departments.dept_name,tbl_manpower_team.shift,tbl_manpower_team_members.shift_date,tbl_manpower_team_members.request_approved,tbl_manpower_team_members.return_status,tbl_manpower_team_members.request_token');
    $this->db->where('shifted_manpower_team_id', $teamId);
    $this->db->where('shift_date', date('Y-m-d'));
    $this->db->from('tbl_manpower_team_members');
    $this->db->join('tbl_users', 'tbl_users.userId=tbl_manpower_team_members.employee_id');
    $this->db->join('tbl_manpower_team', 'tbl_manpower_team.id=tbl_manpower_team_members.manpower_team_id');
    $this->db->join('tbl_departments', 'tbl_departments.dept_id=tbl_users.department_id');
    $this->db->limit($length, $start);
    $query = $this->db->get();
    $filterrecord = $query->num_rows();
    $results = $query->result_array();
    $data = array();
    if (!empty($results)) {
      foreach ($results as $key => $val) {
        $attr = array();
        $attr[] = $val['name'];
        $attr[] = $val['emp_code'];
        $attr[] = $val['designation'];
        $attr[] = $val['dept_name'];
        $attr[] = $val['shift'];
        $attr[] = date('d-m-Y', strtotime($val['shift_date']));
        if ($val['request_approved'] == '1' && $val['return_status'] == '1') {
          $attr[] = 'Approved';
        } else {
          $attr[] = "<a class='btn btn-danger' href='" . site_url('approve_team_shift/' . $val['request_token']) . "'>Pending</a>";
        }
        $data[] = $attr;
      }
    }
    $output = array(
        "draw" => $draw,
        "recordsTotal" => $totalrows,
        "recordsFiltered" => $filterrecord,
        "data" => $data
    );
    echo json_encode($output);
    exit();
  }

  function shiftRequest() {
    if ($this->role != 4 && $this->role != 2 && $this->role != 8) {

      $this->loadThis();
    } else {

      if ($this->role == 2) {

        $department_id = $this->session->userdata('department_id');
        $this->db->select('shift');
        $this->db->where('department_id', $department_id);
        $this->db->where('team_submitted', '1');
        $data['shiftList'] = $this->db->get('tbl_manpower_team')->result_array();
      }


      $this->loadViews("manpower_shift_request", $this->global, $data, NULL);
    }
  }

  function view_team() {
    $userId = $this->session->userdata('userId');
    $shift = $this->session->userdata('shift');
    /** Checking if supervisor exists in the current date team and if not, then adding him to the team. */
    $data['team_id'] = $this->create_team_and_add_supervisor_if_team_does_not_exist();
    $data['team_shift'] = $this->db->select('shift')->from('tbl_manpower_team')->where('id', $data['team_id'])->get()->row()->shift;
    $data['team_client'] = $this->db->select('client')->from('tbl_manpower_team')->where('id', $data['team_id'])->get()->row()->client;
    $data['shift_start_time'] = $this->db->select('shift_start_time')->from('tbl_manpower_team')->where('id', $data['team_id'])->get()->row()->shift_start_time;
    $data['team_submitted'] = $this->db->select('team_submitted')->from('tbl_manpower_team')->where('id', $data['team_id'])->get()->row()->team_submitted;
//$team_id_query = $this->db->select(array('id', 'shift', 'client'))->from('tbl_manpower_team')->where('created_by',$userId)->where('department_id', $this->session->userdata('department_id'))->where('date', date('Y-m-d'))->get();
    $team_id_query = $this->db->select(array('id', 'shift', 'client'))->from('tbl_manpower_team')->where('shift', $shift)->where('department_id', $this->session->userdata('department_id'))->get();
    if ($team_id_query->num_rows()) {
      $data['team_id'] = $team_id_query->row()->id;
      $data['shift'] = $team_id_query->row()->shift;
      $data['client'] = $team_id_query->row()->client;
    } else {
      $data['team_id'] = 0;
      $data['shift'] = '';
      $data['client'] = '';
    }

    $department_name_query = $this->db->select('dept_name')->from('tbl_departments')->where('dept_id', $this->session->userdata('department_id'))->get();

    if ($department_name_query->num_rows()) {

      $data['department_name'] = $department_name_query->row()->dept_name;
    } else {

      $data['department_name'] = '';
    }
    $this->loadViews("manpower_view_team", $this->global, $data, NULL);
  }

  function upload_team_report($team_id) {
    $this->global['pageTitle'] = 'Searbird : Upload Team Report';
    $data['team_id'] = $team_id;
    $data['client_list'] = $this->db->from('tbl_clients')->get()->result_array();
    $this->loadViews("upload_team_report", $this->global, $data, NULL);
  }

  function submit_team() {

    $update_data['team_submitted'] = 1;
    $this->db->where('id', $this->input->post('team_id'))->update('tbl_manpower_team', $update_data);
    $this->session->set_flashdata('message', '<div class="alert alert-success">Team has been created!</div>');
    redirect('create-team');
  }

  function save_shift_start_time() {
    $update['shift_start_time'] = date('Y-m-d') . ' ' . $this->input->post('hour') . ':' . $this->input->post('minute') . ':00';
    $this->db->where('id', $this->input->post('team_id'))->update('tbl_manpower_team', $update);
    echo 'Success';
  }

  function edit_team($team_id) {

    $data['team_id'] = $team_id;

    $data['edit_team_invoked'] = true;

    $data['team_submitted'] = $this->db->select('team_submitted')->from('tbl_manpower_team')->where('id', $data['team_id'])->get()->row()->team_submitted;

    $data['all_departments'] = $this->db->select(array('dept_id', 'dept_name'))->from('tbl_departments')->get()->result();

    $data['team_shift'] = $this->db->select('shift')->from('tbl_manpower_team')->where('id', $data['team_id'])->get()->row()->shift;

    $data['team_client'] = $this->db->select('client')->from('tbl_manpower_team')->where('id', $data['team_id'])->get()->row()->client;


    $data['shift_start_time'] = $this->db->select('shift_start_time')->from('tbl_manpower_team')->where('id', $data['team_id'])->get()->row()->shift_start_time;

    $fetch_department_name_query = $this->db->query('SELECT dept_name FROM tbl_departments WHERE dept_id=' . $this->session->userdata('department_id'));

    if ($fetch_department_name_query->num_rows()) {

      $data['department_name'] = $fetch_department_name_query->row()->dept_name;
    } else {

      $data['department_name'] = '';
    }

    $this->global['pageTitle'] = 'Searbird : Manpower Create Team';
    $data['client_list'] = $this->db->from('tbl_clients')->get()->result_array();

    $ordId = $this->session->userdata('organization_id');
    $data['departmentList'] = $this->user_model->getDepartmentList($ordId);

    $this->loadViews("manpower_create_team", $this->global, $data, NULL);
  }

//  function edit_team() {
//
//    $data['team_id'] = $team_id;
//
//    $data['edit_team_invoked'] = true;
//
//    $data['team_submitted'] = $this->db->select('team_submitted')->from('tbl_manpower_team')->where('id', $data['team_id'])->get()->row()->team_submitted;
//
//    $data['all_departments'] = $this->db->select(array('dept_id', 'dept_name'))->from('tbl_departments')->get()->result();
//
//    $data['team_shift'] = $this->db->select('shift')->from('tbl_manpower_team')->where('id', $data['team_id'])->get()->row()->shift;
//
//    $data['team_client'] = $this->db->select('client')->from('tbl_manpower_team')->where('id', $data['team_id'])->get()->row()->client;
//
//
//    $data['shift_start_time'] = $this->db->select('shift_start_time')->from('tbl_manpower_team')->where('id', $data['team_id'])->get()->row()->shift_start_time;
//
//    $fetch_department_name_query = $this->db->query('SELECT dept_name FROM tbl_departments WHERE dept_id=' . $this->session->userdata('department_id'));
//
//    if ($fetch_department_name_query->num_rows()) {
//
//      $data['department_name'] = $fetch_department_name_query->row()->dept_name;
//    } else {
//
//      $data['department_name'] = '';
//    }
//
//    $this->global['pageTitle'] = 'Searbird : Manpower Create Team';
//    $data['client_list'] = $this->db->from('tbl_clients')->get()->result_array();
//
//    $ordId = $this->session->userdata('organization_id');
//    $data['departmentList'] = $this->user_model->getDepartmentList($ordId);
//
//    $this->loadViews("manpower_create_team", $this->global, $data, NULL);
//  }

  function create_team() {

    /** Checking if supervisor exists in the current date team and if not, then adding him to the team. */
    $data['team_id'] = $this->create_team_and_add_supervisor_if_team_does_not_exist();


    $data['shift_list'] = $this->getAvialableShift();

    $data['team_submitted'] = $this->db->select('team_submitted')->from('tbl_manpower_team')->where('id', $data['team_id'])->get()->row()->team_submitted;

    $data['all_departments'] = $this->db->select(array('dept_id', 'dept_name'))->from('tbl_departments')->get()->result();


    $data['team_shift'] = $this->db->select('shift')->from('tbl_manpower_team')->where('id', $data['team_id'])->get()->row()->shift;

    $data['team_client'] = $this->db->select('client')->from('tbl_manpower_team')->where('id', $data['team_id'])->get()->row()->client;


    $data['shift_start_time'] = $this->db->select('shift_start_time')->from('tbl_manpower_team')->where('id', $data['team_id'])->get()->row()->shift_start_time;

    $fetch_department_name_query = $this->db->query('SELECT dept_name FROM tbl_departments WHERE dept_id=' . $this->session->userdata('department_id'));

    if ($fetch_department_name_query->num_rows()) {

      $data['department_name'] = $fetch_department_name_query->row()->dept_name;
    } else {

      $data['department_name'] = '';
    }

    $this->global['pageTitle'] = 'Searbird : Manpower Create Team';

    $data['client_list'] = $this->db->from('tbl_clients')->get()->result_array();

    $this->loadViews("manpower_create_team", $this->global, $data, NULL);
  }

  function create_team_post() {

    $team_already_exists = $this->db->select('id')->from('tbl_manpower_team')->where('department_id', $this->session->userdata('department_id'))->where('shift', $this->input->post('shift'))->where('date', date('Y-m-d'))->get()->num_rows();

    if ($team_already_exists) {

      $this->session->set_flashdata('message', '<div class="alert alert-danger">Team already created for this department and shift!</div>');
    } else {

      $insert_data = array(
          'department_id' => $this->session->userdata('department_id'),
          'shift' => $this->input->post('shift'),
          'date' => date('Y-m-d'),
          'created_by' => $this->session->userdata('userId')
      );

      $this->db->insert('tbl_manpower_team', $insert_data);
      $team_id = $this->db->insert_id();

      $insert_data = array(
          'manpower_team_id' => $team_id,
          'employee_id' => $this->session->userdata('userId')
      );

      $this->db->insert('tbl_manpower_team_members', $insert_data);

      foreach ($this->input->post('selected_employees') as $employee_id) {

        $insert_data = array(
            'manpower_team_id' => $team_id,
            'employee_id' => $employee_id
        );

        $this->db->insert('tbl_manpower_team_members', $insert_data);
      }

      $this->session->set_flashdata('message', '<div class="alert alert-success">Team has been created successfully!</div>');
    }
    redirect('create-team');
  }

  function clients($clientId = '') {
//pre($this->input->post());
    if ($this->role != '1' && $this->role != '8') {
      $this->loadThis();
    } else {
      $clientInfo = array();
      $original_value = '';
      $original_client_code = '';

      if ($clientId) {
        $this->db->where('id', $clientId);
        $clientInfo = $this->db->get('tbl_clients')->row_array();

        $original_value = isset($clientInfo['client']) ? $clientInfo['client'] : '';
        $original_client_code = isset($clientInfo['client_code']) ? $clientInfo['client_code'] : '';
      }
      if ($this->input->post()) {
        if (($this->input->post('client') != $original_value) || $clientId == '') {
          $is_unique = '|is_unique[tbl_clients.client]';
        } else {
          $is_unique = '';
        }
        if (($this->input->post('client_code') != $original_client_code) || $clientId == '') {
          $is_unique_code = '|is_unique[tbl_clients.client_code]';
        } else {
          $is_unique_code = '';
        }
        $this->form_validation->set_rules('client', 'Client', 'required|trim' . $is_unique);
        $this->form_validation->set_rules('client_code', 'Client Code', 'required|trim' . $is_unique_code);
        if ($this->form_validation->run() === TRUE) {
          $client = $this->input->post('client');
          $client_code = $this->input->post('client_code');
          if ($clientId) {

            $this->db->where('id', $clientId);
            $this->db->update('tbl_clients', ['client' => $client, 'client_code' => $client_code]);
            $this->session->set_flashdata('success', 'Client updated successfully');
          } else {
//$client = $this->input->post('client');
            $this->db->insert('tbl_clients', ['client' => $client, 'client_code' => $client_code]);
            $this->session->set_flashdata('success', 'New Client created successfully');
          }
          redirect(site_url('clients'));
        }
      }
      $this->global['pageTitle'] = 'Searbird : Clients';
      $data['clientInfo'] = $clientInfo;
      $this->loadViews("clients_view", $this->global, $data, NULL);
    }
  }

  function delClient($clientId) {
    $this->db->where('id', $clientId);
    $this->db->delete('tbl_clients');
    $this->session->set_flashdata('success', 'Client deleted successfully');
    redirect(site_url('clients'));
  }

  function convertToHoursMins($time, $format = '%02d:%02d') {
    if ($time < 1) {
      return;
    }
    $hours = floor($time / 60);
    $minutes = ($time % 60);
    return sprintf($format, $hours, $minutes);
  }

  function getTotalHours() {
    if (!$this->input->is_ajax_request()) {
      exit('No direct script access allowed');
    }
    $fromTime = $this->input->post('fromTime');
    $toTime = $this->input->post('toTime');
    $time1 = strtotime($fromTime);
    $time2 = strtotime($toTime);
    $difference = round(abs($time2 - $time1) / 60, 2);
    $diff = $this->convertToHoursMins($difference);
    echo json_encode($diff);
  }

  function getClientAjaxList() {
    if (!$this->input->is_ajax_request()) {
      exit('No direct script access allowed');
    }
    $userId = $this->session->userdata('userId');
    $draw = intval($this->input->post("draw"));
    $start = intval($this->input->post("start"));
    $length = intval($this->input->post("length"));
    $search = $this->input->post('search[value]');

    $this->db->from('tbl_clients');
    $totalrows = $this->db->get()->num_rows();

    $this->db->from('tbl_clients');
    $results = $this->db->get()->result_array();

    $data = array();
    $sr = $start + 1;

    if (!empty($results)) {
      foreach ($results as $key => $client) {
        $attr = array();
        $attr[] = $sr;
        $attr[] = $client['client'];
        $attr[] = $client['client_code'];
        $attr[] = '<a href="' . site_url('clients/' . $client['id']) . '" class="btn btn-sm btn-primary"><i class="fa fa-pencil-square-o" aria-hidden="true"></i></a><a onclick="return confirm(\'Are you sure\')" href="' . site_url('delclient/' . $client['id']) . '" style="margin-left:5px" class="btn btn-sm btn-danger"><i class="fa fa-trash" aria-hidden="true"></i></a>';
        $data[] = $attr;
        $sr++;
      }
    }

    $output = array(
        "draw" => $draw,
        "recordsTotal" => $totalrows,
        "recordsFiltered" => $totalrows,
        "data" => $data
    );
    echo json_encode($output);
    exit();
  }

}
