<?php

if (!defined('BASEPATH'))
  exit('No direct script access allowed');

require APPPATH . '/libraries/BaseController.php';

class ExcelController extends BaseController {

  public function __construct() {
    parent::__construct();
    $this->load->model('user_model');
    $this->isLoggedIn();
    $this->load->model('excel_model');
    $this->load->library('excel');
    date_default_timezone_set('Asia/Kolkata');
  }

  function index() {
    $this->load->view('excel_import');
  }

  function fetch() {
    $data = $this->excel_import_model->select();
    $output = '
		<h3 align="center">Total Data - ' . $data->num_rows() . '</h3>
		<table class="table table-striped table-bordered">
			<tr>
				<th>Customer Name</th>
				<th>Address</th>
				<th>City</th>
				<th>Postal Code</th>
				<th>Country</th>
			</tr>
		';
    foreach ($data->result() as $row) {
      $output .= '
			<tr>
				<td>' . $row->CustomerName . '</td>
				<td>' . $row->Address . '</td>
				<td>' . $row->City . '</td>
				<td>' . $row->PostalCode . '</td>
				<td>' . $row->Country . '</td>
			</tr>
			';
    }
    $output .= '</table>';
    echo $output;
  }

  function import() {

    date_default_timezone_set('Asia/Kolkata');
    $excelId = time();
    $date = (date("Y-m-d H:i:s", $excelId));
    if (isset($_FILES["file"]["name"])) {
      $departmentId = $this->session->userdata('department_id');
      $subDepartmentId = $this->session->userdata('sub_department_id');
      $superviserId = $this->session->userdata('userId');
      $shiftName = shiftNameBySubDeptId($subDepartmentId);
      $organizationId = $this->session->userdata('organization_id');
      $locationId = locationIdByOrgId($organizationId);
      $clientId = clientIdByLocationId($locationId);
      $ftuDataArray = utfDepartmentByOrg($organizationId);
      $path = $_FILES["file"]["tmp_name"];
      $object = PHPExcel_IOFactory::load($path);
      foreach ($object->getWorksheetIterator() as $worksheet) {
        if (isUserHeaderOK($worksheet) == 'TRUE') {
          $highestRow = $worksheet->getHighestRow();
          $highestColumn = $worksheet->getHighestColumn();
          for ($row = 2; $row <= $highestRow; $row++) {
            if ($worksheet->getCellByColumnAndRow(0, $row)->getValue() && checkEmailExists($worksheet->getCellByColumnAndRow(1, $row)->getValue()) && checkEmployeecode($worksheet->getCellByColumnAndRow(5, $row)->getValue())) {
              $data[] = array(
                  'name' => $worksheet->getCellByColumnAndRow(0, $row)->getValue(),
                  'email' => $worksheet->getCellByColumnAndRow(1, $row)->getValue(),
                  'mobile' => $worksheet->getCellByColumnAndRow(2, $row)->getValue(),
                  'doj ' => date('Y-m-d', PHPExcel_Shared_Date::ExcelToPHP($worksheet->getCellByColumnAndRow(3, $row)->getValue())),
                  'organization_id' => $organizationId,
                  'location' => locationIdByOrgId($organizationId),
                  'department_id' => $ftuDataArray['dept_id'],
                  'sub_department_id' => $ftuDataArray['id'],
                  'roleId' => '3',
                  'reporting_manager' => '0',
                  'designation' => $worksheet->getCellByColumnAndRow(3, $row)->getValue(),
                  'emp_code' => $worksheet->getCellByColumnAndRow(4, $row)->getValue(),
                  'skills' => $worksheet->getCellByColumnAndRow(5, $row)->getValue(),
//                  'main_department' => $worksheet->getCellByColumnAndRow(7, $row)->getValue(),
                  'excel_id' => $excelId,
                  'createdDtm' => $date,
              );
            }
          }
        } else {
          echo 'Header Does not Matched';
          exit();
        }
      }
      if (isset($data) && !empty($data)) {
        $this->excel_model->insert($data);
        echo "Data Imported successfully <br>" . $excelId . " is your Reference Id for future use";
      } else {
        echo "Not Any Row Uploaded";
      }
    }
  }

  function deleteAllUserList() {
//echo 'jhhjh';
//die;


    if (in_array($this->role, ['1', '2', '5', '8', '9', '10', '11', '12', '13', '14'])) {
      $orgId = '';
      if ($this->role == '2' || $this->role == '8') {
        $orgId = $this->organization_id;
      }
      $organizationList = $this->user_model->getOrganizationList($orgId, $withManPowerCount = '1');
      $fOrganizationId = isset($organizationList[0]['id']) ? $organizationList[0]['id'] : '';
      $searchText = $this->security->xss_clean($this->input->post('searchText'));
      $empsearchText = $this->security->xss_clean($this->input->post('emp_id'));
      $empId = '';
      $empCode = '';
      $empName = '';
      $deptId = '';
      if ($this->input->post('organization_id')) {
        $fOrganizationId = $this->security->xss_clean($this->input->post('organization_id'));
      }
      if ($this->input->post('department_id')) {
        $deptId = $this->input->post('department_id');
      }
      $emailId = $this->security->xss_clean($this->input->post('emp_email'));
      if ($empsearchText != '') {
        $emparray = explode('_', $empsearchText);
        $empId = isset($emparray[0]) ? $emparray[0] : '';
        $empCode = isset($emparray[1]) ? $emparray[1] : '';
        $empName = isset($emparray[2]) ? $emparray[2] : '';
      }

      $data['searchText'] = $searchText;

      $data['empsearchText'] = $empsearchText;

      $data['emailId'] = $emailId;

      $data['fOrganizationId'] = $fOrganizationId;

      $data['deptId'] = $deptId;
// pre($data);
      $this->load->library('pagination');

      $count = $this->user_model->userListingCount($empName, $empCode, $emailId, $fOrganizationId, $deptId);

      $returns = $this->paginationCompress("userListing/", $count, 10);

      $data['userRecords'] = $this->user_model->deleteUserListing();

      $data['organizationList'] = $organizationList;

      $data['departmentlist'] = $this->user_model->getMainDepartmentList($this->organization_id, '', $withEmpCount = '1');
      $data['subDepartmentList'] = $this->user_model->getSubDepartmentList($data['departmentList'][0]['dept_id'], $subDepartmentId = '', $withManPowerCount = '0');
//pre($data);
      $this->global['pageTitle'] = 'Searbird : Employee Listing';

      $this->loadViews("users-delete", $this->global, $data, NULL);
    } else {
      $this->loadThis();
    }
  }

  function deleteAllProductivityList() {


    if (in_array($this->role, ['1', '2', '4', '5', '8', '9', '10', '11', '12', '13', '14'])) {
      $orgId = '';
      if ($this->role == '2' || $this->role == '8') {
        $orgId = $this->organization_id;
      }
      $organizationList = $this->user_model->getOrganizationList($orgId, $withManPowerCount = '1');
      $fOrganizationId = isset($organizationList[0]['id']) ? $organizationList[0]['id'] : '';
      $searchText = $this->security->xss_clean($this->input->post('searchText'));
      $empsearchText = $this->security->xss_clean($this->input->post('emp_id'));
      $empId = '';
      $empCode = '';
      $empName = '';
      $deptId = '';
      if ($this->input->post('organization_id')) {
        $fOrganizationId = $this->security->xss_clean($this->input->post('organization_id'));
      }
      if ($this->input->post('department_id')) {
        $deptId = $this->input->post('department_id');
      }
      $emailId = $this->security->xss_clean($this->input->post('emp_email'));
      if ($empsearchText != '') {
        $emparray = explode('_', $empsearchText);
        $empId = isset($emparray[0]) ? $emparray[0] : '';
        $empCode = isset($emparray[1]) ? $emparray[1] : '';
        $empName = isset($emparray[2]) ? $emparray[2] : '';
      }

      $data['searchText'] = $searchText;

      $data['empsearchText'] = $empsearchText;

      $data['emailId'] = $emailId;

      $data['fOrganizationId'] = $fOrganizationId;

      $data['deptId'] = $deptId;

      $this->load->library('pagination');

      $count = $this->user_model->userListingCount($empName, $empCode, $emailId, $fOrganizationId, $deptId);

      $returns = $this->paginationCompress("userListing/", $count, 10);

      $data['userRecords'] = $this->user_model->deleteProductivityListing();

      $data['organizationList'] = $organizationList;

      $data['departmentlist'] = $this->user_model->getMainDepartmentList($this->organization_id, '', $withEmpCount = '1');
      $data['subDepartmentList'] = $this->user_model->getSubDepartmentList($data['departmentList'][0]['dept_id'], $subDepartmentId = '', $withManPowerCount = '0');
      $this->global['pageTitle'] = 'Searbird : Employee Listing';
      $this->loadViews("productivity-delete", $this->global, $data, NULL);
    } else {
      $this->loadThis();
    }
  }

  function getdeleteuserajaxlisting() {
    if (!$this->input->is_ajax_request()) {
      exit('No direct script access allowed');
    }
    if ($this->input->post("roleId")) {
      $roleId = intval($this->input->post("roleId"));
    }

    $draw = intval($this->input->post("draw"));
    $start = intval($this->input->post("start"));
    $length = intval($this->input->post("length"));
    $search = $this->input->post('search[value]');


    $empsearchText = $this->input->post('emp_id');
    $empId = '';
    $empCode = '';
    $empName = '';
    if ($empsearchText != '') {
      $emparray = explode('_', $empsearchText);
      $empId = isset($emparray[0]) ? $emparray[0] : '';
      $empCode = isset($emparray[1]) ? $emparray[1] : '';
      $empName = isset($emparray[2]) ? $emparray[2] : '';
    }

    if ($search != '') {
//$emparray = explode('_', $empsearchText);
      $rId = isset($search) ? $search : '';
    }

    $this->db->where('BaseTbl.isDeleted', '0');
    $this->db->select('count(BaseTbl.userId) as totalUser,BaseTbl.excel_id,DATE_FORMAT(BaseTbl.createdDtm, "%d/%m/%Y")');
    $this->db->from('tbl_users as BaseTbl');
    $this->db->where('BaseTbl.excel_id !=', '');
    $this->db->group_by('BaseTbl.excel_id', 'DESC');
    if ($this->role != 1) {
      $this->db->where('BaseTbl.organization_id', $this->organization_id);
    }

    if (!empty($rId)) {
      $likeCriteria = "(BaseTbl.excel_id  LIKE '%" . $rId . "%')";
      $this->db->where($likeCriteria);
    }

    if ($roleId) {
      $this->db->where('BaseTbl.roleId =', $roleId);
    } else {
      $this->db->where('BaseTbl.roleId =', 3);
    }
    $this->db->where('BaseTbl.isDeleted', 0);
    $this->db->where('BaseTbl.roleId !=', 1);
    $query = $this->db->get();
    $totalrows = $query->num_rows();

    $this->db->select('count(BaseTbl.userId) as totalUser,BaseTbl.excel_id,DATE_FORMAT(BaseTbl.createdDtm, "%d/%m/%Y") as cDate');
    $this->db->from('tbl_users as BaseTbl');
    $this->db->where('BaseTbl.excel_id !=', '');
    $this->db->group_by('BaseTbl.excel_id', 'DESC');
    if ($this->role != 1) {
      $this->db->where('BaseTbl.organization_id', $this->organization_id);
    }
    if (!empty($rId)) {
      $likeCriteria = "(BaseTbl.excel_id  LIKE '%" . $rId . "%')";
      $this->db->where($likeCriteria);
    }
    $this->db->where('BaseTbl.isDeleted', 0);
    $this->db->where('BaseTbl.roleId !=', 1);
    if ($roleId) {
      $this->db->where('BaseTbl.roleId =', $roleId);
    } else {
      $this->db->where('BaseTbl.roleId =', 3);
    }
    $this->db->order_by('BaseTbl.userId', 'DESC');
    $this->db->limit($length, $start);
    $query = $this->db->get();
    $results = $query->result();
    $data = array();
    if (!empty($results)) {
      foreach ($results as $key => $userinfo) {
        $attr = array();
        $attr[] = $key + 1;
        $attr[] = $userinfo->totalUser;
        $attr[] = $userinfo->excel_id;
        $attr[] = $userinfo->cDate;
        $attr[] = '<a class="btn btn-sm btn-danger deleteAllUser" href="#" data-userid="' . $userinfo->excel_id . '" title="Delete"><i class="fa fa-trash"></i></a>';
        $data[] = $attr;
      }
    }
    $output = array(
        "draw" => $draw,
        "recordsTotal" => $totalrows,
        "recordsFiltered" => $totalrows,
        "data" => $data
    );
    echo json_encode($output);
    exit();
  }

  function getdeleteproajaxlisting() {
    if (!$this->input->is_ajax_request()) {
      exit('No direct script access allowed');
    }
    if ($this->input->post("roleId")) {
      $roleId = intval($this->input->post("roleId"));
    }
    $draw = intval($this->input->post("draw"));
    $start = intval($this->input->post("start"));
    $length = intval($this->input->post("length"));
    $search = $this->input->post('search[value]');
    $empsearchText = $this->input->post('emp_id');
    $empId = '';
    $empCode = '';
    $empName = '';
    if ($empsearchText != '') {
      $emparray = explode('_', $empsearchText);
      $empId = isset($emparray[0]) ? $emparray[0] : '';
      $empCode = isset($emparray[1]) ? $emparray[1] : '';
      $empName = isset($emparray[2]) ? $emparray[2] : '';
    }

    if ($search != '') {
      $rId = isset($search) ? $search : '';
    }

    $emp_email = $this->input->post('emp_email');
    $organization_id = $this->input->post('organization_id');
    $department_id = $this->input->post('department_id');

    $this->db->select('count(BaseTbl.employee_id) as totalUser,BaseTbl.excel_id,DATE_FORMAT(BaseTbl.date, "%d/%m/%Y") as cDate');
    $this->db->from('tbl_manpower_team_performance as BaseTbl');
    $this->db->where('BaseTbl.excel_id !=', '');
    $this->db->where('BaseTbl.superviser_id', $this->session->userdata('userId'));
    $this->db->group_by('BaseTbl.excel_id', 'DESC');
//    if ($department_id != '') {
//      $this->db->where('BaseTbl.main_dept_id ', $department_id);
//    }
//    if ($emp_email != '') {
//      $this->db->like('BaseTbl.email', $emp_email);
//    }
    if (!empty($rId)) {
      $likeCriteria = "(BaseTbl.excel_id  LIKE '%" . $rId . "%')";
      $this->db->where($likeCriteria);
    }
    $query = $this->db->get();
    $totalrows = $query->num_rows();

    $this->db->select('count(BaseTbl.employee_id) as totalUser,BaseTbl.excel_id,DATE_FORMAT(BaseTbl.date, "%d/%m/%Y") as cDate');
    $this->db->from('tbl_manpower_team_performance as BaseTbl');
    $this->db->where('BaseTbl.excel_id !=', '');
    $this->db->where('BaseTbl.superviser_id', $this->session->userdata('userId'));
    $this->db->group_by('BaseTbl.excel_id', 'DESC');
//    if ($department_id != '') {
//      $this->db->where('BaseTbl.main_dept_id ', $department_id);
//    }
//    if ($emp_email != '') {
//      $this->db->like('BaseTbl.email', $emp_email);
//    }
    if (!empty($rId)) {
      $likeCriteria = "(BaseTbl.excel_id  LIKE '%" . $rId . "%')";
      $this->db->where($likeCriteria);
    }
    $this->db->limit($length, $start);
    $query = $this->db->get();

    $results = $query->result();
    $data = array();

    if (!empty($results)) {
      foreach ($results as $key => $userinfo) {
        $attr = array();
        $attr[] = $key + 1;
        $attr[] = $userinfo->totalUser;
        $attr[] = $userinfo->excel_id;
        $attr[] = $userinfo->cDate;
        $attr[] = '<a class="btn btn-sm btn-danger deleteAllPro" href="#" data-userid="' . $userinfo->excel_id . '" title="Delete"><i class="fa fa-trash"></i></a>';

        $data[] = $attr;
      }
    }

    $output = array(
        "draw" => $draw,
        "recordsTotal" => $totalrows,
        "recordsFiltered" => $totalrows,
        "data" => $data
    );
    echo json_encode($output);
    exit();
  }

  function deleteAllUser() {
    if ($this->role != 9) {
      echo (json_encode(array('status' => 'access')));
    } else {
      $userRowId = $this->input->post('userRowId');
      $userInfo = array('isDeleted' => 1, 'updatedBy' => $this->vendorId, 'updatedDtm' => date('Y-m-d H:i:s'));

      $result = $this->user_model->deleteAllUser($userRowId, $userInfo);

      if ($result > 0) {
        echo (json_encode(array('status' => TRUE)));
      } else {
        echo (json_encode(array('status' => FALSE)));
      }
    }
  }

  function deleteAllPro() {
    if ($this->role != 9) {
      echo (json_encode(array('status' => 'access')));
    } else {
      $userRowId = $this->input->post('userRowId');
      $userInfo = array('isDeleted' => 1, 'updatedBy' => $this->vendorId, 'updatedDtm' => date('Y-m-d H:i:s'));

      $result = $this->user_model->deleteAllPro($userRowId, $userInfo);

      if ($result > 0) {
        echo (json_encode(array('status' => TRUE)));
      } else {
        echo (json_encode(array('status' => FALSE)));
      }
    }
  }

  function importPerformance() {
    date_default_timezone_set('Asia/Kolkata');
    $excelId = time();
    $date = (date("Y-m-d H:i:s", $excelId));
//    pre($this->session->userdata('organization_id'));
    $superviserId = $this->session->userdata('userId');
    $shiftMngtArray = getShiftMngtBySupervisor($superviserId);
    $subDeptMngtArray = subDeptMngtByShifMngtId($shiftMngtArray['id']);
//pre($subDeptMngtArray);
    $departmentId = $shiftMngtArray['dept_id'];
    $subDepartmentId = $shiftMngtArray['sub_dept_id'];
    $shiftName = shiftName($shiftMngtArray['shift']);
    $organizationId = $this->session->userdata('organization_id');
    $locationId = locationIdByOrgId($this->session->userdata('organization_id'));
    $clientId = $subDeptMngtArray['client_id'];
    $banchmark = $subDeptMngtArray['banchmark'];
    $uom_name = $subDeptMngtArray['name'];
    if (isset($_FILES["file"]["name"])) {
      $path = $_FILES["file"]["tmp_name"];
      $object = PHPExcel_IOFactory::load($path);
      foreach ($object->getWorksheetIterator() as $worksheet) {
        if (isProHeaderOK($worksheet) == 'TRUE') {
          $highestRow = $worksheet->getHighestRow();
          $highestColumn = $worksheet->getHighestColumn();

          for ($row = 2; $row <= $highestRow; $row++) {
//            if ($worksheet->getCellByColumnAndRow(1, $row)->getValue() && isPresent($worksheet->getCellByColumnAndRow(1, $row)->getValue()) == '1') {
//            echo date("Y-m-d", strtotime($worksheet->getCellByColumnAndRow(10, $row)->getFormattedValue()));
//            echo date('Y-m-d');
//            die;
            if (!in_array(date("Y-m-d", strtotime($worksheet->getCellByColumnAndRow(15, $row)->getFormattedValue())), [date('Y-m-d'), (date('Y-m-d', strtotime("-1 days")))])) {
//              echo 'hhhhhh';
//              die;
              $status = 'false';
//              echo 'Please check upload date column in excel templet before upload. date is not matched with present day or previous day date';
              echo 'ERROR : Productivity upload date must be current date or a day before';
              exit();
//              break;
//}
//              }
            }
          }


          for ($row = 2; $row <= $highestRow; $row++) {
//            if ($worksheet->getCellByColumnAndRow(1, $row)->getValue() && isPresent($worksheet->getCellByColumnAndRow(1, $row)->getValue()) == '1') {
//            $wData = getWorkingLogs($superviserId, empIdByEmpCode($worksheet->getCellByColumnAndRow(0, $row)->getValue()));
//              $employeeId = empIdByEmpCode($worksheet->getCellByColumnAndRow(1, $row)->getValue());
            $clientArray = explode('=>', $worksheet->getCellByColumnAndRow(16, $row)->getValue());
            $deptArray = explode('=>', $worksheet->getCellByColumnAndRow(17, $row)->getValue());
            $subDeptArray = explode('=>', $worksheet->getCellByColumnAndRow(18, $row)->getValue());
            date_default_timezone_set("Asia/Calcutta");
            $insert_data = array(
//                  'client' => $worksheet->getCellByColumnAndRow(1, $row)->getValue(),
                'location' => $locationId,
                'org' => $organizationId,
                'client' => $clientArray['1'],
                'dept_id' => $deptArray['1'],
                'sub_dept_id' => $subDeptArray['1'],
                'employee_id' => empIdByEmpCode($worksheet->getCellByColumnAndRow(1, $row)->getValue()),
                'superviser_id' => $superviserId,
                'shift' => $worksheet->getCellByColumnAndRow(11, $row)->getValue(),
                'challans' => $worksheet->getCellByColumnAndRow(2, $row)->getValue(),
                'A' => $worksheet->getCellByColumnAndRow(3, $row)->getValue(),
                'B' => $worksheet->getCellByColumnAndRow(4, $row)->getValue(),
                'C' => $worksheet->getCellByColumnAndRow(5, $row)->getValue(),
                'kg' => $worksheet->getCellByColumnAndRow(6, $row)->getValue(),
                'cfc' => $worksheet->getCellByColumnAndRow(7, $row)->getValue(),
                'bins' => $worksheet->getCellByColumnAndRow(8, $row)->getValue(),
                'pallet' => $worksheet->getCellByColumnAndRow(9, $row)->getValue(),
                'remark' => $worksheet->getCellByColumnAndRow(10, $row)->getValue(),
                'banchmark' => $banchmark,
                'uom' => $uom_name,
                'from_time' => $worksheet->getCellByColumnAndRow(13, $row)->getFormattedValue(),
                'to_time' => $worksheet->getCellByColumnAndRow(14, $row)->getFormattedValue(),
                'wl_id' => $worksheet->getCellByColumnAndRow(19, $row)->getFormattedValue(),
                'time' => $worksheet->getCellByColumnAndRow(12, $row)->getFormattedValue(),
                'excel_id' => $excelId,
                'date' => date("Y-m-d", strtotime($worksheet->getCellByColumnAndRow(15, $row)->getFormattedValue())),
            );
//              pre($insert_data);
            $empid = empIdByEmpCode($worksheet->getCellByColumnAndRow(1, $row)->getValue());
//            $manpower_team_performance_query = $this->db->select('id')->from('tbl_manpower_team_performance')
//                            ->where('dept_id', $departmentId)
//                            ->where('sub_dept_id', $subDepartmentId)
//                            ->where('date', date("Y-m-d", strtotime($worksheet->getCellByColumnAndRow(15, $row)->getFormattedValue())))
//                            ->where('employee_id', $empid)->get();

            $selectQuery = 'SELECT id '
                    . ' from tbl_manpower_team_performance'
                    . ' WHERE superviser_id = ' . $superviserId . ' '
                    . 'AND dept_id = ' . $departmentId . ' '
                    . 'AND sub_dept_id = ' . $subDepartmentId . ' '
                    . 'AND date = "' . date("Y-m-d", strtotime($worksheet->getCellByColumnAndRow(15, $row)->getFormattedValue())) . '"  '
                    . 'AND employee_id = "' . $empid . '" '
                    . 'AND wl_id = "' . $worksheet->getCellByColumnAndRow(19, $row)->getFormattedValue() . '" '
                    . '';
//            die;
            $query = $this->db->query($selectQuery);

            if ($query->num_rows()) {
//              last_query();
              $this->db->where(
                      ['dept_id' => $departmentId,
                          'employee_id' => $empid,
                          'date' => date("Y-m-d", strtotime($worksheet->getCellByColumnAndRow(15, $row)->getFormattedValue())),
              ]);
              $this->db->where(['sub_dept_id' => $subDepartmentId]);
              $this->db->where(['wl_id' => $worksheet->getCellByColumnAndRow(19, $row)->getFormattedValue()]);
              $this->db->update('tbl_manpower_team_performance', $insert_data);
            } else {
              $this->db->insert('tbl_manpower_team_performance', $insert_data);
            }
//}
          }
        } else {
          echo "Header Does not Matched";
          exit();
        }
      }
      echo "Data Imported successfully <br>" . $excelId . " is your Reference Id for future use";
    }
  }

  /**
   * This function used to check the user is logged in or not
   */
  function isLoggedIn() {
    $isLoggedIn = $this->session->userdata('isLoggedIn');
    if (!isset($isLoggedIn) || $isLoggedIn != TRUE) {
      redirect('login');
    } else {
      $this->role = $this->session->userdata('role');
      $this->vendorId = $this->session->userdata('userId');
      $this->name = $this->session->userdata('name');
      $this->roleText = $this->session->userdata('roleText');
      $this->lastLogin = $this->session->userdata('lastLogin');
      $this->email = $this->session->userdata('email');
      $this->organization_id = $this->session->userdata('organization_id');
      $this->department_id = $this->session->userdata('department_id');
      $this->global ['name'] = $this->name;
      $this->global ['role'] = $this->role;
      $this->global ['role_text'] = $this->roleText;
      $this->global ['last_login'] = $this->lastLogin;
      $this->global ['avatar'] = $this->session->userdata('avatar');
      $this->global ['email'] = $this->session->userdata('email');
      $this->global ['doj'] = $this->session->userdata('doj');
      $this->global ['reporting_manager'] = $this->session->userdata('reporting_manager');
    }
  }

  /**
   * This function is used to check the access
   */
  function isAdmin() {
    if ($this->role != ROLE_ADMIN) {
      return true;
    } else {
      return false;
    }
  }

}

?>